/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AuthorizationControllerFactory;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.action.ActionFactory;
import org.jdesktop.swingx.action.BoundAction;

public abstract class AbstractSettingsPanel
extends JPanel {
    private JXTaskPane taskPane = new JXTaskPane();
    private JPopupMenu popupMenu = new JPopupMenu();
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private String tabName;
    private int saveIndex;

    public AbstractSettingsPanel(String tabName) {
        this.tabName = tabName;
        this.taskPane.setTitle(tabName + " Tasks");
        this.taskPane.setName("settings_" + this.getTaskKey());
        this.taskPane.setFocusable(false);
        this.addTask("doRefresh", "Refresh", "Refresh " + tabName + " settings.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")));
        this.saveIndex = this.addTask("doSave", "Save", "Save " + tabName + " settings.", "", new ImageIcon(Frame.class.getResource("images/disk.png")));
        this.setVisibleTasks(this.saveIndex, this.saveIndex, false);
        this.addMouseListener(this.getPopupMenuMouseAdapter());
    }

    public MouseAdapter getPopupMenuMouseAdapter() {
        return new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    AbstractSettingsPanel.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    AbstractSettingsPanel.this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        };
    }

    public int addTask(String callbackMethod, String displayName, String toolTip, String shortcutKey, ImageIcon icon) {
        BoundAction boundAction = ActionFactory.createBoundAction((String)callbackMethod, (String)displayName, (String)shortcutKey);
        if (icon != null) {
            boundAction.putValue("SmallIcon", (Object)icon);
        }
        boundAction.putValue("ShortDescription", (Object)toolTip);
        boundAction.registerCallback((Object)this, callbackMethod);
        Component component = this.taskPane.add((Action)boundAction);
        if (!AuthorizationControllerFactory.getAuthorizationController().checkTask(this.taskPane.getName(), callbackMethod)) {
            component.setVisible(false);
        }
        this.parent.getComponentTaskMap().put(component, callbackMethod);
        this.popupMenu.add((Action)boundAction);
        return this.taskPane.getContentPane().getComponentCount() - 1;
    }

    public void setVisibleTasks(int start, int end2, boolean visible) {
        this.parent.setVisibleTasks(this.taskPane, this.popupMenu, start, end2, visible);
    }

    public void setSaveEnabled(boolean enabled) {
        this.setVisibleTasks(this.saveIndex, this.saveIndex, enabled);
    }

    public boolean isSaveEnabled() {
        return this.taskPane.getContentPane().getComponent(this.saveIndex).isVisible();
    }

    public String getTabName() {
        return this.tabName;
    }

    public String getTaskKey() {
        return this.tabName;
    }

    public Frame getFrame() {
        return this.parent;
    }

    public JXTaskPane getTaskPane() {
        return this.taskPane;
    }

    public JPopupMenu getPopupMenu() {
        return this.popupMenu;
    }

    public abstract void doRefresh();

    public abstract boolean doSave();
}

