/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.UIConstants;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ApplicationIconProvider {
    private static final Logger logger = LogManager.getLogger(ApplicationIconProvider.class);
    private static final String ICON_PROP = "bridgelink.icon.path";
    private static volatile String customIconPath;
    private static volatile String cachedPath;
    private static volatile ImageIcon cachedIcon;

    private ApplicationIconProvider() {
    }

    public static void setCustomIconPath(String path) {
        customIconPath = ApplicationIconProvider.trimToNull(path);
        cachedPath = null;
        cachedIcon = null;
        logger.info("Custom icon path set: {}", (Object)customIconPath);
    }

    public static ImageIcon getApplicationIcon() {
        String resolved = ApplicationIconProvider.resolveIconPath();
        if (resolved == null) {
            return UIConstants.MIRTH_FAVICON;
        }
        ImageIcon icon = cachedIcon;
        if (icon != null && resolved.equals(cachedPath)) {
            return icon;
        }
        ImageIcon loaded = ApplicationIconProvider.tryLoadIcon(resolved);
        if (loaded != null) {
            cachedPath = resolved;
            cachedIcon = loaded;
            return loaded;
        }
        return UIConstants.MIRTH_FAVICON;
    }

    private static String resolveIconPath() {
        String prop = ApplicationIconProvider.trimToNull(System.getProperty(ICON_PROP));
        if (prop != null) {
            return prop;
        }
        return ApplicationIconProvider.trimToNull(customIconPath);
    }

    private static ImageIcon tryLoadIcon(String path) {
        File f = new File(path);
        if (!f.exists()) {
            logger.warn("Icon file does not exist: {}", (Object)path);
            return null;
        }
        if (!f.canRead()) {
            logger.warn("Icon file is not readable: {}", (Object)path);
            return null;
        }
        try {
            BufferedImage img = ImageIO.read(f);
            if (img == null) {
                logger.warn("ImageIO could not decode icon file: {}", (Object)path);
                return null;
            }
            return new ImageIcon(img);
        }
        catch (IOException e) {
            logger.warn("Failed to load icon from path: {}", (Object)path, (Object)e);
            return null;
        }
    }

    private static String trimToNull(String s) {
        if (s == null) {
            return null;
        }
        String t = s.trim();
        return t.isEmpty() ? null : t;
    }
}

