/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.MirthHeadingPanel;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.User;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;

public class ChangePasswordDialog
extends MirthDialog {
    private Frame parent;
    private User currentUser;
    private JButton cancelButton;
    private JPanel channelOverview;
    private JPasswordField confirmPassword;
    private JLabel confirmPasswordLabel;
    private JButton finishButton;
    private JSeparator jSeparator1;
    private JLabel mirthHeadingLabel;
    private MirthHeadingPanel mirthHeadingPanel1;
    private JPasswordField password;
    private JLabel passwordLabel;
    private JScrollPane passwordPane;
    private JTextArea passwordTextArea;

    public ChangePasswordDialog(User currentUser, String message) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.currentUser = currentUser;
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        DisplayUtil.setResizable(this, false);
        this.mirthHeadingLabel.setForeground(UIConstants.HEADER_TITLE_TEXT_COLOR);
        this.passwordTextArea.setText(message);
        this.passwordTextArea.setBackground(Color.WHITE);
        this.passwordTextArea.setDisabledTextColor(Color.RED);
        this.finishButton.setEnabled(false);
        this.setModal(true);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ChangePasswordDialog.this.cancelButtonActionPerformed(null);
            }
        });
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setVisible(true);
    }

    public void setFinishButtonEnabled(boolean enabled) {
        this.finishButton.setEnabled(enabled);
    }

    private void checkAndTriggerFinishButton(KeyEvent evt) {
        if (StringUtils.isBlank((CharSequence)String.valueOf(this.password.getPassword())) || StringUtils.isBlank((CharSequence)String.valueOf(this.confirmPassword.getPassword()))) {
            this.setFinishButtonEnabled(false);
        } else {
            this.setFinishButtonEnabled(true);
            if (evt.getKeyCode() == 10) {
                this.finishButtonActionPerformed(null);
            }
        }
    }

    private void initComponents() {
        this.channelOverview = new JPanel();
        this.mirthHeadingPanel1 = new MirthHeadingPanel();
        this.mirthHeadingLabel = new JLabel();
        this.passwordLabel = new JLabel();
        this.password = new JPasswordField();
        this.confirmPasswordLabel = new JLabel();
        this.confirmPassword = new JPasswordField();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.finishButton = new JButton();
        this.passwordPane = new JScrollPane();
        this.passwordTextArea = new JTextArea();
        this.setDefaultCloseOperation(2);
        this.setTitle("Change Password");
        this.channelOverview.setBackground(new Color(255, 255, 255));
        this.channelOverview.setName("");
        this.mirthHeadingLabel.setFont(new Font("Tahoma", 1, 18));
        this.mirthHeadingLabel.setForeground(new Color(255, 255, 255));
        this.mirthHeadingLabel.setText("Change Password");
        GroupLayout mirthHeadingPanel1Layout = new GroupLayout(this.mirthHeadingPanel1);
        this.mirthHeadingPanel1.setLayout(mirthHeadingPanel1Layout);
        mirthHeadingPanel1Layout.setHorizontalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.mirthHeadingLabel, -1, 353, Short.MAX_VALUE).addContainerGap()));
        mirthHeadingPanel1Layout.setVerticalGroup(mirthHeadingPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mirthHeadingPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.mirthHeadingLabel, -1, 29, Short.MAX_VALUE).addContainerGap()));
        this.mirthHeadingLabel.getAccessibleContext().setAccessibleName("Change Password");
        this.passwordLabel.setText("New Password:");
        this.password.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ChangePasswordDialog.this.passwordKeyReleased(evt);
            }
        });
        this.confirmPasswordLabel.setText("Confirm New Password:");
        this.confirmPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ChangePasswordDialog.this.confirmPasswordKeyReleased(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.finishButton.setText("Finish");
        this.finishButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChangePasswordDialog.this.finishButtonActionPerformed(evt);
            }
        });
        this.passwordPane.setBorder(null);
        this.passwordPane.setHorizontalScrollBarPolicy(31);
        this.passwordPane.setVerticalScrollBarPolicy(21);
        this.passwordTextArea.setColumns(20);
        this.passwordTextArea.setEditable(false);
        this.passwordTextArea.setFont(new Font("Tahoma", 0, 11));
        this.passwordTextArea.setLineWrap(true);
        this.passwordTextArea.setRows(2);
        this.passwordTextArea.setText("Your password has expired. You are required to change your password in the next 14 days and 23 hours.");
        this.passwordTextArea.setWrapStyleWord(true);
        this.passwordTextArea.setEnabled(false);
        this.passwordPane.setViewportView(this.passwordTextArea);
        GroupLayout channelOverviewLayout = new GroupLayout(this.channelOverview);
        this.channelOverview.setLayout(channelOverviewLayout);
        channelOverviewLayout.setHorizontalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addContainerGap(234, Short.MAX_VALUE).addComponent(this.cancelButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.finishButton).addGap(9, 9, 9)).addComponent(this.mirthHeadingPanel1, -1, 373, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addContainerGap().addComponent(this.jSeparator1, -1, 353, Short.MAX_VALUE).addContainerGap()).addGroup(channelOverviewLayout.createSequentialGroup().addContainerGap().addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.passwordLabel, GroupLayout.Alignment.TRAILING).addComponent(this.confirmPasswordLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.confirmPassword, -1, 200, Short.MAX_VALUE).addComponent(this.password, -2, 200, -2)).addContainerGap(45, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addContainerGap(34, Short.MAX_VALUE).addComponent(this.passwordPane, -2, 305, -2).addGap(34, 34, 34)));
        channelOverviewLayout.setVerticalGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, channelOverviewLayout.createSequentialGroup().addComponent(this.mirthHeadingPanel1, -2, 51, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.passwordLabel).addComponent(this.password, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.confirmPasswordLabel).addComponent(this.confirmPassword, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.passwordPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(channelOverviewLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.finishButton).addComponent(this.cancelButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.channelOverview, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void finishButtonActionPerformed(ActionEvent evt) {
        this.password.requestFocusInWindow();
        if (!String.valueOf(this.password.getPassword()).equals(String.valueOf(this.confirmPassword.getPassword()))) {
            this.parent.alertError(this, "The passwords you entered do not match.");
            return;
        }
        if (!this.parent.checkOrUpdateUserPassword(this, this.currentUser, String.valueOf(this.password.getPassword()))) {
            return;
        }
        this.dispose();
    }

    private void passwordKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void confirmPasswordKeyReleased(KeyEvent evt) {
        this.checkAndTriggerFinishButton(evt);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }
}

