/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractChannelTabPanel;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.ChannelDependenciesDialog;
import com.mirth.connect.client.ui.ConnectorTypeCellRenderer;
import com.mirth.connect.client.ui.ConnectorTypeData;
import com.mirth.connect.client.ui.ConnectorTypeDecoration;
import com.mirth.connect.client.ui.DataTypesDialog;
import com.mirth.connect.client.ui.DestinationTableCellEditor;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.NumberCellRenderer;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.ScriptPanel;
import com.mirth.connect.client.ui.TextFieldCellEditor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.VariableList;
import com.mirth.connect.client.ui.attachments.CustomAttachmentDialog;
import com.mirth.connect.client.ui.attachments.IdentityAttachmentDialog;
import com.mirth.connect.client.ui.attachments.JavaScriptAttachmentDialog;
import com.mirth.connect.client.ui.attachments.RegexAttachmentDialog;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBox;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellEditor;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTextPane;
import com.mirth.connect.client.ui.components.tag.FilterCompletion;
import com.mirth.connect.client.ui.components.tag.MirthTagField;
import com.mirth.connect.client.ui.components.tag.SearchFilterListener;
import com.mirth.connect.client.ui.components.tag.TagFilterCompletion;
import com.mirth.connect.client.ui.editors.filter.FilterPane;
import com.mirth.connect.client.ui.editors.transformer.TransformerPane;
import com.mirth.connect.client.ui.panels.connectors.ConnectorPanel;
import com.mirth.connect.client.ui.panels.connectors.ConnectorSettingsPanel;
import com.mirth.connect.client.ui.util.VariableListUtil;
import com.mirth.connect.donkey.model.channel.ConnectorPluginProperties;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.donkey.model.channel.DestinationConnectorProperties;
import com.mirth.connect.donkey.model.channel.DestinationConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.MetaDataColumnType;
import com.mirth.connect.donkey.model.channel.SourceConnectorProperties;
import com.mirth.connect.donkey.model.channel.SourceConnectorPropertiesInterface;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelMetadata;
import com.mirth.connect.model.ChannelProperties;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.Filter;
import com.mirth.connect.model.InvalidConnectorPluginProperties;
import com.mirth.connect.model.MessageStorageMode;
import com.mirth.connect.model.PublicServerSettings;
import com.mirth.connect.model.Rule;
import com.mirth.connect.model.Step;
import com.mirth.connect.model.Transformer;
import com.mirth.connect.model.attachments.AttachmentHandlerType;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.model.filter.SearchFilter;
import com.mirth.connect.model.filter.SearchFilterParser;
import com.mirth.connect.plugins.ChannelTabPlugin;
import com.mirth.connect.util.JavaScriptSharedUtil;
import com.mirth.connect.util.PropertyVerifier;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.SerializationException;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.mozilla.javascript.Context;

public class ChannelSetup
extends JPanel {
    private static final String METADATA_NAME_COLUMN_NAME = "Column Name";
    private static final String METADATA_TYPE_COLUMN_NAME = "Type";
    private static final String METADATA_MAPPING_COLUMN_NAME = "Variable Mapping";
    private static final String DESTINATION_DEFAULT = "Channel Writer";
    private static final String SOURCE_DEFAULT = "Channel Reader";
    private static final String DATABASE_READER = "Database Reader";
    private static final String STATUS_COLUMN_NAME = "Status";
    private static final String METADATA_COLUMN_NAME = "Id";
    private static final String DESTINATION_COLUMN_NAME = "Destination";
    private static final String CONNECTOR_TYPE_COLUMN_NAME = "Connector Type";
    private static final String DESTINATION_CHAIN_COLUMN_NAME = "Chain";
    private static final int SOURCE_TAB_INDEX = 1;
    private static final int DESTINATIONS_TAB_INDEX = 2;
    private static final int SCRIPTS_TAB_INDEX = 3;
    private static final String PRUNING_WARNING_DEFAULT_TEXT = "(incomplete, errored, and queued messages will not be pruned)";
    private static final String PRUNING_WARNING_ERRORED_TEXT = "(incomplete and queued messages will not be pruned)";
    public Channel currentChannel;
    public Map<Integer, Map<String, String>> resourceIds = new HashMap<Integer, Map<String, String>>();
    public int defaultQueueBufferSize = 1000;
    public int lastModelIndex = -1;
    public TransformerPane transformerPane = new TransformerPane();
    public FilterPane filterPane = new FilterPane();
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private String saveGroupId;
    private boolean isDeleting = false;
    private boolean loadingChannel = false;
    private boolean channelValidationFailed = false;
    private Calendar dateStartEdit;
    private int previousTab = -1;
    private JTabbedPane channelView;
    private JPanel summaryPanel;
    private JPanel channelPropertiesPanel;
    private JLabel nameLabel;
    private MirthTextField nameField;
    private MirthCheckBox summaryEnabledCheckBox;
    private JTextField channelIdField;
    private JLabel dataTypesLabel;
    private JButton dataTypesButton;
    public MirthCheckBox clearGlobalChannelMapCheckBox;
    private JLabel revisionLabel;
    private JLabel dependenciesLabel;
    private JButton dependenciesButton;
    private JLabel lastModifiedLabel;
    private JLabel initialStateLabel;
    private MirthComboBox<DeployedState> initialStateComboBox;
    private JLabel attachmentLabel;
    private MirthComboBox<AttachmentHandlerType> attachmentComboBox;
    private JButton attachmentPropertiesButton;
    public MirthCheckBox attachmentStoreCheckBox;
    private JLabel attachmentWarningLabel;
    private JLabel tagsLabel;
    private MirthTagField tagsField;
    private JPanel messageStoragePanel;
    private JSlider messageStorageSlider;
    private JLabel storageModeLabel;
    private JLabel contentLabel;
    private JLabel metadataLabel;
    private JLabel durableLabel;
    private JLabel durableStatusLabel;
    private JLabel performanceLabel;
    private JProgressBar messageStorageProgressBar;
    private MirthCheckBox encryptMessagesCheckBox;
    private MirthCheckBox encryptAttachmentsCheckBox;
    private MirthCheckBox encryptCustomMetaDataCheckBox;
    private MirthCheckBox removeContentCheckBox;
    private MirthCheckBox removeOnlyFilteredCheckBox;
    private MirthCheckBox removeAttachmentsCheckBox;
    private JLabel queueWarningLabel;
    private JPanel messagePruningPanel;
    private JLabel metadataPruningLabel;
    private JRadioButton metadataPruningOffRadio;
    private JRadioButton metadataPruningOnRadio;
    private MirthTextField metadataPruningDaysTextField;
    private JLabel metadataDaysLabel;
    private JLabel contentPruningLabel;
    private JRadioButton contentPruningMetadataRadio;
    private JRadioButton contentPruningDaysRadio;
    private MirthTextField contentPruningDaysTextField;
    private JLabel contentDaysLabel;
    private MirthCheckBox archiveCheckBox;
    private MirthCheckBox pruneErroredMessagesCheckBox;
    private JLabel pruningWarningLabel;
    private JPanel customMetadataPanel;
    private MirthTable metaDataTable;
    private JScrollPane metaDataScrollPane;
    private JButton addMetaDataButton;
    private JButton deleteMetaDataButton;
    private JButton revertMetaDataButton;
    private JPanel descriptionPanel;
    private MirthTextPane summaryDescriptionText;
    private JScrollPane summaryDescriptionScrollPane;
    private JPanel sourcePanel;
    private JLabel sourceConnectorTypeLabel;
    private MirthComboBox<String> sourceConnectorTypeComboBox;
    public ConnectorPanel sourceConnectorPanel;
    private JScrollPane sourceConnectorScrollPane;
    private JPanel destinationsPanel;
    private MirthTable destinationTable;
    private JScrollPane destinationTableScrollPane;
    private JLabel destinationConnectorTypeLabel;
    private MirthComboBox<String> destinationConnectorTypeComboBox;
    private MirthCheckBox waitForPreviousCheckbox;
    private ConnectorPanel destinationConnectorPanel;
    private JScrollPane destinationConnectorScrollPane;
    public VariableList destinationVariableList;
    private ScriptPanel scriptsPanel;

    public ChannelSetup() {
        this.initComponents();
        this.initToolTips();
        this.initLayout();
    }

    public void closePopupWindow() {
        this.tagsField.closePopupWindow();
    }

    private void saveChannelTags() {
        this.currentChannel.getExportData().getChannelTags().clear();
        List filters = SearchFilterParser.parse((String)this.tagsField.getTags(), this.parent.getCachedChannelTags());
        if (CollectionUtils.isEmpty((Collection)filters)) {
            for (ChannelTag channelTag : this.parent.getCachedChannelTags()) {
                channelTag.getChannelIds().remove(this.currentChannel.getId());
            }
        } else {
            ArrayList newTagNames = new ArrayList();
            for (SearchFilter filter : filters) {
                List tagNames = filter.getValues();
                for (ChannelTag channelTag : this.parent.getCachedChannelTags()) {
                    boolean found = false;
                    Iterator it = tagNames.iterator();
                    while (it.hasNext()) {
                        String tagName = (String)it.next();
                        if (!StringUtils.equalsIgnoreCase((CharSequence)channelTag.getName(), (CharSequence)tagName)) continue;
                        found = true;
                        channelTag.getChannelIds().add(this.currentChannel.getId());
                        this.currentChannel.getExportData().getChannelTags().add(channelTag);
                        it.remove();
                        break;
                    }
                    if (found) continue;
                    channelTag.getChannelIds().remove(this.currentChannel.getId());
                }
                newTagNames.addAll(tagNames);
            }
            Map<String, Color> tagColors = this.tagsField.getTagColors();
            for (String tagName : newTagNames) {
                HashSet<String> channelIds = new HashSet<String>();
                channelIds.add(this.currentChannel.getId());
                Color tagColor = tagColors.get(tagName);
                if (tagColor == null) {
                    tagColor = Color.LIGHT_GRAY;
                }
                ChannelTag newTag = new ChannelTag(UUID.randomUUID().toString(), tagName, channelIds, tagColor);
                this.currentChannel.getExportData().getChannelTags().add(newTag);
                this.parent.getCachedChannelTags().add(newTag);
            }
        }
    }

    private void updateMetaDataTable() {
        DefaultTableModel model = (DefaultTableModel)this.metaDataTable.getModel();
        model.setNumRows(0);
        for (MetaDataColumn column : this.currentChannel.getProperties().getMetaDataColumns()) {
            model.addRow(new Object[]{column.getName(), column.getType(), column.getMappingName()});
        }
        this.revertMetaDataButton.setEnabled(false);
    }

    public void saveMetaDataColumns() {
        DefaultTableModel model = (DefaultTableModel)this.metaDataTable.getModel();
        List metaDataColumns = this.currentChannel.getProperties().getMetaDataColumns();
        metaDataColumns.clear();
        for (int i = 0; i < model.getRowCount(); ++i) {
            MetaDataColumn column = new MetaDataColumn();
            column.setName((String)model.getValueAt(i, 0));
            column.setType((MetaDataColumnType)model.getValueAt(i, 1));
            column.setMappingName((String)model.getValueAt(i, 2));
            metaDataColumns.add(column);
        }
    }

    private void checkSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.destinationTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.destinationTable.setRowSelectionInterval(row, row);
            }
            this.showChannelEditPopupMenu(evt);
        }
    }

    private void showChannelEditPopupMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            this.parent.channelEditPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public String editTransformer() {
        String name = "";
        if (this.channelView.getSelectedIndex() == 1) {
            name = "Source";
            this.transformerPane.setProperties(this.currentChannel.getSourceConnector(), this.currentChannel.getSourceConnector().getTransformer(), false);
        } else if (this.channelView.getSelectedIndex() == 2) {
            Connector destination = (Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex());
            this.transformerPane.setProperties(destination, destination.getTransformer(), false);
            name = destination.getName();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelSetup.this.transformerPane.resizePanes();
            }
        });
        return name;
    }

    public String editResponseTransformer() {
        String name = "";
        if (this.channelView.getSelectedIndex() == 2) {
            Connector destination = (Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex());
            this.transformerPane.setProperties(destination, destination.getResponseTransformer(), true);
            name = destination.getName();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelSetup.this.transformerPane.resizePanes();
            }
        });
        return name;
    }

    public String editFilter() {
        String name = "";
        if (this.channelView.getSelectedIndex() == 1) {
            name = "Source";
            this.filterPane.setProperties(this.currentChannel.getSourceConnector(), this.currentChannel.getSourceConnector().getFilter(), false);
        } else if (this.channelView.getSelectedIndex() == 2) {
            Connector destination = (Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex());
            this.filterPane.setProperties(destination, destination.getFilter(), false);
            name = destination.getName();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ChannelSetup.this.filterPane.resizePanes();
            }
        });
        return name;
    }

    public void makeDestinationTable(boolean addNew) {
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        int tableSize = destinationConnectors.size();
        if (addNew) {
            ++tableSize;
        }
        int chain = 1;
        Object[][] tableData = new Object[tableSize][5];
        for (int i = 0; i < tableSize; ++i) {
            if (tableSize - 1 == i && addNew) {
                Connector connector = this.makeNewConnector(true);
                String dataType = this.currentChannel.getSourceConnector().getTransformer().getOutboundDataType();
                DataTypeProperties defaultInboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                DataTypeProperties defaultOutboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                DataTypeProperties defaultResponseInboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                DataTypeProperties defaultResponseOutboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                connector.getTransformer().setInboundDataType(dataType);
                connector.getTransformer().setInboundProperties(defaultInboundProperties);
                connector.getTransformer().setOutboundDataType(dataType);
                connector.getTransformer().setOutboundProperties(defaultOutboundProperties);
                connector.getResponseTransformer().setInboundDataType(dataType);
                connector.getResponseTransformer().setInboundProperties(defaultResponseInboundProperties);
                connector.getResponseTransformer().setOutboundDataType(dataType);
                connector.getResponseTransformer().setOutboundProperties(defaultResponseOutboundProperties);
                connector.setName(this.getNewDestinationName(tableSize));
                connector.setTransportName(DESTINATION_DEFAULT);
                this.currentChannel.addDestination(connector);
                tableData[i][0] = connector.isEnabled() ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), "Enabled") : new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled");
                tableData[i][1] = connector.getName();
                tableData[i][2] = connector.getMetaDataId();
                tableData[i][3] = new ConnectorTypeData(((Connector)destinationConnectors.get(i)).getTransportName());
                if (i > 0 && !connector.isWaitForPrevious()) {
                    ++chain;
                }
                tableData[i][4] = chain;
                continue;
            }
            tableData[i][0] = ((Connector)destinationConnectors.get(i)).isEnabled() ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), "Enabled") : new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled");
            tableData[i][1] = ((Connector)destinationConnectors.get(i)).getName();
            tableData[i][2] = ((Connector)destinationConnectors.get(i)).getMetaDataId();
            tableData[i][3] = new ConnectorTypeData(((Connector)destinationConnectors.get(i)).getTransportName());
            if (i > 0 && !((Connector)destinationConnectors.get(i)).isWaitForPrevious()) {
                ++chain;
            }
            tableData[i][4] = chain;
        }
        ((RefreshTableModel)this.destinationTable.getModel()).refreshDataVector(tableData);
        this.destinationTable.requestFocus();
        int last = this.lastModelIndex;
        for (int row = 0; row < this.destinationTable.getRowCount(); ++row) {
            this.destinationTable.setRowSelectionInterval(row, row);
            this.destinationConnectorPanel.decorateConnectorType();
        }
        if (addNew) {
            this.destinationTable.setRowSelectionInterval(this.destinationTable.getRowCount() - 1, this.destinationTable.getRowCount() - 1);
        } else if (last == -1) {
            this.destinationTable.setRowSelectionInterval(0, 0);
        } else if (last == this.destinationTable.getRowCount()) {
            this.destinationTable.setRowSelectionInterval(last - 1, last - 1);
        } else {
            this.destinationTable.setRowSelectionInterval(last, last);
        }
    }

    private String getNewDestinationName(int size) {
        String temp = "Destination ";
        for (int i = 1; i <= size; ++i) {
            boolean exists = false;
            for (int j = 0; j < size - 1; ++j) {
                if (!((String)this.destinationTable.getModel().getValueAt(j, this.destinationTable.getColumnModelIndex(DESTINATION_COLUMN_NAME))).equalsIgnoreCase(temp + i)) continue;
                exists = true;
            }
            if (exists) continue;
            return temp + i;
        }
        return "";
    }

    public boolean loadConnector() {
        if (this.destinationTable.getSelectedModelIndex() == -1) {
            return false;
        }
        String destinationName = (String)this.destinationTable.getModel().getValueAt(this.destinationTable.getSelectedModelIndex(), this.destinationTable.getColumnModelIndex(DESTINATION_COLUMN_NAME));
        if (this.currentChannel != null && this.currentChannel.getDestinationConnectors() != null) {
            List destinationConnectors = this.currentChannel.getDestinationConnectors();
            for (int i = 0; i < destinationConnectors.size(); ++i) {
                if (!((Connector)destinationConnectors.get(i)).getName().equalsIgnoreCase(destinationName)) continue;
                boolean enabled = this.parent.isSaveEnabled();
                this.destinationConnectorTypeComboBox.setSelectedItem(((Connector)destinationConnectors.get(i)).getTransportName());
                this.parent.setSaveEnabled(enabled);
                return true;
            }
        }
        return false;
    }

    public void editChannel(Channel channel) {
        this.loadingChannel = true;
        this.dateStartEdit = Calendar.getInstance();
        HashSet<FilterCompletion> channelTags = new HashSet<FilterCompletion>();
        for (ChannelTag channelTag : this.parent.channelPanel.getCachedChannelTags()) {
            channelTags.add(new TagFilterCompletion(channelTag));
        }
        this.tagsField.update(channelTags, true, true, true);
        this.tagsField.setFocus(false);
        this.channelValidationFailed = false;
        this.lastModelIndex = -1;
        this.currentChannel = channel;
        this.saveGroupId = null;
        this.setResourceIds();
        this.setChannelTags();
        this.sourceConnectorTypeComboBox.setModel(new DefaultComboBoxModel<Object>(LoadedExtensions.getInstance().getSourceConnectors().keySet().toArray()));
        this.destinationConnectorTypeComboBox.setModel(new DefaultComboBoxModel<Object>(LoadedExtensions.getInstance().getDestinationConnectors().keySet().toArray()));
        try {
            PublicServerSettings serverSettings = this.parent.mirthClient.getPublicServerSettings();
            if (serverSettings.getQueueBufferSize() != null && serverSettings.getQueueBufferSize() > 0) {
                this.defaultQueueBufferSize = serverSettings.getQueueBufferSize();
            }
        }
        catch (ClientException serverSettings) {
            // empty catch block
        }
        this.loadChannelInfo();
        this.makeDestinationTable(false);
        this.saveDestinationPanel();
        this.updateMetaDataTable();
        this.setDestinationVariableList();
        this.loadingChannel = false;
        this.channelView.setSelectedIndex(0);
        this.sourceConnectorPanel.updateQueueWarning(this.currentChannel.getProperties().getMessageStorageMode());
        this.destinationConnectorPanel.updateQueueWarning(this.currentChannel.getProperties().getMessageStorageMode());
        this.updateResourceIds();
        ArrayList<ChannelTag> tags = new ArrayList<ChannelTag>();
        for (ChannelTag channelTag : this.parent.channelPanel.getCachedChannelTags()) {
            if (!channelTag.getChannelIds().contains(channel.getId())) continue;
            tags.add(channelTag);
        }
        Collections.sort(tags, new Comparator<ChannelTag>(){

            @Override
            public int compare(ChannelTag tag1, ChannelTag tag2) {
                return tag1.getName().compareToIgnoreCase(tag2.getName());
            }
        });
        this.tagsField.setChannelTags(tags);
    }

    public void addChannel(Channel channel, String groupId) {
        this.loadingChannel = true;
        this.lastModelIndex = -1;
        this.currentChannel = channel;
        this.saveGroupId = groupId;
        this.sourceConnectorTypeComboBox.setModel(new DefaultComboBoxModel<Object>(LoadedExtensions.getInstance().getSourceConnectors().keySet().toArray()));
        this.destinationConnectorTypeComboBox.setModel(new DefaultComboBoxModel<Object>(LoadedExtensions.getInstance().getDestinationConnectors().keySet().toArray()));
        Connector sourceConnector = this.makeNewConnector(false);
        sourceConnector.setName("sourceConnector");
        sourceConnector.setTransportName(SOURCE_DEFAULT);
        Transformer sourceTransformer = new Transformer();
        String defaultDataType = "HL7V2";
        if (!LoadedExtensions.getInstance().getDataTypePlugins().containsKey(defaultDataType) && LoadedExtensions.getInstance().getDataTypePlugins().size() > 0) {
            defaultDataType = LoadedExtensions.getInstance().getDataTypePlugins().keySet().iterator().next();
        }
        DataTypeProperties defaultInboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(defaultDataType).getDefaultProperties();
        DataTypeProperties defaultOutboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(defaultDataType).getDefaultProperties();
        sourceTransformer.setInboundDataType(defaultDataType);
        sourceTransformer.setInboundProperties(defaultInboundProperties);
        sourceTransformer.setOutboundDataType(defaultDataType);
        sourceTransformer.setOutboundProperties(defaultOutboundProperties);
        sourceConnector.setTransformer(sourceTransformer);
        this.currentChannel.setSourceConnector(sourceConnector);
        this.setLastModified();
        try {
            PublicServerSettings serverSettings = this.parent.mirthClient.getPublicServerSettings();
            this.currentChannel.getProperties().setMetaDataColumns(serverSettings.getDefaultMetaDataColumns());
            if (serverSettings.getQueueBufferSize() != null && serverSettings.getQueueBufferSize() > 0) {
                this.defaultQueueBufferSize = serverSettings.getQueueBufferSize();
            }
        }
        catch (ClientException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), (Throwable)e, "Error loading default metadata columns: " + e.getMessage());
        }
        this.loadChannelInfo();
        this.makeDestinationTable(true);
        this.updateMetaDataTable();
        this.tagsField.clear();
        HashSet<FilterCompletion> channelTags = new HashSet<FilterCompletion>();
        for (ChannelTag channelTag : this.parent.channelPanel.getCachedChannelTags()) {
            channelTags.add(new TagFilterCompletion(channelTag));
        }
        this.tagsField.update(channelTags, true, false, true);
        this.setDestinationVariableList();
        this.loadingChannel = false;
        this.channelView.setSelectedIndex(0);
        this.nameField.requestFocus();
        this.parent.setSaveEnabled(true);
        LinkedHashMap<String, String> sourceResourceIds = new LinkedHashMap<String, String>();
        sourceResourceIds.put("Default Resource", "[Default Resource]");
        ((SourceConnectorPropertiesInterface)this.currentChannel.getSourceConnector().getProperties()).getSourceConnectorProperties().setResourceIds(sourceResourceIds);
        for (Connector destinationConnector : this.currentChannel.getDestinationConnectors()) {
            LinkedHashMap<String, String> destinationResourceIds = new LinkedHashMap<String, String>();
            destinationResourceIds.put("Default Resource", "[Default Resource]");
            ((DestinationConnectorPropertiesInterface)destinationConnector.getProperties()).getDestinationConnectorProperties().setResourceIds(destinationResourceIds);
        }
        this.setResourceIds();
    }

    private void setChannelTags() {
        this.currentChannel.getExportData().getChannelTags().clear();
        Set<ChannelTag> channelTags = this.parent.channelPanel.getCachedChannelTags();
        if (channelTags != null) {
            ArrayList<ChannelTag> currentTags = new ArrayList<ChannelTag>();
            for (ChannelTag channelTag : channelTags) {
                if (!channelTag.getChannelIds().contains(this.currentChannel.getId())) continue;
                currentTags.add(channelTag);
            }
            this.currentChannel.getExportData().setChannelTags(currentTags);
        }
    }

    private void setResourceIds() {
        this.resourceIds = new HashMap<Integer, Map<String, String>>();
        this.resourceIds.put(null, this.currentChannel.getProperties().getResourceIds());
        if (this.currentChannel.getSourceConnector() != null && this.currentChannel.getSourceConnector().getProperties() != null) {
            this.resourceIds.put(0, ((SourceConnectorPropertiesInterface)this.currentChannel.getSourceConnector().getProperties()).getSourceConnectorProperties().getResourceIds());
        }
        for (Connector destinationConnector : this.currentChannel.getDestinationConnectors()) {
            if (destinationConnector.getProperties() == null) continue;
            this.resourceIds.put(destinationConnector.getMetaDataId(), ((DestinationConnectorPropertiesInterface)destinationConnector.getProperties()).getDestinationConnectorProperties().getResourceIds());
        }
    }

    private void updateResourceIds() {
        Map<String, String> sourceResourceIds = this.resourceIds.get(0);
        if (sourceResourceIds == null) {
            sourceResourceIds = new LinkedHashMap<String, String>();
        }
        ((SourceConnectorPropertiesInterface)this.currentChannel.getSourceConnector().getProperties()).getSourceConnectorProperties().setResourceIds(sourceResourceIds);
        for (Connector destinationConnector : this.currentChannel.getDestinationConnectors()) {
            Map<String, String> destinationResourceIds = this.resourceIds.get(destinationConnector.getMetaDataId());
            if (destinationResourceIds == null) {
                destinationResourceIds = new LinkedHashMap<String, String>();
            }
            ((DestinationConnectorPropertiesInterface)destinationConnector.getProperties()).getDestinationConnectorProperties().setResourceIds(destinationResourceIds);
        }
    }

    private void setLastModified() {
        this.currentChannel.getExportData().getMetadata().setLastModified(Calendar.getInstance());
    }

    private void setUserId() {
        try {
            this.currentChannel.getExportData().getMetadata().setUserId(this.parent.mirthClient.getCurrentUser().getId());
        }
        catch (ClientException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
    }

    private void updateChannelId() {
        this.channelIdField.setText(" Id: " + this.currentChannel.getId());
    }

    private void updateRevision() {
        this.revisionLabel.setText("Revision: " + this.currentChannel.getRevision());
    }

    private void updateLastModified() {
        this.lastModifiedLabel.setText("Last Modified: " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(this.currentChannel.getExportData().getMetadata().getLastModified().getTime()));
    }

    private void loadChannelInfo() {
        boolean enabled = this.parent.isSaveEnabled();
        ChannelProperties properties = this.currentChannel.getProperties();
        ChannelMetadata metadata = this.currentChannel.getExportData().getMetadata();
        this.parent.setPanelName("Edit Channel - " + this.currentChannel.getName());
        this.nameField.setText(this.currentChannel.getName());
        this.summaryDescriptionText.setText(this.currentChannel.getDescription());
        this.updateChannelId();
        this.updateRevision();
        this.updateLastModified();
        if (this.currentChannel.getExportData().getMetadata().isEnabled()) {
            this.summaryEnabledCheckBox.setSelected(true);
        } else {
            this.summaryEnabledCheckBox.setSelected(false);
        }
        LinkedHashMap<String, String> scriptMap = new LinkedHashMap<String, String>();
        if (this.currentChannel.getPreprocessingScript() != null) {
            scriptMap.put("Preprocessor", this.currentChannel.getPreprocessingScript());
        } else {
            scriptMap.put("Preprocessor", "// Modify the message variable below to pre process data\nreturn message;");
        }
        if (this.currentChannel.getDeployScript() != null) {
            scriptMap.put("Deploy", this.currentChannel.getDeployScript());
        } else {
            scriptMap.put("Deploy", "// This script executes once when the channel is deployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;");
        }
        if (this.currentChannel.getUndeployScript() != null) {
            scriptMap.put("Undeploy", this.currentChannel.getUndeployScript());
        } else {
            scriptMap.put("Undeploy", "// This script executes once when the channel is undeployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;");
        }
        if (this.currentChannel.getPostprocessingScript() != null) {
            scriptMap.put("Postprocessor", this.currentChannel.getPostprocessingScript());
        } else {
            scriptMap.put("Postprocessor", "// This script executes once after a message has been processed\n// Responses returned from here will be stored as \"Postprocessor\" in the response map\nreturn;");
        }
        this.scriptsPanel.setScripts(scriptMap);
        this.updateScriptsPanel(scriptMap);
        this.attachmentComboBox.setSelectedItem(AttachmentHandlerType.fromString((String)properties.getAttachmentProperties().getType()));
        this.clearGlobalChannelMapCheckBox.setSelected(properties.isClearGlobalChannelMap());
        this.encryptMessagesCheckBox.setSelected(properties.isEncryptMessageContent());
        this.encryptAttachmentsCheckBox.setSelected(properties.isEncryptAttachments());
        this.encryptCustomMetaDataCheckBox.setSelected(properties.isEncryptCustomMetaData());
        this.fixNullDataTypesAndProperties();
        this.messageStorageSlider.setValue(properties.getMessageStorageMode().getValue());
        this.encryptMessagesCheckBox.setSelected(properties.isEncryptMessageContent());
        this.removeContentCheckBox.setSelected(properties.isRemoveContentOnCompletion());
        this.removeOnlyFilteredCheckBox.setSelected(properties.isRemoveOnlyFilteredOnCompletion());
        this.removeAttachmentsCheckBox.setSelected(properties.isRemoveAttachmentsOnCompletion());
        this.updateStorageMode();
        Integer pruneMetaDataDays = metadata.getPruningSettings().getPruneMetaDataDays();
        Integer pruneContentDays = metadata.getPruningSettings().getPruneContentDays();
        if (pruneMetaDataDays == null) {
            this.metadataPruningDaysTextField.setText("");
            this.metadataPruningOffRadio.setSelected(true);
            this.metadataPruningOffRadioActionPerformed(null);
        } else {
            this.metadataPruningDaysTextField.setText(pruneMetaDataDays.toString());
            this.metadataPruningOnRadio.setSelected(true);
            this.metadataPruningOnRadioActionPerformed(null);
        }
        if (pruneContentDays == null) {
            this.contentPruningMetadataRadio.setSelected(true);
            this.contentPruningDaysTextField.setText("");
            this.contentPruningMetadataRadioActionPerformed(null);
        } else {
            this.contentPruningDaysRadio.setSelected(true);
            this.contentPruningDaysTextField.setText(pruneContentDays.toString());
            this.contentPruningDaysRadioActionPerformed(null);
        }
        this.archiveCheckBox.setSelected(metadata.getPruningSettings().isArchiveEnabled());
        this.pruneErroredMessagesCheckBox.setSelected(metadata.getPruningSettings().isPruneErroredMessages());
        this.sourceConnectorTypeComboBox.setSelectedItem(this.currentChannel.getSourceConnector().getTransportName());
        this.initialStateComboBox.setSelectedItem(this.currentChannel.getProperties().getInitialState());
        this.attachmentStoreCheckBox.setSelected(this.currentChannel.getProperties().isStoreAttachments());
        for (ChannelTabPlugin channelTabPlugin : LoadedExtensions.getInstance().getChannelTabPlugins().values()) {
            AbstractChannelTabPanel channelTabPanel = channelTabPlugin.getChannelTabPanel();
            this.channelView.addTab(channelTabPlugin.getPluginPointName(), channelTabPanel);
            channelTabPanel.load(this.currentChannel);
        }
        this.parent.setSaveEnabled(enabled);
    }

    private void updateScriptsPanel(Map<String, String> scriptMap) {
        int nonDefaultCount = 0;
        if (!this.compareScripts(scriptMap.get("Preprocessor"), "// Modify the message variable below to pre process data\nreturn message;")) {
            ++nonDefaultCount;
        }
        if (!this.compareScripts(scriptMap.get("Postprocessor"), "// This script executes once after a message has been processed\n// Responses returned from here will be stored as \"Postprocessor\" in the response map\nreturn;")) {
            ++nonDefaultCount;
        }
        if (!this.compareScripts(scriptMap.get("Deploy"), "// This script executes once when the channel is deployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;")) {
            ++nonDefaultCount;
        }
        if (!this.compareScripts(scriptMap.get("Undeploy"), "// This script executes once when the channel is undeployed\n// You only have access to the globalMap and globalChannelMap here to persist data\nreturn;")) {
            ++nonDefaultCount;
        }
        this.channelView.setTitleAt(3, (String)(nonDefaultCount > 0 ? "Scripts (" + nonDefaultCount + ")" : "Scripts"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean compareScripts(String savedScript, String defualtScript) {
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            String decompiledSavedScript = "";
            String decompiledDefaultScript = "";
            try {
                decompiledSavedScript = context.decompileScript(context.compileString("function doScript() {" + savedScript + "}", PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), 1, null), 1);
                decompiledDefaultScript = context.decompileScript(context.compileString("function doScript() {" + defualtScript + "}", PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), 1, null), 1);
            }
            catch (Exception e) {
                boolean bl = false;
                Context.exit();
                return bl;
            }
            boolean bl = decompiledSavedScript.equals(decompiledDefaultScript);
            return bl;
        }
        finally {
            Context.exit();
        }
    }

    public void decorateConnectorType(ConnectorTypeDecoration connectorTypeDecoration, boolean isDestination) {
        if (connectorTypeDecoration != null && isDestination && this.destinationTable.getSelectedModelIndex() >= 0) {
            ConnectorTypeData connectorTypeData = (ConnectorTypeData)this.destinationTable.getModel().getValueAt(this.destinationTable.getSelectedModelIndex(), this.destinationTable.getColumnModelIndex(CONNECTOR_TYPE_COLUMN_NAME));
            connectorTypeData.setDecoration(connectorTypeDecoration);
            this.destinationTable.getModel().setValueAt(connectorTypeData, this.destinationTable.getSelectedModelIndex(), this.destinationTable.getColumnModelIndex(CONNECTOR_TYPE_COLUMN_NAME));
        }
    }

    public String checkInvalidPluginProperties(Connector connector) {
        return this.checkInvalidPluginProperties(null, connector);
    }

    public String checkInvalidPluginProperties(Channel channel) {
        return this.checkInvalidPluginProperties(channel, null);
    }

    private String checkInvalidPluginProperties(Channel channel, Connector connector) {
        HashSet<String> invalidPluginPropertiesNames = new HashSet<String>();
        if (channel != null) {
            this.checkInvalidPluginProperties(channel.getSourceConnector(), invalidPluginPropertiesNames);
            for (Connector destinationConnector : channel.getDestinationConnectors()) {
                this.checkInvalidPluginProperties(destinationConnector, invalidPluginPropertiesNames);
            }
        } else {
            this.checkInvalidPluginProperties(connector, invalidPluginPropertiesNames);
        }
        if (!invalidPluginPropertiesNames.isEmpty()) {
            StringBuilder alertMessage = new StringBuilder("The following invalid connector plugin properties were found:\n\n");
            for (String name : invalidPluginPropertiesNames) {
                alertMessage.append(name);
                alertMessage.append('\n');
            }
            return alertMessage.toString();
        }
        return null;
    }

    private void checkInvalidPluginProperties(Connector connector, Set<String> invalidPluginPropertiesNames) {
        if (connector.getProperties().getPluginProperties() != null) {
            for (ConnectorPluginProperties pluginProperties : connector.getProperties().getPluginProperties()) {
                if (!(pluginProperties instanceof InvalidConnectorPluginProperties)) continue;
                invalidPluginPropertiesNames.add(pluginProperties.getName());
            }
        }
    }

    private void updateStorageMode() {
        MessageStorageMode messageStorageMode = MessageStorageMode.fromInt((int)this.messageStorageSlider.getValue());
        switch (messageStorageMode) {
            case DEVELOPMENT: {
                this.storageModeLabel.setText("Development");
                this.contentLabel.setText("Content: All");
                this.metadataLabel.setText("Metadata: All");
                this.durableStatusLabel.setText("On");
                this.durableStatusLabel.setForeground(new Color(0, 130, 0));
                this.messageStorageProgressBar.setValue(20);
                this.encryptMessagesCheckBox.setEnabled(true);
                this.encryptAttachmentsCheckBox.setEnabled(true);
                this.encryptCustomMetaDataCheckBox.setEnabled(true);
                this.removeContentCheckBox.setEnabled(true);
                this.removeOnlyFilteredCheckBox.setEnabled(this.removeContentCheckBox.isSelected());
                this.removeAttachmentsCheckBox.setEnabled(true);
                break;
            }
            case PRODUCTION: {
                this.storageModeLabel.setText("Production");
                this.contentLabel.setText("Content: Raw, Encoded, Sent, Response, Maps");
                this.metadataLabel.setText("Metadata: All");
                this.durableStatusLabel.setText("On");
                this.durableStatusLabel.setForeground(new Color(0, 130, 0));
                this.messageStorageProgressBar.setValue(25);
                this.encryptMessagesCheckBox.setEnabled(true);
                this.encryptAttachmentsCheckBox.setEnabled(true);
                this.encryptCustomMetaDataCheckBox.setEnabled(true);
                this.removeContentCheckBox.setEnabled(true);
                this.removeOnlyFilteredCheckBox.setEnabled(this.removeContentCheckBox.isSelected());
                this.removeAttachmentsCheckBox.setEnabled(true);
                break;
            }
            case RAW: {
                this.storageModeLabel.setText("Raw");
                this.contentLabel.setText("Content: Raw");
                this.metadataLabel.setText("Metadata: All");
                this.durableStatusLabel.setText("Reprocess only");
                this.durableStatusLabel.setForeground(new Color(255, 102, 0));
                this.messageStorageProgressBar.setValue(60);
                this.encryptMessagesCheckBox.setEnabled(true);
                this.encryptAttachmentsCheckBox.setEnabled(true);
                this.encryptCustomMetaDataCheckBox.setEnabled(true);
                this.removeContentCheckBox.setEnabled(true);
                this.removeOnlyFilteredCheckBox.setEnabled(this.removeContentCheckBox.isSelected());
                this.removeAttachmentsCheckBox.setEnabled(true);
                break;
            }
            case METADATA: {
                this.storageModeLabel.setText("Metadata");
                this.contentLabel.setText("Content: None");
                this.metadataLabel.setText("Metadata: All");
                this.durableStatusLabel.setText("Off");
                this.durableStatusLabel.setForeground(new Color(130, 0, 0));
                this.messageStorageProgressBar.setValue(65);
                this.encryptMessagesCheckBox.setEnabled(false);
                this.encryptAttachmentsCheckBox.setEnabled(false);
                this.encryptCustomMetaDataCheckBox.setEnabled(true);
                this.removeContentCheckBox.setEnabled(false);
                this.removeOnlyFilteredCheckBox.setEnabled(false);
                this.removeAttachmentsCheckBox.setEnabled(false);
                break;
            }
            case DISABLED: {
                this.storageModeLabel.setText("Disabled");
                this.contentLabel.setText("Content: None");
                this.metadataLabel.setText("Metadata: None");
                this.durableStatusLabel.setText("Off");
                this.durableStatusLabel.setForeground(new Color(130, 0, 0));
                this.messageStorageProgressBar.setValue(100);
                this.encryptMessagesCheckBox.setEnabled(false);
                this.encryptAttachmentsCheckBox.setEnabled(false);
                this.encryptCustomMetaDataCheckBox.setEnabled(false);
                this.removeContentCheckBox.setEnabled(false);
                this.removeOnlyFilteredCheckBox.setEnabled(false);
                this.removeAttachmentsCheckBox.setEnabled(false);
            }
        }
        if (this.encryptMessagesCheckBox.isEnabled() && this.encryptMessagesCheckBox.isSelected()) {
            this.messageStorageProgressBar.setValue(this.messageStorageProgressBar.getValue() - 3);
        }
        if (this.encryptAttachmentsCheckBox.isEnabled() && this.encryptAttachmentsCheckBox.isSelected()) {
            this.messageStorageProgressBar.setValue(this.messageStorageProgressBar.getValue() - 3);
        }
        if (this.removeContentCheckBox.isEnabled() && this.removeContentCheckBox.isSelected()) {
            this.messageStorageProgressBar.setValue(this.messageStorageProgressBar.getValue() - 3);
        }
        if (this.removeAttachmentsCheckBox.isEnabled() && this.removeAttachmentsCheckBox.isSelected()) {
            this.messageStorageProgressBar.setValue(this.messageStorageProgressBar.getValue() - 3);
        }
        this.updateQueueWarning(messageStorageMode);
        this.sourceConnectorPanel.updateQueueWarning(messageStorageMode);
        this.destinationConnectorPanel.updateQueueWarning(messageStorageMode);
    }

    public MessageStorageMode getMessageStorageMode() {
        return MessageStorageMode.fromInt((int)this.messageStorageSlider.getValue());
    }

    public void updateQueueWarning(MessageStorageMode messageStorageMode) {
        String errorString = this.getQueueErrorString(messageStorageMode);
        if (errorString != null) {
            this.queueWarningLabel.setText("<html>Disable " + errorString + " queueing before using this mode</html>");
        } else {
            this.queueWarningLabel.setText("");
        }
    }

    private String getQueueErrorString(MessageStorageMode messageStorageMode) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean sourceQueueEnabled = false;
        ConnectorProperties connectorProperties = this.sourceConnectorPanel.getProperties();
        if (connectorProperties != null && connectorProperties instanceof SourceConnectorPropertiesInterface) {
            SourceConnectorProperties sourceConnectorProperties = ((SourceConnectorPropertiesInterface)connectorProperties).getSourceConnectorProperties();
            sourceQueueEnabled = !sourceConnectorProperties.isRespondAfterProcessing();
        }
        boolean destinationQueueEnabled = false;
        for (Connector connector : this.currentChannel.getDestinationConnectors()) {
            DestinationConnectorProperties destinationConnectorProperties;
            connectorProperties = connector.getProperties();
            if (!(connectorProperties instanceof DestinationConnectorPropertiesInterface) || !(destinationConnectorProperties = ((DestinationConnectorPropertiesInterface)connectorProperties).getDestinationConnectorProperties()).isQueueEnabled()) continue;
            destinationQueueEnabled = true;
            break;
        }
        switch (messageStorageMode) {
            case METADATA: 
            case DISABLED: {
                if (sourceQueueEnabled) {
                    stringBuilder.append("source");
                    if (destinationQueueEnabled) {
                        stringBuilder.append(" & ");
                    }
                }
            }
            case RAW: {
                if (!destinationQueueEnabled) break;
                stringBuilder.append("destination");
            }
        }
        return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
    }

    public void updateScripts() {
        this.currentChannel.setPreprocessingScript(this.scriptsPanel.getScripts().get("Preprocessor"));
        this.currentChannel.setDeployScript(this.scriptsPanel.getScripts().get("Deploy"));
        this.currentChannel.setUndeployScript(this.scriptsPanel.getScripts().get("Undeploy"));
        this.currentChannel.setPostprocessingScript(this.scriptsPanel.getScripts().get("Postprocessor"));
        this.updateScriptsPanel(this.getScriptsMap());
    }

    private Map<String, String> getScriptsMap() {
        LinkedHashMap<String, String> scriptMap = new LinkedHashMap<String, String>();
        scriptMap.put("Preprocessor", this.scriptsPanel.getScripts().get("Preprocessor"));
        scriptMap.put("Postprocessor", this.scriptsPanel.getScripts().get("Postprocessor"));
        scriptMap.put("Deploy", this.scriptsPanel.getScripts().get("Deploy"));
        scriptMap.put("Undeploy", this.scriptsPanel.getScripts().get("Undeploy"));
        return scriptMap;
    }

    public void saveSourcePanel() {
        this.currentChannel.getSourceConnector().setProperties(this.sourceConnectorPanel.getProperties());
        if (!this.loadingChannel && this.resourceIds.containsKey(this.currentChannel.getSourceConnector().getMetaDataId())) {
            ((SourceConnectorPropertiesInterface)this.currentChannel.getSourceConnector().getProperties()).getSourceConnectorProperties().setResourceIds(this.resourceIds.get(this.currentChannel.getSourceConnector().getMetaDataId()));
        }
    }

    public void saveDestinationPanel() {
        Connector temp = (Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex());
        temp.setProperties(this.destinationConnectorPanel.getProperties());
        if (!this.loadingChannel && temp.getProperties() != null && this.resourceIds.containsKey(temp.getMetaDataId())) {
            ((DestinationConnectorPropertiesInterface)temp.getProperties()).getDestinationConnectorProperties().setResourceIds(this.resourceIds.get(temp.getMetaDataId()));
        }
    }

    public boolean saveChanges() {
        Integer userId = null;
        Channel originalStateChannel = null;
        try {
            originalStateChannel = this.parent.mirthClient.getChannel(this.currentChannel.getId(), false);
            userId = originalStateChannel != null ? originalStateChannel.getExportData().getMetadata().getUserId() : this.parent.mirthClient.getCurrentUser().getId();
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        if (!this.parent.checkChannelName(this.nameField.getText(), this.currentChannel.getId())) {
            return false;
        }
        if (this.metadataPruningOnRadio.isSelected() && this.metadataPruningDaysTextField.getText().equals("")) {
            this.parent.alertWarning((Component)((Object)this.parent), "If metadata pruning is enabled, the age of metadata to prune cannot be blank.");
            return false;
        }
        if (this.contentPruningDaysRadio.isSelected() && this.contentPruningDaysTextField.getText().equals("")) {
            this.parent.alertWarning((Component)((Object)this.parent), "If content pruning is enabled, the age of content to prune cannot be blank.");
            return false;
        }
        if (this.metadataPruningOnRadio.isSelected() && this.contentPruningDaysRadio.isSelected()) {
            Integer metadataPruningDays = Integer.parseInt(this.metadataPruningDaysTextField.getText());
            Integer contentPruningDays = Integer.parseInt(this.contentPruningDaysTextField.getText());
            if (contentPruningDays > metadataPruningDays) {
                this.parent.alertWarning((Component)((Object)this.parent), "The age of content to prune cannot be greater than the age of metadata to prune.");
                return false;
            }
        }
        this.tagsField.createTagOnFocusLost();
        HashMap<String, MetaDataColumnType> currentColumns = new HashMap<String, MetaDataColumnType>();
        for (MetaDataColumn column : this.currentChannel.getProperties().getMetaDataColumns()) {
            currentColumns.put(column.getName(), column.getType());
        }
        HashSet<String> columnNames = new HashSet<String>();
        for (int i = 0; i < this.metaDataTable.getRowCount(); ++i) {
            DefaultTableModel model = (DefaultTableModel)this.metaDataTable.getModel();
            String columnName = (String)model.getValueAt(i, model.findColumn(METADATA_NAME_COLUMN_NAME));
            if (StringUtils.isEmpty((CharSequence)columnName)) {
                this.parent.alertWarning((Component)((Object)this.parent), "Empty column name detected in custom metadata table. Column names cannot be empty.");
                return false;
            }
            if (columnNames.contains(columnName)) {
                this.parent.alertWarning((Component)((Object)this.parent), "Duplicate column name detected in custom metadata table. Column names must be unique.");
                return false;
            }
            if (columnName.equalsIgnoreCase("MESSAGE_ID") || columnName.equalsIgnoreCase("METADATA_ID")) {
                this.parent.alertWarning((Component)((Object)this.parent), columnName + " is a reserved keyword and cannot be used as a column name in the custom metadata table.");
                return false;
            }
            columnNames.add(columnName);
            MetaDataColumnType columnType = (MetaDataColumnType)model.getValueAt(i, model.findColumn(METADATA_TYPE_COLUMN_NAME));
            if (!currentColumns.containsKey(columnName) || !((MetaDataColumnType)currentColumns.get(columnName)).equals((Object)columnType)) continue;
            currentColumns.remove(columnName);
        }
        if (!currentColumns.isEmpty() && !this.parent.alertOption((Component)((Object)this.parent), "Renaming, deleting, or changing the type of existing custom metadata columns\nwill delete all existing data for that column. Are you sure you want to do this?")) {
            return false;
        }
        boolean enabled = this.summaryEnabledCheckBox.isSelected();
        this.saveSourcePanel();
        if (this.parent.currentContentPage == this.transformerPane) {
            this.transformerPane.accept(false);
        }
        if (this.parent.currentContentPage == this.filterPane) {
            this.filterPane.accept(false);
        }
        this.saveDestinationPanel();
        MessageStorageMode messageStorageMode = MessageStorageMode.fromInt((int)this.messageStorageSlider.getValue());
        String errorString = this.getQueueErrorString(messageStorageMode);
        if (errorString != null) {
            this.parent.alertWarning((Component)((Object)this.parent), StringUtils.capitalize((String)errorString) + " queueing must be disabled first before using the selected message storage mode.");
            return false;
        }
        this.currentChannel.setName(this.nameField.getText());
        this.currentChannel.setDescription(this.summaryDescriptionText.getText());
        this.updateScripts();
        this.setLastModified();
        this.setUserId();
        this.currentChannel.getProperties().setClearGlobalChannelMap(this.clearGlobalChannelMapCheckBox.isSelected());
        this.currentChannel.getProperties().setEncryptMessageContent(this.encryptMessagesCheckBox.isSelected());
        this.currentChannel.getProperties().setEncryptAttachments(this.encryptAttachmentsCheckBox.isSelected());
        this.currentChannel.getProperties().setEncryptCustomMetaData(this.encryptCustomMetaDataCheckBox.isSelected());
        this.currentChannel.getProperties().setInitialState((DeployedState)this.initialStateComboBox.getSelectedItem());
        this.currentChannel.getProperties().setStoreAttachments(this.attachmentStoreCheckBox.isSelected());
        String validationMessage = this.checkAllForms(this.currentChannel);
        if (validationMessage != null) {
            enabled = false;
            if (this.channelView.getSelectedComponent() == this.destinationsPanel) {
                if (((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).isEnabled()) {
                    this.destinationConnectorPanel.checkProperties(this.destinationConnectorPanel.getProperties(), true);
                }
            } else if (this.channelView.getSelectedComponent() == this.sourcePanel) {
                this.sourceConnectorPanel.checkProperties(this.sourceConnectorPanel.getProperties(), true);
            }
            this.summaryEnabledCheckBox.setSelected(false);
            this.parent.alertCustomError((Component)((Object)this.parent), validationMessage, "There was an error in the validation of your channel.  It has been DISABLED and saved.  Before you can deploy you must fix the following error(s):");
        }
        this.currentChannel.getExportData().getMetadata().setEnabled(enabled);
        this.saveChannelTags();
        this.saveMetaDataColumns();
        this.saveMessageStorage(messageStorageMode);
        this.saveMessagePruning();
        this.parent.updateResourceNames(this.currentChannel);
        for (ChannelTabPlugin channelTabPlugin : LoadedExtensions.getInstance().getChannelTabPlugins().values()) {
            channelTabPlugin.getChannelTabPanel().save(this.currentChannel);
        }
        boolean updated = false;
        try {
            updated = this.parent.updateChannel(this.currentChannel, this.parent.channelPanel.getCachedChannelStatuses().containsKey(this.currentChannel.getId()), userId, this.dateStartEdit);
            try {
                this.currentChannel = (Channel)SerializationUtils.clone((Serializable)this.parent.channelPanel.getCachedChannelStatuses().get(this.currentChannel.getId()).getChannel());
                if (this.parent.currentContentPage == this.transformerPane) {
                    if (this.channelView.getSelectedIndex() == 1) {
                        this.transformerPane.setConnector(this.currentChannel.getSourceConnector());
                    } else if (this.channelView.getSelectedIndex() == 2) {
                        this.transformerPane.setConnector((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex()));
                    }
                }
                if (this.parent.currentContentPage == this.filterPane) {
                    if (this.channelView.getSelectedIndex() == 1) {
                        this.filterPane.setConnector(this.currentChannel.getSourceConnector());
                    } else if (this.channelView.getSelectedIndex() == 2) {
                        this.filterPane.setConnector((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex()));
                    }
                }
                this.updateRevision();
                this.updateLastModified();
            }
            catch (SerializationException e) {
                this.parent.alertThrowable((Component)((Object)this.parent), e);
            }
        }
        catch (ClientException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
        this.sourceConnectorPanel.updateQueueWarning(this.currentChannel.getProperties().getMessageStorageMode());
        this.destinationConnectorPanel.updateQueueWarning(this.currentChannel.getProperties().getMessageStorageMode());
        if (updated && this.saveGroupId != null) {
            this.parent.channelPanel.addChannelToGroup(this.currentChannel.getId(), this.saveGroupId);
            this.saveGroupId = null;
        }
        return updated;
    }

    private void saveMessageStorage(MessageStorageMode messageStorageMode) {
        ChannelProperties properties = this.currentChannel.getProperties();
        properties.setMessageStorageMode(messageStorageMode);
        properties.setEncryptMessageContent(this.encryptMessagesCheckBox.isSelected());
        properties.setEncryptAttachments(this.encryptAttachmentsCheckBox.isSelected());
        properties.setEncryptCustomMetaData(this.encryptCustomMetaDataCheckBox.isSelected());
        properties.setRemoveContentOnCompletion(this.removeContentCheckBox.isSelected());
        properties.setRemoveOnlyFilteredOnCompletion(this.removeOnlyFilteredCheckBox.isSelected());
        properties.setRemoveAttachmentsOnCompletion(this.removeAttachmentsCheckBox.isSelected());
    }

    private void saveMessagePruning() {
        ChannelMetadata metadata = this.currentChannel.getExportData().getMetadata();
        if (this.metadataPruningOffRadio.isSelected()) {
            metadata.getPruningSettings().setPruneMetaDataDays(null);
        } else {
            metadata.getPruningSettings().setPruneMetaDataDays(Integer.valueOf(Integer.parseInt(this.metadataPruningDaysTextField.getText())));
        }
        if (this.contentPruningMetadataRadio.isSelected()) {
            metadata.getPruningSettings().setPruneContentDays(null);
        } else {
            metadata.getPruningSettings().setPruneContentDays(Integer.valueOf(Integer.parseInt(this.contentPruningDaysTextField.getText())));
        }
        metadata.getPruningSettings().setArchiveEnabled(this.archiveCheckBox.isSelected());
        metadata.getPruningSettings().setPruneErroredMessages(this.pruneErroredMessagesCheckBox.isSelected());
    }

    public void fixNullDataTypesAndProperties() {
        DataTypeProperties defaultProperties;
        Transformer sourceTransformer = this.currentChannel.getSourceConnector().getTransformer();
        String defaultDataType = "HL7V2";
        if (!LoadedExtensions.getInstance().getDataTypePlugins().containsKey(defaultDataType) && LoadedExtensions.getInstance().getDataTypePlugins().size() > 0) {
            defaultDataType = LoadedExtensions.getInstance().getDataTypePlugins().keySet().iterator().next();
        }
        if (sourceTransformer.getInboundDataType() == null) {
            sourceTransformer.setInboundDataType(defaultDataType);
        }
        if (sourceTransformer.getInboundProperties() == null) {
            defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(sourceTransformer.getInboundDataType()).getDefaultProperties();
            sourceTransformer.setInboundProperties(defaultProperties);
        }
        if (sourceTransformer.getOutboundDataType() == null) {
            sourceTransformer.setOutboundDataType(sourceTransformer.getInboundDataType());
        }
        if (sourceTransformer.getOutboundProperties() == null) {
            defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(sourceTransformer.getOutboundDataType()).getDefaultProperties();
            sourceTransformer.setOutboundProperties(defaultProperties);
        }
        for (Connector c : this.currentChannel.getDestinationConnectors()) {
            DataTypeProperties defaultProperties2;
            Transformer destinationResponseTransformer;
            DataTypeProperties defaultProperties3;
            Transformer destinationTransformer = c.getTransformer();
            if (destinationTransformer.getInboundDataType() == null) {
                destinationTransformer.setInboundDataType(sourceTransformer.getOutboundDataType());
            }
            if (destinationTransformer.getInboundProperties() == null) {
                defaultProperties3 = LoadedExtensions.getInstance().getDataTypePlugins().get(destinationTransformer.getInboundDataType()).getDefaultProperties();
                destinationTransformer.setInboundProperties(defaultProperties3);
            }
            if (destinationTransformer.getOutboundDataType() == null) {
                destinationTransformer.setOutboundDataType(destinationTransformer.getInboundDataType());
            }
            if (destinationTransformer.getOutboundProperties() == null) {
                defaultProperties3 = LoadedExtensions.getInstance().getDataTypePlugins().get(destinationTransformer.getOutboundDataType()).getDefaultProperties();
                destinationTransformer.setOutboundProperties(defaultProperties3);
            }
            if ((destinationResponseTransformer = c.getResponseTransformer()).getInboundDataType() == null) {
                destinationResponseTransformer.setInboundDataType(destinationTransformer.getOutboundDataType());
            }
            if (destinationResponseTransformer.getInboundProperties() == null) {
                defaultProperties2 = LoadedExtensions.getInstance().getDataTypePlugins().get(destinationResponseTransformer.getInboundDataType()).getDefaultProperties();
                destinationResponseTransformer.setInboundProperties(defaultProperties2);
            }
            if (destinationResponseTransformer.getOutboundDataType() == null) {
                destinationResponseTransformer.setOutboundDataType(destinationResponseTransformer.getInboundDataType());
            }
            if (destinationResponseTransformer.getOutboundProperties() != null) continue;
            defaultProperties2 = LoadedExtensions.getInstance().getDataTypePlugins().get(destinationResponseTransformer.getOutboundDataType()).getDefaultProperties();
            destinationResponseTransformer.setOutboundProperties(defaultProperties2);
        }
    }

    public void addNewDestination() {
        this.makeDestinationTable(true);
        this.destinationTableScrollPane.getViewport().setViewPosition(new Point(0, this.destinationTable.getRowHeight() * this.destinationTable.getRowCount()));
        this.parent.setSaveEnabled(true);
    }

    public void cloneDestination() {
        if (!(!this.parent.changesHaveBeenMade() || this.parent.alertOption((Component)((Object)this.parent), "You must save your channel before cloning.  Would you like to save your channel now?") && this.saveChanges())) {
            return;
        }
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        Connector destination = null;
        try {
            destination = (Connector)SerializationUtils.clone((Serializable)((Connector)destinationConnectors.get(this.destinationTable.getSelectedModelIndex())));
        }
        catch (SerializationException e) {
            this.parent.alertThrowable((Component)((Object)this.parent), e);
            return;
        }
        destination.setName(this.getNewDestinationName(destinationConnectors.size() + 1));
        this.currentChannel.addDestination(destination);
        this.resourceIds.put(destination.getMetaDataId(), ((DestinationConnectorPropertiesInterface)destination.getProperties()).getDestinationConnectorProperties().getResourceIds());
        this.makeDestinationTable(false);
        this.parent.setSaveEnabled(true);
    }

    public void enableDestination() {
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        Connector destination = (Connector)destinationConnectors.get(this.destinationTable.getSelectedModelIndex());
        destination.setEnabled(true);
        this.makeDestinationTable(false);
        this.parent.setSaveEnabled(true);
        if (this.channelValidationFailed) {
            this.destinationConnectorPanel.checkProperties(this.destinationConnectorPanel.getProperties(), true);
        }
    }

    public void disableDestination() {
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        int enabledCount = 0;
        for (int i = 0; i < destinationConnectors.size(); ++i) {
            if (!((Connector)destinationConnectors.get(i)).isEnabled()) continue;
            ++enabledCount;
        }
        if (enabledCount <= 1) {
            this.parent.alertError((Component)((Object)this.parent), "You must have at least one destination enabled.");
            return;
        }
        Connector destination = (Connector)destinationConnectors.get(this.destinationTable.getSelectedModelIndex());
        destination.setEnabled(false);
        this.makeDestinationTable(false);
        this.parent.setSaveEnabled(true);
        if (this.channelValidationFailed) {
            this.destinationConnectorPanel.checkProperties(this.destinationConnectorPanel.getProperties(), false);
        }
    }

    public void deleteDestination() {
        this.isDeleting = true;
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        if (destinationConnectors.size() == 1) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "You must have at least one destination.");
            return;
        }
        boolean enabledDestination = false;
        for (int i = 0; i < destinationConnectors.size(); ++i) {
            if (!((Connector)destinationConnectors.get(i)).isEnabled() || i == this.destinationTable.getSelectedModelIndex()) continue;
            enabledDestination = true;
        }
        if (!enabledDestination) {
            JOptionPane.showMessageDialog((Component)((Object)this.parent), "You must have at least one destination enabled.");
            return;
        }
        destinationConnectors.remove(this.destinationTable.getSelectedModelIndex());
        this.makeDestinationTable(false);
        this.parent.setSaveEnabled(true);
        this.isDeleting = false;
    }

    public void checkVisibleDestinationTasks() {
        if (this.channelView.getSelectedComponent() == this.destinationsPanel) {
            List destinationConnectors = this.currentChannel.getDestinationConnectors();
            Connector destination = (Connector)destinationConnectors.get(this.destinationTable.getSelectedModelIndex());
            if (destination.isEnabled()) {
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 5, 5, false);
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 6, 6, true);
            } else {
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 5, 5, true);
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 6, 6, false);
            }
            if (this.destinationTable.getSelectedModelIndex() == 0) {
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 7, 7, false);
            } else {
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 7, 7, true);
            }
            if (this.destinationTable.getSelectedModelIndex() == this.destinationTable.getRowCount() - 1) {
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 8, 8, false);
            } else {
                this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 8, 8, true);
            }
            this.parent.updateFilterTaskName(destination.getFilter().getElements().size());
            this.parent.updateTransformerTaskName(destination.getTransformer().getElements().size(), StringUtils.isNotBlank((CharSequence)destination.getTransformer().getOutboundTemplate()));
            this.parent.updateResponseTransformerTaskName(destination.getResponseTransformer().getElements().size(), StringUtils.isNotBlank((CharSequence)destination.getResponseTransformer().getOutboundTemplate()));
        }
    }

    public void moveDestinationUp() {
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        int destinationIndex = this.destinationTable.getSelectedModelIndex();
        destinationConnectors.add(destinationIndex - 1, (Connector)destinationConnectors.get(destinationIndex));
        destinationConnectors.remove(destinationIndex + 1);
        --this.lastModelIndex;
        this.makeDestinationTable(false);
        this.setDestinationVariableList();
        this.parent.setSaveEnabled(true);
    }

    public void moveDestinationDown() {
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        int destinationIndex = this.destinationTable.getSelectedModelIndex();
        destinationConnectors.add(destinationIndex + 2, (Connector)destinationConnectors.get(destinationIndex));
        destinationConnectors.remove(destinationIndex);
        ++this.lastModelIndex;
        this.makeDestinationTable(false);
        this.setDestinationVariableList();
        this.parent.setSaveEnabled(true);
    }

    public String checkAllForms(Channel channel) {
        String validationMessage;
        Object errors = "";
        ConnectorSettingsPanel tempConnector = null;
        ConnectorProperties tempProps = null;
        tempConnector = LoadedExtensions.getInstance().getSourceConnectors().get(channel.getSourceConnector().getTransportName());
        tempProps = channel.getSourceConnector().getProperties();
        errors = (String)errors + this.validateFilterRules(channel.getSourceConnector());
        errors = (String)errors + this.validateTransformerSteps(channel.getSourceConnector());
        if (tempConnector != null && (validationMessage = this.sourceConnectorPanel.doValidate(tempConnector, tempProps, false)) != null) {
            errors = (String)errors + validationMessage;
        }
        for (int i = 0; i < channel.getDestinationConnectors().size(); ++i) {
            String validationMessage2;
            if (!((Connector)channel.getDestinationConnectors().get(i)).isEnabled()) continue;
            tempConnector = LoadedExtensions.getInstance().getDestinationConnectors().get(((Connector)channel.getDestinationConnectors().get(i)).getTransportName());
            tempProps = ((Connector)channel.getDestinationConnectors().get(i)).getProperties();
            errors = (String)errors + this.validateFilterRules((Connector)channel.getDestinationConnectors().get(i));
            errors = (String)errors + this.validateTransformerSteps((Connector)channel.getDestinationConnectors().get(i));
            if (tempConnector != null && (validationMessage2 = this.destinationConnectorPanel.doValidate(tempConnector, tempProps, false)) != null) {
                errors = (String)errors + validationMessage2;
            }
            tempConnector = null;
            tempProps = null;
        }
        if (((String)(errors = (String)errors + this.validateScripts(channel))).equals("")) {
            errors = null;
            this.channelValidationFailed = false;
        } else {
            this.channelValidationFailed = true;
        }
        return errors;
    }

    private String validateTransformerSteps(Connector connector) {
        String validationMessage;
        Object errors = "";
        Connector currentConnector = this.transformerPane.getConnector();
        if (connector != currentConnector) {
            this.transformerPane.setConnector(connector);
        }
        for (Step step : connector.getTransformer().getElements()) {
            validationMessage = this.transformerPane.validateElement(step);
            if (!StringUtils.isNotBlank((CharSequence)validationMessage)) continue;
            errors = (String)errors + "Error in connector \"" + connector.getName() + "\" at transformer step " + step.getSequenceNumber() + " (\"" + step.getName() + "\"):\n" + validationMessage + "\n\n";
        }
        if (connector.getMode() == Connector.Mode.DESTINATION) {
            for (Step step : connector.getResponseTransformer().getElements()) {
                validationMessage = this.transformerPane.validateElement(step);
                if (!StringUtils.isNotBlank((CharSequence)validationMessage)) continue;
                errors = (String)errors + "Error in connector \"" + connector.getName() + "\" at response transformer step " + step.getSequenceNumber() + " (\"" + step.getName() + "\"):\n" + validationMessage + "\n\n";
            }
        }
        if (connector != currentConnector) {
            this.transformerPane.setConnector(currentConnector);
        }
        return errors;
    }

    private String validateFilterRules(Connector connector) {
        Object errors = "";
        Connector currentConnector = this.filterPane.getConnector();
        if (connector != currentConnector) {
            this.filterPane.setConnector(connector);
        }
        for (Rule rule : connector.getFilter().getElements()) {
            String validationMessage = this.filterPane.validateElement(rule);
            if (!StringUtils.isNotBlank((CharSequence)validationMessage)) continue;
            errors = (String)errors + "Error in connector \"" + connector.getName() + "\" at filter rule " + rule.getSequenceNumber() + " (\"" + rule.getName() + "\"):\n" + validationMessage + "\n\n";
        }
        if (connector != currentConnector) {
            this.filterPane.setConnector(currentConnector);
        }
        return errors;
    }

    private String validateScripts(Channel channel) {
        Object errors = "";
        String validationMessage = this.scriptsPanel.validateScript(channel.getDeployScript());
        if (validationMessage != null) {
            errors = (String)errors + "Error in channel script \"Deploy\":\n" + validationMessage + "\n\n";
        }
        if ((validationMessage = this.scriptsPanel.validateScript(channel.getPreprocessingScript())) != null) {
            errors = (String)errors + "Error in channel script \"Preprocessor\":\n" + validationMessage + "\n\n";
        }
        if ((validationMessage = this.scriptsPanel.validateScript(channel.getPostprocessingScript())) != null) {
            errors = (String)errors + "Error in channel script \"Postprocessor\":\n" + validationMessage + "\n\n";
        }
        if ((validationMessage = this.scriptsPanel.validateScript(channel.getUndeployScript())) != null) {
            errors = (String)errors + "Error in channel script \"Undeploy\":\n" + validationMessage + "\n\n";
        }
        return errors;
    }

    public void doValidate() {
        if (this.sourcePanel.isVisible()) {
            String validationMessage = this.sourceConnectorPanel.doValidate(this.sourceConnectorPanel.getProperties(), true);
            if (validationMessage != null) {
                this.parent.alertCustomError((Component)((Object)this.parent), validationMessage, "There was an error in the validation of your connector.  Please fix the following error(s):");
            } else {
                this.parent.alertInformation((Component)((Object)this.parent), "The connector was successfully validated.");
            }
        } else {
            String validationMessage = this.destinationConnectorPanel.doValidate(this.destinationConnectorPanel.getProperties(), true);
            if (validationMessage != null) {
                this.parent.alertWarning((Component)((Object)this.parent), validationMessage);
            } else {
                this.parent.alertInformation((Component)((Object)this.parent), "The connector was successfully validated.");
            }
        }
    }

    public void validateScripts() {
        this.scriptsPanel.validateCurrentScript();
    }

    public void showAttachmentPropertiesDialog(AttachmentHandlerType type) {
        AttachmentHandlerProperties attachmentHandlerProperties = this.currentChannel.getProperties().getAttachmentProperties();
        if (type.equals((Object)AttachmentHandlerType.IDENTITY)) {
            new IdentityAttachmentDialog(attachmentHandlerProperties);
        } else if (type.equals((Object)AttachmentHandlerType.REGEX)) {
            new RegexAttachmentDialog(attachmentHandlerProperties);
        } else if (!type.equals((Object)AttachmentHandlerType.DICOM)) {
            if (type.equals((Object)AttachmentHandlerType.JAVASCRIPT)) {
                new JavaScriptAttachmentDialog(attachmentHandlerProperties);
            } else if (type.equals((Object)AttachmentHandlerType.CUSTOM)) {
                new CustomAttachmentDialog(attachmentHandlerProperties);
            }
        }
    }

    private void initComponents() {
        this.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.channelView = new JTabbedPane();
        this.channelView.setBackground(this.getBackground());
        this.channelView.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ChannelSetup.this.showChannelEditPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChannelSetup.this.showChannelEditPopupMenu(evt);
            }
        });
        this.channelView.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                int selectedTab = ChannelSetup.this.channelView.getSelectedIndex();
                if (ChannelSetup.this.previousTab == 3 && selectedTab != 3) {
                    ChannelSetup.this.updateScriptsPanel(ChannelSetup.this.getScriptsMap());
                }
                if (selectedTab == 3) {
                    ChannelSetup.this.scriptsPanel.updateDisplayOptions();
                }
                if (selectedTab == 1 && ChannelSetup.this.sourceConnectorPanel.getConnectorSettingsPanel() != null) {
                    ChannelSetup.this.sourceConnectorPanel.getConnectorSettingsPanel().setVisible(true);
                    ChannelSetup.this.sourceConnectorPanel.updateNextFireTime();
                } else if (selectedTab == 2 && ChannelSetup.this.destinationConnectorPanel.getConnectorSettingsPanel() != null) {
                    ChannelSetup.this.destinationConnectorPanel.getConnectorSettingsPanel().setVisible(true);
                }
                ChannelSetup.this.previousTab = selectedTab;
            }
        });
        this.summaryPanel = new JPanel();
        this.summaryPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.summaryPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ChannelSetup.this.summaryComponentShown(evt);
            }
        });
        this.channelPropertiesPanel = new JPanel();
        this.channelPropertiesPanel.setBackground(this.summaryPanel.getBackground());
        this.channelPropertiesPanel.setBorder(BorderFactory.createTitledBorder("Channel Properties"));
        this.nameLabel = new JLabel("Name:");
        this.nameField = new MirthTextField();
        this.nameField.setDocument(new MirthFieldConstraints(40, false, true, true));
        this.nameField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                ChannelSetup.this.summaryNameFieldKeyReleased(evt);
            }
        });
        this.summaryEnabledCheckBox = new MirthCheckBox("Enabled");
        this.summaryEnabledCheckBox.setBackground(this.channelPropertiesPanel.getBackground());
        this.summaryEnabledCheckBox.setText("Enabled");
        this.channelIdField = new JTextField("Id: ");
        this.channelIdField.setEditable(false);
        this.channelIdField.setBackground(this.channelPropertiesPanel.getBackground());
        this.channelIdField.setHorizontalAlignment(4);
        this.channelIdField.setText("Id: ");
        this.channelIdField.setBorder(null);
        this.dataTypesLabel = new JLabel("Data Types:");
        this.dataTypesButton = new JButton("Set Data Types");
        this.dataTypesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.changeDataTypesButtonActionPerformed(evt);
            }
        });
        this.clearGlobalChannelMapCheckBox = new MirthCheckBox("Clear global channel map on deploy");
        this.clearGlobalChannelMapCheckBox.setBackground(this.channelPropertiesPanel.getBackground());
        this.revisionLabel = new JLabel("Revision: ");
        this.revisionLabel.setHorizontalAlignment(4);
        this.dependenciesLabel = new JLabel("Dependencies:");
        this.dependenciesButton = new JButton("Set Dependencies");
        this.dependenciesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.setDependenciesButtonActionPerformed(evt);
            }
        });
        this.lastModifiedLabel = new JLabel("Last Modified: ");
        this.lastModifiedLabel.setHorizontalAlignment(4);
        this.initialStateLabel = new JLabel("Initial State:");
        this.initialStateComboBox = new MirthComboBox();
        this.initialStateComboBox.setModel(new DefaultComboBoxModel<DeployedState>(new DeployedState[]{DeployedState.STARTED, DeployedState.PAUSED, DeployedState.STOPPED}));
        this.attachmentLabel = new JLabel("Attachment:");
        this.attachmentComboBox = new MirthComboBox();
        this.attachmentComboBox.setModel(new DefaultComboBoxModel<AttachmentHandlerType>(AttachmentHandlerType.values()));
        this.attachmentComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.attachmentComboBoxActionPerformed(evt);
            }
        });
        this.attachmentPropertiesButton = new JButton("Properties");
        this.attachmentPropertiesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.attachmentPropertiesButtonActionPerformed(evt);
            }
        });
        this.attachmentStoreCheckBox = new MirthCheckBox("Store Attachments");
        this.attachmentStoreCheckBox.setBackground(this.channelPropertiesPanel.getBackground());
        this.attachmentStoreCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                ChannelSetup.this.attachmentStoreCheckBoxItemStateChanged(evt);
            }
        });
        this.attachmentWarningLabel = new JLabel("Attachments will be extracted but not stored or reattached.");
        this.attachmentWarningLabel.setForeground(new Color(255, 0, 0));
        this.tagsLabel = new JLabel("Tags:");
        HashSet<FilterCompletion> tags = new HashSet<FilterCompletion>();
        for (ChannelTag tag : this.parent.getCachedChannelTags()) {
            tags.add(new TagFilterCompletion(tag));
        }
        this.tagsField = new MirthTagField(null, true, tags);
        this.tagsField.addUpdateSearchListener(new SearchFilterListener(){

            @Override
            public void doSearch(String filterString) {
            }

            @Override
            public void doDelete(String filterString) {
                ChannelSetup.this.parent.setSaveEnabled(true);
            }
        });
        this.messageStoragePanel = new JPanel();
        this.messageStoragePanel.setBackground(this.summaryPanel.getBackground());
        this.messageStoragePanel.setBorder(BorderFactory.createTitledBorder("Message Storage"));
        this.messageStoragePanel.setForeground(new Color(0, 102, 0));
        this.messageStorageSlider = new JSlider();
        this.messageStorageSlider.setBackground(this.messageStoragePanel.getBackground());
        this.messageStorageSlider.setMajorTickSpacing(1);
        this.messageStorageSlider.setMinimum(1);
        this.messageStorageSlider.setMaximum(5);
        this.messageStorageSlider.setOrientation(1);
        this.messageStorageSlider.setPaintTicks(true);
        this.messageStorageSlider.setSnapToTicks(true);
        this.messageStorageSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                ChannelSetup.this.messageStorageSliderStateChanged(evt);
            }
        });
        this.storageModeLabel = new JLabel("Development");
        this.storageModeLabel.setFont(new Font("Dialog", 1, 14));
        this.contentLabel = new JLabel("Content: ");
        this.metadataLabel = new JLabel("Metadata:");
        this.durableLabel = new JLabel("Durable Message Delivery:");
        this.durableStatusLabel = new JLabel("On");
        this.durableStatusLabel.setForeground(new Color(0, 102, 0));
        this.performanceLabel = new JLabel("Performance:");
        this.messageStorageProgressBar = new JProgressBar();
        this.messageStorageProgressBar.setValue(10);
        this.encryptMessagesCheckBox = new MirthCheckBox("Encrypt message content");
        this.encryptMessagesCheckBox.setBackground(this.messageStoragePanel.getBackground());
        this.encryptMessagesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.encryptMessagesCheckBoxActionPerformed(evt);
            }
        });
        this.encryptAttachmentsCheckBox = new MirthCheckBox("Attachments");
        this.encryptAttachmentsCheckBox.setBackground(this.messageStoragePanel.getBackground());
        this.encryptAttachmentsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.encryptMessagesCheckBoxActionPerformed(evt);
            }
        });
        this.encryptCustomMetaDataCheckBox = new MirthCheckBox("Custom metadata");
        this.encryptCustomMetaDataCheckBox.setBackground(this.messageStoragePanel.getBackground());
        this.encryptCustomMetaDataCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.encryptMessagesCheckBoxActionPerformed(evt);
            }
        });
        this.removeContentCheckBox = new MirthCheckBox("Remove content on completion");
        this.removeContentCheckBox.setBackground(this.messageStoragePanel.getBackground());
        this.removeContentCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.removeContentCheckboxActionPerformed(evt);
            }
        });
        this.removeAttachmentsCheckBox = new MirthCheckBox("Remove attachments on completion");
        this.removeAttachmentsCheckBox.setBackground(this.messageStoragePanel.getBackground());
        this.removeAttachmentsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.removeAttachmentsCheckboxActionPerformed(evt);
            }
        });
        this.removeOnlyFilteredCheckBox = new MirthCheckBox("Filtered only");
        this.removeOnlyFilteredCheckBox.setBackground(this.messageStoragePanel.getBackground());
        this.queueWarningLabel = new JLabel("<html>Disable source & destination queueing before using this mode</html>");
        this.queueWarningLabel.setFont(new Font("Dialog", 0, 11));
        this.queueWarningLabel.setForeground(new Color(255, 0, 0));
        this.queueWarningLabel.setVerticalAlignment(1);
        this.messagePruningPanel = new JPanel();
        this.messagePruningPanel.setBackground(this.summaryPanel.getBackground());
        this.messagePruningPanel.setBorder(BorderFactory.createTitledBorder("Message Pruning"));
        this.metadataPruningLabel = new JLabel("Metadata:");
        ButtonGroup metadataPruningButtonGroup = new ButtonGroup();
        this.metadataPruningOffRadio = new JRadioButton("Store indefinitely");
        this.metadataPruningOffRadio.setBackground(this.messagePruningPanel.getBackground());
        this.metadataPruningOffRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.metadataPruningOffRadioActionPerformed(evt);
            }
        });
        metadataPruningButtonGroup.add(this.metadataPruningOffRadio);
        this.metadataPruningOnRadio = new JRadioButton("Prune metadata older than");
        this.metadataPruningOnRadio.setBackground(this.messagePruningPanel.getBackground());
        this.metadataPruningOnRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.metadataPruningOnRadioActionPerformed(evt);
            }
        });
        metadataPruningButtonGroup.add(this.metadataPruningOnRadio);
        this.metadataPruningDaysTextField = new MirthTextField();
        this.metadataPruningDaysTextField.setDocument(new MirthFieldConstraints(3, false, false, true));
        this.metadataDaysLabel = new JLabel("days");
        this.contentPruningLabel = new JLabel("Content:");
        ButtonGroup contentPruningButtonGroup = new ButtonGroup();
        this.contentPruningMetadataRadio = new JRadioButton("Prune when message metadata is removed");
        this.contentPruningMetadataRadio.setBackground(this.messagePruningPanel.getBackground());
        this.contentPruningMetadataRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.contentPruningMetadataRadioActionPerformed(evt);
            }
        });
        contentPruningButtonGroup.add(this.contentPruningMetadataRadio);
        this.contentPruningDaysRadio = new JRadioButton("Prune content older than");
        this.contentPruningDaysRadio.setBackground(this.messagePruningPanel.getBackground());
        this.contentPruningDaysRadio.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.contentPruningDaysRadioActionPerformed(evt);
            }
        });
        contentPruningButtonGroup.add(this.contentPruningDaysRadio);
        this.contentPruningDaysTextField = new MirthTextField();
        this.contentPruningDaysTextField.setDocument(new MirthFieldConstraints(3, false, false, true));
        this.contentDaysLabel = new JLabel("days");
        this.archiveCheckBox = new MirthCheckBox("Allow message archiving");
        this.archiveCheckBox.setBackground(this.messagePruningPanel.getBackground());
        this.pruneErroredMessagesCheckBox = new MirthCheckBox("Prune Errored Messages");
        this.pruneErroredMessagesCheckBox.setBackground(this.messagePruningPanel.getBackground());
        this.pruneErroredMessagesCheckBox.addActionListener(evt -> this.pruneErroredMessagesCheckBoxActionPerformed(evt));
        this.pruningWarningLabel = new JLabel(PRUNING_WARNING_DEFAULT_TEXT);
        this.customMetadataPanel = new JPanel();
        this.customMetadataPanel.setBackground(this.summaryPanel.getBackground());
        this.customMetadataPanel.setBorder(BorderFactory.createTitledBorder("Custom Metadata"));
        this.metaDataTable = new MirthTable();
        DefaultTableModel model = new DefaultTableModel(new Object[0][], new String[]{METADATA_NAME_COLUMN_NAME, METADATA_TYPE_COLUMN_NAME, METADATA_MAPPING_COLUMN_NAME}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                if (!value.equals(this.getValueAt(row, column))) {
                    ChannelSetup.this.revertMetaDataButton.setEnabled(true);
                }
                super.setValueAt(value, row, column);
            }
        };
        model.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (e.getType() == 0) {
                    ChannelSetup.this.parent.setSaveEnabled(true);
                }
            }
        });
        this.metaDataTable.setModel(model);
        this.metaDataTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.metaDataTable.setSelectionMode(0);
        this.metaDataTable.setDragEnabled(false);
        this.metaDataTable.setSortable(false);
        this.metaDataTable.getTableHeader().setReorderingAllowed(false);
        this.metaDataTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                ChannelSetup.this.deleteMetaDataButton.setEnabled(ChannelSetup.this.metaDataTable.getSelectedRow() != -1);
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.metaDataTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        class AlphaNumericCellEditor
        extends TextFieldCellEditor {
            public AlphaNumericCellEditor() {
                MirthFieldConstraints constraints = new MirthFieldConstraints("^[a-zA-Z_0-9]*$");
                constraints.setLimit(30);
                this.getTextField().setDocument(constraints);
            }

            @Override
            protected boolean valueChanged(String value) {
                return true;
            }
        }
        this.metaDataTable.getColumnModel().getColumn(this.metaDataTable.getColumnModel().getColumnIndex(METADATA_NAME_COLUMN_NAME)).setCellEditor(new AlphaNumericCellEditor());
        this.metaDataTable.getColumnModel().getColumn(this.metaDataTable.getColumnModel().getColumnIndex(METADATA_MAPPING_COLUMN_NAME)).setCellEditor(new AlphaNumericCellEditor());
        TableColumn column = this.metaDataTable.getColumnModel().getColumn(this.metaDataTable.getColumnModel().getColumnIndex(METADATA_TYPE_COLUMN_NAME));
        column.setCellRenderer(new MirthComboBoxTableCellRenderer(MetaDataColumnType.values()));
        column.setCellEditor(new MirthComboBoxTableCellEditor((JTable)((Object)this.metaDataTable), MetaDataColumnType.values(), 1, false, null));
        column.setMinWidth(100);
        column.setMaxWidth(100);
        this.metaDataScrollPane = new JScrollPane((Component)((Object)this.metaDataTable));
        this.addMetaDataButton = new JButton("Add");
        this.addMetaDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.addMetaDataButtonActionPerformed(evt);
            }
        });
        this.deleteMetaDataButton = new JButton("Delete");
        this.deleteMetaDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.deleteMetaDataButtonActionPerformed(evt);
            }
        });
        this.revertMetaDataButton = new JButton("Revert");
        this.revertMetaDataButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.revertMetaDataButtonActionPerformed(evt);
            }
        });
        this.descriptionPanel = new JPanel();
        this.descriptionPanel.setBackground(this.summaryPanel.getBackground());
        this.descriptionPanel.setBorder(BorderFactory.createTitledBorder("Channel Description"));
        this.summaryDescriptionText = new MirthTextPane();
        this.summaryDescriptionScrollPane = new JScrollPane(this.summaryDescriptionText);
        this.sourcePanel = new JPanel();
        this.sourcePanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.sourcePanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ChannelSetup.this.sourceComponentShown(evt);
            }
        });
        this.sourceConnectorTypeLabel = new JLabel("Connector Type:");
        this.sourceConnectorTypeComboBox = new MirthComboBox();
        this.sourceConnectorTypeComboBox.setMaximumRowCount(20);
        this.sourceConnectorTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.sourceSourceDropdownActionPerformed(evt);
            }
        });
        this.sourceConnectorPanel = new ConnectorPanel();
        this.sourceConnectorPanel.setChannelSetup(this);
        this.sourceConnectorScrollPane = new JScrollPane(this.sourceConnectorPanel);
        this.sourceConnectorScrollPane.setBorder(null);
        this.destinationsPanel = new JPanel();
        this.destinationsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.destinationsPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ChannelSetup.this.destinationComponentShown(evt);
            }
        });
        this.destinationTable = new MirthTable();
        this.destinationTable.setModel(new RefreshTableModel(new String[]{STATUS_COLUMN_NAME, DESTINATION_COLUMN_NAME, METADATA_COLUMN_NAME, CONNECTOR_TYPE_COLUMN_NAME, DESTINATION_CHAIN_COLUMN_NAME}, 0){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, true, false, false, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.destinationTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.destinationTable.getColumnModel().getColumn(this.destinationTable.getColumnModel().getColumnIndex(DESTINATION_COLUMN_NAME)).setCellEditor(new DestinationTableCellEditor());
        this.destinationTable.setCustomEditorControls(true);
        this.destinationTable.getColumnExt(STATUS_COLUMN_NAME).setMaxWidth(200);
        this.destinationTable.getColumnExt(STATUS_COLUMN_NAME).setMinWidth(75);
        this.destinationTable.getColumnExt(STATUS_COLUMN_NAME).setCellRenderer((TableCellRenderer)new ImageCellRenderer());
        this.destinationTable.getColumnExt(METADATA_COLUMN_NAME).setMaxWidth(30);
        this.destinationTable.getColumnExt(METADATA_COLUMN_NAME).setMinWidth(30);
        this.destinationTable.getColumnExt(METADATA_COLUMN_NAME).setCellRenderer((TableCellRenderer)new NumberCellRenderer(0, false));
        this.destinationTable.getColumnExt(CONNECTOR_TYPE_COLUMN_NAME).setCellRenderer((TableCellRenderer)new ConnectorTypeCellRenderer());
        this.destinationTable.getColumnExt(DESTINATION_CHAIN_COLUMN_NAME).setCellRenderer((TableCellRenderer)new NumberCellRenderer(0, false));
        this.destinationTable.getColumnExt(DESTINATION_CHAIN_COLUMN_NAME).setMaxWidth(50);
        this.destinationTable.setSelectionMode(0);
        this.destinationTable.setRowSelectionAllowed(true);
        this.destinationTable.setRowHeight(20);
        this.destinationTable.setFocusable(true);
        this.destinationTable.setSortable(false);
        this.destinationTable.getTableHeader().setReorderingAllowed(false);
        this.destinationTable.setOpaque(true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.destinationTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.destinationTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    if (ChannelSetup.this.lastModelIndex != -1 && ChannelSetup.this.lastModelIndex != ChannelSetup.this.destinationTable.getRowCount() && !ChannelSetup.this.isDeleting) {
                        Connector destinationConnector = (Connector)ChannelSetup.this.currentChannel.getDestinationConnectors().get(ChannelSetup.this.lastModelIndex);
                        ConnectorProperties props = ChannelSetup.this.destinationConnectorPanel.getProperties();
                        ((DestinationConnectorPropertiesInterface)props).getDestinationConnectorProperties().setResourceIds(ChannelSetup.this.resourceIds.get(destinationConnector.getMetaDataId()));
                        destinationConnector.setProperties(props);
                    }
                    if (!ChannelSetup.this.loadConnector()) {
                        if (ChannelSetup.this.lastModelIndex == ChannelSetup.this.destinationTable.getRowCount()) {
                            ChannelSetup.this.destinationTable.setRowSelectionInterval(ChannelSetup.this.lastModelIndex - 1, ChannelSetup.this.lastModelIndex - 1);
                        } else if (ChannelSetup.this.lastModelIndex >= 0 && ChannelSetup.this.lastModelIndex < ChannelSetup.this.destinationTable.getRowCount()) {
                            ChannelSetup.this.destinationTable.setRowSelectionInterval(ChannelSetup.this.lastModelIndex, ChannelSetup.this.lastModelIndex);
                        } else {
                            ChannelSetup.this.destinationTable.setRowSelectionInterval(0, 0);
                        }
                    } else {
                        ChannelSetup.this.lastModelIndex = ChannelSetup.this.destinationTable.getSelectedModelIndex();
                    }
                    ChannelSetup.this.saveDestinationPanel();
                    ChannelSetup.this.checkVisibleDestinationTasks();
                }
            }
        });
        this.destinationTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ChannelSetup.this.checkSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                ChannelSetup.this.checkSelectionAndPopupMenu(evt);
            }
        });
        this.destinationTable.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 127) {
                    ChannelSetup.this.parent.doDeleteDestination();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.destinationTable.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                ChannelSetup.this.destinationTableScrollPane.getMouseWheelListeners()[0].mouseWheelMoved(e);
            }
        });
        this.destinationTableScrollPane = new JScrollPane((Component)((Object)this.destinationTable));
        this.destinationTableScrollPane.setWheelScrollingEnabled(true);
        this.destinationConnectorTypeLabel = new JLabel("Connector Type:");
        this.destinationConnectorTypeComboBox = new MirthComboBox();
        this.destinationConnectorTypeComboBox.setMaximumRowCount(20);
        this.destinationConnectorTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.destinationSourceDropdownActionPerformed(evt);
            }
        });
        this.waitForPreviousCheckbox = new MirthCheckBox("Wait for previous destination");
        this.waitForPreviousCheckbox.setBackground(this.destinationsPanel.getBackground());
        this.waitForPreviousCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChannelSetup.this.waitForPreviousCheckboxActionPerformed(evt);
            }
        });
        this.destinationConnectorPanel = new ConnectorPanel();
        this.destinationConnectorPanel.setChannelSetup(this);
        this.destinationConnectorScrollPane = new JScrollPane(this.destinationConnectorPanel);
        this.destinationConnectorScrollPane.setBorder(null);
        this.destinationVariableList = new VariableList();
        this.scriptsPanel = new ScriptPanel(false);
        this.scriptsPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.scriptsPanel.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ChannelSetup.this.scriptsComponentShown(evt);
            }
        });
    }

    private void initToolTips() {
        this.summaryEnabledCheckBox.setToolTipText("Enable this channel so that it can be deployed.");
        this.clearGlobalChannelMapCheckBox.setToolTipText("Clear the global channel map on both single channel deploy and a full redeploy.");
        this.attachmentStoreCheckBox.setToolTipText("If checked, attachments will be stored in the database and available for reattachment.");
        this.encryptMessagesCheckBox.setToolTipText("<html>Encrypt message content that is stored in the database. Messages that<br>are stored while this option is enabled will still be viewable in the<br>message browser, but the content will not be searchable.</html>");
        this.encryptAttachmentsCheckBox.setToolTipText("<html>Encrypt message attachments that are stored in the database.<br>Attachments that are stored while this option is enabled<br>will still be viewable in the message browser.</html>");
        this.encryptCustomMetaDataCheckBox.setToolTipText("<html>Encrypt custom metadata columns that are stored in the database.<br/>Custom metadata values that are stored while this option is<br/>enabled will still be viewable in the message browser, but<br/>the metadata will not be searchable.<br/><br/>This will only apply to STRING type custom metadata columns.</html>");
        this.removeContentCheckBox.setToolTipText("<html>Remove message content once the message has completed processing.<br/>Not applicable for messages that are errored or queued.</html>");
        this.removeAttachmentsCheckBox.setToolTipText("<html>Remove message attachments once the message has completed processing.<br/>Not applicable for messages that are errored or queued.</html>");
        this.removeOnlyFilteredCheckBox.setToolTipText("<html>If checked, only content for filtered connector messages will be removed.</html>");
        this.archiveCheckBox.setToolTipText("<html>If checked and the data pruner and archiver are enabled, messages<br />in this channel will be archived before being pruned.</html>");
        this.pruneErroredMessagesCheckBox.setToolTipText("<html>If checked and the data pruner is enabled,<br />errored messages in this channel will be pruned.</html>");
        this.revertMetaDataButton.setToolTipText("<html>Revert the custom metadata settings to the last save.<br>This option allows you to undo your metadata changes without affecting the rest of the channel.</html>");
        this.waitForPreviousCheckbox.setToolTipText("<html>Wait for the previous destination to finish before processing the current destination.<br/>Each destination connector for which this is not selected marks the beginning of a destination chain,<br/>such that all chains execute asynchronously, but each destination within a particular chain executes in order.<br/>This option has no effect on the first destination connector, which always marks the beginning of the first chain.</html>");
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.channelPropertiesPanel.setLayout((LayoutManager)new MigLayout("insets 0 10 10 10, novisualpadding, hidemode 3, fill, gap 6", "[]12[]12[][grow]"));
        this.channelPropertiesPanel.add((Component)this.nameLabel, "right");
        this.channelPropertiesPanel.add((Component)this.nameField, "w 185!");
        this.channelPropertiesPanel.add(this.summaryEnabledCheckBox);
        this.channelPropertiesPanel.add((Component)this.channelIdField, "right");
        this.channelPropertiesPanel.add((Component)this.dataTypesLabel, "newline, right");
        this.channelPropertiesPanel.add((Component)this.dataTypesButton, "w 108!");
        this.channelPropertiesPanel.add(this.clearGlobalChannelMapCheckBox);
        this.channelPropertiesPanel.add((Component)this.revisionLabel, "right");
        this.channelPropertiesPanel.add((Component)this.dependenciesLabel, "newline, right");
        this.channelPropertiesPanel.add((Component)this.dependenciesButton, "w 108!");
        this.channelPropertiesPanel.add((Component)this.lastModifiedLabel, "skip 1, right");
        this.channelPropertiesPanel.add((Component)this.initialStateLabel, "newline, right");
        this.channelPropertiesPanel.add(this.initialStateComboBox, "w 108!");
        this.channelPropertiesPanel.add((Component)this.attachmentLabel, "newline, right");
        this.channelPropertiesPanel.add(this.attachmentComboBox, "w 108!, split 2");
        this.channelPropertiesPanel.add((Component)this.attachmentPropertiesButton, "gapbefore 6");
        this.channelPropertiesPanel.add((Component)this.attachmentStoreCheckBox, "split 2");
        this.channelPropertiesPanel.add((Component)this.attachmentWarningLabel, "gapbefore 12");
        this.channelPropertiesPanel.add((Component)this.tagsLabel, "newline, right");
        this.channelPropertiesPanel.add((Component)this.tagsField, "sx, growx");
        this.messageStoragePanel.setLayout((LayoutManager)new MigLayout("insets 0 10 5 22, novisualpadding, hidemode 3, gap 6", "", "[][][][][][]4[]4[]4[]"));
        this.messageStoragePanel.add((Component)this.messageStorageSlider, "spany, h 167!, top");
        this.messageStoragePanel.add(this.storageModeLabel);
        this.messageStoragePanel.add((Component)this.contentLabel, "newline");
        this.messageStoragePanel.add((Component)this.metadataLabel, "newline");
        this.messageStoragePanel.add((Component)this.durableLabel, "newline, split 2");
        this.messageStoragePanel.add(this.durableStatusLabel);
        this.messageStoragePanel.add((Component)this.performanceLabel, "newline, sx, split 2");
        this.messageStoragePanel.add((Component)this.messageStorageProgressBar, "growx, gapbefore 12");
        this.messageStoragePanel.add((Component)this.encryptMessagesCheckBox, "newline, split 3");
        this.messageStoragePanel.add(this.encryptAttachmentsCheckBox);
        this.messageStoragePanel.add(this.encryptCustomMetaDataCheckBox);
        this.messageStoragePanel.add((Component)this.removeContentCheckBox, "newline, split 2");
        this.messageStoragePanel.add(this.removeOnlyFilteredCheckBox);
        this.messageStoragePanel.add((Component)this.removeAttachmentsCheckBox, "newline");
        this.messageStoragePanel.add((Component)this.queueWarningLabel, "newline");
        this.messagePruningPanel.setLayout((LayoutManager)new MigLayout("insets 0 10 10 10, novisualpadding, hidemode 3, gap 6"));
        this.messagePruningPanel.add(this.metadataPruningLabel);
        this.messagePruningPanel.add((Component)this.metadataPruningOffRadio, "newline, gapleft 12");
        this.messagePruningPanel.add((Component)this.metadataPruningOnRadio, "newline, gapleft 12, split 3");
        this.messagePruningPanel.add((Component)this.metadataPruningDaysTextField, "w 30!");
        this.messagePruningPanel.add(this.metadataDaysLabel);
        this.messagePruningPanel.add((Component)this.contentPruningLabel, "newline");
        this.messagePruningPanel.add((Component)this.contentPruningMetadataRadio, "newline, gapleft 12");
        this.messagePruningPanel.add((Component)this.contentPruningDaysRadio, "newline, gapleft 12, split 3");
        this.messagePruningPanel.add((Component)this.contentPruningDaysTextField, "w 30!");
        this.messagePruningPanel.add(this.contentDaysLabel);
        this.messagePruningPanel.add((Component)this.archiveCheckBox, "newline");
        this.messagePruningPanel.add((Component)this.pruneErroredMessagesCheckBox, "newline");
        this.messagePruningPanel.add((Component)this.pruningWarningLabel, "newline");
        this.customMetadataPanel.setLayout((LayoutManager)new MigLayout("insets 0 10 10 10, novisualpadding, hidemode 3, fill, gap 6", "[grow][]"));
        this.customMetadataPanel.add((Component)this.metaDataScrollPane, "sy, grow");
        this.customMetadataPanel.add((Component)this.addMetaDataButton, "top, sg button, flowy, split 2");
        this.customMetadataPanel.add((Component)this.deleteMetaDataButton, "sg button");
        this.customMetadataPanel.add((Component)this.revertMetaDataButton, "newline, bottom, sg button");
        this.descriptionPanel.setLayout((LayoutManager)new MigLayout("insets 0 10 10 10, novisualpadding, hidemode 3, fill"));
        this.descriptionPanel.add((Component)this.summaryDescriptionScrollPane, "grow");
        this.summaryPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill", "", "[][][][grow]"));
        this.summaryPanel.add((Component)this.channelPropertiesPanel, "growx, sx");
        this.summaryPanel.add((Component)this.messageStoragePanel, "newline, w 420!, h 230!, split 2");
        this.summaryPanel.add((Component)this.messagePruningPanel, "growx, pushx, h 230!");
        this.summaryPanel.add((Component)this.customMetadataPanel, "newline, growx, sx, h 150!");
        this.summaryPanel.add((Component)this.descriptionPanel, "newline, sx, grow");
        this.sourcePanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "[]12[]", "[][grow]"));
        this.sourcePanel.add((Component)this.sourceConnectorTypeLabel, "split 2");
        this.sourcePanel.add(this.sourceConnectorTypeComboBox, "gapbefore 12");
        this.sourcePanel.add((Component)this.sourceConnectorScrollPane, "newline, sx, grow");
        this.destinationsPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "[]12[]", "[][][grow]"));
        this.destinationsPanel.add((Component)this.destinationTableScrollPane, "sx, growx, h 165!");
        this.destinationsPanel.add((Component)this.destinationConnectorTypeLabel, "newline, split 3");
        this.destinationsPanel.add(this.destinationConnectorTypeComboBox, "gapbefore 12");
        this.destinationsPanel.add((Component)this.waitForPreviousCheckbox, "gapbefore 12");
        this.destinationsPanel.add((Component)this.destinationConnectorScrollPane, "newline, grow, pushx");
        this.destinationsPanel.add((Component)this.destinationVariableList, "w 185!, growy");
        this.channelView.addTab("Summary", this.summaryPanel);
        this.channelView.addTab("Source", this.sourcePanel);
        this.channelView.addTab("Destinations", this.destinationsPanel);
        this.channelView.addTab("Scripts", this.scriptsPanel);
        this.add((Component)this.channelView, "grow, h 600, w 600");
    }

    private void scriptsComponentShown(ComponentEvent evt) {
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 1, 13, false);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 15, 15, true);
    }

    private void sourceComponentShown(ComponentEvent evt) {
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 1, 1, true);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 2, 8, false);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 9, 10, true);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 11, 11, false);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 12, 14, true);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 15, 15, false);
        this.parent.updateFilterTaskName(this.currentChannel.getSourceConnector().getFilter().getElements().size());
        this.parent.updateTransformerTaskName(this.currentChannel.getSourceConnector().getTransformer().getElements().size(), StringUtils.isNotBlank((CharSequence)this.currentChannel.getSourceConnector().getTransformer().getOutboundTemplate()));
        int connectorIndex = this.destinationTable.getSelectedModelIndex();
        Connector destinationConnector = (Connector)this.currentChannel.getDestinationConnectors().get(connectorIndex);
        ConnectorProperties props = this.destinationConnectorPanel.getProperties();
        ((DestinationConnectorPropertiesInterface)props).getDestinationConnectorProperties().setResourceIds(this.resourceIds.get(destinationConnector.getMetaDataId()));
        destinationConnector.setProperties(props);
        this.updateScripts();
        this.sourceConnectorPanel.updateResponseDropDown();
        if (this.channelValidationFailed) {
            this.sourceConnectorPanel.checkProperties(this.sourceConnectorPanel.getProperties(), true);
        }
    }

    private void destinationComponentShown(ComponentEvent evt) {
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 1, 1, true);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 2, 13, true);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 15, 15, false);
        this.checkVisibleDestinationTasks();
        if (this.channelValidationFailed && ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).isEnabled()) {
            this.destinationConnectorPanel.checkProperties(this.destinationConnectorPanel.getProperties(), true);
        }
    }

    private void sourceSourceDropdownActionPerformed(ActionEvent evt) {
        if (!this.loadingChannel) {
            boolean changeType;
            if (this.sourceConnectorPanel.getName() != null && this.sourceConnectorPanel.getName().equals(this.sourceConnectorTypeComboBox.getSelectedItem())) {
                return;
            }
            if (!PropertyVerifier.compareProps((ConnectorProperties)this.sourceConnectorPanel.getProperties(), (ConnectorProperties)this.sourceConnectorPanel.getDefaults()) && !(changeType = this.parent.alertOption((Component)((Object)this.parent), "Are you sure you would like to change this connector type and lose all of the current connector data?"))) {
                this.sourceConnectorTypeComboBox.setSelectedItem(this.sourceConnectorPanel.getProperties().getName());
                return;
            }
        }
        if (this.currentChannel.getSourceConnector().getTransportName().equalsIgnoreCase(DATABASE_READER)) {
            this.currentChannel.getSourceConnector().getTransformer().setInboundTemplate("");
            if (this.parent.channelEditPanel.currentChannel.getSourceConnector().getTransformer().getOutboundDataType() == "XML" && this.parent.channelEditPanel.currentChannel.getSourceConnector().getTransformer().getOutboundTemplate() != null && this.parent.channelEditPanel.currentChannel.getSourceConnector().getTransformer().getOutboundTemplate().length() == 0) {
                List list = this.parent.channelEditPanel.currentChannel.getDestinationConnectors();
                for (Connector c : list) {
                    c.getTransformer().setInboundTemplate("");
                }
            }
        }
        this.sourceConnectorPanel.setConnectorSettingsPanel(LoadedExtensions.getInstance().getSourceConnectors().get((String)this.sourceConnectorTypeComboBox.getSelectedItem()));
        Connector sourceConnector = this.currentChannel.getSourceConnector();
        if (sourceConnector != null) {
            String connectorName = "";
            if (sourceConnector.getProperties() != null) {
                connectorName = sourceConnector.getProperties().getName();
            }
            if (sourceConnector.getProperties() == null || !connectorName.equals(this.sourceConnectorTypeComboBox.getSelectedItem())) {
                String name = sourceConnector.getName();
                this.changeConnectorType(sourceConnector, false);
                sourceConnector.setName(name);
                ConnectorProperties props = this.sourceConnectorPanel.getDefaults();
                ((SourceConnectorPropertiesInterface)props).getSourceConnectorProperties().setResourceIds(this.resourceIds.get(sourceConnector.getMetaDataId()));
                this.sourceConnectorPanel.setProperties(props);
                props = this.sourceConnectorPanel.getProperties();
                ((SourceConnectorPropertiesInterface)props).getSourceConnectorProperties().setResourceIds(this.resourceIds.get(sourceConnector.getMetaDataId()));
                sourceConnector.setProperties(props);
                this.checkAndSetSourceDataType();
            }
            sourceConnector.setTransportName((String)this.sourceConnectorTypeComboBox.getSelectedItem());
            this.currentChannel.setSourceConnector(sourceConnector);
            ConnectorProperties props = sourceConnector.getProperties();
            ((SourceConnectorPropertiesInterface)props).getSourceConnectorProperties().setResourceIds(this.resourceIds.get(sourceConnector.getMetaDataId()));
            this.sourceConnectorPanel.setProperties(props);
        }
        this.sourceConnectorScrollPane.repaint();
        if (this.channelValidationFailed) {
            this.sourceConnectorPanel.checkProperties(this.sourceConnectorPanel.getProperties(), true);
        }
    }

    private void destinationSourceDropdownActionPerformed(ActionEvent evt) {
        if (!this.loadingChannel && !this.isDeleting) {
            boolean changeType;
            if (this.destinationConnectorPanel.getProperties().getName() != null && this.destinationConnectorPanel.getProperties().getName().equals(this.destinationConnectorTypeComboBox.getSelectedItem()) && this.lastModelIndex == this.destinationTable.getSelectedModelIndex()) {
                return;
            }
            if (this.lastModelIndex == this.destinationTable.getSelectedModelIndex() && !PropertyVerifier.compareProps((ConnectorProperties)this.destinationConnectorPanel.getProperties(), (ConnectorProperties)this.destinationConnectorPanel.getDefaults()) && !(changeType = this.parent.alertOption((Component)((Object)this.parent), "Are you sure you would like to change this connector type and lose all of the current connector data?"))) {
                this.destinationConnectorTypeComboBox.setSelectedItem(this.destinationConnectorPanel.getProperties().getName());
                return;
            }
        }
        this.generateMultipleDestinationPage();
        if (this.channelValidationFailed && ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).isEnabled()) {
            this.destinationConnectorPanel.checkProperties(this.destinationConnectorPanel.getProperties(), true);
        }
    }

    private void waitForPreviousCheckboxActionPerformed(ActionEvent evt) {
        ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).setWaitForPrevious(this.waitForPreviousCheckbox.isSelected());
        TableModel model = this.destinationTable.getModel();
        int rowCount = model.getRowCount();
        int colNum = this.destinationTable.getColumnModelIndex(DESTINATION_CHAIN_COLUMN_NAME);
        boolean waitForPrevious = this.waitForPreviousCheckbox.isSelected();
        for (int i = this.destinationTable.getSelectedModelIndex(); i < rowCount; ++i) {
            Integer chain = (Integer)model.getValueAt(i, colNum);
            chain = chain + (waitForPrevious ? -1 : 1);
            model.setValueAt(chain, i, colNum);
        }
    }

    private void summaryComponentShown(ComponentEvent evt) {
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 1, 13, false);
        this.parent.setVisibleTasks(this.parent.channelEditTasks, this.parent.channelEditPopupMenu, 15, 15, false);
    }

    private void metadataPruningOffRadioActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        this.metadataPruningDaysTextField.setEnabled(false);
        if (this.contentPruningMetadataRadio.isSelected()) {
            this.archiveCheckBox.setEnabled(false);
            this.pruneErroredMessagesCheckBox.setEnabled(false);
        }
    }

    private void attachmentComboBoxActionPerformed(ActionEvent evt) {
        boolean changeType;
        AttachmentHandlerType type = (AttachmentHandlerType)this.attachmentComboBox.getSelectedItem();
        AttachmentHandlerType lastType = AttachmentHandlerType.fromString((String)this.currentChannel.getProperties().getAttachmentProperties().getType());
        if (lastType != AttachmentHandlerType.NONE && lastType != type && !lastType.getDefaultProperties().equals((Object)this.currentChannel.getProperties().getAttachmentProperties()) && !(changeType = this.parent.alertOption((Component)((Object)this.parent), "Are you sure you would like to change this attachment handler type and lose all of the current handler data?"))) {
            this.attachmentComboBox.setSelectedItem(lastType);
            this.attachmentPropertiesButton.setEnabled(lastType != AttachmentHandlerType.NONE && lastType != AttachmentHandlerType.DICOM);
            return;
        }
        this.attachmentPropertiesButton.setEnabled(type != AttachmentHandlerType.NONE && type != AttachmentHandlerType.DICOM);
        if (lastType != type) {
            this.currentChannel.getProperties().setAttachmentProperties(type.getDefaultProperties());
        }
        MessageStorageMode messageStorageMode = MessageStorageMode.fromInt((int)this.messageStorageSlider.getValue());
        switch (messageStorageMode) {
            case METADATA: 
            case DISABLED: {
                this.attachmentStoreCheckBox.setSelected(false);
                this.attachmentStoreCheckBox.setEnabled(false);
                break;
            }
            default: {
                this.attachmentStoreCheckBox.setSelected(true);
                this.attachmentStoreCheckBox.setEnabled(true);
            }
        }
        if (type == AttachmentHandlerType.NONE) {
            this.attachmentWarningLabel.setVisible(false);
        } else {
            this.attachmentWarningLabel.setVisible(!this.attachmentStoreCheckBox.isEnabled());
        }
    }

    private void attachmentPropertiesButtonActionPerformed(ActionEvent evt) {
        this.showAttachmentPropertiesDialog((AttachmentHandlerType)this.attachmentComboBox.getSelectedItem());
    }

    private void changeDataTypesButtonActionPerformed(ActionEvent evt) {
        String previousDataType = this.currentChannel.getSourceConnector().getTransformer().getInboundDataType();
        AttachmentHandlerType previousDefaultAttachmentHandlerType = LoadedExtensions.getInstance().getDataTypePlugins().get(previousDataType).getDefaultAttachmentHandlerType();
        AttachmentHandlerType previousAttachmentHandlerType = (AttachmentHandlerType)this.attachmentComboBox.getSelectedItem();
        new DataTypesDialog();
        String dataType = this.currentChannel.getSourceConnector().getTransformer().getInboundDataType();
        AttachmentHandlerType defaultAttachmentHandlerType = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultAttachmentHandlerType();
        if (defaultAttachmentHandlerType != null) {
            this.attachmentComboBox.setSelectedItem(defaultAttachmentHandlerType);
        } else if (previousAttachmentHandlerType == previousDefaultAttachmentHandlerType) {
            this.attachmentComboBox.setSelectedItem(AttachmentHandlerType.NONE);
        }
    }

    private void summaryNameFieldKeyReleased(KeyEvent evt) {
        this.currentChannel.setName(this.nameField.getText());
        this.parent.setPanelName("Edit Channel - " + this.currentChannel.getName());
    }

    private void addMetaDataButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.metaDataTable.getModel();
        int row = model.getRowCount();
        model.addRow(new Object[]{"", MetaDataColumnType.STRING, ""});
        this.metaDataTable.setRowSelectionInterval(row, row);
        this.revertMetaDataButton.setEnabled(true);
        this.parent.setSaveEnabled(true);
    }

    private void deleteMetaDataButtonActionPerformed(ActionEvent evt) {
        int rowCount;
        int selectedRow = this.metaDataTable.getSelectedRow();
        if (selectedRow != -1 && !this.metaDataTable.isEditing()) {
            ((DefaultTableModel)this.metaDataTable.getModel()).removeRow(selectedRow);
        }
        if ((rowCount = this.metaDataTable.getRowCount()) > 0) {
            if (selectedRow >= rowCount) {
                --selectedRow;
            }
            this.metaDataTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
        this.revertMetaDataButton.setEnabled(true);
        this.parent.setSaveEnabled(true);
    }

    private void encryptMessagesCheckBoxActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        this.updateStorageMode();
    }

    private void messageStorageSliderStateChanged(ChangeEvent evt) {
        this.parent.setSaveEnabled(true);
        this.updateStorageMode();
        MessageStorageMode messageStorageMode = MessageStorageMode.fromInt((int)this.messageStorageSlider.getValue());
        switch (messageStorageMode) {
            case METADATA: 
            case DISABLED: {
                if (!this.attachmentStoreCheckBox.isEnabled()) break;
                this.attachmentStoreCheckBox.setSelected(false);
                this.attachmentStoreCheckBox.setEnabled(false);
                break;
            }
            default: {
                if (this.attachmentStoreCheckBox.isEnabled()) break;
                this.attachmentStoreCheckBox.setSelected(this.attachmentComboBox.getSelectedItem() != AttachmentHandlerType.NONE);
                this.attachmentStoreCheckBox.setEnabled(true);
            }
        }
    }

    private void removeContentCheckboxActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        this.updateStorageMode();
    }

    private void metadataPruningOnRadioActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        this.metadataPruningDaysTextField.setEnabled(true);
        this.archiveCheckBox.setEnabled(true);
        this.pruneErroredMessagesCheckBox.setEnabled(true);
    }

    private void contentPruningMetadataRadioActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        this.contentPruningDaysTextField.setEnabled(false);
        if (this.metadataPruningOffRadio.isSelected()) {
            this.archiveCheckBox.setEnabled(false);
            this.pruneErroredMessagesCheckBox.setEnabled(false);
        }
    }

    private void contentPruningDaysRadioActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        this.contentPruningDaysTextField.setEnabled(true);
        this.archiveCheckBox.setEnabled(true);
        this.pruneErroredMessagesCheckBox.setEnabled(true);
    }

    private void pruneErroredMessagesCheckBoxActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        if (this.pruneErroredMessagesCheckBox.isSelected()) {
            this.pruningWarningLabel.setText(PRUNING_WARNING_ERRORED_TEXT);
        } else {
            this.pruningWarningLabel.setText(PRUNING_WARNING_DEFAULT_TEXT);
        }
    }

    private void revertMetaDataButtonActionPerformed(ActionEvent evt) {
        if (this.parent.alertOption((Component)((Object)this.parent), "Are you sure you want to revert custom metadata settings to the last save?")) {
            this.updateMetaDataTable();
        }
    }

    private void removeAttachmentsCheckboxActionPerformed(ActionEvent evt) {
        this.parent.setSaveEnabled(true);
        this.updateStorageMode();
    }

    private void attachmentStoreCheckBoxItemStateChanged(ItemEvent evt) {
        this.attachmentWarningLabel.setVisible(evt.getStateChange() != 1 && this.attachmentComboBox.getSelectedItem() != AttachmentHandlerType.NONE);
    }

    private void setDependenciesButtonActionPerformed(ActionEvent evt) {
        ChannelDependenciesDialog dialog = new ChannelDependenciesDialog(this.currentChannel);
        if (dialog.wasSaved()) {
            this.resourceIds = dialog.getSelectedResourceIds();
            this.currentChannel.getProperties().setResourceIds(this.resourceIds.get(null));
            ((SourceConnectorPropertiesInterface)this.currentChannel.getSourceConnector().getProperties()).getSourceConnectorProperties().setResourceIds(this.resourceIds.get(this.currentChannel.getSourceConnector().getMetaDataId()));
            for (Connector destinationConnector : this.currentChannel.getDestinationConnectors()) {
                ((DestinationConnectorPropertiesInterface)destinationConnector.getProperties()).getDestinationConnectorProperties().setResourceIds(this.resourceIds.get(destinationConnector.getMetaDataId()));
            }
            this.parent.setSaveEnabled(true);
        }
    }

    public void generateMultipleDestinationPage() {
        this.destinationConnectorPanel.setConnectorSettingsPanel(LoadedExtensions.getInstance().getDestinationConnectors().get((String)this.destinationConnectorTypeComboBox.getSelectedItem()));
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        int connectorIndex = this.destinationTable.getSelectedModelIndex();
        Connector destinationConnector = (Connector)destinationConnectors.get(connectorIndex);
        if (connectorIndex == 0) {
            this.waitForPreviousCheckbox.setSelected(false);
            this.waitForPreviousCheckbox.setEnabled(false);
        } else {
            this.waitForPreviousCheckbox.setSelected(destinationConnector.isWaitForPrevious());
            this.waitForPreviousCheckbox.setEnabled(true);
        }
        String connectorName = "";
        if (destinationConnector.getProperties() != null) {
            connectorName = destinationConnector.getProperties().getName();
        }
        if (destinationConnector.getProperties() == null || !connectorName.equals(this.destinationConnectorTypeComboBox.getSelectedItem())) {
            String name = destinationConnector.getName();
            this.changeConnectorType(destinationConnector, true);
            destinationConnector.setName(name);
            Map<String, String> destinationResourceIds = this.resourceIds.get(destinationConnector.getMetaDataId());
            ConnectorProperties props = this.destinationConnectorPanel.getDefaults();
            if (destinationResourceIds != null) {
                ((DestinationConnectorPropertiesInterface)props).getDestinationConnectorProperties().setResourceIds(destinationResourceIds);
            }
            this.destinationConnectorPanel.setProperties(props);
            props = this.destinationConnectorPanel.getProperties();
            if (destinationResourceIds != null) {
                ((DestinationConnectorPropertiesInterface)props).getDestinationConnectorProperties().setResourceIds(destinationResourceIds);
            }
            destinationConnector.setProperties(props);
            this.setResourceIds();
            this.checkAndSetDestinationAndResponseDataType();
        }
        this.destinationVariableList.setTransferMode(this.destinationConnectorPanel.getTransferMode());
        destinationConnector.setTransportName((String)this.destinationConnectorTypeComboBox.getSelectedItem());
        destinationConnectors.set(connectorIndex, destinationConnector);
        String transportName = ((ConnectorTypeData)this.destinationTable.getModel().getValueAt(this.destinationTable.getSelectedModelIndex(), this.destinationTable.getColumnModelIndex(CONNECTOR_TYPE_COLUMN_NAME))).getTransportName();
        if (destinationConnector.getTransportName() != null && !transportName.equals(destinationConnector.getTransportName()) && this.destinationTable.getSelectedModelIndex() != -1) {
            ConnectorTypeData connectorTypeData = new ConnectorTypeData((String)this.destinationConnectorTypeComboBox.getSelectedItem());
            this.destinationTable.getModel().setValueAt(connectorTypeData, this.destinationTable.getSelectedModelIndex(), this.destinationTable.getColumnModelIndex(CONNECTOR_TYPE_COLUMN_NAME));
        }
        this.destinationConnectorPanel.setProperties(destinationConnector.getProperties());
        this.setDestinationVariableList();
        this.destinationConnectorScrollPane.repaint();
    }

    private Set<String> getMultipleDestinationRules(Connector currentDestination) {
        LinkedHashSet<String> concatenatedRules = new LinkedHashSet<String>();
        VariableListUtil.getRuleVariables(concatenatedRules, this.currentChannel.getSourceConnector().getFilter(), false);
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        Iterator it = destinationConnectors.iterator();
        boolean seenCurrent = false;
        while (it.hasNext()) {
            Connector destination = (Connector)it.next();
            if (currentDestination == destination) {
                seenCurrent = true;
                VariableListUtil.getRuleVariables(concatenatedRules, destination.getFilter(), true);
                continue;
            }
            if (seenCurrent) continue;
            VariableListUtil.getRuleVariables(concatenatedRules, destination.getFilter(), false);
            concatenatedRules.add(destination.getName());
        }
        return concatenatedRules;
    }

    private Set<String> getMultipleDestinationStepVariables(Connector currentDestination) {
        LinkedHashSet<String> concatenatedSteps = new LinkedHashSet<String>();
        VariableListUtil.getStepVariables(concatenatedSteps, this.currentChannel.getSourceConnector().getTransformer(), false);
        List destinationConnectors = this.currentChannel.getDestinationConnectors();
        Iterator it = destinationConnectors.iterator();
        boolean seenCurrent = false;
        while (it.hasNext()) {
            Connector destination = (Connector)it.next();
            if (currentDestination == destination) {
                seenCurrent = true;
                VariableListUtil.getStepVariables(concatenatedSteps, destination.getTransformer(), true);
                continue;
            }
            if (seenCurrent) continue;
            VariableListUtil.getStepVariables(concatenatedSteps, destination.getTransformer(), false);
            VariableListUtil.getStepVariables(concatenatedSteps, destination.getResponseTransformer(), false);
            concatenatedSteps.add(destination.getName());
        }
        return concatenatedSteps;
    }

    public void setDestinationVariableList() {
        int destination = this.destinationTable.getSelectedModelIndex();
        Set<String> concatenatedRuleVariables = this.getMultipleDestinationRules((Connector)this.currentChannel.getDestinationConnectors().get(destination));
        Set<String> concatenatedStepVariables = this.getMultipleDestinationStepVariables((Connector)this.currentChannel.getDestinationConnectors().get(destination));
        concatenatedRuleVariables.addAll(concatenatedStepVariables);
        this.destinationVariableList.setVariableListInbound(concatenatedRuleVariables);
        this.destinationVariableList.populateConnectors(this.currentChannel.getDestinationConnectors());
        this.destinationVariableList.setBorder("Destination Mappings", new Color(0, 0, 0));
        this.destinationVariableList.repaint();
    }

    public Connector makeNewConnector(boolean isDestination) {
        Connector c = new Connector();
        c.setEnabled(true);
        Transformer dt = new Transformer();
        Transformer drt = null;
        Filter df = new Filter();
        if (isDestination) {
            c.setMode(Connector.Mode.DESTINATION);
            drt = new Transformer();
        } else {
            c.setMode(Connector.Mode.SOURCE);
        }
        c.setTransformer(dt);
        c.setResponseTransformer(drt);
        c.setFilter(df);
        return c;
    }

    public void changeConnectorType(Connector c, boolean isDestination) {
        Transformer oldTransformer = c.getTransformer();
        Filter oldFilter = c.getFilter();
        Transformer oldResponseTransformer = c.getResponseTransformer();
        c = isDestination ? this.makeNewConnector(true) : this.makeNewConnector(false);
        c.setTransformer(oldTransformer);
        c.setFilter(oldFilter);
        c.setResponseTransformer(oldResponseTransformer);
    }

    public String getRequiredInboundDataType() {
        return this.sourceConnectorPanel.getRequiredInboundDataType();
    }

    public String getRequiredOutboundDataType() {
        return this.sourceConnectorPanel.getRequiredOutboundDataType();
    }

    public String getInitialInboundDataType() {
        return this.sourceConnectorPanel.getInitialInboundDataType();
    }

    private String getInitialOutboundDataType() {
        return this.sourceConnectorPanel.getInitialOutboundDataType();
    }

    public void checkAndSetSourceDataType() {
        String outboundDataType;
        String inboundDataType;
        String requiredInboundDataType = this.getRequiredInboundDataType();
        String initialInboundDataType = this.getInitialInboundDataType();
        String string = inboundDataType = requiredInboundDataType != null ? requiredInboundDataType : initialInboundDataType;
        if (inboundDataType != null && !this.currentChannel.getSourceConnector().getTransformer().getInboundDataType().equals(inboundDataType)) {
            DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(inboundDataType).getDefaultProperties();
            this.currentChannel.getSourceConnector().getTransformer().setInboundDataType(inboundDataType);
            this.currentChannel.getSourceConnector().getTransformer().setInboundProperties(defaultProperties);
        }
        String requiredOutboundDataType = this.getRequiredOutboundDataType();
        String initialOutboundDataType = this.getInitialOutboundDataType();
        String string2 = outboundDataType = requiredOutboundDataType != null ? requiredOutboundDataType : initialOutboundDataType;
        if (outboundDataType != null && !this.currentChannel.getSourceConnector().getTransformer().getOutboundDataType().equals(outboundDataType)) {
            DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(outboundDataType).getDefaultProperties();
            this.currentChannel.getSourceConnector().getTransformer().setOutboundDataType(outboundDataType);
            this.currentChannel.getSourceConnector().getTransformer().setOutboundProperties(defaultProperties);
            for (Connector destination : this.currentChannel.getDestinationConnectors()) {
                destination.getTransformer().setInboundDataType(outboundDataType);
                destination.getTransformer().setInboundProperties(defaultProperties);
            }
        }
    }

    public String getRequiredOutboundDestinationDataType() {
        return this.destinationConnectorPanel.getRequiredOutboundDataType();
    }

    private String getInitialOutboundDestinationDataType() {
        return this.destinationConnectorPanel.getInitialOutboundDataType();
    }

    public String getInitialInboundResponseDataType() {
        return this.destinationConnectorPanel.getInitialInboundResponseDataType();
    }

    public String getInitialOutboundResponseDataType() {
        return this.destinationConnectorPanel.getInitialOutboundResponseDataType();
    }

    public void checkAndSetDestinationAndResponseDataType() {
        String responseOutboundDataType;
        String responseInboundDataType;
        String outboundDataType;
        String requiredOutboundDataType = this.getRequiredOutboundDestinationDataType();
        String initialOutboundDataType = this.getInitialOutboundDestinationDataType();
        String string = outboundDataType = requiredOutboundDataType != null ? requiredOutboundDataType : initialOutboundDataType;
        if (outboundDataType != null && !((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getTransformer().getOutboundDataType().equals(outboundDataType)) {
            DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(outboundDataType).getDefaultProperties();
            ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getTransformer().setOutboundDataType(outboundDataType);
            ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getTransformer().setOutboundProperties(defaultProperties);
        }
        if ((responseInboundDataType = this.getInitialInboundResponseDataType()) != null && !((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getResponseTransformer().getOutboundDataType().equals(responseInboundDataType)) {
            DataTypeProperties defaultResponseInboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(responseInboundDataType).getDefaultProperties();
            ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getResponseTransformer().setInboundDataType(responseInboundDataType);
            ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getResponseTransformer().setInboundProperties(defaultResponseInboundProperties);
        }
        if ((responseOutboundDataType = this.getInitialOutboundResponseDataType()) != null && !((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getResponseTransformer().getOutboundDataType().equals(responseOutboundDataType)) {
            DataTypeProperties defaultResponseOutboundProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(responseOutboundDataType).getDefaultProperties();
            ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getResponseTransformer().setOutboundDataType(responseOutboundDataType);
            ((Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex())).getResponseTransformer().setOutboundProperties(defaultResponseOutboundProperties);
        }
    }

    public void updateComponentShown() {
        if (this.channelView.getSelectedIndex() == 1) {
            this.sourceComponentShown(null);
        } else if (this.channelView.getSelectedIndex() == 2) {
            this.destinationComponentShown(null);
        }
    }

    public Connector exportSelectedConnector() {
        if (this.channelView.getSelectedIndex() == 1) {
            return this.currentChannel.getSourceConnector();
        }
        if (this.channelView.getSelectedIndex() == 2) {
            return (Connector)this.currentChannel.getDestinationConnectors().get(this.destinationTable.getSelectedModelIndex());
        }
        return null;
    }

    public void importConnector(Connector connector) {
        String alertMessage = this.checkInvalidPluginProperties(connector);
        if (StringUtils.isNotBlank((CharSequence)alertMessage) && !this.parent.alertOption((Component)((Object)this.parent), alertMessage + "\nWhen this channel is saved, those properties will be lost. You can choose to import this\nconnector at a later time after verifying that all necessary extensions are properly loaded.\nAre you sure you wish to continue?")) {
            return;
        }
        this.parent.updateResourceNames(connector);
        this.loadingChannel = true;
        if (this.channelView.getSelectedIndex() == 1 && connector.getMode().equals((Object)Connector.Mode.SOURCE)) {
            this.currentChannel.setSourceConnector(connector);
            this.resourceIds.put(connector.getMetaDataId(), ((SourceConnectorPropertiesInterface)connector.getProperties()).getSourceConnectorProperties().getResourceIds());
            this.sourceConnectorTypeComboBox.setSelectedItem(this.currentChannel.getSourceConnector().getTransportName());
            String sourceDataType = connector.getTransformer().getOutboundDataType();
            for (Connector destinationConnector : this.currentChannel.getDestinationConnectors()) {
                String destinationDataType = destinationConnector.getTransformer().getInboundDataType();
                if (StringUtils.equals((CharSequence)sourceDataType, (CharSequence)destinationDataType)) continue;
                destinationConnector.getTransformer().setInboundDataType(sourceDataType);
                destinationConnector.getTransformer().setInboundProperties(LoadedExtensions.getInstance().getDataTypePlugins().get(sourceDataType).getDefaultProperties());
            }
            this.updateAttachmentHandler(connector.getTransformer().getInboundDataType());
            this.sourceComponentShown(null);
        } else if (this.channelView.getSelectedIndex() == 2 && connector.getMode().equals((Object)Connector.Mode.DESTINATION)) {
            String destinationDataType;
            List destinationConnectors = this.currentChannel.getDestinationConnectors();
            for (Connector destinationConnector : destinationConnectors) {
                if (!destinationConnector.getName().equalsIgnoreCase(connector.getName())) continue;
                connector.setName(this.getNewDestinationName(destinationConnectors.size() + 1));
            }
            String sourceDataType = this.currentChannel.getSourceConnector().getTransformer().getOutboundDataType();
            if (!StringUtils.equals((CharSequence)sourceDataType, (CharSequence)(destinationDataType = connector.getTransformer().getInboundDataType()))) {
                connector.getTransformer().setInboundDataType(sourceDataType);
                connector.getTransformer().setInboundProperties(LoadedExtensions.getInstance().getDataTypePlugins().get(sourceDataType).getDefaultProperties());
            }
            this.currentChannel.addDestination(connector);
            this.resourceIds.put(connector.getMetaDataId(), ((DestinationConnectorPropertiesInterface)connector.getProperties()).getDestinationConnectorProperties().getResourceIds());
            this.makeDestinationTable(false);
        } else {
            String errorMessage = "You must be on the Source tab to import a Source connector.";
            if (connector.getMode().equals((Object)Connector.Mode.DESTINATION)) {
                errorMessage = "You must be on the Destinations tab to import a Destination connector.";
            }
            this.parent.alertError((Component)((Object)this.parent), errorMessage);
            this.loadingChannel = false;
            return;
        }
        this.loadingChannel = false;
        this.parent.setSaveEnabled(true);
    }

    public void updateAttachmentHandler(String dataType) {
        if (LoadedExtensions.getInstance().getDataTypePlugins().containsKey(dataType)) {
            AttachmentHandlerType oldType = (AttachmentHandlerType)this.attachmentComboBox.getSelectedItem();
            AttachmentHandlerType newType = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultAttachmentHandlerType();
            if (newType == null) {
                newType = AttachmentHandlerType.NONE;
            }
            if (oldType == AttachmentHandlerType.NONE && newType != AttachmentHandlerType.NONE || oldType == AttachmentHandlerType.DICOM && newType == AttachmentHandlerType.NONE) {
                this.attachmentComboBox.setSelectedItem(newType);
            }
        }
    }

    public int getSelectedDestinationIndex() {
        return this.destinationTable.getSelectedModelIndex();
    }

    public void setChannelEnabledField(boolean enabled) {
        this.summaryEnabledCheckBox.setSelected(enabled);
    }
}

