/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractChannelTableNode;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.ChannelGroupStatus;
import com.mirth.connect.client.ui.ChannelTableNameEntry;
import com.mirth.connect.client.ui.DashboardPanel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.plugins.ChannelColumnPlugin;
import javax.swing.ImageIcon;

public class ChannelTableNode
extends AbstractChannelTableNode {
    private Object[] row = new Object[DashboardPanel.getNumberOfDefaultColumns() + LoadedExtensions.getInstance().getDashboardColumnPlugins().size()];
    private ChannelGroupStatus groupStatus;
    private ChannelStatus channelStatus;

    public ChannelTableNode(ChannelGroupStatus groupStatus) {
        this(groupStatus, null);
    }

    public ChannelTableNode(ChannelStatus channelStatus) {
        this(null, channelStatus);
    }

    private ChannelTableNode(ChannelGroupStatus groupStatus, ChannelStatus channelStatus) {
        if (groupStatus != null) {
            this.setGroupStatus(groupStatus);
        } else {
            this.setChannelStatus(channelStatus);
        }
    }

    @Override
    public boolean isGroupNode() {
        return this.groupStatus != null;
    }

    @Override
    public ChannelGroupStatus getGroupStatus() {
        return this.groupStatus;
    }

    @Override
    public void setGroupStatus(ChannelGroupStatus groupStatus) {
        this.groupStatus = groupStatus;
        this.channelStatus = null;
        ChannelGroup group = groupStatus.getGroup();
        int i = 0;
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            this.row[i++] = plugin.getTableData(group);
        }
        this.updateStatusColumn();
        int n = ++i;
        this.row[n] = null;
        int n2 = ++i;
        this.row[n2] = new ChannelTableNameEntry(group.getName());
        int n3 = ++i;
        this.row[n3] = group.getId();
        int n4 = ++i;
        this.row[n4] = null;
        int n5 = ++i;
        this.row[n5] = group.getDescription();
        int n6 = ++i;
        this.row[n6] = null;
        int n7 = ++i;
        this.row[n7] = null;
        int n8 = ++i;
        ++i;
        this.row[n8] = group.getLastModified();
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            this.row[i++] = plugin.getTableData(groupStatus.getGroup());
        }
    }

    @Override
    public ChannelStatus getChannelStatus() {
        return this.channelStatus;
    }

    @Override
    public void setChannelStatus(ChannelStatus channelStatus) {
        this.groupStatus = null;
        this.channelStatus = channelStatus;
        Channel channel = channelStatus.getChannel();
        int i = 0;
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            this.row[i++] = plugin.getTableData(channelStatus.getChannel());
        }
        this.row[i++] = channel.getExportData().getMetadata().isEnabled() ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), "Enabled") : new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled");
        this.row[i++] = PlatformUI.MIRTH_FRAME.dataTypeToDisplayName.get(channel.getSourceConnector().getTransformer().getInboundDataType());
        this.row[i++] = new ChannelTableNameEntry(channel.getName());
        this.row[i++] = channel.getId();
        this.row[i++] = channelStatus.getLocalChannelId();
        this.row[i++] = channel.getDescription();
        this.row[i++] = channelStatus.getDeployedRevisionDelta();
        this.row[i++] = channelStatus.getDeployedDate();
        this.row[i++] = channel.getExportData().getMetadata().getLastModified();
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            this.row[i++] = plugin.getTableData(channelStatus.getChannel());
        }
    }

    @Override
    public void updateStatusColumn() {
        if (this.isGroupNode()) {
            int offset = this.getColumnOffset();
            boolean allEnabled = true;
            boolean allDisabled = true;
            for (ChannelStatus channelStatus : this.groupStatus.getChannelStatuses()) {
                if (channelStatus.getChannel().getExportData().getMetadata().isEnabled()) {
                    allDisabled = false;
                    continue;
                }
                allEnabled = false;
            }
            this.row[offset + 0] = this.groupStatus.getChannelStatuses().isEmpty() ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "N/A") : (allEnabled ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_blue.png")), "Enabled") : (allDisabled ? new CellData(new ImageIcon(Frame.class.getResource("images/bullet_black.png")), "Disabled") : new CellData(new ImageIcon(Frame.class.getResource("images/bullet_orange.png")), "Mixed")));
        }
    }

    public int getColumnCount() {
        return this.row.length;
    }

    public Object getValueAt(int i) {
        return this.row[i];
    }

    public void setValueAt(Object value, int i) {
        this.row[i] = value;
        if (this.isGroupNode()) {
            int offset = this.getColumnOffset();
            if (i - offset == 2) {
                this.groupStatus.getGroup().setName(((ChannelTableNameEntry)value).getName());
            } else if (i - offset == 5) {
                this.groupStatus.getGroup().setDescription((String)value);
            }
        }
        super.setValueAt(value, i);
    }

    public String toString() {
        if (this.isGroupNode()) {
            return this.groupStatus.getGroup().getName();
        }
        return this.channelStatus.getChannel().getName();
    }

    private int getColumnOffset() {
        int offset = 0;
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            ++offset;
        }
        return offset;
    }
}

