/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractChannelTableNode;
import com.mirth.connect.client.ui.AbstractSortableTreeTableNode;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.ChannelGroupStatus;
import com.mirth.connect.client.ui.ChannelTableNameEntry;
import com.mirth.connect.client.ui.ChannelTableNodeFactory;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.plugins.ChannelColumnPlugin;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class ChannelTreeTableModel
extends SortableTreeTableModel {
    private ChannelTableNodeFactory nodeFactory;
    private boolean groupModeEnabled = true;
    private AtomicBoolean updating = new AtomicBoolean(false);

    public ChannelTreeTableModel() {
        this.setSortChildNodes(true);
    }

    public void setNodeFactory(ChannelTableNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public boolean isGroupModeEnabled() {
        return this.groupModeEnabled;
    }

    public void setGroupModeEnabled(boolean groupModeEnabled) {
        this.groupModeEnabled = groupModeEnabled;
    }

    public int getHierarchicalColumn() {
        return 2;
    }

    public Class<?> getColumnClass(int column) {
        switch (column -= this.getColumnOffset()) {
            case 0: {
                return CellData.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return ChannelTableNameEntry.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Long.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Calendar.class;
            }
            case 8: {
                return Calendar.class;
            }
        }
        return String.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(List<ChannelGroupStatus> groupStatuses) {
        if (this.updating.getAndSet(true)) {
            return;
        }
        try {
            AbstractSortableTreeTableNode root = new AbstractSortableTreeTableNode(){

                public Object getValueAt(int arg0) {
                    return null;
                }

                public int getColumnCount() {
                    return 0;
                }
            };
            this.setRoot((TreeTableNode)root);
            int rootIndex = 0;
            if (this.groupModeEnabled) {
                for (ChannelGroupStatus groupStatus : groupStatuses) {
                    AbstractChannelTableNode groupNode = this.nodeFactory.createNode(groupStatus);
                    this.insertNodeInto((MutableTreeTableNode)groupNode, (MutableTreeTableNode)root, rootIndex++);
                    int groupIndex = 0;
                    for (ChannelStatus channelStatus : groupStatus.getChannelStatuses()) {
                        AbstractChannelTableNode channelNode = this.nodeFactory.createNode(channelStatus);
                        this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)groupNode, groupIndex++);
                    }
                }
            } else {
                for (ChannelGroupStatus groupStatus : groupStatuses) {
                    for (ChannelStatus channelStatus : groupStatus.getChannelStatuses()) {
                        AbstractChannelTableNode channelNode = this.nodeFactory.createNode(channelStatus);
                        this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)root, rootIndex++);
                    }
                }
            }
        }
        finally {
            this.updating.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChannelToGroup(AbstractChannelTableNode targetGroupNode, String channelId) {
        if (this.updating.getAndSet(true)) {
            return;
        }
        try {
            if (!this.groupModeEnabled || !targetGroupNode.isGroupNode()) {
                return;
            }
            Enumeration channelNodes = targetGroupNode.children();
            while (channelNodes.hasMoreElements()) {
                AbstractChannelTableNode channelNode = (AbstractChannelTableNode)((Object)channelNodes.nextElement());
                if (!StringUtils.equals((CharSequence)channelNode.getChannelStatus().getChannel().getId(), (CharSequence)channelId)) continue;
                return;
            }
            MutableTreeTableNode root = (MutableTreeTableNode)this.getRoot();
            if (root == null) {
                return;
            }
            AbstractChannelTableNode previousGroupNode = null;
            Enumeration groupNodes = root.children();
            while (groupNodes.hasMoreElements()) {
                AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
                if (!StringUtils.equals((CharSequence)targetGroupNode.getGroupStatus().getGroup().getId(), (CharSequence)groupNode.getGroupStatus().getGroup().getId())) {
                    for (int channelNodeIndex = 0; channelNodeIndex < groupNode.getChildCount(); ++channelNodeIndex) {
                        AbstractChannelTableNode channelNode = (AbstractChannelTableNode)groupNode.getChildAt(channelNodeIndex);
                        if (!StringUtils.equals((CharSequence)channelNode.getChannelStatus().getChannel().getId(), (CharSequence)channelId)) continue;
                        previousGroupNode = groupNode;
                        this.removeNodeFromParent((MutableTreeTableNode)channelNode);
                        this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)targetGroupNode);
                        break;
                    }
                }
                if (previousGroupNode == null) continue;
                break;
            }
            ChannelStatus targetChannelStatus = null;
            Iterator<Object> it = previousGroupNode.getGroupStatus().getChannelStatuses().iterator();
            while (it.hasNext()) {
                ChannelStatus channelStatus = it.next();
                if (!StringUtils.equals((CharSequence)channelStatus.getChannel().getId(), (CharSequence)channelId)) continue;
                targetChannelStatus = channelStatus;
                it.remove();
            }
            it = previousGroupNode.getGroupStatus().getGroup().getChannels().iterator();
            while (it.hasNext()) {
                Channel channel = (Channel)it.next();
                if (!StringUtils.equals((CharSequence)channel.getId(), (CharSequence)channelId)) continue;
                it.remove();
            }
            targetGroupNode.getGroupStatus().getChannelStatuses().add(targetChannelStatus);
            targetGroupNode.getGroupStatus().getGroup().getChannels().add(new Channel(channelId));
            previousGroupNode.updateStatusColumn();
            targetGroupNode.updateStatusColumn();
        }
        finally {
            this.updating.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannelFromGroup(AbstractChannelTableNode targetGroupNode, String channelId) {
        if (this.updating.getAndSet(true)) {
            return;
        }
        try {
            if (!this.groupModeEnabled || StringUtils.equals((CharSequence)targetGroupNode.getGroupStatus().getGroup().getId(), (CharSequence)"Default Group") || !targetGroupNode.isGroupNode()) {
                return;
            }
            AbstractChannelTableNode targetChannelNode = null;
            Enumeration channelNodes = targetGroupNode.children();
            while (channelNodes.hasMoreElements()) {
                AbstractChannelTableNode channelNode = (AbstractChannelTableNode)((Object)channelNodes.nextElement());
                if (!StringUtils.equals((CharSequence)channelNode.getChannelStatus().getChannel().getId(), (CharSequence)channelId)) continue;
                targetChannelNode = channelNode;
                break;
            }
            if (targetChannelNode == null) {
                return;
            }
            MutableTreeTableNode root = (MutableTreeTableNode)this.getRoot();
            if (root == null) {
                return;
            }
            AbstractChannelTableNode defaultGroupNode = null;
            Enumeration groupNodes = root.children();
            while (groupNodes.hasMoreElements()) {
                AbstractChannelTableNode groupNode = (AbstractChannelTableNode)((Object)groupNodes.nextElement());
                if (StringUtils.equals((CharSequence)targetGroupNode.getGroupStatus().getGroup().getId(), (CharSequence)"Default Group")) continue;
                defaultGroupNode = groupNode;
                break;
            }
            if (defaultGroupNode == null) {
                return;
            }
            this.removeNodeFromParent((MutableTreeTableNode)targetChannelNode);
            this.insertNodeInto((MutableTreeTableNode)targetChannelNode, (MutableTreeTableNode)defaultGroupNode);
            ChannelStatus targetChannelStatus = null;
            Iterator<Object> it = targetGroupNode.getGroupStatus().getChannelStatuses().iterator();
            while (it.hasNext()) {
                ChannelStatus channelStatus = it.next();
                if (!StringUtils.equals((CharSequence)channelStatus.getChannel().getId(), (CharSequence)channelId)) continue;
                targetChannelStatus = channelStatus;
                it.remove();
            }
            it = targetGroupNode.getGroupStatus().getGroup().getChannels().iterator();
            while (it.hasNext()) {
                Channel channel = (Channel)it.next();
                if (!StringUtils.equals((CharSequence)channel.getId(), (CharSequence)channelId)) continue;
                it.remove();
            }
            defaultGroupNode.getGroupStatus().getChannelStatuses().add(targetChannelStatus);
            defaultGroupNode.getGroupStatus().getGroup().getChannels().add(new Channel(channelId));
            targetGroupNode.updateStatusColumn();
            defaultGroupNode.updateStatusColumn();
        }
        finally {
            this.updating.set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractChannelTableNode addNewGroup(ChannelGroup group) {
        if (this.updating.getAndSet(true)) {
            return null;
        }
        try {
            MutableTreeTableNode root = (MutableTreeTableNode)this.getRoot();
            if (root == null) {
                AbstractChannelTableNode abstractChannelTableNode = null;
                return abstractChannelTableNode;
            }
            ChannelGroupStatus groupStatus = new ChannelGroupStatus(group, new ArrayList<ChannelStatus>());
            AbstractChannelTableNode groupNode = this.nodeFactory.createNode(groupStatus);
            this.insertNodeInto((MutableTreeTableNode)groupNode, root);
            AbstractChannelTableNode abstractChannelTableNode = groupNode;
            return abstractChannelTableNode;
        }
        finally {
            this.updating.set(false);
        }
    }

    public void removeGroup(AbstractChannelTableNode groupNode) {
        if (this.updating.getAndSet(true)) {
            return;
        }
        try {
            MutableTreeTableNode root = (MutableTreeTableNode)this.getRoot();
            if (root == null) {
                return;
            }
            this.removeNodeFromParent((MutableTreeTableNode)groupNode);
        }
        finally {
            this.updating.set(false);
        }
    }

    public void refresh() {
        MutableTreeTableNode root = (MutableTreeTableNode)this.getRoot();
        if (root != null) {
            this.modelSupport.firePathChanged(new TreePath(root));
        }
    }

    private int getColumnOffset() {
        int counter = 0;
        for (ChannelColumnPlugin plugin : LoadedExtensions.getInstance().getChannelColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            ++counter;
        }
        return counter;
    }
}

