/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.util.DisplayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.miginfocom.swing.MigLayout;

public class CustomBannerPanelDialog
extends JDialog {
    private boolean isAccepted = false;
    private String notificationText;
    private String title;
    protected JTextArea textArea;
    protected JButton btnAccept;
    protected JButton btnCancel;
    private static Timer timer;

    public CustomBannerPanelDialog(JFrame parent, String title, String text) {
        this.notificationText = text;
        this.title = title;
        DisplayUtil.setResizable(this, true);
        this.setPreferredSize(new Dimension(800, 600));
        this.setModal(true);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = parent.getSize();
        Point loc = parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.startTimer();
        this.initComponents();
        this.setVisible(true);
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 12"));
        this.setTitle(this.title);
        this.setIconImage(UIConstants.MIRTH_FAVICON.getImage());
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.textArea = new JTextArea();
        this.textArea.setBackground(this.getBackground());
        this.textArea.setEditable(false);
        this.textArea.setText(this.notificationText);
        this.textArea.setLineWrap(true);
        this.textArea.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        JScrollPane scrollPane = new JScrollPane(this.textArea);
        scrollPane.setBackground(this.getBackground());
        this.btnAccept = new JButton("Accept");
        this.btnAccept.setVerticalTextPosition(3);
        this.btnAccept.setHorizontalTextPosition(2);
        this.btnAccept.setActionCommand("accept");
        this.btnAccept.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomBannerPanelDialog.this.isAccepted = true;
                CustomBannerPanelDialog.this.stopTimer();
                CustomBannerPanelDialog.this.dispose();
            }
        });
        this.btnCancel = new JButton("Cancel");
        this.btnCancel.setVerticalTextPosition(3);
        this.btnCancel.setHorizontalTextPosition(4);
        this.btnCancel.setActionCommand("cancel");
        this.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CustomBannerPanelDialog.this.cancelOut();
            }
        });
        this.add((Component)scrollPane, "grow, sx, push, h 100%");
        this.add((Component)new JSeparator(), "grow, span, gap 0 0 4 4");
        this.add((Component)this.btnAccept, "newline, right, split 2");
        this.add(this.btnCancel);
        this.pack();
    }

    public boolean isAccepted() {
        return this.isAccepted;
    }

    public void setAccepted(boolean isAccepted) {
        this.isAccepted = isAccepted;
    }

    public void startTimer() {
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                CustomBannerPanelDialog.this.cancelOut();
            }
        };
        timer = new Timer(false);
        timer.schedule(task, 300000L);
    }

    public void stopTimer() {
        if (timer != null) {
            timer.cancel();
        }
    }

    public void cancelOut() {
        this.isAccepted = false;
        this.stopTimer();
        this.dispose();
    }
}

