/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractDashboardTableNode;
import com.mirth.connect.client.ui.AuthorizationControllerFactory;
import com.mirth.connect.client.ui.ChannelGroupStatus;
import com.mirth.connect.client.ui.DashboardTableColumnFactory;
import com.mirth.connect.client.ui.DashboardTableNode;
import com.mirth.connect.client.ui.DashboardTableNodeFactory;
import com.mirth.connect.client.ui.DashboardTreeTableModel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.QueuingSwingWorker;
import com.mirth.connect.client.ui.QueuingSwingWorkerTask;
import com.mirth.connect.client.ui.TagTreeCellRenderer;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.IconToggleButton;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.components.tag.ChannelNameFilterCompletion;
import com.mirth.connect.client.ui.components.tag.FilterCompletion;
import com.mirth.connect.client.ui.components.tag.MirthTagField;
import com.mirth.connect.client.ui.components.tag.SearchFilterListener;
import com.mirth.connect.client.ui.components.tag.TagFilterCompletion;
import com.mirth.connect.donkey.model.channel.DeployedState;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.model.filter.SearchFilter;
import com.mirth.connect.model.filter.SearchFilterParser;
import com.mirth.connect.plugins.DashboardColumnPlugin;
import com.mirth.connect.plugins.DashboardPanelPlugin;
import com.mirth.connect.plugins.DashboardTabPlugin;
import com.mirth.connect.plugins.DashboardTablePlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.decorator.ColorHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class DashboardPanel
extends JPanel {
    private static final String STATUS_COLUMN_NAME = "Status";
    private static final String NAME_COLUMN_NAME = "Name";
    private static final String RECEIVED_COLUMN_NAME = "Received";
    private static final String QUEUED_COLUMN_NAME = "Queued";
    private static final String SENT_COLUMN_NAME = "Sent";
    private static final String ERROR_COLUMN_NAME = "Errored";
    private static final String FILTERED_COLUMN_NAME = "Filtered";
    private static final String LAST_DEPLOYED_COLUMN_NAME = "Last Deployed";
    private static final String DEPLOYED_REVISION_DELTA_COLUMN_NAME = "Rev \u0394";
    private static final String[] defaultColumns = new String[]{"Status", "Name", "Rev \u0394", "Last Deployed", "Received", "Filtered", "Queued", "Sent", "Errored"};
    private Frame parent;
    private boolean showLifetimeStats = false;
    private Preferences userPreferences;
    private boolean tagTextModeSelected = false;
    private boolean tagIconModeSelected = false;
    private boolean canViewChannelGroups = AuthorizationControllerFactory.getAuthorizationController().checkTask("channelGroup", "doExportGroup");
    private Set<String> defaultVisibleColumns;
    private Set<DeployedState> haltableStates = new HashSet<DeployedState>();
    private ListSelectionListener listSelectionListener;
    private JSplitPane splitPane;
    private JPanel topPanel;
    public MirthTreeTable dashboardTable;
    private JScrollPane dashboardTableScrollPane;
    private JPanel controlPanel;
    private MirthTagField tagField;
    private JLabel tagsLabel;
    private JRadioButton showCurrentStatsButton;
    private JRadioButton showLifetimeStatsButton;
    private JPanel pluginContainerPanel;
    private JSeparator controlSeparator;
    private IconToggleButton tagModeTextButton;
    private IconToggleButton tagModeIconButton;
    private IconToggleButton tableModeGroupsButton;
    private IconToggleButton tableModeChannelsButton;
    private JTabbedPane tabPane;

    public DashboardPanel() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.userPreferences = Preferences.userNodeForPackage(Mirth.class);
        this.haltableStates.add(DeployedState.DEPLOYING);
        this.haltableStates.add(DeployedState.UNDEPLOYING);
        this.haltableStates.add(DeployedState.STARTING);
        this.haltableStates.add(DeployedState.STOPPING);
        this.haltableStates.add(DeployedState.PAUSING);
        this.haltableStates.add(DeployedState.SYNCING);
        this.haltableStates.add(DeployedState.UNKNOWN);
        this.initComponents();
        this.initLayout();
        this.loadTabPlugins();
        ChangeListener changeListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane sourceTabbedPane = (JTabbedPane)changeEvent.getSource();
                int index = sourceTabbedPane.getSelectedIndex();
                if (LoadedExtensions.getInstance().getDashboardTabPlugins().size() > 0) {
                    DashboardPanel.this.loadPanelPlugin(LoadedExtensions.getInstance().getDashboardTabPlugins().get(sourceTabbedPane.getTitleAt(index)));
                }
            }
        };
        this.tabPane.addChangeListener(changeListener);
        this.defaultVisibleColumns = new LinkedHashSet<String>();
        this.makeStatusTable();
        this.loadTablePlugins();
        this.setDoubleBuffered(true);
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        if (this.canViewChannelGroups && this.userPreferences.getBoolean("channelGroupViewEnabled", true)) {
            this.tableModeGroupsButton.setSelected(true);
            this.tableModeGroupsButton.setContentFilled(true);
            this.tableModeChannelsButton.setContentFilled(false);
            model.setGroupModeEnabled(true);
        } else {
            this.tableModeChannelsButton.setSelected(true);
            this.tableModeChannelsButton.setContentFilled(true);
            this.tableModeGroupsButton.setContentFilled(false);
            model.setGroupModeEnabled(false);
        }
        if (!this.canViewChannelGroups) {
            this.tableModeGroupsButton.setEnabled(false);
        }
        this.updateTagButtons(this.userPreferences.getBoolean("showTags", true), this.userPreferences.getBoolean("tagTextMode", false), false);
    }

    public void loadTabPlugins() {
        if (LoadedExtensions.getInstance().getDashboardTabPlugins().size() > 0) {
            for (DashboardTabPlugin plugin : LoadedExtensions.getInstance().getDashboardTabPlugins().values()) {
                if (plugin.getTabComponent() == null) continue;
                this.tabPane.addTab(plugin.getPluginPointName(), plugin.getTabComponent());
            }
            this.splitPane.setBottomComponent(this.tabPane);
            this.splitPane.setDividerSize(6);
            this.splitPane.setDividerLocation(3 * this.userPreferences.getInt("height", 650) / 5);
            this.splitPane.setResizeWeight(0.5);
        }
    }

    public void closePopupWindow() {
        this.tagField.closePopupWindow();
    }

    public String getUserTags() {
        return this.tagField.getTags();
    }

    public void updateTags(Set<String> channelNames, boolean updateUserTags) {
        HashSet<FilterCompletion> tags = new HashSet<FilterCompletion>();
        for (String name : channelNames) {
            tags.add(new ChannelNameFilterCompletion(name));
        }
        for (ChannelTag channelTag : this.parent.getCachedChannelTags()) {
            tags.add(new TagFilterCompletion(channelTag));
        }
        this.tagField.update(tags, false, updateUserTags, true);
    }

    private void loadTablePlugins() {
        this.pluginContainerPanel.setLayout((LayoutManager)new MigLayout("fillx, insets 0 0 0 0", "[grow,fill]", "[grow,fill]"));
        for (DashboardTablePlugin plugin : LoadedExtensions.getInstance().getDashboardTablePlugins().values()) {
            for (JComponent component : plugin.getToolbarComponents(this.dashboardTable)) {
                this.pluginContainerPanel.add((Component)component, "grow");
            }
        }
        for (DashboardTablePlugin plugin : LoadedExtensions.getInstance().getDashboardTablePlugins().values()) {
            plugin.onDashboardInit(this.dashboardTable);
        }
        this.repaint();
    }

    public void loadPanelPlugin(final DashboardPanelPlugin plugin) {
        final List<DashboardStatus> selectedStatuses = this.getSelectedStatuses();
        QueuingSwingWorkerTask<Void, Void> task = new QueuingSwingWorkerTask<Void, Void>(plugin.getPluginPointName(), "Updating " + plugin.getPluginPointName() + " dashboard plugin..."){

            @Override
            public Void doInBackground() {
                try {
                    if (selectedStatuses.size() != 0) {
                        plugin.prepareData(selectedStatuses);
                    } else {
                        plugin.prepareData();
                    }
                }
                catch (ClientException e) {
                    DashboardPanel.this.parent.alertThrowable((Component)((Object)DashboardPanel.this.parent), e);
                }
                return null;
            }

            @Override
            public void done() {
                if (selectedStatuses.size() != 0) {
                    plugin.update(selectedStatuses);
                } else {
                    plugin.update();
                }
            }
        };
        new QueuingSwingWorker<Void, Void>(task, true).executeDelegate();
    }

    public DashboardTabPlugin getCurrentTabPlugin() {
        return LoadedExtensions.getInstance().getDashboardTabPlugins().get(this.tabPane.getTitleAt(this.tabPane.getSelectedIndex()));
    }

    public void switchPanel() {
        boolean groupViewEnabled = this.canViewChannelGroups && this.userPreferences.getBoolean("channelGroupViewEnabled", true);
        this.switchTableMode(groupViewEnabled);
        if (groupViewEnabled) {
            this.tableModeGroupsButton.setSelected(true);
            this.tableModeGroupsButton.setContentFilled(true);
            this.tableModeChannelsButton.setContentFilled(false);
        } else {
            this.tableModeChannelsButton.setSelected(true);
            this.tableModeChannelsButton.setContentFilled(true);
            this.tableModeGroupsButton.setContentFilled(false);
        }
        this.updateTagButtons(this.userPreferences.getBoolean("showTags", true), this.userPreferences.getBoolean("tagTextMode", false), false);
        this.updateTags(new HashSet<String>(this.parent.channelPanel.getCachedChannelIdsAndNames().values()), true);
        this.tagField.setUserPreferenceTags();
    }

    private void updateTagButtons(boolean showTags, boolean textMode, boolean updatePreferences) {
        this.tagModeTextButton.setSelected(showTags && textMode);
        this.tagModeIconButton.setSelected(showTags && !textMode);
        this.tagModeTextButton.setContentFilled(showTags && textMode);
        this.tagModeIconButton.setContentFilled(showTags && !textMode);
        this.dashboardTable.setTreeCellRenderer(new TagTreeCellRenderer(showTags, textMode));
        this.tagTextModeSelected = showTags && textMode;
        boolean bl = this.tagIconModeSelected = showTags && !textMode;
        if (updatePreferences) {
            this.userPreferences.putBoolean("showTags", showTags);
            this.userPreferences.putBoolean("tagTextMode", textMode);
        }
    }

    public void makeStatusTable() {
        ArrayList<String> columns = new ArrayList<String>();
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            columns.add(plugin.getColumnHeader());
        }
        columns.addAll(Arrays.asList(defaultColumns));
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            columns.add(plugin.getColumnHeader());
        }
        DashboardTreeTableModel model = new DashboardTreeTableModel();
        model.setColumnIdentifiers(columns);
        model.setNodeFactory(new DefaultDashboardTableNodeFactory());
        for (DashboardTablePlugin plugin : LoadedExtensions.getInstance().getDashboardTablePlugins().values()) {
            this.dashboardTable = plugin.getTable();
            if (this.dashboardTable == null) continue;
            break;
        }
        this.defaultVisibleColumns.addAll(columns);
        if (this.dashboardTable == null) {
            this.dashboardTable = new MirthTreeTable("dashboardPanel", this.defaultVisibleColumns);
        }
        this.dashboardTable.setColumnFactory(new DashboardTableColumnFactory());
        this.dashboardTable.setTreeTableModel((TreeTableModel)model);
        this.dashboardTable.setDoubleBuffered(true);
        this.dashboardTable.setSelectionMode(2);
        this.dashboardTable.setHorizontalScrollEnabled(true);
        this.dashboardTable.packTable(10);
        this.dashboardTable.setRowHeight(20);
        this.dashboardTable.setOpaque(true);
        this.dashboardTable.setRowSelectionAllowed(true);
        this.dashboardTable.setSortable(true);
        this.dashboardTable.putClientProperty("JTree.lineStyle", "Horizontal");
        this.dashboardTable.setAutoCreateColumnsFromModel(false);
        this.dashboardTable.setShowGrid(true, true);
        this.dashboardTable.restoreColumnPreferences();
        this.dashboardTable.setMirthColumnControlEnabled(true);
        this.dashboardTable.setTreeCellRenderer(new TagTreeCellRenderer(true, false));
        this.dashboardTable.setLeafIcon(UIConstants.ICON_CONNECTOR);
        this.dashboardTable.setOpenIcon(UIConstants.ICON_CHANNEL);
        this.dashboardTable.setClosedIcon(UIConstants.ICON_CHANNEL);
        this.dashboardTableScrollPane.setViewportView((Component)((Object)this.dashboardTable));
        this.dashboardTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                DashboardPanel.this.checkSelectionAndPopupMenu(event);
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                DashboardPanel.this.checkSelectionAndPopupMenu(event);
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                int clickedRow = DashboardPanel.this.dashboardTable.rowAtPoint(new Point(event.getX(), event.getY()));
                if (clickedRow == -1) {
                    return;
                }
                TreePath path = DashboardPanel.this.dashboardTable.getPathForRow(clickedRow);
                if (path != null && ((AbstractDashboardTableNode)((Object)path.getLastPathComponent())).isGroupNode()) {
                    return;
                }
                if (event.getClickCount() >= 2 && DashboardPanel.this.dashboardTable.getSelectedRowCount() == 1 && DashboardPanel.this.dashboardTable.getSelectedRow() == clickedRow) {
                    DashboardPanel.this.parent.doShowMessages();
                }
            }
        });
        this.listSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                DashboardPanel.this.updatePopupMenu(!event.getValueIsAdjusting());
            }
        };
        this.dashboardTable.getSelectionModel().addListSelectionListener(this.listSelectionListener);
    }

    private void checkSelectionAndPopupMenu(MouseEvent event) {
        TreePath path = this.dashboardTable.getPathForLocation(event.getX(), event.getY());
        if (path == null) {
            this.deselectRows(false);
        } else {
            this.updatePopupMenu(false);
        }
        if (event.isPopupTrigger()) {
            TreeSelectionModel selectionModel = this.dashboardTable.getTreeSelectionModel();
            if (!selectionModel.isPathSelected(path)) {
                this.deselectRows(false);
                selectionModel.addSelectionPath(path);
            }
            this.parent.dashboardPopupMenu.show(event.getComponent(), event.getX(), event.getY());
        }
    }

    private void updatePopupMenu(boolean loadPanelPlugin) {
        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 1, -1, false);
        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 2, 2, true);
        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 4, 4, true);
        boolean useChannelOptions = true;
        boolean singleChannel = true;
        boolean containsHaltableNonSyncingState = false;
        HashSet<String> selectedChannelIds = new HashSet<String>();
        HashSet<String> selectedChannelNodes = new HashSet<String>();
        List<AbstractDashboardTableNode> selectedNodes = this.dashboardTable.getSelectedNodes();
        if (selectedNodes.size() > 0) {
            for (AbstractDashboardTableNode abstractDashboardTableNode : selectedNodes) {
                if (!abstractDashboardTableNode.isGroupNode()) {
                    selectedChannelIds.add(abstractDashboardTableNode.getChannelId());
                    if (abstractDashboardTableNode.getDashboardStatus().getStatusType() == DashboardStatus.StatusType.CHANNEL) {
                        if (this.haltableStates.contains(abstractDashboardTableNode.getDashboardStatus().getState()) && abstractDashboardTableNode.getDashboardStatus().getState() != DeployedState.SYNCING) {
                            containsHaltableNonSyncingState = true;
                        }
                        selectedChannelNodes.add(abstractDashboardTableNode.getChannelId());
                    } else if (!selectedChannelNodes.contains(abstractDashboardTableNode.getChannelId())) {
                        useChannelOptions = false;
                    }
                }
                if (selectedChannelIds.size() <= 1) continue;
                singleChannel = false;
            }
        } else {
            this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 2, 2, false);
            this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 4, 4, false);
        }
        for (AbstractDashboardTableNode abstractDashboardTableNode : selectedNodes) {
            if (abstractDashboardTableNode.isGroupNode()) continue;
            DashboardStatus status = abstractDashboardTableNode.getDashboardStatus();
            DashboardStatus.StatusType statusType = status.getStatusType();
            if (useChannelOptions) {
                if (statusType != DashboardStatus.StatusType.CHANNEL) continue;
                switch (status.getState()) {
                    case STARTED: {
                        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 6, 7, true);
                        break;
                    }
                    case PAUSED: {
                        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 5, 5, true);
                        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 7, 7, true);
                        break;
                    }
                    case STOPPED: {
                        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 5, 5, true);
                        break;
                    }
                }
                this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 1, 1, true);
                this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 3, 3, true);
                this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 9, 9, true);
                if (!this.isHaltable(abstractDashboardTableNode)) continue;
                if (status.getState() == DeployedState.DEPLOYING || status.getState() == DeployedState.UNDEPLOYING) {
                    this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 1, 8, false);
                } else {
                    this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 3, 3, false);
                    this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 5, 8, false);
                }
                if (containsHaltableNonSyncingState) {
                    this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 9, 9, false);
                }
                if (!singleChannel) break;
                this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 8, 8, true);
                continue;
            }
            if (selectedChannelNodes.size() != 0) continue;
            AbstractDashboardTableNode channelNode = (AbstractDashboardTableNode)abstractDashboardTableNode.getParent();
            if (channelNode.getDashboardStatus().getState() != DeployedState.STARTED && channelNode.getDashboardStatus().getState() != DeployedState.PAUSED) {
                this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 10, 11, false);
                break;
            }
            switch (status.getState()) {
                case STARTED: {
                    this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 11, 11, true);
                    break;
                }
                case STOPPED: {
                    this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 10, 10, true);
                    break;
                }
            }
        }
        if (this.showLifetimeStats) {
            this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 4, 4, false);
        }
        if (loadPanelPlugin) {
            for (DashboardPanelPlugin dashboardPanelPlugin : LoadedExtensions.getInstance().getDashboardTablePlugins().values()) {
                this.loadPanelPlugin(dashboardPanelPlugin);
            }
            this.loadPanelPlugin(this.getCurrentTabPlugin());
        }
    }

    private boolean isHaltable(AbstractDashboardTableNode node) {
        DeployedState nodeState = node.getDashboardStatus().getState();
        if (this.haltableStates.contains(nodeState)) {
            return true;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!this.isHaltable((AbstractDashboardTableNode)node.getChildAt(i))) continue;
            return true;
        }
        return false;
    }

    public synchronized void updateTableChannelNodes(List<DashboardStatus> intermediateStatuses) {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        model.setStatuses(intermediateStatuses);
        model.setShowLifetimeStats(this.showLifetimeStatsButton.isSelected());
        this.updateTableHighlighting();
    }

    public synchronized void finishUpdatingTable(List<DashboardStatus> finishedStatuses, Collection<ChannelGroupStatus> channelGroupStatuses, int totalDeployedCount) {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        model.finishStatuses(finishedStatuses);
        model.setShowLifetimeStats(this.showLifetimeStatsButton.isSelected());
        if (this.dashboardTable.getSelectedRowCount() == 0) {
            this.deselectRows(true);
        } else {
            this.updatePopupMenu(true);
        }
        this.updateTableHighlighting();
        HashMap<String, DashboardStatus> statusMap = new HashMap<String, DashboardStatus>();
        for (DashboardStatus status : this.parent.status) {
            statusMap.put(status.getChannelId(), status);
        }
        ArrayList<ChannelGroupStatus> filteredGroupStatuses = new ArrayList<ChannelGroupStatus>(channelGroupStatuses);
        Iterator it = filteredGroupStatuses.iterator();
        while (it.hasNext()) {
            ChannelGroup group = ((ChannelGroupStatus)it.next()).getGroup();
            boolean found = false;
            for (Channel channel : group.getChannels()) {
                DashboardStatus dashboardStatus = (DashboardStatus)statusMap.get(channel.getId());
                if (dashboardStatus == null) continue;
                found = true;
                break;
            }
            if (found) continue;
            it.remove();
        }
        model.setGroupStatuses(filteredGroupStatuses);
        HashMap<String, String> channelNameMap = new HashMap<String, String>();
        for (DashboardStatus status : finishedStatuses) {
            channelNameMap.put(status.getChannelId(), status.getName());
        }
        this.updateTags(new HashSet<String>(channelNameMap.values()), false);
        this.updateTagsLabel(channelGroupStatuses.size(), filteredGroupStatuses.size(), totalDeployedCount, finishedStatuses.size());
    }

    private void updateTagsLabel(int totalGroupCount, int visibleGroupCount, int totalChannelCount, int visibleChannelCount) {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        if (this.tagField.isFilterEnabled()) {
            StringBuilder builder = new StringBuilder();
            if (model.isGroupModeEnabled()) {
                if (totalGroupCount == visibleGroupCount) {
                    builder.append(totalGroupCount);
                } else {
                    builder.append(visibleGroupCount).append(" of ").append(totalGroupCount);
                }
                builder.append(" Group");
                if (totalGroupCount != 1) {
                    builder.append('s');
                }
                if (totalGroupCount != visibleGroupCount) {
                    builder.append(" (").append(totalGroupCount - visibleGroupCount).append(" filtered)");
                }
                builder.append(", ");
            }
            if (totalChannelCount == visibleChannelCount) {
                builder.append(totalChannelCount);
            } else {
                builder.append(visibleChannelCount).append(" of ").append(totalChannelCount);
            }
            builder.append(" Deployed Channel");
            if (totalChannelCount != 1) {
                builder.append('s');
            }
            if (totalChannelCount != visibleChannelCount) {
                builder.append(" (").append(totalChannelCount - visibleChannelCount).append(" filtered)");
            }
            ArrayList<String> activeFilters = new ArrayList<String>();
            for (SearchFilter filter : SearchFilterParser.parse((String)this.tagField.getTags(), this.parent.getCachedChannelTags())) {
                activeFilters.add(filter.toDisplayString());
            }
            builder.append(" (");
            Iterator it = activeFilters.iterator();
            while (it.hasNext()) {
                builder.append((String)it.next());
                if (!it.hasNext()) continue;
                builder.append(", ");
            }
            builder.append(')');
            this.tagsLabel.setText(builder.toString());
        } else if (model.isGroupModeEnabled()) {
            this.tagsLabel.setText(totalGroupCount + " Groups, " + totalChannelCount + " Deployed Channels");
        } else {
            this.tagsLabel.setText(totalChannelCount + " Deployed Channels");
        }
    }

    public void updateTableState(TableState tableState) {
        this.restoreTableState(tableState);
        this.updatePopupMenu(false);
    }

    public synchronized void updateTableHighlighting() {
        this.dashboardTable.setHighlighters(new Highlighter[0]);
        if (this.userPreferences.getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.dashboardTable.addHighlighter(highlighter);
        }
        HighlightPredicate queuedHighlighterPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Long value;
                return adapter.column == DashboardPanel.this.dashboardTable.getColumnViewIndex(DashboardPanel.QUEUED_COLUMN_NAME) && (value = (Long)DashboardPanel.this.dashboardTable.getValueAt(adapter.row, adapter.column)) != null && value > 0L;
            }
        };
        this.dashboardTable.addHighlighter((Highlighter)new ColorHighlighter(queuedHighlighterPredicate, new Color(240, 230, 140), Color.BLACK, new Color(240, 230, 140), Color.BLACK));
        HighlightPredicate errorHighlighterPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                Long value;
                return adapter.column == DashboardPanel.this.dashboardTable.getColumnViewIndex(DashboardPanel.ERROR_COLUMN_NAME) && (value = (Long)DashboardPanel.this.dashboardTable.getValueAt(adapter.row, adapter.column)) != null && value > 0L;
            }
        };
        ColorHighlighter errorHighlighter = new ColorHighlighter(errorHighlighterPredicate, Color.PINK, Color.BLACK, Color.PINK, Color.BLACK);
        this.dashboardTable.addHighlighter((Highlighter)errorHighlighter);
        HighlightPredicate revisionDeltaHighlighterPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                if (adapter.column == DashboardPanel.this.dashboardTable.getColumnViewIndex(DashboardPanel.DEPLOYED_REVISION_DELTA_COLUMN_NAME)) {
                    DashboardStatus status;
                    AbstractDashboardTableNode dashboardTableNode;
                    Integer value = (Integer)DashboardPanel.this.dashboardTable.getValueAt(adapter.row, adapter.column);
                    if (value != null && value > 0) {
                        return true;
                    }
                    TreePath path = DashboardPanel.this.dashboardTable.getPathForRow(adapter.row);
                    if (path != null && !(dashboardTableNode = (AbstractDashboardTableNode)((Object)path.getLastPathComponent())).isGroupNode() && (status = dashboardTableNode.getDashboardStatus()).getCodeTemplatesChanged() != null && status.getCodeTemplatesChanged().booleanValue()) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.dashboardTable.addHighlighter((Highlighter)new ColorHighlighter(revisionDeltaHighlighterPredicate, new Color(255, 204, 0), Color.BLACK, new Color(255, 204, 0), Color.BLACK));
        HighlightPredicate lastDeployedHighlighterPredicate = new HighlightPredicate(){

            public boolean isHighlighted(Component renderer, ComponentAdapter adapter) {
                if (adapter.column == DashboardPanel.this.dashboardTable.getColumnViewIndex(DashboardPanel.LAST_DEPLOYED_COLUMN_NAME)) {
                    Calendar checkAfter = Calendar.getInstance();
                    checkAfter.add(12, -2);
                    Object value = DashboardPanel.this.dashboardTable.getValueAt(adapter.row, adapter.column);
                    if (value != null && value instanceof Calendar && ((Calendar)value).after(checkAfter)) {
                        return true;
                    }
                }
                return false;
            }
        };
        this.dashboardTable.addHighlighter((Highlighter)new ColorHighlighter(lastDeployedHighlighterPredicate, new Color(240, 230, 140), Color.BLACK, new Color(240, 230, 140), Color.BLACK));
    }

    public synchronized List<DashboardStatus> getSelectedStatuses() {
        ArrayList<DashboardStatus> selectedStatuses = new ArrayList<DashboardStatus>();
        List<AbstractDashboardTableNode> selectedNodes = this.dashboardTable.getSelectedNodes();
        for (AbstractDashboardTableNode node : selectedNodes) {
            if (node.isGroupNode()) continue;
            selectedStatuses.add(node.getDashboardStatus());
        }
        return selectedStatuses;
    }

    public synchronized Set<DashboardStatus> getSelectedChannelStatuses() {
        HashSet<DashboardStatus> selectedStatuses = new HashSet<DashboardStatus>();
        List<AbstractDashboardTableNode> selectedNodes = this.dashboardTable.getSelectedNodes();
        Iterator<AbstractDashboardTableNode> iterator = selectedNodes.iterator();
        block0: while (iterator.hasNext()) {
            for (TreeTableNode treeNode = (TreeTableNode)iterator.next(); treeNode != null && treeNode instanceof AbstractDashboardTableNode; treeNode = treeNode.getParent()) {
                AbstractDashboardTableNode node = (AbstractDashboardTableNode)treeNode;
                if (node.isGroupNode() || node.getDashboardStatus().getStatusType() != DashboardStatus.StatusType.CHANNEL) continue;
                if (selectedStatuses.contains(node.getDashboardStatus())) continue block0;
                selectedStatuses.add(node.getDashboardStatus());
                continue block0;
            }
        }
        return selectedStatuses;
    }

    public synchronized List<DashboardStatus> getSelectedStatusesRecursive() {
        ArrayList<DashboardStatus> selectedStatuses = new ArrayList<DashboardStatus>();
        List<AbstractDashboardTableNode> selectedNodes = this.dashboardTable.getSelectedNodes();
        for (AbstractDashboardTableNode node : selectedNodes) {
            if (node.isGroupNode()) continue;
            selectedStatuses.add(node.getDashboardStatus());
            selectedStatuses.addAll(this.getAllChildStatuses(node.getDashboardStatus()));
        }
        return selectedStatuses;
    }

    public Set<DashboardStatus> getAllChildStatuses(DashboardStatus status) {
        HashSet<DashboardStatus> statuses = new HashSet<DashboardStatus>();
        for (DashboardStatus childStatus : status.getChildStatuses()) {
            if (!statuses.contains(childStatus)) {
                statuses.add(childStatus);
            }
            statuses.addAll(this.getAllChildStatuses(childStatus));
        }
        return statuses;
    }

    public Map<Integer, String> getDestinationConnectorNames(String channelId) {
        LinkedHashMap<Integer, String> destinationConnectors = new LinkedHashMap<Integer, String>();
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        TreeTableNode root = model.getRoot();
        int channelCount = model.getChildCount(root);
        for (int i = 0; i < channelCount; ++i) {
            AbstractDashboardTableNode node = (AbstractDashboardTableNode)root.getChildAt(i);
            if (node.isGroupNode()) {
                Enumeration channelNodes = node.children();
                while (channelNodes.hasMoreElements()) {
                    this.populateDestinationConnectorNames(channelId, (AbstractDashboardTableNode)((Object)channelNodes.nextElement()), destinationConnectors);
                }
                continue;
            }
            this.populateDestinationConnectorNames(channelId, node, destinationConnectors);
        }
        return destinationConnectors;
    }

    private void populateDestinationConnectorNames(String channelId, AbstractDashboardTableNode channelNode, Map<Integer, String> destinationConnectors) {
        if (channelNode.getDashboardStatus().getChannelId() == channelId) {
            int connectorCount = channelNode.getChildCount();
            for (int j = 0; j < connectorCount; ++j) {
                AbstractDashboardTableNode connectorNode = (AbstractDashboardTableNode)channelNode.getChildAt(j);
                DashboardStatus status = connectorNode.getDashboardStatus();
                Integer metaDataId = status.getMetaDataId();
                if (metaDataId <= 0) continue;
                destinationConnectors.put(metaDataId, status.getName());
            }
        }
    }

    public void deselectRows(boolean loadPanelPlugin) {
        this.dashboardTable.clearSelection();
        this.parent.setVisibleTasks(this.parent.dashboardTasks, this.parent.dashboardPopupMenu, 1, -1, false);
        if (loadPanelPlugin) {
            this.loadPanelPlugin(this.getCurrentTabPlugin());
            for (DashboardPanelPlugin dashboardPanelPlugin : LoadedExtensions.getInstance().getDashboardTablePlugins().values()) {
                this.loadPanelPlugin(dashboardPanelPlugin);
            }
        }
    }

    public static int getNumberOfDefaultColumns() {
        return defaultColumns.length;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane(0);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.splitPane.setOneTouchExpandable(true);
        this.topPanel = new JPanel();
        this.topPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.dashboardTable = null;
        this.dashboardTableScrollPane = new JScrollPane();
        this.dashboardTableScrollPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.dashboardTableScrollPane.setViewportView((Component)((Object)this.dashboardTable));
        this.dashboardTableScrollPane.setDoubleBuffered(true);
        this.controlPanel = new JPanel();
        this.controlPanel.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(164, 164, 164)));
        this.controlPanel.setPreferredSize(new Dimension(100, 20));
        HashSet<FilterCompletion> tags = new HashSet<FilterCompletion>();
        for (ChannelTag tag : this.parent.getCachedChannelTags()) {
            tags.add(new TagFilterCompletion(tag));
        }
        this.tagField = new MirthTagField("Dashboard", false, tags);
        this.tagField.addUpdateSearchListener(new SearchFilterListener(){

            @Override
            public void doSearch(String filterString) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DashboardPanel.this.parent.doRefreshStatuses();
                    }
                });
            }

            @Override
            public void doDelete(String filterString) {
                DashboardPanel.this.parent.doRefreshStatuses();
            }
        });
        this.tagsLabel = new JLabel(){

            @Override
            public void setText(String text) {
                this.setToolTipText(text);
                super.setText(text);
            }
        };
        ButtonGroup showStatsButtonGroup = new ButtonGroup();
        this.showCurrentStatsButton = new JRadioButton("Current Statistics");
        this.showCurrentStatsButton.setSelected(true);
        this.showCurrentStatsButton.setToolTipText("Show the statistics accumulated since the last time the statistics were reset");
        this.showCurrentStatsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardPanel.this.showCurrentStatsButtonActionPerformed();
            }
        });
        showStatsButtonGroup.add(this.showCurrentStatsButton);
        this.showLifetimeStatsButton = new JRadioButton("Lifetime Statistics");
        this.showLifetimeStatsButton.setToolTipText("Show the statistics accumulated over the entire lifetime of the channel");
        this.showLifetimeStatsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardPanel.this.showLifetimeStatsButtonActionPerformed();
            }
        });
        showStatsButtonGroup.add(this.showLifetimeStatsButton);
        this.pluginContainerPanel = new JPanel();
        this.controlSeparator = new JSeparator(1);
        this.tagModeTextButton = new IconToggleButton(UIConstants.ICON_TEXT);
        this.tagModeTextButton.setToolTipText("Display tags as names.");
        this.tagModeTextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardPanel.this.updateTagButtons(!DashboardPanel.this.tagTextModeSelected, true, true);
                DashboardPanel.this.dashboardTable.updateUI();
            }
        });
        this.tagModeIconButton = new IconToggleButton(UIConstants.ICON_TAG);
        this.tagModeIconButton.setToolTipText("Display tags as icons.");
        this.tagModeIconButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardPanel.this.updateTagButtons(!DashboardPanel.this.tagIconModeSelected, false, true);
                DashboardPanel.this.dashboardTable.updateUI();
            }
        });
        ButtonGroup tableModeButtonGroup = new ButtonGroup();
        this.tableModeGroupsButton = new IconToggleButton(UIConstants.ICON_GROUP);
        this.tableModeGroupsButton.setToolTipText("Groups");
        this.tableModeGroupsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardPanel.this.switchTableMode(true);
            }
        });
        tableModeButtonGroup.add(this.tableModeGroupsButton);
        this.tableModeChannelsButton = new IconToggleButton(UIConstants.ICON_CHANNEL);
        this.tableModeChannelsButton.setToolTipText("Channels");
        this.tableModeChannelsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DashboardPanel.this.switchTableMode(false);
            }
        });
        tableModeButtonGroup.add(this.tableModeChannelsButton);
        this.tabPane = new JTabbedPane();
        this.splitPane.setTopComponent(this.topPanel);
        this.splitPane.setBottomComponent(this.tabPane);
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 0"));
        this.topPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 0"));
        this.topPanel.add((Component)this.dashboardTableScrollPane, "grow, push");
        this.controlPanel.setLayout((LayoutManager)new MigLayout("insets 0 12 0 12, novisualpadding, hidemode 3, fill, gap 12"));
        this.controlPanel.add((Component)new JLabel("Filter:"), "split 3");
        this.controlPanel.add((Component)this.tagField, "gapbottom 3, w 195:500:500");
        this.controlPanel.add((Component)this.tagsLabel, "gapleft 8, w 100:500:500");
        this.controlPanel.add((Component)this.showCurrentStatsButton, "right, push, split 2");
        this.controlPanel.add(this.showLifetimeStatsButton);
        this.pluginContainerPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3"));
        this.controlPanel.add(this.pluginContainerPanel);
        this.controlPanel.add((Component)this.controlSeparator, "right, split 6, h 18!, gapbefore 0, gapafter 12");
        this.controlPanel.add((Component)this.tagModeTextButton, "gapafter 0");
        this.controlPanel.add(this.tagModeIconButton);
        this.controlPanel.add((Component)new JSeparator(1), "right, h 18!, gapbefore 12, gapafter 12");
        this.controlPanel.add((Component)this.tableModeGroupsButton, "gapafter 0");
        this.controlPanel.add(this.tableModeChannelsButton);
        this.topPanel.add((Component)this.controlPanel, "newline, growx");
        this.add((Component)this.splitPane, "grow, push, h :300");
    }

    private void showCurrentStatsButtonActionPerformed() {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        this.showLifetimeStats = false;
        model.setShowLifetimeStats(this.showLifetimeStats);
        if (this.dashboardTable.getSelectedRowCount() == 0) {
            this.deselectRows(false);
        } else {
            this.updatePopupMenu(false);
        }
        this.updateTableHighlighting();
    }

    private void showLifetimeStatsButtonActionPerformed() {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        this.showLifetimeStats = true;
        model.setShowLifetimeStats(this.showLifetimeStats);
        if (this.dashboardTable.getSelectedRowCount() == 0) {
            this.deselectRows(false);
        } else {
            this.updatePopupMenu(false);
        }
        this.updateTableHighlighting();
    }

    private void switchTableMode(boolean groupModeEnabled) {
        DashboardTreeTableModel model;
        if (!this.canViewChannelGroups) {
            groupModeEnabled = false;
        }
        if ((model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel()).isGroupModeEnabled() != groupModeEnabled) {
            int totalChannelCount;
            this.userPreferences.putBoolean("channelGroupViewEnabled", groupModeEnabled);
            if (groupModeEnabled) {
                this.tableModeChannelsButton.setContentFilled(false);
            } else {
                this.tableModeGroupsButton.setContentFilled(false);
            }
            TableState tableState = this.getCurrentTableState();
            model.setGroupModeEnabled(groupModeEnabled);
            this.restoreTableState(tableState);
            this.updatePopupMenu(false);
            int totalGroupCount = this.parent.channelPanel.getCachedGroupStatuses().size();
            int n = totalChannelCount = this.parent.status != null ? this.parent.status.size() : 0;
            if (this.tagField.isEnabled()) {
                int visibleGroupCount = 0;
                int visibleChannelCount = 0;
                if (model.isGroupModeEnabled()) {
                    Enumeration groupNodes = ((MutableTreeTableNode)model.getRoot()).children();
                    while (groupNodes.hasMoreElements()) {
                        ++visibleGroupCount;
                        visibleChannelCount += ((MutableTreeTableNode)groupNodes.nextElement()).getChildCount();
                    }
                } else {
                    visibleChannelCount = ((MutableTreeTableNode)model.getRoot()).getChildCount();
                }
                this.updateTagsLabel(totalGroupCount, visibleGroupCount, totalChannelCount, visibleChannelCount);
            } else {
                this.updateTagsLabel(totalGroupCount, totalGroupCount, totalChannelCount, totalChannelCount);
            }
        }
    }

    public TableState getCurrentTableState() {
        int[] selectedRows;
        HashSet<String> selectedIds = new HashSet<String>();
        HashMap<String, Set<Integer>> selectedConnectors = new HashMap<String, Set<Integer>>();
        HashSet<String> expandedIds = new HashSet<String>();
        HashSet<String> collapsedIds = new HashSet<String>();
        for (int row : selectedRows = this.dashboardTable.getSelectedModelRows()) {
            AbstractDashboardTableNode node = (AbstractDashboardTableNode)((Object)this.dashboardTable.getPathForRow(row).getLastPathComponent());
            if (node.isGroupNode()) {
                selectedIds.add(node.getGroupStatus().getGroup().getId());
                continue;
            }
            DashboardStatus status = node.getDashboardStatus();
            if (status.getStatusType() == DashboardStatus.StatusType.CHANNEL) {
                selectedIds.add(status.getChannelId());
                continue;
            }
            if (status.getStatusType() != DashboardStatus.StatusType.SOURCE_CONNECTOR && status.getStatusType() != DashboardStatus.StatusType.DESTINATION_CONNECTOR) continue;
            HashSet<Integer> selectedMetaDataIds = (HashSet<Integer>)selectedConnectors.get(status.getChannelId());
            if (selectedMetaDataIds == null) {
                selectedMetaDataIds = new HashSet<Integer>();
                selectedConnectors.put(status.getChannelId(), selectedMetaDataIds);
            }
            selectedMetaDataIds.add(status.getMetaDataId());
        }
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        MutableTreeTableNode root = (MutableTreeTableNode)model.getRoot();
        if (root != null) {
            if (model.isGroupModeEnabled()) {
                Enumeration groupNodes = root.children();
                while (groupNodes.hasMoreElements()) {
                    AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
                    if (this.dashboardTable.isExpanded(new TreePath(new Object[]{root, groupNode}))) {
                        expandedIds.add(groupNode.getGroupStatus().getGroup().getId());
                    } else if (groupNode.getChildCount() > 0) {
                        collapsedIds.add(groupNode.getGroupStatus().getGroup().getId());
                    }
                    this.addChannelNodeExpansionStates((MutableTreeTableNode)groupNode, expandedIds, collapsedIds);
                }
            } else {
                this.addChannelNodeExpansionStates(root, expandedIds, collapsedIds);
            }
        }
        return new TableState(selectedIds, selectedConnectors, expandedIds, collapsedIds);
    }

    private void addChannelNodeExpansionStates(MutableTreeTableNode parent, Set<String> expandedIds, Set<String> collapsedIds) {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        Enumeration channelNodes = parent.children();
        while (channelNodes.hasMoreElements()) {
            AbstractDashboardTableNode channelNode = (AbstractDashboardTableNode)((Object)channelNodes.nextElement());
            if (this.dashboardTable.isExpanded(new TreePath(model.getPathToRoot((TreeTableNode)channelNode)))) {
                expandedIds.add(channelNode.getChannelId());
                continue;
            }
            collapsedIds.add(channelNode.getChannelId());
        }
    }

    private void restoreTableState(TableState tableState) {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        MutableTreeTableNode root = (MutableTreeTableNode)model.getRoot();
        if (model.isGroupModeEnabled()) {
            Enumeration groupNodes = root.children();
            while (groupNodes.hasMoreElements()) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
                String groupId = groupNode.getGroupStatus().getGroup().getId();
                if (tableState.getExpandedIds().contains(groupId) || !tableState.getCollapsedIds().contains(groupId)) {
                    this.dashboardTable.expandPath(new TreePath(new Object[]{root, groupNode}));
                } else if (tableState.getCollapsedIds().contains(groupId)) {
                    this.dashboardTable.collapsePath(new TreePath(new Object[]{root, groupNode}));
                }
                this.setChannelNodeExpansionStates((MutableTreeTableNode)groupNode, tableState);
            }
        } else {
            this.setChannelNodeExpansionStates(root, tableState);
        }
        final ArrayList<TreePath> selectionPaths = new ArrayList<TreePath>();
        if (model.isGroupModeEnabled()) {
            Enumeration groupNodes = root.children();
            while (groupNodes.hasMoreElements()) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
                if (tableState.getSelectedIds().contains(groupNode.getGroupStatus().getGroup().getId())) {
                    selectionPaths.add(new TreePath(new Object[]{root, groupNode}));
                }
                this.selectChannelNodes((MutableTreeTableNode)groupNode, tableState, selectionPaths);
            }
        } else {
            this.selectChannelNodes(root, tableState, selectionPaths);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DashboardPanel.this.dashboardTable.getSelectionModel().removeListSelectionListener(DashboardPanel.this.listSelectionListener);
                try {
                    DashboardPanel.this.dashboardTable.getTreeSelectionModel().setSelectionPaths(selectionPaths.toArray(new TreePath[selectionPaths.size()]));
                }
                catch (Exception exception) {
                }
                finally {
                    DashboardPanel.this.dashboardTable.getSelectionModel().addListSelectionListener(DashboardPanel.this.listSelectionListener);
                    DashboardPanel.this.updatePopupMenu(true);
                }
            }
        });
    }

    private void setChannelNodeExpansionStates(MutableTreeTableNode parent, TableState tableState) {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        Enumeration channelNodes = parent.children();
        while (channelNodes.hasMoreElements()) {
            AbstractDashboardTableNode channelNode = (AbstractDashboardTableNode)((Object)channelNodes.nextElement());
            String channelId = channelNode.getChannelId();
            if (tableState.getExpandedIds().contains(channelId)) {
                this.dashboardTable.expandPath(new TreePath(model.getPathToRoot((TreeTableNode)channelNode)));
                continue;
            }
            if (!tableState.getCollapsedIds().contains(channelId)) continue;
            this.dashboardTable.collapsePath(new TreePath(model.getPathToRoot((TreeTableNode)channelNode)));
        }
    }

    private void selectChannelNodes(MutableTreeTableNode parent, TableState tableState, List<TreePath> selectionPaths) {
        DashboardTreeTableModel model = (DashboardTreeTableModel)this.dashboardTable.getTreeTableModel();
        Enumeration channelNodes = parent.children();
        while (channelNodes.hasMoreElements()) {
            AbstractDashboardTableNode channelNode = (AbstractDashboardTableNode)((Object)channelNodes.nextElement());
            if (tableState.getSelectedIds().contains(channelNode.getChannelId())) {
                selectionPaths.add(new TreePath(model.getPathToRoot((TreeTableNode)channelNode)));
            }
            Enumeration connectorNodes = channelNode.children();
            while (connectorNodes.hasMoreElements()) {
                AbstractDashboardTableNode connectorNode = (AbstractDashboardTableNode)((Object)connectorNodes.nextElement());
                if (!tableState.getSelectedConnectors().containsKey(connectorNode.getChannelId()) || !tableState.getSelectedConnectors().get(connectorNode.getChannelId()).contains(connectorNode.getDashboardStatus().getMetaDataId())) continue;
                selectionPaths.add(new TreePath(model.getPathToRoot((TreeTableNode)connectorNode)));
            }
        }
    }

    private static class DefaultDashboardTableNodeFactory
    implements DashboardTableNodeFactory {
        private DefaultDashboardTableNodeFactory() {
        }

        @Override
        public AbstractDashboardTableNode createNode(ChannelGroupStatus groupStatus) {
            return new DashboardTableNode(groupStatus);
        }

        @Override
        public AbstractDashboardTableNode createNode(String channelId, DashboardStatus status) {
            return new DashboardTableNode(channelId, status);
        }
    }

    public class TableState {
        private Set<String> selectedIds = new HashSet<String>();
        private Map<String, Set<Integer>> selectedConnectors = new HashMap<String, Set<Integer>>();
        private Set<String> expandedIds = new HashSet<String>();
        private Set<String> collapsedIds = new HashSet<String>();

        public TableState(Set<String> selectedIds, Map<String, Set<Integer>> selectedConnectors, Set<String> expandedIds, Set<String> collapsedIds) {
            this.selectedIds = selectedIds;
            this.selectedConnectors = selectedConnectors;
            this.expandedIds = expandedIds;
            this.collapsedIds = collapsedIds;
        }

        public Set<String> getSelectedIds() {
            return this.selectedIds;
        }

        public Map<String, Set<Integer>> getSelectedConnectors() {
            return this.selectedConnectors;
        }

        public Set<String> getExpandedIds() {
            return this.expandedIds;
        }

        public Set<String> getCollapsedIds() {
            return this.collapsedIds;
        }
    }
}

