/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.DashboardPanel;
import com.mirth.connect.client.ui.DateCellRenderer;
import com.mirth.connect.client.ui.ImageCellRenderer;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.NumberCellComparator;
import com.mirth.connect.client.ui.NumberCellRenderer;
import com.mirth.connect.plugins.DashboardColumnPlugin;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class DashboardTableColumnFactory
extends ColumnFactory {
    private int colOffset;
    private Map<Integer, DashboardColumnPlugin> plugins = new HashMap<Integer, DashboardColumnPlugin>();

    public DashboardTableColumnFactory() {
        int i = 0;
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            this.plugins.put(i++, plugin);
        }
        this.colOffset = i;
        i += DashboardPanel.getNumberOfDefaultColumns();
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (plugin.isDisplayFirst()) continue;
            this.plugins.put(i++, plugin);
        }
    }

    public TableColumnExt createAndConfigureTableColumn(TableModel model, int modelIndex) {
        TableColumnExt column = super.createAndConfigureTableColumn(model, modelIndex);
        int index = modelIndex - this.colOffset;
        switch (index) {
            case 0: {
                column.setCellRenderer((TableCellRenderer)new ImageCellRenderer());
                column.setMaxWidth(85);
                column.setMinWidth(75);
                column.setPreferredWidth(75);
                column.setToolTipText("<html><body>The status of the deployed channel. Possible values are deploying, undeploying,<br>started, starting, pausing, paused, stopping, and stopped.</body></html>");
                break;
            }
            case 1: {
                column.setMinWidth(150);
                column.setToolTipText("<html><body>The name of the deployed channel or connector.</body></html>");
                break;
            }
            case 2: {
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer(0, false));
                column.setComparator((Comparator)new NumberCellComparator());
                column.setMaxWidth(50);
                column.setMinWidth(50);
                column.setToolTipText("<html><body>The number of times this channel was saved since it was deployed.<br>Rev \u0394 = Channel Revision - Deployed Revision<br>This value will be highlighted if it is greater than 0,<br/><b>or</b> if any code templates linked to this channel have changed.</body></html>");
                break;
            }
            case 3: {
                column.setCellRenderer((TableCellRenderer)new DateCellRenderer());
                column.setMaxWidth(95);
                column.setMinWidth(95);
                column.setToolTipText("<html><body>The time this channel was last deployed.<br>This value will be highlighted if it is within the last two minutes.</body></html>");
                break;
            }
            case 4: {
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer());
                column.setComparator((Comparator)new NumberCellComparator());
                column.setMaxWidth(75);
                column.setMinWidth(75);
                column.setToolTipText("<html><body>The number of messages received and accepted by this channel's source connector.</body></html>");
                break;
            }
            case 5: {
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer());
                column.setComparator((Comparator)new NumberCellComparator());
                column.setMaxWidth(75);
                column.setMinWidth(75);
                column.setToolTipText("<html><body>The number of messages filtered out by this channel's source connector or any destination connector.</body></html>");
                break;
            }
            case 6: {
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer());
                column.setComparator((Comparator)new NumberCellComparator());
                column.setMaxWidth(75);
                column.setMinWidth(75);
                column.setToolTipText("<html><body>The number of messages currently queued by all destination connectors in this channel.</body></html>");
                break;
            }
            case 7: {
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer());
                column.setComparator((Comparator)new NumberCellComparator());
                column.setMaxWidth(75);
                column.setMinWidth(75);
                column.setToolTipText("<html><body>The numer of messages that have been sent by all of the destination connectors in this channel.</body></html>");
                break;
            }
            case 8: {
                column.setCellRenderer((TableCellRenderer)new NumberCellRenderer());
                column.setComparator((Comparator)new NumberCellComparator());
                column.setMaxWidth(75);
                column.setMinWidth(75);
                column.setToolTipText("<html><body>The number of messages that errored in this channel.<br>This value will be highlighted if it is greater than 0.</body></html>");
                break;
            }
            default: {
                DashboardColumnPlugin plugin = this.plugins.get(modelIndex);
                if (plugin == null) break;
                column.setCellRenderer(plugin.getCellRenderer());
                column.setMaxWidth(plugin.getMaxWidth());
                column.setMinWidth(plugin.getMinWidth());
            }
        }
        return column;
    }
}

