/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractDashboardTableNode;
import com.mirth.connect.client.ui.AbstractSortableTreeTableNode;
import com.mirth.connect.client.ui.CellData;
import com.mirth.connect.client.ui.ChannelGroupStatus;
import com.mirth.connect.client.ui.DashboardTableNodeFactory;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.ChannelGroup;
import com.mirth.connect.model.ChannelStatus;
import com.mirth.connect.model.DashboardStatus;
import com.mirth.connect.plugins.DashboardColumnPlugin;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class DashboardTreeTableModel
extends SortableTreeTableModel {
    private DashboardTableNodeFactory nodeFactory;
    private boolean groupModeEnabled = true;
    private MutableTreeTableNode groupRoot;
    private MutableTreeTableNode channelRoot;

    public DashboardTreeTableModel() {
        this.setSortChildNodes(true);
    }

    public void setNodeFactory(DashboardTableNodeFactory nodeFactory) {
        this.nodeFactory = nodeFactory;
    }

    public boolean isGroupModeEnabled() {
        return this.groupModeEnabled;
    }

    public MutableTreeTableNode getGroupRoot() {
        if (this.groupRoot == null) {
            this.initializeRoot();
        }
        return this.groupRoot;
    }

    public MutableTreeTableNode getChannelRoot() {
        if (this.channelRoot == null) {
            this.initializeRoot();
        }
        return this.channelRoot;
    }

    public void setGroupModeEnabled(boolean groupModeEnabled) {
        if (groupModeEnabled != this.groupModeEnabled) {
            this.groupModeEnabled = groupModeEnabled;
            if (this.getRoot() == null) {
                this.initializeRoot();
            } else {
                this.setRoot((TreeTableNode)(groupModeEnabled ? this.groupRoot : this.channelRoot));
            }
        }
    }

    public int getHierarchicalColumn() {
        return 1;
    }

    public Class<?> getColumnClass(int column) {
        switch (column -= this.getColumnOffset()) {
            case 0: {
                return CellData.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 3: {
                return Calendar.class;
            }
            case 4: {
                return Integer.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return Integer.class;
            }
            case 7: {
                return Integer.class;
            }
            case 8: {
                return Integer.class;
            }
            case 9: {
                return Integer.class;
            }
        }
        return String.class;
    }

    public Object getChild(Object parent, int index) {
        if (!this.isValidTreeTableNode(parent)) {
            throw new IllegalArgumentException("parent must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)parent).getChildAt(index);
    }

    public int getChildCount(Object parent) {
        if (!this.isValidTreeTableNode(parent)) {
            throw new IllegalArgumentException("parent must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)parent).getChildCount();
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (!this.isValidTreeTableNode(parent) || !this.isValidTreeTableNode(child)) {
            return -1;
        }
        return ((TreeTableNode)parent).getIndex((TreeNode)((TreeTableNode)child));
    }

    public Object getValueAt(Object node, int column) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode ttn = (TreeTableNode)node;
        if (column >= ttn.getColumnCount()) {
            return null;
        }
        return ttn.getValueAt(column);
    }

    public boolean isCellEditable(Object node, int column) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode ttn = (TreeTableNode)node;
        if (column >= ttn.getColumnCount()) {
            return false;
        }
        return ttn.isEditable(column);
    }

    public boolean isLeaf(Object node) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a TreeTableNode managed by this model");
        }
        return ((TreeTableNode)node).isLeaf();
    }

    public void setValueAt(Object value, Object node, int column) {
        if (!this.isValidTreeTableNode(node)) {
            throw new IllegalArgumentException("node must be a valid node managed by this model");
        }
        if (column < 0 || column >= this.getColumnCount()) {
            throw new IllegalArgumentException("column must be a valid index");
        }
        TreeTableNode ttn = (TreeTableNode)node;
        if (column < ttn.getColumnCount()) {
            ttn.setValueAt(value, column);
            this.modelSupport.firePathChanged(new TreePath(this.getPathToRoot(ttn)));
        }
    }

    public TreeTableNode[] getPathToRoot(TreeTableNode aNode) {
        TreeTableNode node;
        ArrayList<TreeTableNode> path = new ArrayList<TreeTableNode>();
        for (node = aNode; node != this.groupRoot && node != this.channelRoot; node = node.getParent()) {
            path.add(0, node);
        }
        if (node == this.groupRoot || node == this.channelRoot) {
            path.add(0, node);
        }
        return path.toArray(new TreeTableNode[0]);
    }

    private boolean isValidTreeTableNode(Object node) {
        boolean result = false;
        if (node instanceof TreeTableNode) {
            for (TreeTableNode ttn = (TreeTableNode)node; !result && ttn != null; ttn = ttn.getParent()) {
                result = ttn == this.groupRoot || ttn == this.channelRoot;
            }
        }
        return result;
    }

    public void setShowLifetimeStats(boolean showLifetimeStats) {
        this.setShowLifetimeStats(showLifetimeStats, this.groupRoot);
        this.setShowLifetimeStats(showLifetimeStats, this.channelRoot);
    }

    private void setShowLifetimeStats(boolean showLifetimeStats, MutableTreeTableNode parent) {
        if (parent == this.groupRoot) {
            Enumeration groupNodes = this.groupRoot.children();
            while (groupNodes.hasMoreElements()) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
                this.setShowLifetimeStats(showLifetimeStats, (MutableTreeTableNode)groupNode);
                groupNode.setShowLifetimeStats(showLifetimeStats);
            }
        } else {
            for (int i = 0; i < parent.getChildCount(); ++i) {
                AbstractDashboardTableNode node = (AbstractDashboardTableNode)parent.getChildAt(i);
                node.setShowLifetimeStats(showLifetimeStats);
                this.setShowLifetimeStats(showLifetimeStats, (MutableTreeTableNode)node);
            }
        }
    }

    private void initializeRoot() {
        if (this.getRoot() == null) {
            this.channelRoot = this.getNewRootNode();
            this.groupRoot = this.getNewRootNode();
            this.setRoot((TreeTableNode)(this.groupModeEnabled ? this.groupRoot : this.channelRoot));
            this.addDefaultGroupNode();
        }
    }

    private AbstractDashboardTableNode addDefaultGroupNode() {
        AbstractDashboardTableNode defaultGroupNode = this.nodeFactory.createNode(new ChannelGroupStatus(ChannelGroup.getDefaultGroup(), new ArrayList<ChannelStatus>()));
        this.insertNodeInto((MutableTreeTableNode)defaultGroupNode, this.groupRoot);
        return defaultGroupNode;
    }

    private MutableTreeTableNode getNewRootNode() {
        return new AbstractSortableTreeTableNode(){

            public Object getValueAt(int arg0) {
                return null;
            }

            public int getColumnCount() {
                return 0;
            }
        };
    }

    public void setStatuses(List<DashboardStatus> intermediateStatuses) {
        MutableTreeTableNode root = (MutableTreeTableNode)this.getRoot();
        if (root == null) {
            this.initializeRoot();
            this.add(intermediateStatuses, this.groupRoot);
            this.add(intermediateStatuses, this.channelRoot);
        } else {
            this.updateChannelNodes(new ArrayList<DashboardStatus>(intermediateStatuses), this.groupRoot);
            this.updateChannelNodes(new ArrayList<DashboardStatus>(intermediateStatuses), this.channelRoot);
        }
    }

    public void setGroupStatuses(Collection<ChannelGroupStatus> channelGroupStatuses) {
        HashMap<String, ChannelGroupStatus> groupStatusMap = new HashMap<String, ChannelGroupStatus>();
        for (ChannelGroupStatus groupStatus : channelGroupStatuses) {
            groupStatusMap.put(groupStatus.getGroup().getId(), groupStatus);
        }
        ArrayList<AbstractDashboardTableNode> tableGroupNodes = new ArrayList<AbstractDashboardTableNode>();
        AbstractDashboardTableNode defaultGroupNode = null;
        Enumeration groupNodes = this.groupRoot.children();
        while (groupNodes.hasMoreElements()) {
            AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
            if (StringUtils.equals((CharSequence)groupNode.getGroupStatus().getGroup().getId(), (CharSequence)"Default Group")) {
                defaultGroupNode = groupNode;
            }
            tableGroupNodes.add(groupNode);
        }
        ArrayList<AbstractDashboardTableNode> groupNodesToRemove = new ArrayList<AbstractDashboardTableNode>();
        for (AbstractDashboardTableNode groupNode : tableGroupNodes) {
            ChannelGroup group = groupNode.getGroupStatus().getGroup();
            ChannelGroupStatus matchingGroupStatus = (ChannelGroupStatus)groupStatusMap.remove(group.getId());
            if (matchingGroupStatus != null) {
                AbstractDashboardTableNode channelNode;
                ChannelGroup matchingGroup = matchingGroupStatus.getGroup();
                HashSet<String> channelIds = new HashSet<String>();
                for (Channel channel : matchingGroup.getChannels()) {
                    channelIds.add(channel.getId());
                }
                for (Channel channel : group.getChannels()) {
                    if (channelIds.remove(channel.getId()) || (channelNode = groupNode.getChannelNode(channel.getId())) == null) continue;
                    this.removeNodeFromParent((MutableTreeTableNode)channelNode);
                    if (defaultGroupNode == null) {
                        defaultGroupNode = this.addDefaultGroupNode();
                    }
                    this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)defaultGroupNode);
                }
                for (String channelId : channelIds) {
                    channelNode = this.findChannelNode(channelId);
                    if (channelNode == null) continue;
                    this.removeNodeFromParent((MutableTreeTableNode)channelNode);
                    this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)groupNode);
                }
                groupNode.setGroupStatus(matchingGroupStatus);
                continue;
            }
            for (Channel channel : group.getChannels()) {
                AbstractDashboardTableNode channelNode = groupNode.getChannelNode(channel.getId());
                if (channelNode == null) continue;
                this.removeNodeFromParent((MutableTreeTableNode)channelNode);
                if (defaultGroupNode == null) {
                    defaultGroupNode = this.addDefaultGroupNode();
                }
                this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)defaultGroupNode);
            }
            groupNodesToRemove.add(groupNode);
        }
        for (ChannelGroupStatus groupStatus : groupStatusMap.values()) {
            AbstractDashboardTableNode groupNode = this.nodeFactory.createNode(groupStatus);
            this.insertNodeInto((MutableTreeTableNode)groupNode, this.groupRoot);
            for (Channel channel : groupStatus.getGroup().getChannels()) {
                AbstractDashboardTableNode channelNode;
                if (defaultGroupNode == null) {
                    defaultGroupNode = this.addDefaultGroupNode();
                }
                if ((channelNode = defaultGroupNode.getChannelNode(channel.getId())) == null) continue;
                this.removeNodeFromParent((MutableTreeTableNode)channelNode);
                this.insertNodeInto((MutableTreeTableNode)channelNode, (MutableTreeTableNode)groupNode);
            }
            groupNode.updateGroupNode();
        }
        for (AbstractDashboardTableNode groupNode : groupNodesToRemove) {
            this.removeNodeFromParent((MutableTreeTableNode)groupNode);
        }
    }

    private AbstractDashboardTableNode findChannelNode(String channelId) {
        Enumeration groupNodes = this.groupRoot.children();
        while (groupNodes.hasMoreElements()) {
            AbstractDashboardTableNode channelNode = ((AbstractDashboardTableNode)((Object)groupNodes.nextElement())).getChannelNode(channelId);
            if (channelNode == null) continue;
            return channelNode;
        }
        return null;
    }

    public void refresh() {
        MutableTreeTableNode root = (MutableTreeTableNode)this.getRoot();
        if (root != null) {
            this.modelSupport.firePathChanged(new TreePath(root));
        }
    }

    public void finishStatuses(List<DashboardStatus> finishedStatuses) {
        this.initializeRoot();
        this.removeLingeringChannelNodes(finishedStatuses, this.groupRoot);
        this.removeLingeringChannelNodes(finishedStatuses, this.channelRoot);
    }

    private int getColumnOffset() {
        int counter = 0;
        for (DashboardColumnPlugin plugin : LoadedExtensions.getInstance().getDashboardColumnPlugins().values()) {
            if (!plugin.isDisplayFirst()) continue;
            ++counter;
        }
        return counter;
    }

    private void add(Collection<DashboardStatus> statuses, MutableTreeTableNode parent) {
        if (parent == this.groupRoot) {
            HashMap<String, AbstractDashboardTableNode> groupNodeMap = new HashMap<String, AbstractDashboardTableNode>();
            Enumeration groupNodes = this.groupRoot.children();
            while (groupNodes.hasMoreElements()) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
                for (Channel channel : groupNode.getGroupStatus().getGroup().getChannels()) {
                    groupNodeMap.put(channel.getId(), groupNode);
                }
            }
            AbstractDashboardTableNode defaultGroupNode = null;
            Enumeration groupNodes2 = this.groupRoot.children();
            while (groupNodes2.hasMoreElements()) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes2.nextElement());
                if (!StringUtils.equals((CharSequence)groupNode.getGroupStatus().getGroup().getId(), (CharSequence)"Default Group")) continue;
                defaultGroupNode = groupNode;
                break;
            }
            for (DashboardStatus status : statuses) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodeMap.get(status.getChannelId()));
                if (groupNode != null) {
                    this.add(Collections.singleton(status), (MutableTreeTableNode)groupNode);
                    groupNode.updateGroupNode();
                    continue;
                }
                if (defaultGroupNode == null) {
                    defaultGroupNode = this.addDefaultGroupNode();
                }
                this.add(Collections.singleton(status), (MutableTreeTableNode)defaultGroupNode);
                defaultGroupNode.updateGroupNode();
            }
        } else {
            int index = parent.getChildCount();
            for (DashboardStatus status : statuses) {
                AbstractDashboardTableNode newNode = this.nodeFactory.createNode(status.getChannelId(), status);
                this.insertNodeInto((MutableTreeTableNode)newNode, parent, index++);
                this.add(status.getChildStatuses(), (MutableTreeTableNode)newNode);
            }
        }
    }

    private void updateChannelNodes(List<DashboardStatus> statuses, MutableTreeTableNode root) {
        Map<String, DashboardStatus> statusMap = this.getStatusMap(statuses);
        if (root == this.groupRoot) {
            Enumeration groupNodes = this.groupRoot.children();
            while (groupNodes.hasMoreElements()) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
                this.updateChannelNodes(statusMap, statuses, (MutableTreeTableNode)groupNode);
                groupNode.updateGroupNode();
            }
        } else {
            this.updateChannelNodes(statusMap, statuses, root);
        }
        this.add(statuses, root);
    }

    private void updateChannelNodes(Map<String, DashboardStatus> statusMap, List<DashboardStatus> statuses, MutableTreeTableNode parent) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            AbstractDashboardTableNode node = (AbstractDashboardTableNode)parent.getChildAt(i);
            if (!statusMap.containsKey(node.getDashboardStatus().getKey())) continue;
            DashboardStatus status = statusMap.get(node.getDashboardStatus().getKey());
            statuses.remove(status);
            node.setDashboardStatus(status);
            this.modelSupport.firePathChanged(new TreePath(this.getPathToRoot((TreeTableNode)node)));
            this.updateConnector(statusMap, node);
        }
    }

    private void removeLingeringChannelNodes(List<DashboardStatus> statuses, MutableTreeTableNode root) {
        Map<String, DashboardStatus> statusMap = this.getStatusMap(statuses);
        if (root == this.groupRoot) {
            Enumeration groupNodes = this.groupRoot.children();
            while (groupNodes.hasMoreElements()) {
                AbstractDashboardTableNode groupNode = (AbstractDashboardTableNode)((Object)groupNodes.nextElement());
                this.removeLingeringChannelNodes(statusMap, statuses, (MutableTreeTableNode)groupNode);
                groupNode.updateGroupNode();
            }
        } else {
            this.removeLingeringChannelNodes(statusMap, statuses, root);
        }
    }

    private void removeLingeringChannelNodes(Map<String, DashboardStatus> statusMap, List<DashboardStatus> statuses, MutableTreeTableNode root) {
        for (int i = 0; i < root.getChildCount(); ++i) {
            AbstractDashboardTableNode node = (AbstractDashboardTableNode)root.getChildAt(i);
            if (statusMap.containsKey(node.getDashboardStatus().getKey())) continue;
            this.removeNodeFromParent((MutableTreeTableNode)node);
            --i;
        }
    }

    private void updateConnector(Map<String, DashboardStatus> statusMap, AbstractDashboardTableNode channelNode) {
        int i;
        HashMap<String, AbstractDashboardTableNode> nodeMap = new HashMap<String, AbstractDashboardTableNode>();
        DashboardStatus channelStatus = statusMap.get(channelNode.getDashboardStatus().getKey());
        for (i = 0; i < channelNode.getChildCount(); ++i) {
            AbstractDashboardTableNode node = (AbstractDashboardTableNode)channelNode.getChildAt(i);
            if (!statusMap.containsKey(node.getDashboardStatus().getKey())) {
                this.removeNodeFromParent((MutableTreeTableNode)node);
                --i;
                continue;
            }
            nodeMap.put(node.getDashboardStatus().getKey(), node);
        }
        for (i = 0; i < channelStatus.getChildStatuses().size(); ++i) {
            AbstractDashboardTableNode node;
            DashboardStatus newConnectorStatus = (DashboardStatus)channelStatus.getChildStatuses().get(i);
            AbstractDashboardTableNode oldConnectorNode = null;
            if (i < channelNode.getChildCount()) {
                oldConnectorNode = (AbstractDashboardTableNode)channelNode.getChildAt(i);
            }
            if (oldConnectorNode != null && newConnectorStatus.getKey().equals(oldConnectorNode.getDashboardStatus().getKey())) {
                oldConnectorNode.setDashboardStatus(newConnectorStatus);
                this.modelSupport.firePathChanged(new TreePath(this.getPathToRoot((TreeTableNode)oldConnectorNode)));
                continue;
            }
            if (nodeMap.containsKey(newConnectorStatus.getKey())) {
                node = (AbstractDashboardTableNode)((Object)nodeMap.get(newConnectorStatus.getKey()));
                this.removeNodeFromParent((MutableTreeTableNode)node);
                node.setDashboardStatus(newConnectorStatus);
            } else {
                node = this.nodeFactory.createNode(newConnectorStatus.getChannelId(), newConnectorStatus);
            }
            this.insertNodeInto((MutableTreeTableNode)node, (MutableTreeTableNode)channelNode, i);
        }
    }

    private Map<String, DashboardStatus> getStatusMap(List<DashboardStatus> statuses) {
        LinkedHashMap<String, DashboardStatus> statusMap = new LinkedHashMap<String, DashboardStatus>();
        for (DashboardStatus status : statuses) {
            statusMap.put(status.getKey(), status);
            for (DashboardStatus child : status.getChildStatuses()) {
                statusMap.put(child.getKey(), status);
            }
        }
        return statusMap;
    }
}

