/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.DataTypeNodeDescriptor;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTriStateCheckBox;
import com.mirth.connect.client.ui.editors.JavaScriptEditorDialog;
import com.mirth.connect.model.datatype.PropertyEditorType;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;

public class DataTypePropertiesCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private static final String DIFFERENT_VALUES = "<Different Values>";
    private JTextField textField = new JTextField();
    private MirthTriStateCheckBox checkBox = new MirthTriStateCheckBox();
    private JComboBox comboBox;
    private JLabel label;
    private JButton button;
    private JPanel panel;
    private PropertyEditorType valueType;

    public DataTypePropertiesCellEditor() {
        this.checkBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypePropertiesCellEditor.this.fireEditingStopped();
            }
        });
        this.comboBox = new JComboBox();
        this.comboBox.setFocusable(false);
        this.comboBox.setMaximumRowCount(20);
        this.comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (index >= 0 && !isSelected) {
                    component.setBackground(UIConstants.BACKGROUND_COLOR);
                }
                return component;
            }
        });
        this.comboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypePropertiesCellEditor.this.fireEditingStopped();
            }
        });
        for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
            if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
            ((AbstractButton)this.comboBox.getComponent(i)).setBorderPainted(false);
        }
        this.label = new JLabel();
        this.button = new JButton("Edit");
        this.button.setAlignmentX(1.0f);
        this.button.addActionListener(new JavaScriptActionListener());
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.panel.add((Component)this.label, constraints);
        this.panel.add(this.button);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.valueType == PropertyEditorType.BOOLEAN) {
            if (this.checkBox.getState() == 0) {
                return true;
            }
            if (this.checkBox.getState() == 1) {
                return false;
            }
        } else {
            if (this.valueType == PropertyEditorType.STRING) {
                return this.textField.getText();
            }
            if (this.valueType == PropertyEditorType.JAVASCRIPT) {
                return this.label.getText();
            }
            if (this.valueType == PropertyEditorType.OPTION) {
                return this.comboBox.getSelectedItem();
            }
        }
        return null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (value instanceof DataTypeNodeDescriptor) {
            DataTypeNodeDescriptor nodeDescriptor = (DataTypeNodeDescriptor)value;
            this.valueType = nodeDescriptor.getEditorType();
            if (this.valueType == PropertyEditorType.BOOLEAN) {
                this.checkBox.setBackground(table.getSelectionBackground());
                Boolean booleanValue = (Boolean)nodeDescriptor.getValue();
                if (nodeDescriptor.isMultipleValues()) {
                    this.checkBox.setText(DIFFERENT_VALUES);
                    this.checkBox.setState(2);
                } else if (booleanValue.booleanValue()) {
                    this.checkBox.setText("");
                    this.checkBox.setState(0);
                } else {
                    this.checkBox.setText("");
                    this.checkBox.setState(1);
                }
                return this.checkBox;
            }
            if (this.valueType == PropertyEditorType.STRING) {
                this.textField.setText((String)nodeDescriptor.getValue());
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DataTypePropertiesCellEditor.this.textField.requestFocus();
                    }
                });
            } else {
                if (this.valueType == PropertyEditorType.JAVASCRIPT) {
                    this.label.setText((String)nodeDescriptor.getValue());
                    this.panel.setBackground(table.getSelectionBackground());
                    return this.panel;
                }
                if (this.valueType == PropertyEditorType.OPTION) {
                    this.comboBox.setBackground(table.getSelectionBackground());
                    this.comboBox.setModel(new DefaultComboBoxModel<Object>(nodeDescriptor.getOptions()));
                    this.comboBox.setSelectedItem(nodeDescriptor.getValue());
                    return this.comboBox;
                }
            }
        }
        return this.textField;
    }

    private class JavaScriptActionListener
    implements ActionListener {
        private JavaScriptActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JavaScriptEditorDialog dialog = new JavaScriptEditorDialog(DataTypePropertiesCellEditor.this.label.getText());
            DataTypePropertiesCellEditor.this.label.setText(dialog.getSavedScript());
            DataTypePropertiesCellEditor.this.fireEditingStopped();
        }
    }
}

