/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.DataTypeNodeDescriptor;
import com.mirth.connect.client.ui.components.MirthTriStateCheckBox;
import com.mirth.connect.model.datatype.PropertyEditorType;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class DataTypePropertiesCellRenderer
extends DefaultTableCellRenderer {
    private static final String DIFFERENT_VALUES = "<Different Values>";
    private JLabel label = new JLabel();
    private JLabel javascriptLabel;
    private MirthTriStateCheckBox checkBox;
    private JComboBox comboBox;
    private JButton button;
    private JPanel panel;

    public DataTypePropertiesCellRenderer() {
        this.label.setOpaque(true);
        this.label.setBorder(BorderFactory.createEmptyBorder());
        this.javascriptLabel = new JLabel();
        this.javascriptLabel.setBorder(BorderFactory.createEmptyBorder());
        this.checkBox = new MirthTriStateCheckBox();
        this.comboBox = new JComboBox();
        for (int i = 0; i < this.comboBox.getComponentCount(); ++i) {
            if (!(this.comboBox.getComponent(i) instanceof AbstractButton)) continue;
            ((AbstractButton)this.comboBox.getComponent(i)).setBorderPainted(false);
        }
        this.button = new JButton("Edit");
        this.button.setAlignmentX(1.0f);
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        this.panel.setBorder(BorderFactory.createEmptyBorder());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 1;
        constraints.anchor = 10;
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        this.panel.add((Component)this.javascriptLabel, constraints);
        this.panel.add(this.button);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Color backgroundColor = isSelected ? table.getSelectionBackground() : table.getBackground();
        this.checkBox.setBackground(backgroundColor);
        this.comboBox.setBackground(backgroundColor);
        this.label.setBackground(backgroundColor);
        this.panel.setBackground(backgroundColor);
        if (value != null) {
            if (value instanceof DataTypeNodeDescriptor) {
                DataTypeNodeDescriptor nodeDescriptor = (DataTypeNodeDescriptor)value;
                PropertyEditorType editorType = nodeDescriptor.getEditorType();
                if (editorType == PropertyEditorType.BOOLEAN) {
                    Boolean booleanValue = (Boolean)nodeDescriptor.getValue();
                    if (nodeDescriptor.isMultipleValues()) {
                        this.checkBox.setText(DIFFERENT_VALUES);
                        this.checkBox.setState(2);
                    } else if (booleanValue.booleanValue()) {
                        this.checkBox.setText("");
                        this.checkBox.setState(0);
                    } else {
                        this.checkBox.setText("");
                        this.checkBox.setState(1);
                    }
                    return this.checkBox;
                }
                if (editorType == PropertyEditorType.STRING) {
                    String stringValue = (String)nodeDescriptor.getValue();
                    if (nodeDescriptor.isMultipleValues()) {
                        stringValue = DIFFERENT_VALUES;
                    }
                    this.label.setText(stringValue);
                    return this.label;
                }
                if (editorType == PropertyEditorType.JAVASCRIPT) {
                    String stringValue = (String)nodeDescriptor.getValue();
                    if (nodeDescriptor.isMultipleValues()) {
                        stringValue = DIFFERENT_VALUES;
                    }
                    this.javascriptLabel.setText(stringValue);
                    return this.panel;
                }
                if (editorType == PropertyEditorType.OPTION) {
                    Object objectValue = nodeDescriptor.getValue();
                    if (nodeDescriptor.isMultipleValues()) {
                        objectValue = DIFFERENT_VALUES;
                    }
                    this.comboBox.getModel().setSelectedItem(objectValue);
                    return this.comboBox;
                }
            }
        } else {
            this.label.setText("");
        }
        return this.label;
    }
}

