/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.DataTypeColumnFactory;
import com.mirth.connect.client.ui.DataTypePropertiesContainer;
import com.mirth.connect.client.ui.DataTypePropertiesTableModel;
import com.mirth.connect.client.ui.DataTypePropertiesTableNode;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.model.datatype.DataTypeProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class DataTypePropertiesPanel
extends JPanel {
    private DataTypePropertiesTableModel tableModel;
    private boolean inbound;
    private Style style;
    private JComboBox dataTypeComboBox;
    private JButton defaultButton;
    private JTextPane descriptionPane;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private MirthTreeTable propertiesTreeTable;

    public DataTypePropertiesPanel() {
        this.initComponents();
        this.style = this.descriptionPane.addStyle("BOLD", null);
        StyleConstants.setBold(this.style, true);
        this.tableModel = new DataTypePropertiesTableModel(){

            public void setValueAt(Object value, Object node, int column) {
                super.setValueAt(value, node, column);
                DataTypePropertiesPanel.this.updateDefaultButton();
            }
        };
        this.tableModel.setColumnIdentifiers(Arrays.asList("Name", "Value"));
        this.propertiesTreeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.propertiesTreeTable.setColumnFactory(new DataTypeColumnFactory());
        this.propertiesTreeTable.setTreeTableModel((TreeTableModel)this.tableModel);
        this.propertiesTreeTable.setDragEnabled(false);
        this.propertiesTreeTable.setSortable(false);
        this.propertiesTreeTable.setSelectionMode(0);
        this.propertiesTreeTable.setDoubleBuffered(true);
        this.propertiesTreeTable.setLeafIcon(null);
        this.propertiesTreeTable.setOpenIcon(null);
        this.propertiesTreeTable.setClosedIcon(null);
        this.propertiesTreeTable.setAutoCreateColumnsFromModel(false);
        this.propertiesTreeTable.setShowGrid(true, true);
        this.propertiesTreeTable.setTableHeader(null);
        this.propertiesTreeTable.setEditable(true);
        this.propertiesTreeTable.setShowsRootHandles(false);
        this.propertiesTreeTable.setTreeCellRenderer(new TreeCellRenderer(){
            private JLabel label = new JLabel();

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof DataTypePropertiesTableNode) {
                    DataTypePropertiesTableNode node = (DataTypePropertiesTableNode)((Object)value);
                    if (node.isGroupHeader()) {
                        this.label.setFont(this.label.getFont().deriveFont(1));
                        this.label.setText(" " + String.valueOf(((DataTypePropertiesTableNode)((Object)value)).getValueAt(0)));
                    } else {
                        this.label.setFont(this.label.getFont().deriveFont(0));
                        this.label.setText((String)((DataTypePropertiesTableNode)((Object)value)).getValueAt(0));
                    }
                }
                return this.label;
            }
        });
        this.propertiesTreeTable.getTreeSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                DataTypePropertiesPanel.this.descriptionPane.setText("");
                if (e.getNewLeadSelectionPath() != null) {
                    StyledDocument document = DataTypePropertiesPanel.this.descriptionPane.getStyledDocument();
                    DataTypePropertiesTableNode tableNode = (DataTypePropertiesTableNode)((Object)e.getNewLeadSelectionPath().getLastPathComponent());
                    String descriptionTitle = tableNode.getName();
                    String descriptionBody = tableNode.getDescription();
                    try {
                        if (descriptionTitle != null && descriptionBody != null) {
                            document.insertString(0, descriptionTitle, DataTypePropertiesPanel.this.style);
                            document.insertString(document.getLength(), "\n" + descriptionBody, null);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                    DataTypePropertiesPanel.this.descriptionPane.setCaretPosition(0);
                }
            }
        });
        this.propertiesTreeTable.getColumnModel().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getFirstIndex() != 1) {
                    DataTypePropertiesPanel.this.propertiesTreeTable.getColumnModel().getSelectionModel().setLeadSelectionIndex(1);
                }
            }
        });
        this.propertiesTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    int x = e.getX();
                    int y = e.getY();
                    final TreePath path = DataTypePropertiesPanel.this.propertiesTreeTable.getPathForLocation(x, y);
                    DataTypePropertiesPanel.this.propertiesTreeTable.getTreeSelectionModel().setSelectionPath(path);
                    JPopupMenu popupMenu = new JPopupMenu();
                    JMenuItem menuItem = new JMenuItem("Restore Defaults");
                    menuItem.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            DataTypePropertiesTableNode tableNode = (DataTypePropertiesTableNode)((Object)path.getLastPathComponent());
                            DataTypePropertiesPanel.this.tableModel.resetToDefault((TreeTableNode)tableNode);
                            DataTypePropertiesPanel.this.updateDefaultButton();
                        }
                    });
                    popupMenu.add(menuItem);
                    popupMenu.show(e.getComponent(), x, y);
                }
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.propertiesTreeTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    public JComboBox getDataTypeComboBox() {
        return this.dataTypeComboBox;
    }

    public JButton getDefaultButton() {
        return this.defaultButton;
    }

    public void updateDefaultButton() {
        this.defaultButton.setEnabled(!this.tableModel.isDefaultProperties(null));
    }

    public void setInbound(boolean inbound) {
        this.inbound = inbound;
    }

    public void setUseTitleBorder(boolean useTitleBorder) {
        if (useTitleBorder) {
            this.setBorder(BorderFactory.createTitledBorder((this.inbound ? "Inbound" : "Outbound") + " Properties"));
        } else {
            this.setBorder(BorderFactory.createEmptyBorder());
        }
    }

    public void setDataTypeProperties(String dataType, DataTypePropertiesContainer propertiesContainer) {
        ArrayList<DataTypePropertiesContainer> propertiesContainerList = null;
        if (propertiesContainer != null) {
            propertiesContainerList = new ArrayList<DataTypePropertiesContainer>();
            propertiesContainerList.add(propertiesContainer);
        }
        this.setDataTypeProperties(dataType, propertiesContainerList);
    }

    public void setDataTypeProperties(String displayName, List<DataTypePropertiesContainer> propertiesContainers) {
        DataTypeProperties defaultProperties = null;
        if (displayName != null) {
            defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(PlatformUI.MIRTH_FRAME.displayNameToDataType.get(displayName)).getDefaultProperties();
        }
        this.tableModel.clear();
        this.tableModel.addProperties(this.inbound, propertiesContainers, defaultProperties);
        this.updateDefaultButton();
        this.propertiesTreeTable.expandAll();
    }

    private void initComponents() {
        this.jScrollPane3 = new JScrollPane();
        this.propertiesTreeTable = new MirthTreeTable();
        this.jScrollPane1 = new JScrollPane();
        this.descriptionPane = new JTextPane();
        this.jPanel1 = new JPanel();
        this.defaultButton = new JButton();
        this.dataTypeComboBox = new JComboBox();
        this.setBackground(new Color(255, 255, 255));
        this.jScrollPane3.setVerticalScrollBarPolicy(22);
        this.propertiesTreeTable.setAutoResizeMode(4);
        this.jScrollPane3.setViewportView((Component)((Object)this.propertiesTreeTable));
        this.descriptionPane.setEditable(false);
        this.jScrollPane1.setViewportView(this.descriptionPane);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.defaultButton.setText("Restore Defaults");
        this.dataTypeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.dataTypeComboBox, -2, 137, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.defaultButton)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.defaultButton).addComponent(this.dataTypeComboBox, -2, 21, -2)));
        jPanel1Layout.linkSize(1, this.dataTypeComboBox, this.defaultButton);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 457, Short.MAX_VALUE).addComponent(this.jScrollPane3).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -1, 237, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 79, -2)));
    }
}

