/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.DataTypeNodeDescriptor;
import com.mirth.connect.model.datatype.DataTypePropertiesGroup;
import com.mirth.connect.model.datatype.DataTypePropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;

public class DataTypePropertiesTableNode
extends AbstractMutableTreeTableNode {
    private String groupName;
    private String groupDescription;
    private String propertyName;
    private List<DataTypePropertiesGroup> propertiesGroups;
    private DataTypePropertiesGroup defaultPropertiesGroup;

    public DataTypePropertiesTableNode(String groupName, String groupDescription) {
        this.groupName = groupName;
        this.groupDescription = groupDescription;
    }

    public DataTypePropertiesTableNode(String propertyName, List<DataTypePropertiesGroup> propertiesGroups, DataTypePropertiesGroup defaultPropertiesGroup) {
        this.propertyName = propertyName;
        this.propertiesGroups = propertiesGroups;
        this.defaultPropertiesGroup = defaultPropertiesGroup;
    }

    public boolean isEditable(int column) {
        return column == 1 && this.propertiesGroups != null;
    }

    public int getColumnCount() {
        return 2;
    }

    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                if (this.isGroupHeader()) {
                    return this.groupName;
                }
                Object displayName = ((DataTypePropertyDescriptor)this.defaultPropertiesGroup.getPropertyDescriptors().get(this.propertyName)).getDisplayName();
                if (!this.isDefaultProperty()) {
                    displayName = "<html><b>" + (String)displayName + "</b></html>";
                }
                return displayName;
            }
            case 1: {
                if (this.isGroupHeader()) {
                    return null;
                }
                DataTypeNodeDescriptor descriptor = null;
                for (DataTypePropertiesGroup propertiesGroup : this.propertiesGroups) {
                    DataTypePropertyDescriptor currentDescriptor = (DataTypePropertyDescriptor)propertiesGroup.getPropertyDescriptors().get(this.propertyName);
                    if (descriptor == null) {
                        descriptor = new DataTypeNodeDescriptor(currentDescriptor.getValue(), currentDescriptor.getEditorType(), false, currentDescriptor.getOptions());
                        continue;
                    }
                    if (descriptor.getValue().equals(currentDescriptor.getValue())) continue;
                    descriptor.setMultipleValues(true);
                    break;
                }
                return descriptor;
            }
        }
        return null;
    }

    public void setValueAt(Object value, int column) {
        if (column == 1 && this.propertiesGroups != null && value != null) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put(this.propertyName, value);
            for (DataTypePropertiesGroup propertiesGroup : this.propertiesGroups) {
                propertiesGroup.setProperties(map);
            }
        }
    }

    public boolean isGroupHeader() {
        return this.groupName != null;
    }

    public DataTypePropertyDescriptor getPropertyDescriptor() {
        return (DataTypePropertyDescriptor)this.defaultPropertiesGroup.getPropertyDescriptors().get(this.propertyName);
    }

    public String getName() {
        if (this.isGroupHeader()) {
            return this.groupName;
        }
        return ((DataTypePropertyDescriptor)this.defaultPropertiesGroup.getPropertyDescriptors().get(this.propertyName)).getDisplayName();
    }

    public String getDescription() {
        if (this.isGroupHeader()) {
            return this.groupDescription;
        }
        return ((DataTypePropertyDescriptor)this.defaultPropertiesGroup.getPropertyDescriptors().get(this.propertyName)).getDescription();
    }

    public void resetToDefault() {
        if (this.propertyName != null) {
            Object defaultValue = ((DataTypePropertyDescriptor)this.defaultPropertiesGroup.getPropertyDescriptors().get(this.propertyName)).getValue();
            this.setValueAt(defaultValue, 1);
        }
    }

    public boolean isDefaultProperty() {
        if (this.propertiesGroups != null) {
            Object defaultValue = ((DataTypePropertyDescriptor)this.defaultPropertiesGroup.getPropertyDescriptors().get(this.propertyName)).getValue();
            for (DataTypePropertiesGroup propertiesGroup : this.propertiesGroups) {
                Object value = ((DataTypePropertyDescriptor)propertiesGroup.getPropertyDescriptors().get(this.propertyName)).getValue();
                if (defaultValue.equals(value)) continue;
                return false;
            }
        }
        return true;
    }
}

