/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.DataTypeConnectorTableModel;
import com.mirth.connect.client.ui.DataTypeConnectorTableNode;
import com.mirth.connect.client.ui.DataTypePropertiesContainer;
import com.mirth.connect.client.ui.DataTypePropertiesPanel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TransformerType;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellEditor;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.components.MirthTriStateCheckBox;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.Connector;
import com.mirth.connect.model.Transformer;
import com.mirth.connect.model.datatype.DataTypeProperties;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class DataTypesDialog
extends MirthDialog {
    public static int CONNECTOR_COLUMN = 1;
    public static int INBOUND_COLUMN = 2;
    public static int OUTBOUND_COLUMN = 3;
    public static int SELECTION_COLUMN = 0;
    private static int SELECTION_COLUMN_WIDTH = 20;
    private Frame parent;
    private final String[] columnNames = new String[]{"", "Connector", "Inbound", "Outbound"};
    private EditMode editMode;
    private Map<Integer, TransformerContainer> transformerContainer;
    private MirthTriStateCheckBox allCheckBox;
    private JRadioButton bulkEditButton;
    private JButton closeButton;
    private JLabel collapseLabel;
    private MirthTreeTable connectorTreeTable;
    private JScrollPane connectorTreeTablePane;
    private MirthTriStateCheckBox destinationsCheckBox;
    private ButtonGroup editingGroup;
    private JLabel expandLabel;
    private DataTypePropertiesPanel inboundPropertiesPanel;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel5;
    private JSeparator jSeparator1;
    private JButton okButton;
    private DataTypePropertiesPanel outboundPropertiesPanel;
    private MirthTriStateCheckBox responsesCheckBox;
    private JRadioButton singleEditButton;

    public DataTypesDialog() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.parent = PlatformUI.MIRTH_FRAME;
        this.initComponents();
        this.inboundPropertiesPanel.setInbound(true);
        this.outboundPropertiesPanel.setInbound(false);
        this.inboundPropertiesPanel.setUseTitleBorder(true);
        this.outboundPropertiesPanel.setUseTitleBorder(true);
        String[] dataTypes = new String[PlatformUI.MIRTH_FRAME.dataTypeToDisplayName.values().size()];
        PlatformUI.MIRTH_FRAME.dataTypeToDisplayName.values().toArray(dataTypes);
        this.inboundPropertiesPanel.getDataTypeComboBox().setModel(new DefaultComboBoxModel<String>(dataTypes));
        this.outboundPropertiesPanel.getDataTypeComboBox().setModel(new DefaultComboBoxModel<String>(dataTypes));
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.transformerContainer = new HashMap<Integer, TransformerContainer>();
        this.makeTables();
        this.toggleEditMode(EditMode.SINGLE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                DataTypesDialog.this.revertProperties();
            }
        });
        this.addListeners();
        this.setVisible(true);
    }

    public void toggleEditMode(EditMode mode) {
        boolean singleEdit;
        if (this.editMode == mode) {
            return;
        }
        this.editMode = mode;
        TableColumnExt column = this.connectorTreeTable.getColumnExt(SELECTION_COLUMN);
        if (this.editMode == EditMode.SINGLE) {
            singleEdit = true;
            column.setMaxWidth(0);
            column.setMinWidth(0);
            column.setPreferredWidth(0);
            this.inboundPropertiesPanel.getDataTypeComboBox().setEnabled(true);
            this.outboundPropertiesPanel.getDataTypeComboBox().setEnabled(true);
            this.connectorTreeTable.clearSelection();
            this.connectorTreeTable.getTreeSelectionModel().setSelectionPath(this.connectorTreeTable.getPathForRow(0));
        } else {
            singleEdit = false;
            column.setMaxWidth(SELECTION_COLUMN_WIDTH);
            column.setMinWidth(SELECTION_COLUMN_WIDTH);
            column.setPreferredWidth(SELECTION_COLUMN_WIDTH);
            TreeTableNode root = (TreeTableNode)this.connectorTreeTable.getTreeTableModel().getRoot();
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeTableNode connector = root.getChildAt(i);
                connector.setValueAt((Object)false, SELECTION_COLUMN);
                for (int j = 0; j < connector.getChildCount(); ++j) {
                    connector.getChildAt(j).setValueAt((Object)false, SELECTION_COLUMN);
                }
            }
            this.updateBulkSelection();
        }
        this.allCheckBox.setVisible(!singleEdit);
        this.destinationsCheckBox.setVisible(!singleEdit);
        this.responsesCheckBox.setVisible(!singleEdit);
        this.connectorTreeTable.setRowSelectionAllowed(singleEdit);
        this.connectorTreeTable.setFocusable(singleEdit);
        this.connectorTreeTable.getColumnExt(INBOUND_COLUMN).setEditable(singleEdit);
        this.connectorTreeTable.getColumnExt(OUTBOUND_COLUMN).setEditable(singleEdit);
    }

    private void addListeners() {
        this.inboundPropertiesPanel.getDataTypeComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                if (comboBox.isPopupVisible()) {
                    String dataTypeDisplayName = (String)((JComboBox)e.getSource()).getSelectedItem();
                    if (DataTypesDialog.this.editMode == EditMode.SINGLE) {
                        DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)((Object)DataTypesDialog.this.connectorTreeTable.getPathForRow(DataTypesDialog.this.connectorTreeTable.getSelectedRow()).getLastPathComponent());
                        DataTypesDialog.this.updateSingleDataType(tableNode, dataTypeDisplayName, true);
                    } else {
                        String dataType = DataTypesDialog.this.parent.displayNameToDataType.get(dataTypeDisplayName);
                        if (dataType != null) {
                            TreeTableNode root = (TreeTableNode)DataTypesDialog.this.connectorTreeTable.getTreeTableModel().getRoot();
                            if (DataTypesDialog.this.updateInboundDataType(root, dataType, false)) {
                                DataTypesDialog.this.updateInboundDataType(root, dataType, true);
                                for (int i = 0; i < root.getChildCount(); ++i) {
                                    DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)root.getChildAt(i);
                                    Transformer transformer = DataTypesDialog.this.transformerContainer.get(tableNode.getContainerIndex()).getTransformer();
                                    TransformerType type = DataTypesDialog.this.transformerContainer.get(tableNode.getContainerIndex()).getType();
                                    if (type != TransformerType.SOURCE) continue;
                                    DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                                    tableNode.setValueAt(DataTypesDialog.this.parent.dataTypeToDisplayName.get(dataType), OUTBOUND_COLUMN);
                                    transformer.setOutboundDataType(dataType);
                                    transformer.setOutboundProperties(defaultProperties);
                                }
                            }
                            DataTypesDialog.this.updateBulkSelection();
                        }
                    }
                    DataTypesDialog.this.connectorTreeTable.repaint();
                }
            }
        });
        this.inboundPropertiesPanel.getDefaultButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)((Object)DataTypesDialog.this.connectorTreeTable.getTreeSelectionModel().getSelectionPath().getLastPathComponent());
                String dataTypeDisplayName = (String)tableNode.getValueAt(INBOUND_COLUMN);
                String dataType = PlatformUI.MIRTH_FRAME.displayNameToDataType.get(dataTypeDisplayName);
                if (DataTypesDialog.this.editMode == EditMode.SINGLE) {
                    int containerIndex = tableNode.getContainerIndex();
                    TransformerContainer container = DataTypesDialog.this.transformerContainer.get(containerIndex);
                    Transformer transformer = container.getTransformer();
                    DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                    transformer.setInboundProperties(defaultProperties);
                    DataTypesDialog.this.inboundPropertiesPanel.setDataTypeProperties(dataTypeDisplayName, new DataTypePropertiesContainer(defaultProperties, container.getType()));
                } else if (DataTypesDialog.this.editMode == EditMode.BULK) {
                    TreeTableNode root = (TreeTableNode)DataTypesDialog.this.connectorTreeTable.getTreeTableModel().getRoot();
                    DataTypesDialog.this.resetToDefault(root, dataType, true);
                    DataTypesDialog.this.updateBulkSelection();
                }
                DataTypesDialog.this.inboundPropertiesPanel.updateDefaultButton();
            }
        });
        this.outboundPropertiesPanel.getDataTypeComboBox().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JComboBox comboBox = (JComboBox)e.getSource();
                if (comboBox.isPopupVisible()) {
                    String dataTypeDisplayName = (String)((JComboBox)e.getSource()).getSelectedItem();
                    if (DataTypesDialog.this.editMode == EditMode.SINGLE) {
                        DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)((Object)DataTypesDialog.this.connectorTreeTable.getPathForRow(DataTypesDialog.this.connectorTreeTable.getSelectedRow()).getLastPathComponent());
                        DataTypesDialog.this.updateSingleDataType(tableNode, dataTypeDisplayName, false);
                    } else {
                        String dataType = DataTypesDialog.this.parent.displayNameToDataType.get(dataTypeDisplayName);
                        if (dataType != null) {
                            TreeTableNode root = (TreeTableNode)DataTypesDialog.this.connectorTreeTable.getTreeTableModel().getRoot();
                            if (DataTypesDialog.this.updateOutboundDataType(root, dataType)) {
                                DataTypesDialog.this.updateInboundDataType(root, dataType, true);
                            }
                            DataTypesDialog.this.updateBulkSelection();
                        }
                    }
                    DataTypesDialog.this.connectorTreeTable.repaint();
                }
            }
        });
        this.outboundPropertiesPanel.getDefaultButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)((Object)DataTypesDialog.this.connectorTreeTable.getTreeSelectionModel().getSelectionPath().getLastPathComponent());
                String dataTypeDisplayName = (String)tableNode.getValueAt(OUTBOUND_COLUMN);
                String dataType = PlatformUI.MIRTH_FRAME.displayNameToDataType.get(dataTypeDisplayName);
                if (DataTypesDialog.this.editMode == EditMode.SINGLE) {
                    int containerIndex = tableNode.getContainerIndex();
                    TransformerContainer container = DataTypesDialog.this.transformerContainer.get(containerIndex);
                    Transformer transformer = container.getTransformer();
                    DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                    transformer.setOutboundProperties(defaultProperties);
                    DataTypesDialog.this.outboundPropertiesPanel.setDataTypeProperties(dataTypeDisplayName, new DataTypePropertiesContainer(defaultProperties, container.getType()));
                } else if (DataTypesDialog.this.editMode == EditMode.BULK) {
                    TreeTableNode root = (TreeTableNode)DataTypesDialog.this.connectorTreeTable.getTreeTableModel().getRoot();
                    DataTypesDialog.this.resetToDefault(root, dataType, false);
                    DataTypesDialog.this.updateBulkSelection();
                }
                DataTypesDialog.this.outboundPropertiesPanel.updateDefaultButton();
            }
        });
    }

    private void resetToDefault(TreeTableNode node, String dataType, boolean inbound) {
        DataTypeConnectorTableNode tableNode;
        if (node instanceof DataTypeConnectorTableNode && ((Boolean)(tableNode = (DataTypeConnectorTableNode)node).getValueAt(SELECTION_COLUMN)).booleanValue()) {
            DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
            Transformer transformer = this.transformerContainer.get(tableNode.getContainerIndex()).getTransformer();
            tableNode.setValueAt(this.parent.dataTypeToDisplayName.get(dataType), INBOUND_COLUMN);
            if (inbound) {
                transformer.setInboundProperties(defaultProperties);
            } else {
                transformer.setOutboundProperties(defaultProperties);
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.resetToDefault(node.getChildAt(i), dataType, inbound);
        }
    }

    private boolean updateInboundDataType(TreeTableNode node, String dataType, boolean updateDestinationInbound) {
        boolean updateSourceOutbound = false;
        if (node instanceof DataTypeConnectorTableNode) {
            DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)node;
            TransformerType type = this.transformerContainer.get(tableNode.getContainerIndex()).getType();
            if ((PlatformUI.MIRTH_FRAME.channelEditPanel.getRequiredInboundDataType() == null || type != TransformerType.SOURCE) && (!updateDestinationInbound && ((Boolean)tableNode.getValueAt(SELECTION_COLUMN)).booleanValue() && type != TransformerType.DESTINATION || updateDestinationInbound && type == TransformerType.DESTINATION)) {
                DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                Transformer transformer = this.transformerContainer.get(tableNode.getContainerIndex()).getTransformer();
                tableNode.setValueAt(this.parent.dataTypeToDisplayName.get(dataType), INBOUND_COLUMN);
                transformer.setInboundDataType(dataType);
                transformer.setInboundProperties(defaultProperties);
            } else if (!updateDestinationInbound && ((Boolean)tableNode.getValueAt(SELECTION_COLUMN)).booleanValue() && type == TransformerType.DESTINATION) {
                updateSourceOutbound = true;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!this.updateInboundDataType(node.getChildAt(i), dataType, updateDestinationInbound)) continue;
            updateSourceOutbound = true;
        }
        return updateSourceOutbound;
    }

    private boolean updateOutboundDataType(TreeTableNode node, String dataType) {
        DataTypeConnectorTableNode tableNode;
        boolean updateDestinationInbound = false;
        if (node instanceof DataTypeConnectorTableNode && ((Boolean)(tableNode = (DataTypeConnectorTableNode)node).getValueAt(SELECTION_COLUMN)).booleanValue()) {
            DataTypeProperties defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
            Transformer transformer = this.transformerContainer.get(tableNode.getContainerIndex()).getTransformer();
            TransformerType type = this.transformerContainer.get(tableNode.getContainerIndex()).getType();
            tableNode.setValueAt(this.parent.dataTypeToDisplayName.get(dataType), OUTBOUND_COLUMN);
            transformer.setOutboundDataType(dataType);
            transformer.setOutboundProperties(defaultProperties);
            if (type == TransformerType.SOURCE) {
                updateDestinationInbound = true;
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            if (!this.updateOutboundDataType(node.getChildAt(i), dataType)) continue;
            updateDestinationInbound = true;
        }
        return updateDestinationInbound;
    }

    public void makeTables() {
        this.updateConnectorTreeTable();
        this.makeTreeTable(this.connectorTreeTable, this.connectorTreeTablePane);
    }

    public void makeTreeTable(MirthTreeTable table, JScrollPane scrollPane) {
        int dataTypeColumnWidth = 100;
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        table.setSelectionMode(0);
        Object[] dataTypes = new String[this.parent.dataTypeToDisplayName.values().size()];
        this.parent.dataTypeToDisplayName.values().toArray(dataTypes);
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (DataTypesDialog.this.editMode == EditMode.SINGLE && !e.getValueIsAdjusting()) {
                    if (DataTypesDialog.this.connectorTreeTable.getSelectedRow() != -1) {
                        DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)((Object)DataTypesDialog.this.connectorTreeTable.getPathForRow(DataTypesDialog.this.connectorTreeTable.getSelectedRow()).getLastPathComponent());
                        Transformer transformer = DataTypesDialog.this.transformerContainer.get(tableNode.getContainerIndex()).getTransformer();
                        TransformerType type = DataTypesDialog.this.transformerContainer.get(tableNode.getContainerIndex()).getType();
                        String inboundDataType = (String)tableNode.getValueAt(INBOUND_COLUMN);
                        String outboundDataType = (String)tableNode.getValueAt(OUTBOUND_COLUMN);
                        DataTypesDialog.this.inboundPropertiesPanel.setDataTypeProperties(inboundDataType, new DataTypePropertiesContainer(transformer.getInboundProperties(), type));
                        DataTypesDialog.this.inboundPropertiesPanel.getDataTypeComboBox().getModel().setSelectedItem(inboundDataType);
                        DataTypesDialog.this.inboundPropertiesPanel.getDataTypeComboBox().setEnabled(type != TransformerType.DESTINATION && (type != TransformerType.SOURCE || PlatformUI.MIRTH_FRAME.channelEditPanel.getRequiredInboundDataType() == null));
                        DataTypesDialog.this.outboundPropertiesPanel.setDataTypeProperties(outboundDataType, new DataTypePropertiesContainer(transformer.getOutboundProperties(), type));
                        DataTypesDialog.this.outboundPropertiesPanel.getDataTypeComboBox().getModel().setSelectedItem(outboundDataType);
                        DataTypesDialog.this.outboundPropertiesPanel.getDataTypeComboBox().setEnabled(type == TransformerType.DESTINATION || type == TransformerType.SOURCE && PlatformUI.MIRTH_FRAME.channelEditPanel.getRequiredOutboundDataType() == null);
                    } else {
                        DataTypePropertiesContainer propertiesContainer = null;
                        DataTypesDialog.this.inboundPropertiesPanel.setDataTypeProperties(null, propertiesContainer);
                        DataTypesDialog.this.outboundPropertiesPanel.setDataTypeProperties(null, propertiesContainer);
                    }
                }
            }
        });
        table.getColumnExt(INBOUND_COLUMN).setCellEditor((TableCellEditor)new MirthComboBoxTableCellEditor((JTable)((Object)table), dataTypes, 1, false, new DataTypeComboBoxActionListener(true)));
        table.getColumnExt(INBOUND_COLUMN).setCellRenderer((TableCellRenderer)new DataTypeCellRenderer(dataTypes));
        table.getColumnExt(OUTBOUND_COLUMN).setCellEditor((TableCellEditor)new MirthComboBoxTableCellEditor((JTable)((Object)table), dataTypes, 1, false, new DataTypeComboBoxActionListener(false)));
        table.getColumnExt(OUTBOUND_COLUMN).setCellRenderer((TableCellRenderer)new DataTypeCellRenderer(dataTypes));
        table.getColumnExt(SELECTION_COLUMN).setCellRenderer(new TableCellRenderer(){
            private JCheckBox checkBox = new JCheckBox();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                if (value instanceof Boolean) {
                    this.checkBox.setSelected((Boolean)value);
                }
                if (isSelected) {
                    this.checkBox.setForeground(table.getSelectionForeground());
                    this.checkBox.setBackground(table.getSelectionBackground());
                } else {
                    this.checkBox.setForeground(table.getForeground());
                    this.checkBox.setBackground(table.getBackground());
                }
                this.checkBox.setVerticalAlignment(0);
                this.checkBox.setHorizontalAlignment(0);
                return this.checkBox;
            }
        });
        table.getColumnExt(SELECTION_COLUMN).setCellEditor((TableCellEditor)new CheckBoxCellEditor());
        table.setRowHeight(20);
        table.setSortable(false);
        table.setOpaque(true);
        table.setDragEnabled(false);
        table.getTableHeader().setReorderingAllowed(false);
        table.setShowGrid(true, true);
        table.setLeafIcon(null);
        table.setOpenIcon(null);
        table.setClosedIcon(null);
        table.setAutoCreateColumnsFromModel(false);
        table.getColumnExt(SELECTION_COLUMN).setMaxWidth(SELECTION_COLUMN_WIDTH);
        table.getColumnExt(SELECTION_COLUMN).setMinWidth(SELECTION_COLUMN_WIDTH);
        table.getColumnExt(SELECTION_COLUMN).setResizable(false);
        table.getColumnExt(CONNECTOR_COLUMN).setMinWidth(75);
        table.getColumnExt(CONNECTOR_COLUMN).setResizable(false);
        table.getColumnExt(INBOUND_COLUMN).setMaxWidth(dataTypeColumnWidth);
        table.getColumnExt(INBOUND_COLUMN).setMinWidth(dataTypeColumnWidth);
        table.getColumnExt(INBOUND_COLUMN).setResizable(false);
        table.getColumnExt(OUTBOUND_COLUMN).setMaxWidth(dataTypeColumnWidth);
        table.getColumnExt(OUTBOUND_COLUMN).setMinWidth(dataTypeColumnWidth);
        table.getColumnExt(OUTBOUND_COLUMN).setResizable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            table.setHighlighters(new Highlighter[]{highlighter});
        }
        scrollPane.setViewportView((Component)((Object)table));
    }

    public void updateSingleDataType(DataTypeConnectorTableNode tableNode, String dataTypeDisplayName, boolean inbound) {
        block7: {
            Transformer transformer;
            TransformerContainer container;
            DataTypeProperties defaultProperties;
            String dataType;
            block6: {
                dataType = PlatformUI.MIRTH_FRAME.displayNameToDataType.get(dataTypeDisplayName);
                defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                container = this.transformerContainer.get(tableNode.getContainerIndex());
                transformer = container.getTransformer();
                if (!inbound) break block6;
                if (transformer.getInboundDataType().equals(dataType)) break block7;
                transformer.setInboundDataType(dataType);
                transformer.setInboundProperties(defaultProperties);
                tableNode.setValueAt(dataTypeDisplayName, INBOUND_COLUMN);
                this.inboundPropertiesPanel.getDataTypeComboBox().setSelectedItem(dataTypeDisplayName);
                this.inboundPropertiesPanel.setDataTypeProperties(dataTypeDisplayName, new DataTypePropertiesContainer(transformer.getInboundProperties(), container.getType()));
                break block7;
            }
            if (!transformer.getOutboundDataType().equals(dataType)) {
                transformer.setOutboundDataType(dataType);
                transformer.setOutboundProperties(defaultProperties);
                tableNode.setValueAt(dataTypeDisplayName, OUTBOUND_COLUMN);
                this.outboundPropertiesPanel.getDataTypeComboBox().setSelectedItem(dataTypeDisplayName);
                this.outboundPropertiesPanel.setDataTypeProperties(dataTypeDisplayName, new DataTypePropertiesContainer(transformer.getOutboundProperties(), container.getType()));
            }
            if (container.getType() == TransformerType.SOURCE) {
                TreeTableNode root = (TreeTableNode)this.connectorTreeTable.getTreeTableModel().getRoot();
                for (int i = 0; i < root.getChildCount(); ++i) {
                    DataTypeConnectorTableNode node;
                    TransformerContainer childContainer;
                    if (!(root.getChildAt(i) instanceof DataTypeConnectorTableNode) || (childContainer = this.transformerContainer.get((node = (DataTypeConnectorTableNode)root.getChildAt(i)).getContainerIndex())).getType() != TransformerType.DESTINATION) continue;
                    defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                    node.setValueAt(dataTypeDisplayName, INBOUND_COLUMN);
                    transformer = childContainer.getTransformer();
                    transformer.setInboundDataType(dataType);
                    transformer.setInboundProperties(defaultProperties);
                }
            } else if (container.getType() == TransformerType.DESTINATION) {
                for (int i = 0; i < tableNode.getChildCount(); ++i) {
                    DataTypeConnectorTableNode node;
                    TransformerContainer childContainer;
                    if (!(tableNode.getChildAt(i) instanceof DataTypeConnectorTableNode) || (childContainer = this.transformerContainer.get((node = (DataTypeConnectorTableNode)tableNode.getChildAt(i)).getContainerIndex())).getType() != TransformerType.RESPONSE) continue;
                    transformer = childContainer.getTransformer();
                    defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                    node.setValueAt(dataTypeDisplayName, INBOUND_COLUMN);
                    transformer.setInboundDataType(dataType);
                    transformer.setInboundProperties(defaultProperties);
                    defaultProperties = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getDefaultProperties();
                    node.setValueAt(dataTypeDisplayName, OUTBOUND_COLUMN);
                    transformer.setOutboundDataType(dataType);
                    transformer.setOutboundProperties(defaultProperties);
                }
            }
        }
    }

    public void updateConnectorTreeTable() {
        Object[][] tableData = null;
        HashSet<Integer> destinations = new HashSet<Integer>();
        int containerIndex = 0;
        Channel currentChannel = this.parent.channelEditPanel.currentChannel;
        DataTypeConnectorTableModel tableModel = new DataTypeConnectorTableModel();
        tableModel.setColumnIdentifiers(Arrays.asList(this.columnNames));
        Connector sourceConnector = currentChannel.getSourceConnector();
        Transformer transformer = sourceConnector.getTransformer();
        this.transformerContainer.put(containerIndex, new TransformerContainer(transformer, TransformerType.SOURCE, transformer.getInboundDataType(), transformer.getOutboundDataType(), transformer.getInboundProperties().clone(), transformer.getOutboundProperties().clone()));
        tableData = new Object[1][this.columnNames.length];
        tableData[0][DataTypesDialog.SELECTION_COLUMN] = false;
        tableData[0][DataTypesDialog.CONNECTOR_COLUMN] = "Source Connector";
        tableData[0][DataTypesDialog.INBOUND_COLUMN] = this.parent.dataTypeToDisplayName.get(sourceConnector.getTransformer().getInboundDataType());
        tableData[0][DataTypesDialog.OUTBOUND_COLUMN] = this.parent.dataTypeToDisplayName.get(sourceConnector.getTransformer().getOutboundDataType());
        tableModel.addConnector(containerIndex++, tableData);
        for (Connector destinationConnector : currentChannel.getDestinationConnectors()) {
            tableData = new Object[2][this.columnNames.length];
            transformer = destinationConnector.getTransformer();
            destinations.add(containerIndex);
            this.transformerContainer.put(containerIndex, new TransformerContainer(transformer, TransformerType.DESTINATION, transformer.getInboundDataType(), transformer.getOutboundDataType(), transformer.getInboundProperties().clone(), transformer.getOutboundProperties().clone()));
            tableData[0][DataTypesDialog.SELECTION_COLUMN] = false;
            tableData[0][DataTypesDialog.CONNECTOR_COLUMN] = destinationConnector.getName();
            tableData[0][DataTypesDialog.INBOUND_COLUMN] = this.parent.dataTypeToDisplayName.get(currentChannel.getSourceConnector().getTransformer().getOutboundDataType());
            tableData[0][DataTypesDialog.OUTBOUND_COLUMN] = this.parent.dataTypeToDisplayName.get(destinationConnector.getTransformer().getOutboundDataType());
            transformer = destinationConnector.getResponseTransformer();
            this.transformerContainer.put(containerIndex + 1, new TransformerContainer(transformer, TransformerType.RESPONSE, transformer.getInboundDataType(), transformer.getOutboundDataType(), transformer.getInboundProperties().clone(), transformer.getOutboundProperties().clone()));
            tableData[1][DataTypesDialog.SELECTION_COLUMN] = false;
            tableData[1][DataTypesDialog.CONNECTOR_COLUMN] = "Response";
            tableData[1][DataTypesDialog.INBOUND_COLUMN] = this.parent.dataTypeToDisplayName.get(destinationConnector.getResponseTransformer().getInboundDataType());
            tableData[1][DataTypesDialog.OUTBOUND_COLUMN] = this.parent.dataTypeToDisplayName.get(destinationConnector.getResponseTransformer().getOutboundDataType());
            tableModel.addConnector(containerIndex, tableData);
            containerIndex += 2;
        }
        tableModel.setDestinations(destinations);
        this.connectorTreeTable.setTreeTableModel((TreeTableModel)tableModel);
    }

    private void revertProperties() {
        for (TransformerContainer container : this.transformerContainer.values()) {
            Transformer transformer = container.getTransformer();
            transformer.setInboundDataType(container.getLastInboundDataType());
            transformer.setInboundProperties(container.getLastInboundDataTypeProperties());
            transformer.setOutboundDataType(container.getLastOutboundDataType());
            transformer.setOutboundProperties(container.getLastOutboundDataTypeProperties());
        }
    }

    private void revertProperties(TreeTableNode node) {
        if (node == null) {
            node = (TreeTableNode)this.connectorTreeTable.getTreeTableModel().getRoot();
        }
        if (node instanceof DataTypeConnectorTableNode) {
            DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)node;
            TransformerContainer container = this.transformerContainer.get(tableNode.getContainerIndex());
            Transformer transformer = container.getTransformer();
            transformer.setInboundDataType(container.getLastInboundDataType());
            transformer.setInboundProperties(container.getLastInboundDataTypeProperties());
            transformer.setOutboundDataType(container.getLastOutboundDataType());
            transformer.setOutboundProperties(container.getLastOutboundDataTypeProperties());
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.revertProperties(node.getChildAt(i));
        }
    }

    private void toggleSelection(Set<TransformerType> types, boolean select) {
        TreeTableNode root = (TreeTableNode)this.connectorTreeTable.getTreeTableModel().getRoot();
        this.toggleSelection(types, select, root);
        if (types.contains((Object)TransformerType.RESPONSE) && select) {
            this.connectorTreeTable.expandAll();
        }
        this.updateBulkSelection();
        this.connectorTreeTable.repaint();
    }

    private void toggleSelection(Set<TransformerType> types, boolean select, TreeTableNode node) {
        DataTypeConnectorTableNode tableNode;
        TransformerContainer container;
        if (node instanceof DataTypeConnectorTableNode && types.contains((Object)(container = this.transformerContainer.get((tableNode = (DataTypeConnectorTableNode)node).getContainerIndex())).getType())) {
            tableNode.setValueAt(select, SELECTION_COLUMN);
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.toggleSelection(types, select, node.getChildAt(i));
        }
    }

    private void updateBulkSelection() {
        TreeTableNode root = (TreeTableNode)this.connectorTreeTable.getTreeTableModel().getRoot();
        HashMap<MirthTriStateCheckBox, Integer> status = new HashMap<MirthTriStateCheckBox, Integer>();
        ArrayList<Integer> containerIds = new ArrayList<Integer>();
        this.updateSelectionStatus(root, status, containerIds);
        for (Map.Entry entry : status.entrySet()) {
            ((MirthTriStateCheckBox)entry.getKey()).setState((Integer)entry.getValue());
        }
        ArrayList<DataTypePropertiesContainer> inboundPropertiesList = null;
        ArrayList<DataTypePropertiesContainer> outboundPropertiesList = null;
        String inboundDataType = null;
        String inboundDataTypeDisplayName = null;
        String outboundDataType = null;
        String outboundDataTypeDisplayName = null;
        if (containerIds.isEmpty()) {
            this.inboundPropertiesPanel.getDataTypeComboBox().setSelectedIndex(-1);
            this.outboundPropertiesPanel.getDataTypeComboBox().setSelectedIndex(-1);
            this.inboundPropertiesPanel.getDataTypeComboBox().setEnabled(false);
            this.outboundPropertiesPanel.getDataTypeComboBox().setEnabled(false);
        } else {
            this.inboundPropertiesPanel.getDataTypeComboBox().setEnabled(true);
            this.outboundPropertiesPanel.getDataTypeComboBox().setEnabled(true);
            inboundPropertiesList = new ArrayList<DataTypePropertiesContainer>();
            outboundPropertiesList = new ArrayList<DataTypePropertiesContainer>();
            Iterator iterator = containerIds.iterator();
            while (iterator.hasNext()) {
                int containerId = (Integer)iterator.next();
                TransformerContainer container = this.transformerContainer.get(containerId);
                if (inboundPropertiesList != null) {
                    inboundPropertiesList.add(new DataTypePropertiesContainer(container.getTransformer().getInboundProperties(), container.getType()));
                    if (inboundDataType == null) {
                        inboundDataType = container.getTransformer().getInboundDataType();
                        inboundDataTypeDisplayName = this.parent.dataTypeToDisplayName.get(inboundDataType);
                    } else if (!inboundDataType.equals(container.getTransformer().getInboundDataType())) {
                        this.inboundPropertiesPanel.getDataTypeComboBox().getModel().setSelectedItem("<Different Data Types>");
                        inboundDataTypeDisplayName = null;
                        inboundPropertiesList = null;
                    }
                }
                if (outboundPropertiesList == null) continue;
                outboundPropertiesList.add(new DataTypePropertiesContainer(container.getTransformer().getOutboundProperties(), container.getType()));
                if (outboundDataType == null) {
                    outboundDataType = container.getTransformer().getOutboundDataType();
                    outboundDataTypeDisplayName = this.parent.dataTypeToDisplayName.get(outboundDataType);
                    continue;
                }
                if (outboundDataType.equals(container.getTransformer().getOutboundDataType())) continue;
                this.outboundPropertiesPanel.getDataTypeComboBox().getModel().setSelectedItem("<Different Data Types>");
                outboundDataTypeDisplayName = null;
                outboundPropertiesList = null;
            }
            if (inboundDataTypeDisplayName != null) {
                this.inboundPropertiesPanel.getDataTypeComboBox().setSelectedItem(inboundDataTypeDisplayName);
            }
            if (outboundDataTypeDisplayName != null) {
                this.outboundPropertiesPanel.getDataTypeComboBox().setSelectedItem(outboundDataTypeDisplayName);
            }
        }
        this.inboundPropertiesPanel.setDataTypeProperties(inboundDataTypeDisplayName, inboundPropertiesList);
        this.outboundPropertiesPanel.setDataTypeProperties(outboundDataTypeDisplayName, outboundPropertiesList);
    }

    private void updateSelectionStatus(TreeTableNode node, Map<MirthTriStateCheckBox, Integer> status, List<Integer> containerIds) {
        if (node instanceof DataTypeConnectorTableNode) {
            int state;
            DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)node;
            TransformerContainer container = this.transformerContainer.get(tableNode.getContainerIndex());
            boolean selected = (Boolean)tableNode.getValueAt(SELECTION_COLUMN);
            int n = state = selected ? 0 : 1;
            if (selected) {
                containerIds.add(tableNode.getContainerIndex());
            }
            if (!status.containsKey(this.allCheckBox)) {
                status.put(this.allCheckBox, state);
            } else if (status.get(this.allCheckBox) != 2 && status.get(this.allCheckBox) != state) {
                status.put(this.allCheckBox, 2);
            }
            if (container.getType() == TransformerType.DESTINATION) {
                if (!status.containsKey(this.destinationsCheckBox)) {
                    status.put(this.destinationsCheckBox, state);
                } else if (status.get(this.destinationsCheckBox) != 2 && status.get(this.destinationsCheckBox) != state) {
                    status.put(this.destinationsCheckBox, 2);
                }
            }
            if (container.getType() == TransformerType.RESPONSE) {
                if (!status.containsKey(this.responsesCheckBox)) {
                    status.put(this.responsesCheckBox, state);
                } else if (status.get(this.responsesCheckBox) != 2 && status.get(this.responsesCheckBox) != state) {
                    status.put(this.responsesCheckBox, 2);
                }
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            this.updateSelectionStatus(node.getChildAt(i), status, containerIds);
        }
    }

    @Override
    public void onCloseAction() {
        this.revertProperties();
    }

    private void initComponents() {
        this.editingGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.closeButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jPanel5 = new JPanel();
        this.inboundPropertiesPanel = new DataTypePropertiesPanel();
        this.outboundPropertiesPanel = new DataTypePropertiesPanel();
        this.singleEditButton = new JRadioButton();
        this.bulkEditButton = new JRadioButton();
        this.connectorTreeTablePane = new JScrollPane();
        this.connectorTreeTable = new MirthTreeTable();
        this.allCheckBox = new MirthTriStateCheckBox();
        this.destinationsCheckBox = new MirthTriStateCheckBox();
        this.responsesCheckBox = new MirthTriStateCheckBox();
        this.expandLabel = new JLabel();
        this.collapseLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Set Data Types");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jPanel1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.okButton.setText("OK");
        this.okButton.setMargin(new Insets(0, 2, 0, 2));
        this.okButton.setMaximumSize(new Dimension(48, 21));
        this.okButton.setMinimumSize(new Dimension(48, 21));
        this.okButton.setPreferredSize(new Dimension(48, 21));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypesDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.closeButton.setText("Cancel");
        this.closeButton.setMargin(new Insets(0, 2, 0, 2));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypesDialog.this.closeButtonActionPerformed(evt);
            }
        });
        this.jPanel5.setBackground(new Color(255, 255, 255));
        this.jPanel5.setLayout(new GridLayout(0, 2));
        this.jPanel5.add(this.inboundPropertiesPanel);
        this.jPanel5.add(this.outboundPropertiesPanel);
        this.singleEditButton.setBackground(new Color(255, 255, 255));
        this.editingGroup.add(this.singleEditButton);
        this.singleEditButton.setSelected(true);
        this.singleEditButton.setText("Single Edit");
        this.singleEditButton.setFocusable(false);
        this.singleEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypesDialog.this.singleEditButtonActionPerformed(evt);
            }
        });
        this.bulkEditButton.setBackground(new Color(255, 255, 255));
        this.editingGroup.add(this.bulkEditButton);
        this.bulkEditButton.setText("Bulk Edit");
        this.bulkEditButton.setFocusable(false);
        this.bulkEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypesDialog.this.bulkEditButtonActionPerformed(evt);
            }
        });
        this.connectorTreeTablePane.setVerticalScrollBarPolicy(22);
        this.connectorTreeTablePane.setViewportView((Component)((Object)this.connectorTreeTable));
        this.allCheckBox.setBackground(new Color(255, 255, 255));
        this.allCheckBox.setText("All");
        this.allCheckBox.setFocusable(false);
        this.allCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypesDialog.this.allCheckBoxActionPerformed(evt);
            }
        });
        this.destinationsCheckBox.setBackground(new Color(255, 255, 255));
        this.destinationsCheckBox.setText("Destinations");
        this.destinationsCheckBox.setFocusable(false);
        this.destinationsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypesDialog.this.destinationsCheckBoxActionPerformed(evt);
            }
        });
        this.responsesCheckBox.setBackground(new Color(255, 255, 255));
        this.responsesCheckBox.setText("Responses");
        this.responsesCheckBox.setFocusable(false);
        this.responsesCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DataTypesDialog.this.responsesCheckBoxActionPerformed(evt);
            }
        });
        this.expandLabel.setForeground(Color.blue);
        this.expandLabel.setText("<html><u>Expand All</u></html>");
        this.expandLabel.setCursor(new Cursor(12));
        this.expandLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataTypesDialog.this.expandLabelMouseReleased(evt);
            }
        });
        this.collapseLabel.setForeground(Color.blue);
        this.collapseLabel.setText("<html><u>Collapse All</u></html>");
        this.collapseLabel.setCursor(new Cursor(12));
        this.collapseLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                DataTypesDialog.this.collapseLabelMouseReleased(evt);
            }
        });
        this.jLabel1.setText("|");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel5, GroupLayout.Alignment.TRAILING, -1, 814, Short.MAX_VALUE).addComponent(this.jSeparator1, GroupLayout.Alignment.TRAILING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.closeButton)).addComponent(this.connectorTreeTablePane).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.singleEditButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bulkEditButton).addGap(18, 18, 18).addComponent(this.allCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.destinationsCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.responsesCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 324, Short.MAX_VALUE).addComponent(this.expandLabel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.collapseLabel, -2, -1, -2))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.closeButton, this.okButton);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.expandLabel, -2, -1, -2).addComponent(this.collapseLabel, -2, -1, -2).addComponent(this.destinationsCheckBox, -2, -1, -2).addComponent(this.allCheckBox, -2, -1, -2).addComponent(this.responsesCheckBox, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.singleEditButton).addComponent(this.bulkEditButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectorTreeTablePane, -1, 145, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel5, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.closeButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(1, this.closeButton, this.okButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void closeButtonActionPerformed(ActionEvent evt) {
        this.revertProperties();
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        for (TransformerContainer container : this.transformerContainer.values()) {
            Transformer transformer = container.getTransformer();
            if (transformer.getInboundDataType().equals(container.getLastInboundDataType()) && transformer.getInboundProperties().equals((Object)container.getLastInboundDataTypeProperties()) && transformer.getOutboundDataType().equals(container.getLastOutboundDataType()) && transformer.getOutboundProperties().equals((Object)container.getLastOutboundDataTypeProperties())) continue;
            this.parent.setSaveEnabled(true);
        }
        this.dispose();
    }

    private void expandLabelMouseReleased(MouseEvent evt) {
        this.connectorTreeTable.expandAll();
    }

    private void collapseLabelMouseReleased(MouseEvent evt) {
        this.connectorTreeTable.collapseAll();
    }

    private void allCheckBoxActionPerformed(ActionEvent evt) {
        MirthTriStateCheckBox checkBox = (MirthTriStateCheckBox)evt.getSource();
        HashSet<TransformerType> types = new HashSet<TransformerType>();
        types.add(TransformerType.SOURCE);
        types.add(TransformerType.DESTINATION);
        types.add(TransformerType.RESPONSE);
        this.toggleSelection(types, checkBox.getState() == 0);
    }

    private void destinationsCheckBoxActionPerformed(ActionEvent evt) {
        MirthTriStateCheckBox checkBox = (MirthTriStateCheckBox)evt.getSource();
        HashSet<TransformerType> types = new HashSet<TransformerType>();
        types.add(TransformerType.DESTINATION);
        this.toggleSelection(types, checkBox.getState() == 0);
    }

    private void responsesCheckBoxActionPerformed(ActionEvent evt) {
        MirthTriStateCheckBox checkBox = (MirthTriStateCheckBox)evt.getSource();
        HashSet<TransformerType> types = new HashSet<TransformerType>();
        types.add(TransformerType.RESPONSE);
        this.toggleSelection(types, checkBox.getState() == 0);
    }

    private void singleEditButtonActionPerformed(ActionEvent evt) {
        this.toggleEditMode(EditMode.SINGLE);
    }

    private void bulkEditButtonActionPerformed(ActionEvent evt) {
        this.toggleEditMode(EditMode.BULK);
    }

    private static enum EditMode {
        SINGLE,
        BULK;

    }

    private class TransformerContainer {
        private Transformer transformer;
        private TransformerType type;
        private String lastInboundDataType;
        private String lastOutboundDataType;
        private DataTypeProperties lastInboundDataTypeProperties;
        private DataTypeProperties lastOutboundDataTypeProperties;

        public TransformerContainer(Transformer transformer, TransformerType type, String lastInboundDataType, String lastOutboundDataType, DataTypeProperties lastInboundDataTypeProperties, DataTypeProperties lastOutboundDataTypeProperties) {
            this.transformer = transformer;
            this.type = type;
            this.lastInboundDataType = lastInboundDataType;
            this.lastOutboundDataType = lastOutboundDataType;
            this.lastInboundDataTypeProperties = lastInboundDataTypeProperties;
            this.lastOutboundDataTypeProperties = lastOutboundDataTypeProperties;
        }

        public Transformer getTransformer() {
            return this.transformer;
        }

        public TransformerType getType() {
            return this.type;
        }

        public String getLastInboundDataType() {
            return this.lastInboundDataType;
        }

        public String getLastOutboundDataType() {
            return this.lastOutboundDataType;
        }

        public DataTypeProperties getLastInboundDataTypeProperties() {
            return this.lastInboundDataTypeProperties;
        }

        public DataTypeProperties getLastOutboundDataTypeProperties() {
            return this.lastOutboundDataTypeProperties;
        }
    }

    private class DataTypeComboBoxActionListener
    implements ActionListener {
        private boolean inbound;

        public DataTypeComboBoxActionListener(boolean inbound) {
            this.inbound = inbound;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox comboBox = (JComboBox)e.getSource();
            if (comboBox.isPopupVisible()) {
                DataTypeConnectorTableNode tableNode = (DataTypeConnectorTableNode)((Object)DataTypesDialog.this.connectorTreeTable.getPathForRow(DataTypesDialog.this.connectorTreeTable.getEditingRow()).getLastPathComponent());
                String dataTypeDisplayName = (String)comboBox.getSelectedItem();
                DataTypesDialog.this.updateSingleDataType(tableNode, dataTypeDisplayName, this.inbound);
            }
        }
    }

    private class DataTypeCellRenderer
    extends MirthComboBoxTableCellRenderer {
        private JLabel label;

        public DataTypeCellRenderer(Object[] items) {
            super(items);
            this.label = new JLabel();
            this.label.setOpaque(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (value != null && !table.isCellEditable(row, column)) {
                if (isSelected) {
                    this.label.setForeground(table.getSelectionForeground());
                    this.label.setBackground(table.getSelectionBackground());
                } else {
                    this.label.setForeground(table.getForeground());
                    this.label.setBackground(table.getBackground());
                }
                this.label.setText(" " + value.toString());
                return this.label;
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }

    private class CheckBoxCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JCheckBox checkBox = new JCheckBox();

        public CheckBoxCellEditor() {
            this.checkBox.setVerticalAlignment(0);
            this.checkBox.setHorizontalAlignment(0);
            this.checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    CheckBoxCellEditor.this.fireEditingStopped();
                    DataTypesDialog.this.updateBulkSelection();
                }
            });
        }

        @Override
        public Object getCellEditorValue() {
            return this.checkBox.isSelected();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            if (value != null && value instanceof Boolean) {
                this.checkBox.setSelected((Boolean)value);
            }
            this.checkBox.setForeground(table.getSelectionForeground());
            this.checkBox.setBackground(table.getSelectionBackground());
            return this.checkBox;
        }
    }
}

