/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.Channel;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.prefs.Preferences;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.text.StringEscapeUtils;

public class ExportChannelLibrariesDialog
extends MirthDialog {
    private int result = -1;
    private JLabel label1;
    private JTextPane librariesTextPane;
    private JScrollPane librariesScrollPane;
    private JLabel label2;
    private JCheckBox alwaysChooseCheckBox;
    private JButton yesButton;
    private JButton noButton;
    private JButton cancelButton;

    public ExportChannelLibrariesDialog(Channel channel) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.initComponents(channel);
        this.initLayout();
        this.setMaximumSize(new Dimension(800, 600));
        this.setDefaultCloseOperation(2);
        this.setTitle("Select an Option");
        this.pack();
        this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
        this.yesButton.requestFocus();
        this.setVisible(true);
    }

    public int getResult() {
        return this.result;
    }

    private void initComponents(Channel channel) {
        this.label1 = new JLabel("   The following code template libraries are linked to this channel:");
        this.label1.setIcon(UIManager.getIcon("OptionPane.questionIcon"));
        this.librariesTextPane = new JTextPane();
        this.librariesTextPane.setContentType("text/html");
        HTMLEditorKit editorKit = new HTMLEditorKit();
        StyleSheet styleSheet = editorKit.getStyleSheet();
        styleSheet.addRule(".export-channel-libraries-dialog {font-family:\"Tahoma\";font-size:11;text-align:top}");
        this.librariesTextPane.setEditorKit(editorKit);
        this.librariesTextPane.setEditable(false);
        this.librariesTextPane.setBackground(this.getBackground());
        this.librariesTextPane.setBorder(null);
        StringBuilder librariesText = new StringBuilder("<html><ul class=\"export-channel-libraries-dialog\">");
        for (CodeTemplateLibrary library : PlatformUI.MIRTH_FRAME.codeTemplatePanel.getCachedCodeTemplateLibraries().values()) {
            if (!library.getEnabledChannelIds().contains(channel.getId()) && (!library.isIncludeNewChannels() || library.getDisabledChannelIds().contains(channel.getId()))) continue;
            librariesText.append("<li>").append(StringEscapeUtils.escapeHtml4((String)library.getName())).append("</li>");
        }
        librariesText.append("</ul></html>");
        this.librariesTextPane.setText(librariesText.toString());
        this.librariesTextPane.setCaretPosition(0);
        this.librariesScrollPane = new JScrollPane(this.librariesTextPane);
        this.label2 = new JLabel("Do you wish to include these libraries in the channel export?");
        this.alwaysChooseCheckBox = new JCheckBox("Always choose this option by default in the future (may be changed in the Administrator settings)");
        this.yesButton = new JButton("Yes");
        this.yesButton.setMnemonic('Y');
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportChannelLibrariesDialog.this.result = 0;
                if (ExportChannelLibrariesDialog.this.alwaysChooseCheckBox.isSelected()) {
                    Preferences.userNodeForPackage(Mirth.class).putBoolean("exportChannelCodeTemplateLibraries", true);
                }
                ExportChannelLibrariesDialog.this.dispose();
            }
        });
        this.noButton = new JButton("No");
        this.noButton.setMnemonic('N');
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportChannelLibrariesDialog.this.result = 1;
                if (ExportChannelLibrariesDialog.this.alwaysChooseCheckBox.isSelected()) {
                    Preferences.userNodeForPackage(Mirth.class).putBoolean("exportChannelCodeTemplateLibraries", false);
                }
                ExportChannelLibrariesDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setMnemonic('C');
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ExportChannelLibrariesDialog.this.result = 2;
                ExportChannelLibrariesDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 10"));
        this.add(this.label1);
        this.add((Component)this.librariesScrollPane, "newline, grow, push");
        this.add((Component)this.label2, "newline");
        this.add((Component)this.alwaysChooseCheckBox, "newline");
        this.add((Component)this.yesButton, "newline, center, split 3, w 75!, h 24!");
        this.add((Component)this.noButton, "gapbefore 6, w 75!, h 24!");
        this.add((Component)this.cancelButton, "gapbefore 6, w 75!, h 24!");
    }
}

