/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.util.DisplayUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.syntax.jedit.JEditTextArea;

public class FindRplDialog
extends MirthDialog {
    static MyOwnFocusTraversalPolicy tabPolicy;
    private Frame parent;
    private JButton button_close;
    private JButton button_find;
    private JButton button_replace;
    private JButton button_replaceAll;
    private JCheckBox checkBox_matchCase;
    private JCheckBox checkBox_regularExpression;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField textField_find;
    private JTextField textField_replaceWith;
    JEditTextArea search_text;

    public FindRplDialog(java.awt.Frame parent, boolean modal, JEditTextArea textarea) {
        super((Window)parent, modal);
        this.initialize(textarea);
    }

    public FindRplDialog(Dialog parent, boolean modal, JEditTextArea textarea) {
        super((Window)parent, modal);
        this.initialize(textarea);
    }

    private void initialize(JEditTextArea textarea) {
        this.initComponents();
        DisplayUtil.setResizable(this, false);
        this.parent = PlatformUI.MIRTH_FRAME;
        this.search_text = textarea;
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        if (this.search_text.isEditable()) {
            this.enableReplace();
        } else {
            this.disableReplace();
        }
        this.textField_find.setText(this.search_text.getSelectedText());
        Vector<Component> order = new Vector<Component>(8);
        order.add(this.textField_find);
        order.add(this.textField_replaceWith);
        order.add(this.button_find);
        order.add(this.button_replace);
        order.add(this.button_replaceAll);
        order.add(this.button_close);
        order.add(this.checkBox_regularExpression);
        order.add(this.checkBox_matchCase);
        tabPolicy = new MyOwnFocusTraversalPolicy(order);
        this.setFocusTraversalPolicy(tabPolicy);
        this.textField_find.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    FindRplDialog.this.find(true);
                } else if (e.getKeyCode() == 27) {
                    FindRplDialog.this.exit();
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
    }

    void exit() {
        this.setVisible(false);
    }

    void replaceAll() {
        if (this.search_text.isEditable()) {
            boolean anyRemaining = true;
            this.search_text.select(0, 0);
            int min = Integer.MIN_VALUE;
            while (anyRemaining) {
                this.find(false);
                int start = this.search_text.getSelectionStart();
                int end2 = this.search_text.getSelectionEnd();
                if (start < end2) {
                    this.search_text.setSelectedText(this.textField_replaceWith.getText());
                } else {
                    anyRemaining = false;
                }
                if (start <= min) break;
                min = start;
            }
        }
    }

    void replace() {
        if (this.search_text.isEditable()) {
            if (this.search_text.getSelectedText() == null) {
                this.find(true);
            } else {
                int end2;
                int start = this.search_text.getSelectionStart();
                if (start < (end2 = this.search_text.getSelectionEnd())) {
                    this.search_text.setSelectedText(this.textField_replaceWith.getText());
                }
            }
        }
    }

    void find(boolean wrapSearch) {
        String text = this.search_text.getText();
        String search = this.textField_find.getText();
        if (!this.checkBox_matchCase.isSelected()) {
            text = text.toLowerCase();
            search = search.toLowerCase();
        }
        if (this.checkBox_regularExpression.isSelected()) {
            Pattern p = Pattern.compile(search);
            Matcher m = p.matcher(text);
            if (m.find(this.search_text.getSelectionEnd())) {
                int position = m.start();
                String group = m.group();
                if (position > -1) {
                    this.search_text.select(position, position + group.length());
                }
            } else if (m.find(0)) {
                int position = m.start();
                String group = m.group();
                if (position > -1) {
                    this.search_text.select(position, position + group.length());
                }
            }
        } else {
            int position = text.indexOf(search, this.search_text.getSelectionEnd());
            if (position > -1) {
                this.search_text.select(position, position + search.length());
            } else if (wrapSearch && (position = text.indexOf(search, 0)) > -1) {
                this.search_text.select(position, position + search.length());
            }
        }
    }

    void disableReplace() {
        this.button_replace.setVisible(false);
        this.button_replaceAll.setVisible(false);
    }

    void enableReplace() {
        this.button_replace.setVisible(true);
        this.button_replaceAll.setVisible(true);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.button_find = new JButton();
        this.button_replace = new JButton();
        this.button_replaceAll = new JButton();
        this.button_close = new JButton();
        this.checkBox_regularExpression = new JCheckBox();
        this.checkBox_matchCase = new JCheckBox();
        this.textField_find = new JTextField();
        this.textField_replaceWith = new JTextField();
        this.setDefaultCloseOperation(2);
        this.setTitle("Find Replace");
        this.jLabel1.setText("Find text:");
        this.jLabel2.setText("Replace with:");
        this.button_find.setText("Find");
        this.button_find.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindRplDialog.this.button_findActionPerformed(evt);
            }
        });
        this.button_replace.setText("Replace");
        this.button_replace.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindRplDialog.this.button_replaceActionPerformed(evt);
            }
        });
        this.button_replaceAll.setText("Replace All");
        this.button_replaceAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindRplDialog.this.button_replaceAllActionPerformed(evt);
            }
        });
        this.button_close.setText("Close");
        this.button_close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FindRplDialog.this.button_closeActionPerformed(evt);
            }
        });
        this.checkBox_regularExpression.setText("Regular Expression");
        this.checkBox_matchCase.setText("Match Case");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.textField_replaceWith, -1, 135, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.checkBox_regularExpression).addGap(18, 18, 18)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.checkBox_matchCase).addGap(54, 54, 54)).addComponent(this.textField_find, GroupLayout.Alignment.LEADING, -1, 135, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.button_replace, -1, -1, Short.MAX_VALUE).addComponent(this.button_find, -1, -1, Short.MAX_VALUE)).addComponent(this.button_replaceAll)).addComponent(this.button_close, -2, 85, -2)).addContainerGap()));
        layout.linkSize(0, this.button_close, this.button_find, this.button_replace, this.button_replaceAll);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.button_find).addComponent(this.textField_find, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.button_replace).addComponent(this.textField_replaceWith, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.checkBox_regularExpression, -1, -1, Short.MAX_VALUE).addComponent(this.button_replaceAll, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.button_close).addComponent(this.checkBox_matchCase, -2, 15, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void button_findActionPerformed(ActionEvent evt) {
        this.find(true);
    }

    private void button_replaceActionPerformed(ActionEvent evt) {
        this.replace();
    }

    private void button_replaceAllActionPerformed(ActionEvent evt) {
        this.replaceAll();
    }

    private void button_closeActionPerformed(ActionEvent evt) {
        this.exit();
    }

    public static class MyOwnFocusTraversalPolicy
    extends FocusTraversalPolicy {
        Vector<Component> order;

        public MyOwnFocusTraversalPolicy(Vector<Component> order) {
            this.order = new Vector(order.size());
            this.order.addAll(order);
        }

        @Override
        public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
            int idx = (this.order.indexOf(aComponent) + 1) % this.order.size();
            return this.order.get(idx);
        }

        @Override
        public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
            int idx = this.order.indexOf(aComponent) - 1;
            if (idx < 0) {
                idx = this.order.size() - 1;
            }
            return this.order.get(idx);
        }

        @Override
        public Component getDefaultComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }

        @Override
        public Component getLastComponent(Container focusCycleRoot) {
            return this.order.lastElement();
        }

        @Override
        public Component getFirstComponent(Container focusCycleRoot) {
            return this.order.get(0);
        }
    }
}

