/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.ScriptPanel;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JPanel;

public class GlobalScriptsPanel
extends JPanel {
    Frame parent = PlatformUI.MIRTH_FRAME;
    private ScriptPanel scriptPanel;

    public GlobalScriptsPanel() {
        this.initComponents();
    }

    public void edit() {
        try {
            this.scriptPanel.setScripts(this.parent.mirthClient.getGlobalScripts());
        }
        catch (ClientException e) {
            this.parent.alertThrowable(this, e);
        }
    }

    public void validateCurrentScript() {
        this.scriptPanel.validateCurrentScript();
    }

    public String validateAllScripts() {
        Object errors = "";
        for (Map.Entry<String, String> entry : this.scriptPanel.getScripts().entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            String validationMessage = this.scriptPanel.validateScript(value);
            if (validationMessage == null) continue;
            errors = (String)errors + "Error in global script \"" + key + "\":\n" + validationMessage + "\n\n";
        }
        if (((String)errors).equals("")) {
            errors = null;
        }
        return errors;
    }

    public void importAllScripts(Map<String, String> scripts) {
        this.scriptPanel.setScripts(scripts);
        this.parent.setSaveEnabled(true);
    }

    public Map<String, String> exportAllScripts() {
        return this.scriptPanel.getScripts();
    }

    public void save() {
        try {
            this.parent.mirthClient.setGlobalScripts(this.scriptPanel.getScripts());
        }
        catch (ClientException e) {
            this.parent.alertThrowable(this, e);
        }
    }

    private void initComponents() {
        this.scriptPanel = new ScriptPanel(true);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scriptPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scriptPanel, -1, 418, Short.MAX_VALUE));
    }
}

