/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.model.LicenseInfo;
import java.awt.Component;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jetty.util.StringUtil;

public class LicenseClient {
    private static Timer timer;
    private static boolean isLicenseExpired;

    public static void start() {
        LicenseClient.stop();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                Thread.currentThread().setName("daily pop-up warning/error messages");
                LicenseClient.check();
            }
        };
        timer = new Timer(true);
        timer.scheduleAtFixedRate(task, 0L, 86400000L);
    }

    public static void stop() {
        if (timer != null) {
            timer.cancel();
        }
    }

    private static void check() {
        try {
            LicenseInfo licenseInfo = PlatformUI.MIRTH_FRAME.mirthClient.getLicenseInfo();
            String property = PlatformUI.MIRTH_FRAME.mirthClient.getProperty("padlock", "padlockMessage");
            ZonedDateTime now = ZonedDateTime.ofInstant(Instant.now(), ZoneId.systemDefault());
            StringBuilder errorBuilder = new StringBuilder("<html> ");
            StringBuilder warningBuilder = new StringBuilder("<html> ");
            boolean invalidLicense = false;
            if (licenseInfo.getErrorReason() != null) {
                invalidLicense = true;
                if (!licenseInfo.isPadlock()) {
                    errorBuilder.append(licenseInfo.getErrorReason().replace("\n", "<br/>")).append("<br/>");
                }
            }
            if (licenseInfo.getWarningReason() != null) {
                invalidLicense = true;
                if (!licenseInfo.isPadlock()) {
                    warningBuilder.append(licenseInfo.getWarningReason().replace("\n", "<br/>")).append("<br/>");
                }
            }
            if (invalidLicense) {
                String errorMessage = errorBuilder.toString();
                String warningMessage = warningBuilder.toString();
                SwingUtilities.invokeLater(() -> {
                    if (licenseInfo.isError()) {
                        PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), errorMessage);
                    }
                    if (licenseInfo.isWarning()) {
                        PlatformUI.MIRTH_FRAME.alertWarning((Component)((Object)PlatformUI.MIRTH_FRAME), warningMessage);
                    }
                });
            }
            if (!StringUtil.isBlank((String)property)) {
                PlatformUI.MIRTH_FRAME.updatePadlockWarning(property);
            } else if (StringUtils.isBlank((CharSequence)property) && !StringUtils.isBlank((CharSequence)PlatformUI.MIRTH_FRAME.getPadlockWarning())) {
                PlatformUI.MIRTH_FRAME.updatePadlockWarning(null);
            }
        }
        catch (ClientException clientException) {
            // empty catch block
        }
    }

    static {
        isLicenseExpired = false;
    }
}

