/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractLoginPanel;
import com.mirth.connect.client.ui.CustomLoginPanelProvider;
import com.mirth.connect.client.ui.LoginPanel;
import java.util.Objects;
import java.util.function.Supplier;

public final class LoginPanelProvider {
    private static volatile Supplier<AbstractLoginPanel> customFactory;
    private static AbstractLoginPanel instance;

    private LoginPanelProvider() {
    }

    public static synchronized void registerCustomLoginPanelFactory(String className) {
        if (instance != null || customFactory != null) {
            return;
        }
        Objects.requireNonNull(className, "className");
        try {
            Class<?> cls = Class.forName(className);
            CustomLoginPanelProvider provider = (CustomLoginPanelProvider)cls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            Supplier<AbstractLoginPanel> factory = provider.getFactory();
            if (factory != null) {
                customFactory = factory;
            }
        }
        catch (ClassNotFoundException cls) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static synchronized AbstractLoginPanel getInstance() {
        if (instance == null) {
            instance = LoginPanelProvider.createPanelFailSafe();
        }
        return instance;
    }

    private static AbstractLoginPanel createPanelFailSafe() {
        try {
            AbstractLoginPanel p;
            if (customFactory != null && (p = customFactory.get()) != null) {
                return p;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return new LoginPanel();
    }
}

