/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.browsers.message.MessageBrowser;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.model.MessageImportResult;
import com.mirth.connect.util.MessageImporter;
import com.mirth.connect.util.messagewriter.MessageWriter;
import com.mirth.connect.util.messagewriter.MessageWriterException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.prefs.Preferences;
import javax.swing.ButtonGroup;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;

public class MessageImportDialog
extends MirthDialog {
    private String channelId;
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private Preferences userPreferences = Frame.userPreferences;
    private MessageBrowser messageBrowser;
    private JLabel importFromLabel;
    private ButtonGroup importFromButtonGroup;
    private MirthRadioButton importServerRadio;
    private MirthRadioButton importLocalRadio;
    private MirthButton browseButton;
    private JLabel fileLabel;
    private MirthTextField fileTextField;
    private MirthCheckBox subfoldersCheckbox;
    private JLabel noteLabel;
    private MirthButton importButton;
    private MirthButton cancelButton;

    public MessageImportDialog() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.setTitle("Import Messages");
        this.setLocationRelativeTo(null);
        this.setModal(true);
        this.initComponents();
        this.initLayout();
        this.pack();
    }

    public void setChannelId(String channelId) {
        this.channelId = channelId;
    }

    public void setMessageBrowser(MessageBrowser messageBrowser) {
        this.messageBrowser = messageBrowser;
    }

    private void initComponents() {
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        this.importFromLabel = new JLabel("Import From:");
        ActionListener importDestinationChanged = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (MessageImportDialog.this.importServerRadio.isSelected()) {
                    MessageImportDialog.this.fileTextField.setText(null);
                    MessageImportDialog.this.browseButton.setEnabled(false);
                } else {
                    MessageImportDialog.this.fileTextField.setText(null);
                    MessageImportDialog.this.browseButton.setEnabled(true);
                }
            }
        };
        this.importServerRadio = new MirthRadioButton("Server");
        this.importServerRadio.setSelected(true);
        this.importServerRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.importServerRadio.addActionListener(importDestinationChanged);
        this.importServerRadio.setToolTipText("<html>Import messages from a file, folder or archive<br />on the BridgeLink Server.</html>");
        this.importLocalRadio = new MirthRadioButton("My Computer");
        this.importLocalRadio.setBackground(UIConstants.BACKGROUND_COLOR);
        this.importLocalRadio.addActionListener(importDestinationChanged);
        this.importLocalRadio.setToolTipText("<html>Import messages from a file, folder<br />or archive on this computer.</html>");
        this.importFromButtonGroup = new ButtonGroup();
        this.importFromButtonGroup.add(this.importServerRadio);
        this.importFromButtonGroup.add(this.importLocalRadio);
        this.browseButton = new MirthButton("Browse...");
        this.browseButton.setEnabled(false);
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageImportDialog.this.browseSelected();
            }
        });
        this.fileLabel = new JLabel("File/Folder/Archive:");
        this.fileTextField = new MirthTextField();
        this.fileTextField.setToolTipText("<html>A file containing message(s) in XML format, or a folder/archive<br />containing files with message(s) in XML format.</html>");
        this.subfoldersCheckbox = new MirthCheckBox("Include Sub-folders");
        this.subfoldersCheckbox.setSelected(true);
        this.subfoldersCheckbox.setBackground(UIConstants.BACKGROUND_COLOR);
        this.subfoldersCheckbox.setToolTipText("<html>If checked, sub-folders of the folder/archive shown above<br />will be searched for messages to import.</html>");
        this.noteLabel = new JLabel("<html><i>Note: RECEIVED, QUEUED, or PENDING messages will be set to ERROR upon import.</i></html>");
        this.importButton = new MirthButton("Import");
        this.importButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageImportDialog.this.importMessages();
            }
        });
        this.cancelButton = new MirthButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageImportDialog.this.setVisible(false);
            }
        });
    }

    private void browseSelected() {
        File currentDir;
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(2);
        if (this.userPreferences != null && (currentDir = new File(this.userPreferences.get("currentDirectory", ""))).exists()) {
            chooser.setCurrentDirectory(currentDir);
        }
        if (chooser.showOpenDialog(this.getParent()) == 0) {
            if (this.userPreferences != null) {
                this.userPreferences.put("currentDirectory", chooser.getCurrentDirectory().getPath());
            }
            this.fileTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, wrap", "[right]4[left, grow]", ""));
        this.add(this.importFromLabel);
        this.add((Component)this.importServerRadio, "split 3");
        this.add(this.importLocalRadio);
        this.add(this.browseButton);
        this.add(this.fileLabel);
        this.add((Component)this.fileTextField, "grow");
        this.add((Component)this.subfoldersCheckbox, "skip");
        this.add((Component)this.noteLabel, "skip, grow, pushy, wrap push");
        this.add((Component)new JSeparator(), "grow, gaptop 6, span");
        this.add((Component)this.importButton, "skip, split 2, gaptop 4, alignx right, width 60");
        this.add((Component)this.cancelButton, "width 60");
    }

    private void importMessages() {
        if (StringUtils.isBlank((CharSequence)this.fileTextField.getText())) {
            this.fileTextField.setBackground(UIConstants.INVALID_COLOR);
            this.parent.alertError((Component)((Object)this.parent), "Please enter a file/folder to import.");
            this.setVisible(true);
            return;
        }
        this.fileTextField.setBackground(null);
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            MessageImportResult result;
            if (this.importLocalRadio.isSelected()) {
                MessageWriter messageWriter = new MessageWriter(){

                    public boolean write(Message message) throws MessageWriterException {
                        try {
                            MessageImportDialog.this.parent.mirthClient.importMessage(MessageImportDialog.this.channelId, message);
                        }
                        catch (ClientException e) {
                            throw new MessageWriterException((Throwable)e);
                        }
                        return true;
                    }

                    public void finishWrite() {
                    }

                    public void close() throws MessageWriterException {
                    }
                };
                try {
                    result = new MessageImporter().importMessages(this.fileTextField.getText(), Boolean.valueOf(this.subfoldersCheckbox.isSelected()), messageWriter, SystemUtils.getUserHome().getAbsolutePath());
                }
                catch (MessageImporter.MessageImportInvalidPathException e) {
                    this.setCursor(Cursor.getDefaultCursor());
                    this.parent.alertError((Component)((Object)this.parent), e.getMessage());
                    this.setVisible(true);
                    return;
                }
            } else {
                result = this.parent.mirthClient.importMessagesServer(this.channelId, this.fileTextField.getText(), this.subfoldersCheckbox.isSelected());
            }
            this.setVisible(false);
            this.setCursor(Cursor.getDefaultCursor());
            if (result.getSuccessCount() == 0 && result.getTotalCount() == 0) {
                this.parent.alertInformation((Component)((Object)this.parent), "No messages were found to import");
            } else {
                if (result.getSuccessCount() > 0 && this.messageBrowser != null) {
                    this.messageBrowser.updateFilterButtonFont(1);
                }
                this.parent.alertInformation((Component)((Object)this.parent), result.getSuccessCount() + " out of " + result.getTotalCount() + " message(s) have been successfully imported from " + this.fileTextField.getText() + ".");
            }
        }
        catch (Exception e) {
            this.setCursor(Cursor.getDefaultCursor());
            Throwable cause = e.getCause() == null ? e : e.getCause();
            this.parent.alertThrowable((Component)((Object)this.parent), cause);
        }
    }
}

