/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.ConnectServiceUtil;
import com.mirth.connect.client.ui.BareBonesBrowserLaunch;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.notification.Notification;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingWorker;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.DefaultCaret;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

public class NotificationDialog
extends MirthDialog {
    private NotificationModel notificationModel = new NotificationModel();
    private Notification currentNotification;
    private String checkForNotifications = null;
    private String showNotificationPopup = null;
    private boolean checkForNotificationsSetting = false;
    private int unarchivedCount = 0;
    private Set<Integer> archivedNotifications = new HashSet<Integer>();
    Properties userPreferences = new Properties();
    private Color borderColor = new Color(110, 110, 110);
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private JPanel notificationPanel;
    private JPanel headerListPanel;
    private JLabel newNotificationsLabel;
    private JLabel archiveAll;
    private JList list;
    private JScrollPane listScrollPane;
    private JPanel headerContentPanel;
    private JTextField notificationNameTextField;
    private JLabel archiveLabel;
    private JTextPane contentTextPane;
    private JScrollPane contentScrollPane;
    private JCheckBox notificationCheckBox;
    private JButton closeButton;

    public NotificationDialog() {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        DisplayUtil.setResizable(this, false);
        this.setTitle("Notifications");
        this.setPreferredSize(new Dimension(750, 625));
        this.getContentPane().setBackground(UIConstants.BACKGROUND_COLOR);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.loadNotifications();
        this.initLayout();
        this.pack();
        this.setVisible(true);
    }

    private void loadNotifications() {
        HashSet<String> preferenceNames = new HashSet<String>();
        preferenceNames.add("firstlogin");
        preferenceNames.add("checkForNotifications");
        preferenceNames.add("showNotificationPopup");
        preferenceNames.add("archivedNotifications");
        try {
            this.userPreferences = this.parent.mirthClient.getUserPreferences(this.parent.getCurrentUser((Component)((Object)this.parent)).getId(), preferenceNames);
        }
        catch (ClientException clientException) {
            // empty catch block
        }
        String archivedNotificationString = this.userPreferences.getProperty("archivedNotifications");
        if (archivedNotificationString != null) {
            this.archivedNotifications = (Set)ObjectXMLSerializer.getInstance().deserialize(archivedNotificationString, Set.class);
        }
        this.showNotificationPopup = this.userPreferences.getProperty("showNotificationPopup");
        this.checkForNotifications = this.userPreferences.getProperty("checkForNotifications");
        this.initComponents();
        final String workingId = this.parent.startWorking("Loading notifications...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            List<Notification> notifications = new ArrayList<Notification>();

            @Override
            public Void doInBackground() {
                try {
                    this.notifications = ConnectServiceUtil.getNotifications((String)PlatformUI.SERVER_ID, (String)PlatformUI.SERVER_VERSION, LoadedExtensions.getInstance().getExtensionVersions(), (String[])PlatformUI.HTTPS_PROTOCOLS, (String[])PlatformUI.HTTPS_CIPHER_SUITES);
                }
                catch (Exception e) {
                    PlatformUI.MIRTH_FRAME.alertError((Component)((Object)PlatformUI.MIRTH_FRAME), "Failed to retrieve notifications. Please try again later.");
                }
                return null;
            }

            @Override
            public void done() {
                NotificationDialog.this.notificationModel.setData(this.notifications);
                for (Notification notification : this.notifications) {
                    if (NotificationDialog.this.archivedNotifications.contains(notification.getId())) {
                        NotificationDialog.this.notificationModel.setArchived(true, this.notifications.indexOf(notification));
                        continue;
                    }
                    ++NotificationDialog.this.unarchivedCount;
                }
                NotificationDialog.this.updateUnarchivedCountLabel();
                NotificationDialog.this.list.setModel(NotificationDialog.this.notificationModel);
                NotificationDialog.this.list.setSelectedIndex(0);
                NotificationDialog.this.parent.stopWorking(workingId);
            }
        };
        worker.execute();
    }

    @Override
    public void onCloseAction() {
        this.doSave();
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("insets 12", "[]", "[fill][]"));
        this.notificationPanel = new JPanel();
        this.notificationPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 0 0, fill", "[200!][]", "[25!]0[]"));
        this.notificationPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.archiveAll = new JLabel("Archive All");
        this.archiveAll.setForeground(Color.blue);
        this.archiveAll.setText("<html><u>Archive All</u></html>");
        this.archiveAll.setToolTipText("Archive all notifications below.");
        this.archiveAll.setCursor(new Cursor(12));
        this.newNotificationsLabel = new JLabel();
        this.newNotificationsLabel.setFont(this.newNotificationsLabel.getFont().deriveFont(1));
        this.headerListPanel = new JPanel();
        this.headerListPanel.setBackground(UIConstants.HIGHLIGHTER_COLOR);
        this.headerListPanel.setLayout((LayoutManager)new MigLayout("insets 2, fill"));
        this.headerListPanel.setBorder(BorderFactory.createLineBorder(this.borderColor));
        this.list = new JList();
        this.list.setCellRenderer(new NotificationListCellRenderer());
        this.list.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent event) {
                if (!event.getValueIsAdjusting()) {
                    NotificationDialog.this.currentNotification = (Notification)NotificationDialog.this.list.getSelectedValue();
                    if (NotificationDialog.this.currentNotification != null) {
                        NotificationDialog.this.notificationNameTextField.setText(NotificationDialog.this.currentNotification.getName());
                        NotificationDialog.this.contentTextPane.setText(NotificationDialog.this.currentNotification.getContent());
                        NotificationDialog.this.archiveSelected();
                    }
                }
            }
        });
        this.listScrollPane = new JScrollPane();
        this.listScrollPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.listScrollPane.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, this.borderColor));
        this.listScrollPane.setViewportView(this.list);
        this.listScrollPane.setHorizontalScrollBarPolicy(31);
        this.archiveLabel = new JLabel();
        this.archiveLabel.setForeground(Color.blue);
        this.archiveLabel.setCursor(new Cursor(12));
        this.notificationNameTextField = new JTextField();
        this.notificationNameTextField.setFont(this.notificationNameTextField.getFont().deriveFont(1));
        this.notificationNameTextField.setEditable(false);
        this.notificationNameTextField.setFocusable(false);
        this.notificationNameTextField.setBorder(BorderFactory.createEmptyBorder());
        this.notificationNameTextField.setBackground(UIConstants.HIGHLIGHTER_COLOR);
        DefaultCaret nameCaret = (DefaultCaret)this.notificationNameTextField.getCaret();
        nameCaret.setUpdatePolicy(1);
        this.headerContentPanel = new JPanel();
        this.headerContentPanel.setLayout((LayoutManager)new MigLayout("insets 2, fill"));
        this.headerContentPanel.setBorder(BorderFactory.createLineBorder(this.borderColor));
        this.headerContentPanel.setBackground(UIConstants.HIGHLIGHTER_COLOR);
        this.contentTextPane = new JTextPane();
        this.contentTextPane.setContentType("text/html");
        this.contentTextPane.setEditable(false);
        this.contentTextPane.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED && Desktop.isDesktopSupported()) {
                    try {
                        if (Desktop.isDesktopSupported()) {
                            Desktop.getDesktop().browse(evt.getURL().toURI());
                        } else {
                            BareBonesBrowserLaunch.openURL(evt.getURL().toString());
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        DefaultCaret contentCaret = (DefaultCaret)this.contentTextPane.getCaret();
        contentCaret.setUpdatePolicy(1);
        this.contentScrollPane = new JScrollPane();
        this.contentScrollPane.setViewportView(this.contentTextPane);
        this.contentScrollPane.setBorder(BorderFactory.createMatteBorder(0, 1, 1, 1, this.borderColor));
        this.archiveLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                int index = NotificationDialog.this.list.getSelectedIndex();
                if (NotificationDialog.this.currentNotification.isArchived()) {
                    NotificationDialog.this.notificationModel.setArchived(false, index);
                    ++NotificationDialog.this.unarchivedCount;
                } else {
                    NotificationDialog.this.notificationModel.setArchived(true, index);
                    --NotificationDialog.this.unarchivedCount;
                }
                NotificationDialog.this.archiveSelected();
                NotificationDialog.this.updateUnarchivedCountLabel();
            }
        });
        this.archiveAll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                for (int i = 0; i < NotificationDialog.this.notificationModel.getSize(); ++i) {
                    NotificationDialog.this.notificationModel.setArchived(true, i);
                }
                NotificationDialog.this.unarchivedCount = 0;
                NotificationDialog.this.archiveSelected();
                NotificationDialog.this.updateUnarchivedCountLabel();
            }
        });
        this.notificationCheckBox = new JCheckBox("Show new notifications on login");
        this.notificationCheckBox.setBackground(UIConstants.BACKGROUND_COLOR);
        if (this.checkForNotifications == null || BooleanUtils.toBoolean((String)this.checkForNotifications)) {
            this.checkForNotificationsSetting = true;
            if (this.showNotificationPopup == null || BooleanUtils.toBoolean((String)this.showNotificationPopup)) {
                this.notificationCheckBox.setSelected(true);
            } else {
                this.notificationCheckBox.setSelected(false);
            }
        } else {
            this.notificationCheckBox.setSelected(false);
        }
        this.notificationCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (NotificationDialog.this.notificationCheckBox.isSelected() && !NotificationDialog.this.checkForNotificationsSetting) {
                    NotificationDialog.this.alertSettingsChange();
                }
            }
        });
        this.closeButton = new JButton("Close");
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NotificationDialog.this.doSave();
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                NotificationDialog.this.doSave();
            }
        });
    }

    private void initLayout() {
        this.headerListPanel.add((Component)this.newNotificationsLabel, "alignx left");
        this.headerListPanel.add((Component)this.archiveAll, "alignx right");
        this.headerContentPanel.add((Component)this.notificationNameTextField, "alignx left, growx, push");
        this.headerContentPanel.add((Component)this.archiveLabel, "alignx right");
        this.notificationPanel.add((Component)this.headerListPanel, "grow");
        this.notificationPanel.add((Component)this.headerContentPanel, "wrap, grow");
        this.notificationPanel.add((Component)this.listScrollPane, "grow");
        this.notificationPanel.add((Component)this.contentScrollPane, "grow");
        this.add((Component)this.notificationPanel, "grow, push, span");
        this.add((Component)new JSeparator(), "grow, gaptop 4, span");
        this.add((Component)this.notificationCheckBox, "alignx left");
        this.add((Component)this.closeButton, "alignx right, width 60, spany 2");
    }

    private void updateUnarchivedCountLabel() {
        if (this.unarchivedCount == 0) {
            this.newNotificationsLabel.setText("");
        } else {
            this.newNotificationsLabel.setText(this.unarchivedCount + " new");
        }
    }

    private void archiveSelected() {
        if (this.currentNotification != null) {
            if (this.currentNotification.isArchived()) {
                this.archiveLabel.setText("<html><u>Unarchive</u></html>");
                this.archiveLabel.setToolTipText("Unarchive this notification.");
            } else {
                this.archiveLabel.setText("<html><u>Archive</u></html>");
                this.archiveLabel.setToolTipText("Archive this notification.");
            }
        }
    }

    private void alertSettingsChange() {
        boolean option = this.parent.alertOption(this, "<html>Selecting this option will enable checking for notifications on login.<br/>Are you sure you want to continue?</html>");
        if (option) {
            this.checkForNotificationsSetting = true;
        } else {
            this.notificationCheckBox.setSelected(false);
        }
    }

    private void doSave() {
        Set<Integer> currentArchivedNotifications;
        final Properties personPreferences = new Properties();
        if (!StringUtils.equals((CharSequence)this.checkForNotifications, (CharSequence)Boolean.toString(this.checkForNotificationsSetting))) {
            personPreferences.put("checkForNotifications", Boolean.toString(this.checkForNotificationsSetting));
        }
        if (!StringUtils.equals((CharSequence)this.showNotificationPopup, (CharSequence)Boolean.toString(this.notificationCheckBox.isSelected()))) {
            personPreferences.put("showNotificationPopup", Boolean.toString(this.notificationCheckBox.isSelected()));
        }
        if (!this.archivedNotifications.equals(currentArchivedNotifications = this.notificationModel.getArchivedNotifications())) {
            personPreferences.put("archivedNotifications", ObjectXMLSerializer.getInstance().serialize(currentArchivedNotifications));
        }
        if (!personPreferences.isEmpty()) {
            final String workingId = this.parent.startWorking("Saving notifications settings...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                @Override
                public Void doInBackground() {
                    try {
                        NotificationDialog.this.parent.mirthClient.setUserPreferences(NotificationDialog.this.parent.getCurrentUser((Component)((Object)NotificationDialog.this.parent)).getId(), personPreferences);
                    }
                    catch (ClientException e) {
                        NotificationDialog.this.parent.alertThrowable((Component)((Object)NotificationDialog.this.parent), e);
                    }
                    return null;
                }

                @Override
                public void done() {
                    NotificationDialog.this.parent.stopWorking(workingId);
                }
            };
            worker.execute();
        }
        this.parent.updateNotificationTaskName(this.unarchivedCount);
        this.dispose();
    }

    private class NotificationModel
    extends AbstractListModel {
        private List<Notification> notifications = new ArrayList<Notification>();

        private NotificationModel() {
        }

        @Override
        public Notification getElementAt(int index) {
            return this.notifications.get(index);
        }

        public void setArchived(boolean archived, int index) {
            this.getElementAt(index).setArchived(archived);
            this.fireContentsChanged(this, index, index);
        }

        public Set<Integer> getArchivedNotifications() {
            HashSet<Integer> archivedNotifications = new HashSet<Integer>();
            for (Notification notification : this.notifications) {
                if (!notification.isArchived()) continue;
                archivedNotifications.add(notification.getId());
            }
            return archivedNotifications;
        }

        @Override
        public int getSize() {
            return this.notifications.size();
        }

        public void setData(List<Notification> notifications) {
            int size = this.getSize();
            this.notifications.clear();
            this.fireIntervalRemoved(this, 0, size - 1);
            this.notifications.addAll(notifications);
            this.fireIntervalAdded(this, 0, this.getSize() - 1);
        }
    }

    private class NotificationListCellRenderer
    extends DefaultListCellRenderer {
        private JPanel panel;
        private JLabel nameLabel = new JLabel();
        private JLabel dateLabel = new JLabel();

        public NotificationListCellRenderer() {
            this.dateLabel.setFont(NotificationDialog.this.list.getFont().deriveFont(10.0f));
            this.dateLabel.setForeground(Color.GRAY);
            this.panel = new JPanel();
            this.panel.setLayout((LayoutManager)new MigLayout("insets 2, wrap"));
            this.panel.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIConstants.HIGHLIGHTER_COLOR));
            this.panel.add(this.nameLabel);
            this.panel.add(this.dateLabel);
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Notification notification = (Notification)value;
            this.nameLabel.setText(notification.getName());
            this.dateLabel.setText(notification.getDate());
            if (notification.isArchived()) {
                this.nameLabel.setFont(list.getFont().deriveFont(0));
            } else {
                this.nameLabel.setFont(list.getFont().deriveFont(1));
            }
            if (isSelected) {
                this.panel.setBackground(list.getSelectionBackground());
                this.panel.setForeground(list.getSelectionForeground());
            } else {
                this.panel.setBackground(list.getBackground());
                this.panel.setForeground(list.getForeground());
            }
            return this.panel;
        }
    }
}

