/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.util.DisplayUtil;
import java.awt.Component;
import java.math.BigDecimal;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class NumberCellRenderer
extends DefaultTableCellRenderer {
    private boolean padding = false;

    public NumberCellRenderer() {
        this(4, true);
    }

    public NumberCellRenderer(int alignment, boolean padding) {
        this.padding = padding;
        this.setHorizontalAlignment(alignment);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            super.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        }
        if (value == null) {
            this.setText("--");
        } else if (value instanceof Integer) {
            String displayText = DisplayUtil.formatNumber((Integer)value);
            if (this.padding) {
                this.setText(displayText + " ");
            } else {
                this.setText(displayText);
            }
        } else if (value instanceof Long) {
            String displayText = DisplayUtil.formatNumber((Long)value);
            if (this.padding) {
                this.setText(displayText + " ");
            } else {
                this.setText(displayText);
            }
        } else if (value instanceof BigDecimal) {
            String displayText = ((BigDecimal)value).stripTrailingZeros().toString();
            if (this.padding) {
                this.setText(displayText + " ");
            } else {
                this.setText(displayText);
            }
        }
        return this;
    }
}

