/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.QueuingSwingWorkerTask;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingWorker;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueuingSwingWorker<T, V>
extends SwingWorker<T, V> {
    private static Map<String, WorkerInfo> workerInfoMap = new ConcurrentHashMap<String, WorkerInfo>();
    private static Logger logger = LogManager.getLogger(QueuingSwingWorker.class);
    private QueuingSwingWorkerTask<T, V> task;
    private String workingId;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueuingSwingWorker(QueuingSwingWorkerTask<T, V> task, boolean queue) {
        Object object;
        this.task = task;
        WorkerInfo workerInfo = workerInfoMap.get(task.getKey());
        if (workerInfo == null) {
            object = workerInfoMap;
            synchronized (object) {
                workerInfo = workerInfoMap.get(task.getKey());
                if (workerInfo == null) {
                    workerInfo = new WorkerInfo();
                    workerInfoMap.put(task.getKey(), workerInfo);
                }
            }
        }
        object = workerInfo;
        synchronized (object) {
            logger.debug("Locked: key=" + task.getKey() + ", queue=" + queue + ", workerState=" + String.valueOf((Object)workerInfo.workerState));
            if (workerInfo.workerState != WorkerState.IDLE) {
                if (queue) {
                    workerInfo.workerState = WorkerState.QUEUED;
                }
                return;
            }
            workerInfo.workerState = WorkerState.WORKING;
            logger.debug("Unlocking: key=" + task.getKey() + ", queue=" + queue + ", workerState=" + String.valueOf((Object)workerInfo.workerState));
        }
        this.workingId = PlatformUI.MIRTH_FRAME.startWorking(task.getDisplayText());
        task.setWorker(this);
    }

    protected final void publishDelegate(V ... chunks) {
        logger.debug("Delegate publish running: key=" + this.task.getKey());
        this.publish(chunks);
    }

    public final void executeDelegate() {
        if (this.workingId != null) {
            this.execute();
        }
    }

    @Override
    protected T doInBackground() throws Exception {
        logger.debug("Delegate doInBackground running: key=" + this.task.getKey());
        return this.task.doInBackground();
    }

    @Override
    protected void process(List<V> chunks) {
        logger.debug("Delegate process running: key=" + this.task.getKey());
        this.task.process(chunks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void done() {
        logger.debug("Delegate done running: key=" + this.task.getKey());
        this.task.done();
        PlatformUI.MIRTH_FRAME.stopWorking(this.workingId);
        WorkerInfo workerInfo = workerInfoMap.get(this.task.getKey());
        boolean queued = false;
        WorkerInfo workerInfo2 = workerInfo;
        synchronized (workerInfo2) {
            logger.debug("Delegate done, locked: key=" + this.task.getKey() + ", workerState=" + String.valueOf((Object)workerInfo.workerState));
            if (workerInfo.workerState == WorkerState.QUEUED) {
                queued = true;
            }
            workerInfo.workerState = WorkerState.IDLE;
            logger.debug("Delegate done, unlocking: key=" + this.task.getKey() + ", workerState=" + String.valueOf((Object)workerInfo.workerState));
        }
        if (queued) {
            logger.debug("Delegate done, creating new worker: key=" + this.task.getKey());
            new QueuingSwingWorker<T, V>(this.task, false).executeDelegate();
        }
    }

    private static class WorkerInfo {
        public WorkerState workerState = WorkerState.IDLE;

        private WorkerInfo() {
        }
    }

    private static enum WorkerState {
        IDLE,
        WORKING,
        QUEUED;

    }
}

