/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.QueuingSwingWorker;
import java.util.List;
import java.util.concurrent.ExecutionException;

public abstract class QueuingSwingWorkerTask<T, V> {
    private String key;
    private String displayText;
    private QueuingSwingWorker<T, V> worker;

    public QueuingSwingWorkerTask(String key, String displayText) {
        this.key = key;
        this.displayText = displayText;
    }

    protected abstract T doInBackground() throws Exception;

    protected final T get() throws InterruptedException, ExecutionException {
        if (this.worker != null) {
            return this.worker.get();
        }
        return null;
    }

    protected final void publish(V ... chunks) {
        if (this.worker != null) {
            this.worker.publishDelegate(chunks);
        }
    }

    protected void process(List<V> chunks) {
    }

    protected void done() {
    }

    public String getKey() {
        return this.key;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public void setWorker(QueuingSwingWorker<T, V> worker) {
        this.worker = worker;
    }
}

