/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AuthorizationControllerFactory;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.util.DisplayUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;

public class RemoveMessagesDialog
extends MirthDialog {
    private Frame parent;
    private Set<String> channelIds;
    private JPanel buttonPanel;
    private MirthCheckBox clearStatsCheckBox;
    private MirthCheckBox includeRunningChannels;
    private JLabel messageLabel;
    private MirthButton noButton;
    private MirthButton yesButton;

    public RemoveMessagesDialog(Frame parent, boolean modal) {
        super((Window)((Object)parent), modal);
        this.initComponents();
        DisplayUtil.setResizable(this, false);
        this.parent = parent;
    }

    public void init(Set<String> selectedChannelIds, boolean restartCheckboxEnabled) {
        this.yesButton.requestFocus();
        boolean canClearStats = AuthorizationControllerFactory.getAuthorizationController().checkTask("dashboard", "doClearStats");
        this.clearStatsCheckBox.setSelected(canClearStats);
        this.clearStatsCheckBox.setEnabled(canClearStats);
        this.includeRunningChannels.setSelected(false);
        this.channelIds = selectedChannelIds;
        this.includeRunningChannels.setEnabled(restartCheckboxEnabled);
    }

    private void initComponents() {
        this.messageLabel = new JLabel();
        this.clearStatsCheckBox = new MirthCheckBox();
        this.includeRunningChannels = new MirthCheckBox();
        this.buttonPanel = new JPanel();
        this.yesButton = new MirthButton();
        this.noButton = new MirthButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Remove All Messages");
        this.messageLabel.setText("Are you sure you want to remove all messages (including QUEUED) for the selected stopped channel(s)?");
        this.clearStatsCheckBox.setText("Clear statistics for affected channel(s)");
        this.includeRunningChannels.setText("Include selected channels that are not stopped (channels will be temporarily stopped while messages are being removed) ");
        this.yesButton.setText("Yes");
        this.yesButton.setHorizontalTextPosition(0);
        this.yesButton.setMaximumSize(new Dimension(75, 22));
        this.yesButton.setMinimumSize(new Dimension(75, 22));
        this.yesButton.setPreferredSize(new Dimension(75, 22));
        this.yesButton.setVerticalTextPosition(3);
        this.yesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveMessagesDialog.this.yesButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.yesButton);
        this.noButton.setText("No");
        this.noButton.setHorizontalTextPosition(0);
        this.noButton.setMaximumSize(new Dimension(75, 22));
        this.noButton.setMinimumSize(new Dimension(75, 22));
        this.noButton.setPreferredSize(new Dimension(75, 22));
        this.noButton.setVerticalTextPosition(3);
        this.noButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RemoveMessagesDialog.this.noButtonActionPerformed(evt);
            }
        });
        this.buttonPanel.add(this.noButton);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(12, 12, 12).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.includeRunningChannels, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageLabel).addComponent(this.clearStatsCheckBox, -2, -1, -2)).addGap(129, 129, 129)))).addComponent(this.buttonPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.messageLabel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.includeRunningChannels, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.clearStatsCheckBox, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonPanel, -2, 32, -2).addGap(8, 8, 8)));
        this.pack();
    }

    private void noButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void yesButtonActionPerformed(ActionEvent evt) {
        String result;
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("showReprocessRemoveMessagesWarning", true) && !StringUtils.equals((CharSequence)(result = DisplayUtil.showInputDialog(this, "<html>This will remove <b>all</b> messages for the selected channel(s).<br><font size='1'><br></font>Type REMOVEALL and click the OK button to continue.</html>", "Remove All Messages", 2)), (CharSequence)"REMOVEALL")) {
            this.parent.alertWarning(this, "You must type REMOVEALL to remove all messages.");
            return;
        }
        final String workingId = this.parent.startWorking("Removing messages...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    RemoveMessagesDialog.this.parent.mirthClient.removeAllMessages(RemoveMessagesDialog.this.channelIds, RemoveMessagesDialog.this.includeRunningChannels.isSelected(), RemoveMessagesDialog.this.clearStatsCheckBox.isSelected());
                }
                catch (ClientException e) {
                    RemoveMessagesDialog.this.parent.alertThrowable((Component)((Object)PlatformUI.MIRTH_FRAME), e);
                }
                return null;
            }

            @Override
            public void done() {
                RemoveMessagesDialog.this.parent.doRefreshStatuses(true);
                if (RemoveMessagesDialog.this.parent.currentContentPage == RemoveMessagesDialog.this.parent.messageBrowser) {
                    RemoveMessagesDialog.this.parent.messageBrowser.refresh(1, true);
                }
                RemoveMessagesDialog.this.parent.stopWorking(workingId);
            }
        };
        worker.execute();
        this.setVisible(false);
    }
}

