/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.components.ItemSelectionTable;
import com.mirth.connect.client.ui.components.ItemSelectionTableModel;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.filters.MessageFilter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ReprocessMessagesDialog
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private MessageFilter filter = null;
    private Long messageId = null;
    private String channelId;
    private boolean showWarning;
    private JEditorPane warningPane;
    private JCheckBox overwriteCheckBox;
    private JLabel reprocessLabel;
    private JLabel selectAllLabel;
    private JLabel selectSeparatorLabel;
    private JLabel deselectAllLabel;
    private JScrollPane includedDestinationsPane;
    private MirthTable includedDestinationsTable;
    private JButton okButton;
    private JButton cancelButton;

    public ReprocessMessagesDialog(String channelId, MessageFilter filter, Long messageId, Map<Integer, String> destinationsConnectors, Integer selectedMetaDataId, boolean showWarning) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME));
        this.showWarning = showWarning;
        this.initComponents();
        this.initLayout();
        this.channelId = channelId;
        this.filter = filter;
        this.messageId = messageId;
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        DisplayUtil.setResizable(this, false);
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setTitle("Reprocessing Options");
        this.makeIncludedDestinationsTable(destinationsConnectors, selectedMetaDataId);
        this.okButton.requestFocus();
        this.setVisible(true);
    }

    public void makeIncludedDestinationsTable(Map<Integer, String> destinationsConnectors, Integer selectedMetaDataId) {
        ArrayList<Integer> selectedMetaDataIds = null;
        if (selectedMetaDataId != null && selectedMetaDataId > 0) {
            selectedMetaDataIds = new ArrayList<Integer>();
            selectedMetaDataIds.add(selectedMetaDataId);
        }
        this.includedDestinationsTable = new ItemSelectionTable();
        this.includedDestinationsTable.setModel(new ItemSelectionTableModel<Integer, String>(destinationsConnectors, selectedMetaDataIds, "Destination", "Included"));
        this.includedDestinationsPane.setViewportView((Component)((Object)this.includedDestinationsTable));
    }

    private void initComponents() {
        this.warningPane = new JEditorPane("text/html", "");
        this.warningPane.setBorder(BorderFactory.createEmptyBorder());
        this.warningPane.setBackground(this.getBackground());
        this.warningPane.setEditable(false);
        HTMLEditorKit editorKit = new HTMLEditorKit();
        StyleSheet styleSheet = editorKit.getStyleSheet();
        styleSheet.addRule(".reprocess-dialog {font-family:\"Tahoma\";font-size:11;text-align:center}");
        this.warningPane.setEditorKit(editorKit);
        this.warningPane.setText("<html><span class=\"reprocess-dialog\" style=\"color:#FF0000\"><b>Warning:</b></span> <span class=\"reprocess-dialog\">This will reprocess <b>all</b> results for the current search criteria, including those not listed on the current page. To see how many messages will be reprocessed, close this dialog and click the Count button in the upper-right.</span></html>");
        this.overwriteCheckBox = new JCheckBox();
        this.overwriteCheckBox.setText("Overwrite existing messages and update statistics");
        this.reprocessLabel = new JLabel("Reprocess through the following destinations:");
        this.selectAllLabel = new JLabel("<html><u>Select All</u></html>");
        this.selectAllLabel.setForeground(Color.BLUE);
        this.selectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ((ItemSelectionTableModel)ReprocessMessagesDialog.this.includedDestinationsTable.getModel()).selectAllKeys();
            }
        });
        this.selectSeparatorLabel = new JLabel("|");
        this.deselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
        this.deselectAllLabel.setForeground(Color.BLUE);
        this.deselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                ((ItemSelectionTableModel)ReprocessMessagesDialog.this.includedDestinationsTable.getModel()).unselectAllKeys();
            }
        });
        this.includedDestinationsTable = new MirthTable();
        this.includedDestinationsPane = new JScrollPane((Component)((Object)this.includedDestinationsTable));
        this.okButton = new JButton();
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String result;
                if (ReprocessMessagesDialog.this.showWarning && Preferences.userNodeForPackage(Mirth.class).getBoolean("showReprocessRemoveMessagesWarning", true) && !StringUtils.equals((CharSequence)(result = DisplayUtil.showInputDialog(ReprocessMessagesDialog.this, "<html>This will reprocess all messages that match the current search criteria.<br/>To see how many messages will be reprocessed, close this dialog and<br/>click the Count button in the upper-right.<br><font size='1'><br></font>Type REPROCESSALL and click the OK button to continue.</html>", "Reprocess Results", 2)), (CharSequence)"REPROCESSALL")) {
                    ReprocessMessagesDialog.this.parent.alertWarning(ReprocessMessagesDialog.this, "You must type REPROCESSALL to reprocess results.");
                    return;
                }
                ItemSelectionTableModel model = (ItemSelectionTableModel)ReprocessMessagesDialog.this.includedDestinationsTable.getModel();
                List<Integer> metaDataIds = model.getKeys(true);
                if (metaDataIds.size() == model.getRowCount()) {
                    metaDataIds = null;
                }
                ReprocessMessagesDialog.this.parent.reprocessMessage(ReprocessMessagesDialog.this.channelId, ReprocessMessagesDialog.this.filter, ReprocessMessagesDialog.this.messageId, ReprocessMessagesDialog.this.overwriteCheckBox.isSelected(), metaDataIds);
                ReprocessMessagesDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ReprocessMessagesDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        Container contentPane = this.getContentPane();
        contentPane.setLayout((LayoutManager)new MigLayout("insets 12, fill", "[grow]"));
        contentPane.setPreferredSize(new Dimension(425, 330));
        if (this.showWarning) {
            contentPane.add((Component)this.warningPane, "growx, sx, wrap");
            contentPane.add((Component)new JSeparator(), "growx, gapbottom 6, sx, wrap");
        }
        contentPane.add((Component)this.overwriteCheckBox, "wrap, sx");
        contentPane.add((Component)this.reprocessLabel, "left");
        contentPane.add((Component)this.selectAllLabel, "right, split 3");
        contentPane.add(this.selectSeparatorLabel);
        contentPane.add((Component)this.deselectAllLabel, "wrap");
        contentPane.add((Component)this.includedDestinationsPane, "growx, wrap, gapbottom 6, sx");
        contentPane.add((Component)new JSeparator(), "growx, gapbottom 6, span");
        contentPane.add((Component)this.okButton, "alignx right, width 48, split, span");
        contentPane.add((Component)this.cancelButton, "alignx right, width 48");
        this.pack();
    }
}

