/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.FunctionList;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class ScriptPanel
extends JPanel {
    public static final String DEPLOY_SCRIPT = "Deploy";
    public static final String UNDEPLOY_SCRIPT = "Undeploy";
    public static final String PREPROCESSOR_SCRIPT = "Preprocessor";
    public static final String POSTPROCESSOR_SCRIPT = "Postprocessor";
    private static final String[] SCRIPT_TYPES = new String[]{"Deploy", "Undeploy", "Preprocessor", "Postprocessor"};
    private JLabel scriptLabel;
    private JComboBox<String> scriptComboBox;
    private Map<String, MirthRTextScrollPane> scriptTextAreaMap;
    private Map<String, FunctionList> functionListMap;

    public ScriptPanel(boolean global) {
        this.initComponents(global);
        this.initLayout();
        this.scriptComboBox.setSelectedIndex(0);
    }

    public void setScripts(Map<String, String> scripts) {
        for (Map.Entry<String, String> entry : scripts.entrySet()) {
            this.scriptTextAreaMap.get(entry.getKey()).setText(entry.getValue());
        }
    }

    public Map<String, String> getScripts() {
        HashMap<String, String> scripts = new HashMap<String, String>();
        for (Map.Entry<String, MirthRTextScrollPane> entry : this.scriptTextAreaMap.entrySet()) {
            scripts.put(entry.getKey(), entry.getValue().getText());
        }
        return scripts;
    }

    public void updateDisplayOptions() {
        for (MirthRTextScrollPane scriptTextArea : this.scriptTextAreaMap.values()) {
            scriptTextArea.updateDisplayOptions();
        }
        for (FunctionList functionList : this.functionListMap.values()) {
            functionList.updateUserTemplates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateCurrentScript() {
        StringBuilder sb = new StringBuilder();
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            context.compileString("function rhinoWrapper() {" + this.getScriptTextArea().getText() + "\n}", PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), 1, null);
            sb.append("JavaScript was successfully validated.");
        }
        catch (EvaluatorException e) {
            sb.append("Error on line " + e.lineNumber() + ": " + e.getMessage() + " of the current script.");
        }
        catch (Exception e) {
            sb.append("Unknown error occurred during validation.");
        }
        finally {
            Context.exit();
        }
        PlatformUI.MIRTH_FRAME.alertInformation(this, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String validateScript(String script) {
        Object error = null;
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            context.compileString("function rhinoWrapper() {" + script + "\n}", UUID.randomUUID().toString(), 1, null);
        }
        catch (EvaluatorException e) {
            error = "Error on line " + e.lineNumber() + ": " + e.getMessage() + ".";
        }
        catch (Exception e) {
            error = "Unknown error occurred during validation.";
        }
        finally {
            Context.exit();
        }
        return error;
    }

    private void initComponents(boolean global) {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.scriptLabel = new JLabel("Script:");
        this.scriptComboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(SCRIPT_TYPES));
        this.scriptComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ScriptPanel.this.scriptComboBoxActionPerformed();
            }
        });
        this.scriptTextAreaMap = new HashMap<String, MirthRTextScrollPane>();
        this.functionListMap = new HashMap<String, FunctionList>();
        for (String scriptType : SCRIPT_TYPES) {
            ContextType contextType = this.getContextType(scriptType, global);
            MirthRTextScrollPane scriptTextArea = new MirthRTextScrollPane(contextType, true);
            scriptTextArea.setBorder(BorderFactory.createEtchedBorder());
            this.scriptTextAreaMap.put(scriptType, scriptTextArea);
            FunctionList functionList = new FunctionList(contextType);
            functionList.setDefaultDropDownValue();
            this.functionListMap.put(scriptType, functionList);
        }
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gapx 8"));
        this.add((Component)this.scriptLabel, "split 2, gapafter 13");
        this.add(this.scriptComboBox);
        for (FunctionList functionList : this.functionListMap.values()) {
            this.add((Component)functionList, "grow, w 200!, sy");
        }
        for (MirthRTextScrollPane scriptTextArea : this.scriptTextAreaMap.values()) {
            this.add((Component)((Object)scriptTextArea), "newline, grow, push, w :400, h :300");
        }
    }

    private ContextType getContextType(String scriptType, boolean global) {
        if (scriptType.equals(DEPLOY_SCRIPT)) {
            return global ? ContextType.GLOBAL_DEPLOY : ContextType.CHANNEL_DEPLOY;
        }
        if (scriptType.equals(UNDEPLOY_SCRIPT)) {
            return global ? ContextType.GLOBAL_UNDEPLOY : ContextType.CHANNEL_UNDEPLOY;
        }
        if (scriptType.equals(PREPROCESSOR_SCRIPT)) {
            return global ? ContextType.GLOBAL_PREPROCESSOR : ContextType.CHANNEL_PREPROCESSOR;
        }
        if (scriptType.equals(POSTPROCESSOR_SCRIPT)) {
            return global ? ContextType.GLOBAL_POSTPROCESSOR : ContextType.CHANNEL_POSTPROCESSOR;
        }
        return null;
    }

    private MirthRTextScrollPane getScriptTextArea() {
        return this.scriptTextAreaMap.get((String)this.scriptComboBox.getSelectedItem());
    }

    private void scriptComboBoxActionPerformed() {
        String scriptType = (String)this.scriptComboBox.getSelectedItem();
        for (Map.Entry<String, MirthRTextScrollPane> entry : this.scriptTextAreaMap.entrySet()) {
            entry.getValue().setVisible(entry.getKey().equals(scriptType));
        }
        for (Map.Entry<String, Object> entry : this.functionListMap.entrySet()) {
            ((FunctionList)entry.getValue()).setVisible(entry.getKey().equals(scriptType));
        }
    }
}

