/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractSettingsPanel;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.KeyStrokeTextField;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthRadioButton;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.rsta.AutoCompleteProperties;
import com.mirth.connect.client.ui.components.rsta.MirthRSyntaxTextArea;
import com.mirth.connect.client.ui.components.rsta.RSTAPreferences;
import com.mirth.connect.client.ui.components.rsta.actions.ActionInfo;
import com.mirth.connect.model.User;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class SettingsPanelAdministrator
extends AbstractSettingsPanel {
    public static final String TAB_NAME = "Administrator";
    private static final int ACTION_INFO_COLUMN = 0;
    private static final int NAME_COLUMN = 1;
    private static final int DESCRIPTION_COLUMN = 2;
    private static final int KEY_COLUMN = 3;
    private static Preferences userPreferences;
    private User currentUser = this.getFrame().getCurrentUser((Component)((Object)this.getFrame()));
    private List<ActionInfo> shortcutKeyList = new ArrayList<ActionInfo>();
    private JPanel systemSettingsPanel;
    private JLabel dashboardRefreshIntervalLabel;
    private JTextField dashboardRefreshIntervalField;
    private JLabel messageBrowserPageSizeLabel;
    private JTextField messageBrowserPageSizeField;
    private JLabel eventBrowserPageSizeLabel;
    private JTextField eventBrowserPageSizeField;
    private JLabel formatLabel;
    private ButtonGroup formatButtonGroup;
    private JRadioButton formatYesRadio;
    private JRadioButton formatNoRadio;
    private JLabel textSearchWarningLabel;
    private ButtonGroup textSearchWarningButtonGroup;
    private JRadioButton textSearchWarningYesRadio;
    private JRadioButton textSearchWarningNoRadio;
    private JLabel multiChannelSearchWarningLabel;
    private ButtonGroup multiChannelSearchWarningButtonGroup;
    private JRadioButton multiChannelSearchWarningYesRadio;
    private JRadioButton multiChannelSearchWarningNoRadio;
    private JLabel filterTransformerShowIteratorLabel;
    private ButtonGroup filterTransformerShowIteratorButtonGroup;
    private JRadioButton filterTransformerShowIteratorYesRadio;
    private JRadioButton filterTransformerShowIteratorNoRadio;
    private JLabel messageBrowserShowAttachmentTypeDialogLabel;
    private ButtonGroup messageBrowserShowAttachmentTypeDialogButtonGroup;
    private JRadioButton messageBrowserShowAttachmentTypeDialogYesRadio;
    private JRadioButton messageBrowserShowAttachmentTypeDialogNoRadio;
    private JLabel reprocessRemoveMessagesWarningLabel;
    private JRadioButton reprocessRemoveMessagesWarningYesRadio;
    private JRadioButton reprocessRemoveMessagesWarningNoRadio;
    private JLabel importChannelLibrariesLabel;
    private ButtonGroup importChannelLibrariesButtonGroup;
    private JRadioButton importChannelLibrariesYesRadio;
    private JRadioButton importChannelLibrariesNoRadio;
    private JRadioButton importChannelLibrariesAskRadio;
    private JLabel exportChannelLibrariesLabel;
    private ButtonGroup exportChannelLibrariesButtonGroup;
    private JRadioButton exportChannelLibrariesYesRadio;
    private JRadioButton exportChannelLibrariesNoRadio;
    private JRadioButton exportChannelLibrariesAskRadio;
    private JPanel userSettingsPanel;
    private JLabel checkForNotificationsLabel;
    private ButtonGroup notificationButtonGroup;
    private JRadioButton checkForNotificationsYesRadio;
    private JRadioButton checkForNotificationsNoRadio;
    private JLabel backgroundColorLabel;
    private ButtonGroup backgroundColorButtonGroup;
    private JRadioButton backgroundColorServerDefaultRadio;
    private JRadioButton backgroundColorCustomRadio;
    private JButton backgroundColorButton;
    private JPanel codeEditorSettingsPanel;
    private JLabel autoCompleteCharactersLabel;
    private JTextField autoCompleteCharactersField;
    private JCheckBox autoCompleteIncludeLettersCheckBox;
    private JLabel autoCompleteDelayLabel;
    private JTextField autoCompleteDelayField;
    private JLabel shortcutKeyLabel;
    private JScrollPane shortcutKeyScrollPane;
    private MirthTable shortcutKeyTable;
    private JButton restoreDefaultsButton;

    public SettingsPanelAdministrator(String tabName) {
        super(tabName);
        ResourceBundle resourceBundle = MirthRSyntaxTextArea.getResourceBundle();
        for (ActionInfo actionInfo : ActionInfo.values()) {
            if (BooleanUtils.toBoolean((String)resourceBundle.getString(actionInfo.toString() + ".Toggle"))) continue;
            this.shortcutKeyList.add(actionInfo);
        }
        this.initComponents();
        this.initLayout();
        this.addTask("doSetAdminDefaults", "Restore Defaults", "Restore all Administrator settings to defaults.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")));
    }

    @Override
    public void doRefresh() {
        if (PlatformUI.MIRTH_FRAME.alertRefresh()) {
            return;
        }
        this.dashboardRefreshIntervalField.setDocument(new MirthFieldConstraints(3, false, false, true));
        this.messageBrowserPageSizeField.setDocument(new MirthFieldConstraints(3, false, false, true));
        this.eventBrowserPageSizeField.setDocument(new MirthFieldConstraints(3, false, false, true));
        userPreferences = Preferences.userNodeForPackage(Mirth.class);
        int interval = userPreferences.getInt("intervalTime", 10);
        this.dashboardRefreshIntervalField.setText("" + interval);
        int messageBrowserPageSize = userPreferences.getInt("messageBrowserPageSize", 20);
        this.messageBrowserPageSizeField.setText("" + messageBrowserPageSize);
        int eventBrowserPageSize = userPreferences.getInt("eventBrowserPageSize", 100);
        this.eventBrowserPageSizeField.setText("" + eventBrowserPageSize);
        if (userPreferences.getBoolean("messageBrowserFormat", true)) {
            this.formatYesRadio.setSelected(true);
        } else {
            this.formatNoRadio.setSelected(true);
        }
        if (userPreferences.getBoolean("textSearchWarning", true)) {
            this.textSearchWarningYesRadio.setSelected(true);
        } else {
            this.textSearchWarningNoRadio.setSelected(true);
        }
        if (userPreferences.getBoolean("multiChannelSearchWarning", true)) {
            this.multiChannelSearchWarningYesRadio.setSelected(true);
        } else {
            this.multiChannelSearchWarningNoRadio.setSelected(true);
        }
        this.multiChannelSearchWarningLabel.setVisible(PlatformUI.MIRTH_FRAME.multiChannelMessageBrowsingEnabled);
        this.multiChannelSearchWarningYesRadio.setVisible(PlatformUI.MIRTH_FRAME.multiChannelMessageBrowsingEnabled);
        this.multiChannelSearchWarningNoRadio.setVisible(PlatformUI.MIRTH_FRAME.multiChannelMessageBrowsingEnabled);
        if (userPreferences.getBoolean("filterTransformerShowIteratorDialog", true)) {
            this.filterTransformerShowIteratorYesRadio.setSelected(true);
        } else {
            this.filterTransformerShowIteratorNoRadio.setSelected(true);
        }
        if (userPreferences.getBoolean("messageBrowserShowAttachmentTypeDialog", true)) {
            this.messageBrowserShowAttachmentTypeDialogYesRadio.setSelected(true);
        } else {
            this.messageBrowserShowAttachmentTypeDialogNoRadio.setSelected(true);
        }
        if (userPreferences.getBoolean("showReprocessRemoveMessagesWarning", true)) {
            this.reprocessRemoveMessagesWarningYesRadio.setSelected(true);
        } else {
            this.reprocessRemoveMessagesWarningNoRadio.setSelected(true);
        }
        String importChannelCodeTemplateLibraries = userPreferences.get("importChannelCodeTemplateLibraries", null);
        if (importChannelCodeTemplateLibraries == null) {
            this.importChannelLibrariesAskRadio.setSelected(true);
        } else if (Boolean.parseBoolean(importChannelCodeTemplateLibraries)) {
            this.importChannelLibrariesYesRadio.setSelected(true);
        } else {
            this.importChannelLibrariesNoRadio.setSelected(true);
        }
        String exportChannelCodeTemplateLibraries = userPreferences.get("exportChannelCodeTemplateLibraries", null);
        if (exportChannelCodeTemplateLibraries == null) {
            this.exportChannelLibrariesAskRadio.setSelected(true);
        } else if (Boolean.parseBoolean(exportChannelCodeTemplateLibraries)) {
            this.exportChannelLibrariesYesRadio.setSelected(true);
        } else {
            this.exportChannelLibrariesNoRadio.setSelected(true);
        }
        final String workingId = this.getFrame().startWorking("Loading " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
            private String checkForNotifications = null;
            private Color backgroundColor = null;

            @Override
            public Void doInBackground() {
                try {
                    this.checkForNotifications = SettingsPanelAdministrator.this.getFrame().mirthClient.getUserPreference(SettingsPanelAdministrator.this.currentUser.getId(), "checkForNotifications");
                }
                catch (ClientException e) {
                    SettingsPanelAdministrator.this.getFrame().alertThrowable((Component)((Object)SettingsPanelAdministrator.this.getFrame()), e);
                }
                try {
                    String backgroundColorStr = SettingsPanelAdministrator.this.getFrame().mirthClient.getUserPreference(SettingsPanelAdministrator.this.currentUser.getId(), "backgroundColor");
                    if (StringUtils.isNotBlank((CharSequence)backgroundColorStr)) {
                        this.backgroundColor = (Color)ObjectXMLSerializer.getInstance().deserialize(backgroundColorStr, Color.class);
                    }
                }
                catch (Exception e) {
                    SettingsPanelAdministrator.this.getFrame().alertThrowable((Component)((Object)SettingsPanelAdministrator.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                if (this.checkForNotifications == null || BooleanUtils.toBoolean((String)this.checkForNotifications)) {
                    SettingsPanelAdministrator.this.checkForNotificationsYesRadio.setSelected(true);
                } else {
                    SettingsPanelAdministrator.this.checkForNotificationsNoRadio.setSelected(true);
                }
                if (this.backgroundColor != null) {
                    SettingsPanelAdministrator.this.backgroundColorCustomRadio.setSelected(true);
                    SettingsPanelAdministrator.this.backgroundColorRadioActionPerformed(false);
                    SettingsPanelAdministrator.this.backgroundColorButton.setBackground(this.backgroundColor);
                } else {
                    SettingsPanelAdministrator.this.backgroundColorServerDefaultRadio.setSelected(true);
                    SettingsPanelAdministrator.this.backgroundColorRadioActionPerformed(true);
                }
                SettingsPanelAdministrator.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
        RSTAPreferences rstaPreferences = MirthRSyntaxTextArea.getRSTAPreferences();
        this.updateShortcutKeyTable(rstaPreferences);
        this.updateRestoreKeyDefaultsButton();
        AutoCompleteProperties autoCompleteProperties = rstaPreferences.getAutoCompleteProperties();
        this.autoCompleteIncludeLettersCheckBox.setSelected(autoCompleteProperties.isActivateAfterLetters());
        this.autoCompleteCharactersField.setText(autoCompleteProperties.getActivateAfterOthers());
        this.autoCompleteDelayField.setText(String.valueOf(autoCompleteProperties.getActivationDelay()));
    }

    @Override
    public boolean doSave() {
        if (this.dashboardRefreshIntervalField.getText().length() == 0) {
            this.getFrame().alertWarning(this, "Please enter a valid interval time.");
            return false;
        }
        if (this.messageBrowserPageSizeField.getText().length() == 0) {
            this.getFrame().alertWarning(this, "Please enter a valid message browser page size.");
            return false;
        }
        if (this.eventBrowserPageSizeField.getText().length() == 0) {
            this.getFrame().alertWarning(this, "Please enter a valid event browser page size.");
            return false;
        }
        if (this.autoCompleteDelayField.isEnabled() && StringUtils.isBlank((CharSequence)this.autoCompleteDelayField.getText())) {
            this.getFrame().alertWarning(this, "Please enter a valid auto-complete activation delay.");
            return false;
        }
        int interval = Integer.parseInt(this.dashboardRefreshIntervalField.getText());
        int messageBrowserPageSize = Integer.parseInt(this.messageBrowserPageSizeField.getText());
        int eventBrowserPageSize = Integer.parseInt(this.eventBrowserPageSizeField.getText());
        if (interval <= 0) {
            this.getFrame().alertWarning(this, "Please enter an interval time that is larger than 0.");
        } else if (messageBrowserPageSize <= 0) {
            this.getFrame().alertWarning(this, "Please enter an message browser page size larger than 0.");
        } else if (eventBrowserPageSize <= 0) {
            this.getFrame().alertWarning(this, "Please enter an event browser page size larger than 0.");
        } else {
            userPreferences.putInt("intervalTime", interval);
            userPreferences.putInt("messageBrowserPageSize", messageBrowserPageSize);
            userPreferences.putInt("eventBrowserPageSize", eventBrowserPageSize);
            userPreferences.putBoolean("messageBrowserFormat", this.formatYesRadio.isSelected());
            userPreferences.putBoolean("textSearchWarning", this.textSearchWarningYesRadio.isSelected());
            userPreferences.putBoolean("multiChannelSearchWarning", this.multiChannelSearchWarningYesRadio.isSelected());
            userPreferences.putBoolean("filterTransformerShowIteratorDialog", this.filterTransformerShowIteratorYesRadio.isSelected());
            userPreferences.putBoolean("messageBrowserShowAttachmentTypeDialog", this.messageBrowserShowAttachmentTypeDialogYesRadio.isSelected());
            userPreferences.putBoolean("showReprocessRemoveMessagesWarning", this.reprocessRemoveMessagesWarningYesRadio.isSelected());
            if (this.importChannelLibrariesAskRadio.isSelected()) {
                userPreferences.remove("importChannelCodeTemplateLibraries");
            } else {
                userPreferences.putBoolean("importChannelCodeTemplateLibraries", this.importChannelLibrariesYesRadio.isSelected());
            }
            if (this.exportChannelLibrariesAskRadio.isSelected()) {
                userPreferences.remove("exportChannelCodeTemplateLibraries");
            } else {
                userPreferences.putBoolean("exportChannelCodeTemplateLibraries", this.exportChannelLibrariesYesRadio.isSelected());
            }
        }
        final Color backgroundColor = this.backgroundColorServerDefaultRadio.isSelected() ? null : this.backgroundColorButton.getBackground();
        if (backgroundColor != null) {
            this.getFrame().setupBackgroundPainters(backgroundColor);
        } else {
            this.getFrame().setupBackgroundPainters(PlatformUI.DEFAULT_BACKGROUND_COLOR);
        }
        final String workingId = this.getFrame().startWorking("Saving " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    SettingsPanelAdministrator.this.getFrame().mirthClient.setUserPreference(SettingsPanelAdministrator.this.currentUser.getId(), "checkForNotifications", Boolean.toString(SettingsPanelAdministrator.this.checkForNotificationsYesRadio.isSelected()));
                }
                catch (ClientException e) {
                    SettingsPanelAdministrator.this.getFrame().alertThrowable((Component)((Object)SettingsPanelAdministrator.this.getFrame()), e);
                }
                try {
                    SettingsPanelAdministrator.this.getFrame().mirthClient.setUserPreference(SettingsPanelAdministrator.this.currentUser.getId(), "backgroundColor", ObjectXMLSerializer.getInstance().serialize((Object)backgroundColor));
                }
                catch (ClientException e) {
                    SettingsPanelAdministrator.this.getFrame().alertThrowable((Component)((Object)SettingsPanelAdministrator.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                SettingsPanelAdministrator.this.getFrame().setSaveEnabled(false);
                SettingsPanelAdministrator.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
        RSTAPreferences rstaPreferences = MirthRSyntaxTextArea.getRSTAPreferences();
        for (int row = 0; row < this.shortcutKeyTable.getRowCount(); ++row) {
            ActionInfo actionInfo = (ActionInfo)((Object)this.shortcutKeyTable.getModel().getValueAt(row, 0));
            KeyStroke keyStroke = (KeyStroke)this.shortcutKeyTable.getModel().getValueAt(row, 3);
            rstaPreferences.getKeyStrokeMap().put(actionInfo.getActionMapKey(), keyStroke);
        }
        MirthRSyntaxTextArea.updateKeyStrokePreferences(userPreferences);
        AutoCompleteProperties autoCompleteProperties = rstaPreferences.getAutoCompleteProperties();
        autoCompleteProperties.setActivateAfterLetters(this.autoCompleteIncludeLettersCheckBox.isSelected());
        autoCompleteProperties.setActivateAfterOthers(this.autoCompleteCharactersField.getText());
        autoCompleteProperties.setActivationDelay(NumberUtils.toInt((String)this.autoCompleteDelayField.getText()));
        MirthRSyntaxTextArea.updateAutoCompletePreferences(userPreferences);
        return true;
    }

    public void doSetAdminDefaults() {
        if (!this.getFrame().alertOkCancel(this, "<html>Set Administrator Settings to defaults?<br/><br/>This will reset all of your local settings!<br/><br/>It is suggested that you restart the Administrator<br/>since some settings may not take effect until<br/>the Administrator has been reloaded.</html>")) {
            return;
        }
        try {
            String[] keys;
            for (String key : keys = userPreferences.keys()) {
                userPreferences.remove(key);
            }
        }
        catch (Exception keys) {
            // empty catch block
        }
        RSTAPreferences newRstaPreferences = new RSTAPreferences();
        MirthRSyntaxTextArea.getRSTAPreferences().setAutoCompleteProperties(newRstaPreferences.getAutoCompleteProperties());
        MirthRSyntaxTextArea.getRSTAPreferences().setFindReplaceProperties(newRstaPreferences.getFindReplaceProperties());
        MirthRSyntaxTextArea.getRSTAPreferences().setKeyStrokeMap(newRstaPreferences.getKeyStrokeMap());
        MirthRSyntaxTextArea.getRSTAPreferences().setToggleOptions(newRstaPreferences.getToggleOptions());
        MirthRSyntaxTextArea.updateAutoCompletePreferences(userPreferences);
        MirthRSyntaxTextArea.updateFindReplacePreferences(userPreferences);
        MirthRSyntaxTextArea.updateKeyStrokePreferences(userPreferences);
        MirthRSyntaxTextArea.updateToggleOptionPreferences(userPreferences);
        final String workingId = this.getFrame().startWorking("Resetting " + this.getTabName() + " settings...");
        SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() {
                try {
                    SettingsPanelAdministrator.this.getFrame().mirthClient.setUserPreference(SettingsPanelAdministrator.this.currentUser.getId(), "checkForNotifications", Boolean.toString(true));
                }
                catch (ClientException e) {
                    SettingsPanelAdministrator.this.getFrame().alertThrowable((Component)((Object)SettingsPanelAdministrator.this.getFrame()), e);
                }
                try {
                    SettingsPanelAdministrator.this.getFrame().mirthClient.setUserPreference(SettingsPanelAdministrator.this.currentUser.getId(), "backgroundColor", ObjectXMLSerializer.getInstance().serialize(null));
                }
                catch (ClientException e) {
                    SettingsPanelAdministrator.this.getFrame().alertThrowable((Component)((Object)SettingsPanelAdministrator.this.getFrame()), e);
                }
                return null;
            }

            @Override
            public void done() {
                SettingsPanelAdministrator.this.getFrame().setSaveEnabled(false);
                SettingsPanelAdministrator.this.doRefresh();
                SettingsPanelAdministrator.this.getFrame().stopWorking(workingId);
            }
        };
        worker.execute();
    }

    private void updateRestoreKeyDefaultsButton() {
        boolean isDefault = true;
        Map<String, KeyStroke> defaultKeyStrokeMap = new RSTAPreferences().getKeyStrokeMap();
        for (int row = 0; row < this.shortcutKeyTable.getRowCount(); ++row) {
            ActionInfo actionInfo = (ActionInfo)((Object)this.shortcutKeyTable.getModel().getValueAt(row, 0));
            KeyStroke keyStroke = (KeyStroke)this.shortcutKeyTable.getModel().getValueAt(row, 3);
            if (ObjectUtils.equals((Object)keyStroke, (Object)defaultKeyStrokeMap.get(actionInfo.getActionMapKey()))) continue;
            isDefault = false;
            break;
        }
        this.restoreDefaultsButton.setEnabled(!isDefault);
    }

    private void restoreShortcutKeyDefaults() {
        if (PlatformUI.MIRTH_FRAME.alertOkCancel((Component)((Object)PlatformUI.MIRTH_FRAME), "<html>This will reset all the code editor shortcut keys to their defaults.<br/>Are you sure you wish to continue?</html>")) {
            this.updateShortcutKeyTable(new RSTAPreferences());
            this.restoreDefaultsButton.setEnabled(false);
            PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
        }
    }

    private void updateShortcutKeyTable(RSTAPreferences rstaPreferences) {
        ResourceBundle resourceBundle = MirthRSyntaxTextArea.getResourceBundle();
        Object[][] data = new Object[this.shortcutKeyList.size()][4];
        int i = 0;
        for (ActionInfo actionInfo : this.shortcutKeyList) {
            data[i][0] = actionInfo;
            data[i][1] = resourceBundle.getString(actionInfo.toString() + ".Name");
            data[i][2] = resourceBundle.getString(actionInfo.toString() + ".Desc");
            data[i][3] = rstaPreferences.getKeyStrokeMap().get(actionInfo.getActionMapKey());
            ++i;
        }
        ((RefreshTableModel)this.shortcutKeyTable.getModel()).refreshDataVector(data);
    }

    private void autoCompleteActionPerformed() {
        boolean enabled = StringUtils.isNotEmpty((CharSequence)this.autoCompleteCharactersField.getText()) || this.autoCompleteIncludeLettersCheckBox.isSelected();
        this.autoCompleteDelayLabel.setEnabled(enabled);
        this.autoCompleteDelayField.setEnabled(enabled);
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.systemSettingsPanel = new JPanel();
        this.systemSettingsPanel.setBackground(this.getBackground());
        this.systemSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "System Preferences", 0, 0, new Font("Tahoma", 1, 11)));
        this.dashboardRefreshIntervalLabel = new JLabel("Dashboard refresh interval (seconds):");
        this.dashboardRefreshIntervalField = new MirthTextField();
        this.dashboardRefreshIntervalField.setToolTipText("<html>Interval in seconds at which to refresh the Dashboard. Decrement this for <br>faster updates, and increment it for slower servers with more channels.</html>");
        String toolTipText = "Sets the default page size for browsers (message, event, etc.)";
        this.messageBrowserPageSizeLabel = new JLabel("Message browser page size:");
        this.messageBrowserPageSizeField = new MirthTextField();
        this.messageBrowserPageSizeField.setToolTipText(toolTipText);
        this.eventBrowserPageSizeLabel = new JLabel("Event browser page size:");
        this.eventBrowserPageSizeField = new MirthTextField();
        this.eventBrowserPageSizeField.setToolTipText(toolTipText);
        this.formatLabel = new JLabel("Format text in message browser:");
        this.formatButtonGroup = new ButtonGroup();
        toolTipText = "Pretty print messages in the message browser.";
        this.formatYesRadio = new MirthRadioButton("Yes");
        this.formatYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.formatYesRadio.setToolTipText(toolTipText);
        this.formatButtonGroup.add(this.formatYesRadio);
        this.formatNoRadio = new MirthRadioButton("No");
        this.formatNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.formatNoRadio.setToolTipText(toolTipText);
        this.formatButtonGroup.add(this.formatNoRadio);
        this.textSearchWarningLabel = new JLabel("Message browser text search confirmation:");
        this.textSearchWarningButtonGroup = new ButtonGroup();
        toolTipText = "<html>Show a confirmation dialog in the message browser when attempting a text search, warning users<br/>that the query may take a long time depending on the amount of messages being searched.</html>";
        this.textSearchWarningYesRadio = new MirthRadioButton("Yes");
        this.textSearchWarningYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.textSearchWarningYesRadio.setToolTipText(toolTipText);
        this.textSearchWarningButtonGroup.add(this.textSearchWarningYesRadio);
        this.textSearchWarningNoRadio = new MirthRadioButton("No");
        this.textSearchWarningNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.textSearchWarningNoRadio.setToolTipText(toolTipText);
        this.textSearchWarningButtonGroup.add(this.textSearchWarningNoRadio);
        this.multiChannelSearchWarningLabel = new JLabel("Multi-channel message view confirmation:");
        this.multiChannelSearchWarningButtonGroup = new ButtonGroup();
        toolTipText = "<html>Show a confirmation dialog when attempting to view messages for multiple channels, warning users that<br/>the query may take a long time depending on the number of channels and messages being searched.</html>";
        this.multiChannelSearchWarningYesRadio = new MirthRadioButton("Yes");
        this.multiChannelSearchWarningYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.multiChannelSearchWarningYesRadio.setToolTipText(toolTipText);
        this.multiChannelSearchWarningButtonGroup.add(this.multiChannelSearchWarningYesRadio);
        this.multiChannelSearchWarningNoRadio = new MirthRadioButton("No");
        this.multiChannelSearchWarningNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.multiChannelSearchWarningNoRadio.setToolTipText(toolTipText);
        this.multiChannelSearchWarningButtonGroup.add(this.multiChannelSearchWarningNoRadio);
        this.filterTransformerShowIteratorLabel = new JLabel("Filter/Transformer Iterator dialog:");
        this.filterTransformerShowIteratorButtonGroup = new ButtonGroup();
        toolTipText = "<html>Show a confirmation dialog in the filter/transformer<br/>views when dragging and dropping elements from the<br/>message tree, asking users whether to use an Iterator.</html>";
        this.filterTransformerShowIteratorYesRadio = new MirthRadioButton("Yes");
        this.filterTransformerShowIteratorYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.filterTransformerShowIteratorYesRadio.setToolTipText(toolTipText);
        this.filterTransformerShowIteratorButtonGroup.add(this.filterTransformerShowIteratorYesRadio);
        this.filterTransformerShowIteratorNoRadio = new MirthRadioButton("No");
        this.filterTransformerShowIteratorNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.filterTransformerShowIteratorNoRadio.setToolTipText(toolTipText);
        this.filterTransformerShowIteratorButtonGroup.add(this.filterTransformerShowIteratorNoRadio);
        this.messageBrowserShowAttachmentTypeDialogLabel = new JLabel("Message browser attachment type dialog:");
        this.messageBrowserShowAttachmentTypeDialogButtonGroup = new ButtonGroup();
        toolTipText = "<html>Show a selection dialog in the message browser when viewing attachments<br/>to allow the user to select a specific attachment viewer. If No is selected,<br/>the attachment viewer will be automatically chosen from the MIME type.</html>";
        this.messageBrowserShowAttachmentTypeDialogYesRadio = new MirthRadioButton("Yes");
        this.messageBrowserShowAttachmentTypeDialogYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.messageBrowserShowAttachmentTypeDialogYesRadio.setToolTipText(toolTipText);
        this.messageBrowserShowAttachmentTypeDialogButtonGroup.add(this.messageBrowserShowAttachmentTypeDialogYesRadio);
        this.messageBrowserShowAttachmentTypeDialogNoRadio = new MirthRadioButton("No");
        this.messageBrowserShowAttachmentTypeDialogNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.messageBrowserShowAttachmentTypeDialogNoRadio.setToolTipText(toolTipText);
        this.messageBrowserShowAttachmentTypeDialogButtonGroup.add(this.messageBrowserShowAttachmentTypeDialogNoRadio);
        this.reprocessRemoveMessagesWarningLabel = new JLabel("Reprocess/remove messages confirmation:");
        ButtonGroup reprocessRemoveMessagesWarningButtonGroup = new ButtonGroup();
        toolTipText = "<html>Show a confirmation dialog in the message browser when reprocessing<br/>or removing multiple messages that forces the user to type<br/>in \"REPROCESSALL\" or \"REMOVEALL\" first before proceeding.</html>";
        this.reprocessRemoveMessagesWarningYesRadio = new MirthRadioButton("Yes");
        this.reprocessRemoveMessagesWarningYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.reprocessRemoveMessagesWarningYesRadio.setToolTipText(toolTipText);
        reprocessRemoveMessagesWarningButtonGroup.add(this.reprocessRemoveMessagesWarningYesRadio);
        this.reprocessRemoveMessagesWarningNoRadio = new MirthRadioButton("No");
        this.reprocessRemoveMessagesWarningNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.reprocessRemoveMessagesWarningNoRadio.setToolTipText(toolTipText);
        reprocessRemoveMessagesWarningButtonGroup.add(this.reprocessRemoveMessagesWarningNoRadio);
        this.importChannelLibrariesLabel = new JLabel("Import code template libraries with channels:");
        this.importChannelLibrariesButtonGroup = new ButtonGroup();
        toolTipText = "<html>When attempting to import channels that have code template<br/>libraries linked to them, select Yes to always include them,<br/>No to never include them, or Ask to prompt the user each time.</html>";
        this.importChannelLibrariesYesRadio = new MirthRadioButton("Yes");
        this.importChannelLibrariesYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.importChannelLibrariesYesRadio.setToolTipText(toolTipText);
        this.importChannelLibrariesButtonGroup.add(this.importChannelLibrariesYesRadio);
        this.importChannelLibrariesNoRadio = new MirthRadioButton("No");
        this.importChannelLibrariesNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.importChannelLibrariesNoRadio.setToolTipText(toolTipText);
        this.importChannelLibrariesButtonGroup.add(this.importChannelLibrariesNoRadio);
        this.importChannelLibrariesAskRadio = new MirthRadioButton("Ask");
        this.importChannelLibrariesAskRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.importChannelLibrariesAskRadio.setToolTipText(toolTipText);
        this.importChannelLibrariesButtonGroup.add(this.importChannelLibrariesAskRadio);
        this.exportChannelLibrariesLabel = new JLabel("Export code template libraries with channels:");
        this.exportChannelLibrariesButtonGroup = new ButtonGroup();
        toolTipText = "<html>When attempting to export channels that have code template<br/>libraries linked to them, select Yes to always include them,<br/>No to never include them, or Ask to prompt the user each time.</html>";
        this.exportChannelLibrariesYesRadio = new MirthRadioButton("Yes");
        this.exportChannelLibrariesYesRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.exportChannelLibrariesYesRadio.setToolTipText(toolTipText);
        this.exportChannelLibrariesButtonGroup.add(this.exportChannelLibrariesYesRadio);
        this.exportChannelLibrariesNoRadio = new MirthRadioButton("No");
        this.exportChannelLibrariesNoRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.exportChannelLibrariesNoRadio.setToolTipText(toolTipText);
        this.exportChannelLibrariesButtonGroup.add(this.exportChannelLibrariesNoRadio);
        this.exportChannelLibrariesAskRadio = new MirthRadioButton("Ask");
        this.exportChannelLibrariesAskRadio.setBackground(this.systemSettingsPanel.getBackground());
        this.exportChannelLibrariesAskRadio.setToolTipText(toolTipText);
        this.exportChannelLibrariesButtonGroup.add(this.exportChannelLibrariesAskRadio);
        this.userSettingsPanel = new JPanel();
        this.userSettingsPanel.setBackground(this.getBackground());
        this.userSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "User Preferences", 0, 0, new Font("Tahoma", 1, 11)));
        this.checkForNotificationsLabel = new JLabel("Check for new notifications on login:");
        this.notificationButtonGroup = new ButtonGroup();
        this.checkForNotificationsYesRadio = new MirthRadioButton("Yes");
        this.checkForNotificationsYesRadio.setBackground(this.userSettingsPanel.getBackground());
        this.checkForNotificationsYesRadio.setToolTipText("<html>Checks for notifications from NextGen Healthcare (announcements, available updates, etc.)<br/>relevant to this version of Mirth Connect whenever user logs in.</html>");
        this.notificationButtonGroup.add(this.checkForNotificationsYesRadio);
        this.checkForNotificationsNoRadio = new MirthRadioButton("No");
        this.checkForNotificationsNoRadio.setBackground(this.userSettingsPanel.getBackground());
        this.checkForNotificationsNoRadio.setToolTipText("<html>Checks for notifications from NextGen Healthcare (announcements, available updates, etc.)<br/>relevant to this version of Mirth Connect whenever user logs in.</html>");
        this.notificationButtonGroup.add(this.checkForNotificationsNoRadio);
        this.backgroundColorLabel = new JLabel("Administrator Background Color:");
        this.backgroundColorButtonGroup = new ButtonGroup();
        this.backgroundColorServerDefaultRadio = new MirthRadioButton("Server Default");
        this.backgroundColorServerDefaultRadio.setSelected(true);
        this.backgroundColorServerDefaultRadio.setBackground(this.userSettingsPanel.getBackground());
        this.backgroundColorServerDefaultRadio.setToolTipText("If selected, the server default background color will be used for the Administrator GUI.");
        this.backgroundColorServerDefaultRadio.addActionListener(e -> this.backgroundColorRadioActionPerformed(true));
        this.backgroundColorButtonGroup.add(this.backgroundColorServerDefaultRadio);
        this.backgroundColorCustomRadio = new MirthRadioButton("Custom:");
        this.backgroundColorCustomRadio.setBackground(this.userSettingsPanel.getBackground());
        this.backgroundColorCustomRadio.setToolTipText("If selected, the following custom color will be used for the Administrator GUI.");
        this.backgroundColorCustomRadio.addActionListener(e -> this.backgroundColorRadioActionPerformed(false));
        this.backgroundColorButtonGroup.add(this.backgroundColorCustomRadio);
        this.backgroundColorButton = new JButton();
        this.backgroundColorButton.setEnabled(false);
        this.backgroundColorButton.setBackground(PlatformUI.DEFAULT_BACKGROUND_COLOR);
        this.backgroundColorButton.setToolTipText("<html>The background color to use for the Administrator GUI.</html>");
        this.backgroundColorButton.setCursor(Cursor.getPredefinedCursor(12));
        this.backgroundColorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                Color color = JColorChooser.showDialog((Component)((Object)PlatformUI.MIRTH_FRAME), "Edit Background Color", SettingsPanelAdministrator.this.backgroundColorButton.getBackground());
                if (color != null) {
                    SettingsPanelAdministrator.this.backgroundColorButton.setBackground(color);
                    SettingsPanelAdministrator.this.getFrame().setSaveEnabled(true);
                }
            }
        });
        this.codeEditorSettingsPanel = new JPanel();
        this.codeEditorSettingsPanel.setBackground(this.getBackground());
        this.codeEditorSettingsPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, new Color(204, 204, 204)), "Code Editor Preferences", 0, 0, new Font("Tahoma", 1, 11)));
        toolTipText = "<html>The auto-completion popup will be triggered<br/>after any of these characters are typed.</html>";
        this.autoCompleteCharactersLabel = new JLabel("Auto-Complete Characters:");
        this.autoCompleteCharactersField = new MirthTextField();
        this.autoCompleteCharactersField.setToolTipText(toolTipText);
        this.autoCompleteCharactersField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent evt) {
                SettingsPanelAdministrator.this.autoCompleteActionPerformed();
            }

            @Override
            public void removeUpdate(DocumentEvent evt) {
                SettingsPanelAdministrator.this.autoCompleteActionPerformed();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                SettingsPanelAdministrator.this.autoCompleteActionPerformed();
            }
        });
        toolTipText = "<html>If selected, auto-completion will be<br/>triggered after any letter is typed.</html>";
        this.autoCompleteIncludeLettersCheckBox = new MirthCheckBox("Include Letters");
        this.autoCompleteIncludeLettersCheckBox.setBackground(this.codeEditorSettingsPanel.getBackground());
        this.autoCompleteIncludeLettersCheckBox.setToolTipText(toolTipText);
        this.autoCompleteIncludeLettersCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelAdministrator.this.autoCompleteActionPerformed();
            }
        });
        toolTipText = "<html>The amount of time to wait after typing<br/>an activation character before opening<br/>the auto-completion popup menu.</html>";
        this.autoCompleteDelayLabel = new JLabel("Activation Delay (ms):");
        this.autoCompleteDelayField = new MirthTextField();
        this.autoCompleteDelayField.setToolTipText(toolTipText);
        this.autoCompleteDelayField.setDocument(new MirthFieldConstraints(9, false, false, true));
        this.shortcutKeyLabel = new JLabel("Shortcut Key Mappings:");
        this.shortcutKeyTable = new MirthTable();
        this.shortcutKeyTable.setModel(new RefreshTableModel(new Object[]{"Action Info", "Name", "Description", "Shortcut Key Mapping"}, 0){

            @Override
            public boolean isCellEditable(int row, int column) {
                return column == 3;
            }
        });
        this.shortcutKeyTable.setDragEnabled(false);
        this.shortcutKeyTable.setRowSelectionAllowed(false);
        this.shortcutKeyTable.setRowHeight(20);
        this.shortcutKeyTable.setFocusable(false);
        this.shortcutKeyTable.setOpaque(true);
        this.shortcutKeyTable.setSortable(true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.shortcutKeyTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.shortcutKeyTable.getColumnModel().getColumn(1).setMinWidth(145);
        this.shortcutKeyTable.getColumnModel().getColumn(1).setPreferredWidth(145);
        this.shortcutKeyTable.getColumnModel().getColumn(2).setPreferredWidth(600);
        this.shortcutKeyTable.getColumnModel().getColumn(3).setMinWidth(120);
        this.shortcutKeyTable.getColumnModel().getColumn(3).setPreferredWidth(150);
        this.shortcutKeyTable.getColumnModel().getColumn(3).setCellRenderer(new KeyStrokeCellRenderer());
        this.shortcutKeyTable.getColumnModel().getColumn(3).setCellEditor(new KeyStrokeCellEditor());
        this.shortcutKeyTable.removeColumn(this.shortcutKeyTable.getColumnModel().getColumn(0));
        this.shortcutKeyTable.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent evt) {
                SettingsPanelAdministrator.this.updateRestoreKeyDefaultsButton();
            }
        });
        this.shortcutKeyScrollPane = new JScrollPane((Component)((Object)this.shortcutKeyTable));
        this.restoreDefaultsButton = new JButton("Restore Defaults");
        this.restoreDefaultsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SettingsPanelAdministrator.this.restoreShortcutKeyDefaults();
            }
        });
    }

    private void initLayout() {
        this.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6 6", "", "[][][][grow]"));
        this.systemSettingsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6 6", "12[]13[][grow]", ""));
        this.systemSettingsPanel.add((Component)this.dashboardRefreshIntervalLabel, "right");
        this.systemSettingsPanel.add((Component)this.dashboardRefreshIntervalField, "w 30!");
        this.systemSettingsPanel.add((Component)this.messageBrowserPageSizeLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.messageBrowserPageSizeField, "w 30!");
        this.systemSettingsPanel.add((Component)this.eventBrowserPageSizeLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.eventBrowserPageSizeField, "w 30!");
        this.systemSettingsPanel.add((Component)this.formatLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.formatYesRadio, "split");
        this.systemSettingsPanel.add(this.formatNoRadio);
        this.systemSettingsPanel.add((Component)this.textSearchWarningLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.textSearchWarningYesRadio, "split");
        this.systemSettingsPanel.add(this.textSearchWarningNoRadio);
        this.systemSettingsPanel.add((Component)this.multiChannelSearchWarningLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.multiChannelSearchWarningYesRadio, "split");
        this.systemSettingsPanel.add(this.multiChannelSearchWarningNoRadio);
        this.systemSettingsPanel.add((Component)this.filterTransformerShowIteratorLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.filterTransformerShowIteratorYesRadio, "split");
        this.systemSettingsPanel.add(this.filterTransformerShowIteratorNoRadio);
        this.systemSettingsPanel.add((Component)this.messageBrowserShowAttachmentTypeDialogLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.messageBrowserShowAttachmentTypeDialogYesRadio, "split");
        this.systemSettingsPanel.add(this.messageBrowserShowAttachmentTypeDialogNoRadio);
        this.systemSettingsPanel.add((Component)this.reprocessRemoveMessagesWarningLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.reprocessRemoveMessagesWarningYesRadio, "split");
        this.systemSettingsPanel.add(this.reprocessRemoveMessagesWarningNoRadio);
        this.systemSettingsPanel.add((Component)this.importChannelLibrariesLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.importChannelLibrariesYesRadio, "split");
        this.systemSettingsPanel.add(this.importChannelLibrariesNoRadio);
        this.systemSettingsPanel.add(this.importChannelLibrariesAskRadio);
        this.systemSettingsPanel.add((Component)this.exportChannelLibrariesLabel, "newline, right");
        this.systemSettingsPanel.add((Component)this.exportChannelLibrariesYesRadio, "split");
        this.systemSettingsPanel.add(this.exportChannelLibrariesNoRadio);
        this.systemSettingsPanel.add(this.exportChannelLibrariesAskRadio);
        this.add((Component)this.systemSettingsPanel, "grow");
        this.userSettingsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6 6", "12[]13[][grow]", ""));
        this.userSettingsPanel.add((Component)this.checkForNotificationsLabel, "right");
        this.userSettingsPanel.add((Component)this.checkForNotificationsYesRadio, "split");
        this.userSettingsPanel.add(this.checkForNotificationsNoRadio);
        this.userSettingsPanel.add((Component)this.backgroundColorLabel, "newline, right");
        this.userSettingsPanel.add((Component)this.backgroundColorServerDefaultRadio, "split 3");
        this.userSettingsPanel.add(this.backgroundColorCustomRadio);
        this.userSettingsPanel.add((Component)this.backgroundColorButton, "h 22!, w 22!");
        this.add((Component)this.userSettingsPanel, "newline, grow");
        this.codeEditorSettingsPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 6 6", "12[]13[][]", ""));
        this.codeEditorSettingsPanel.add((Component)this.autoCompleteCharactersLabel, "right");
        this.codeEditorSettingsPanel.add((Component)this.autoCompleteCharactersField, "w 50, split");
        this.codeEditorSettingsPanel.add((Component)this.autoCompleteIncludeLettersCheckBox, "gapbefore 6");
        this.codeEditorSettingsPanel.add((Component)this.autoCompleteDelayLabel, "newline, right");
        this.codeEditorSettingsPanel.add((Component)this.autoCompleteDelayField, "w 50");
        this.codeEditorSettingsPanel.add((Component)this.shortcutKeyLabel, "newline, top, right, gaptop 2");
        this.codeEditorSettingsPanel.add((Component)this.shortcutKeyScrollPane, "grow, push, h ::179");
        this.codeEditorSettingsPanel.add((Component)this.restoreDefaultsButton, "top");
        this.add((Component)this.codeEditorSettingsPanel, "newline, grow");
    }

    private void backgroundColorRadioActionPerformed(boolean serverDefault) {
        if (serverDefault) {
            this.backgroundColorButton.setBackground(PlatformUI.DEFAULT_BACKGROUND_COLOR);
            this.backgroundColorButton.setEnabled(false);
        } else {
            this.backgroundColorButton.setEnabled(true);
        }
    }

    private class KeyStrokeCellRenderer
    extends KeyStrokeTextField
    implements TableCellRenderer {
        public KeyStrokeCellRenderer() {
            this.setBorder(BorderFactory.createEmptyBorder());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setKeyStroke((KeyStroke)value);
            return this;
        }
    }

    private class KeyStrokeCellEditor
    extends DefaultCellEditor {
        private KeyStrokeTextField textField;

        public KeyStrokeCellEditor() {
            super(new KeyStrokeTextField());
            this.textField = (KeyStrokeTextField)this.getComponent();
        }

        @Override
        public Object getCellEditorValue() {
            return this.textField.getKeyStroke();
        }

        @Override
        public boolean isCellEditable(EventObject evt) {
            if (evt != null && evt instanceof MouseEvent) {
                return ((MouseEvent)evt).getClickCount() >= 2;
            }
            return false;
        }

        @Override
        public boolean stopCellEditing() {
            KeyStroke keyStroke = (KeyStroke)this.getCellEditorValue();
            if (keyStroke != null) {
                if (keyStroke.getKeyCode() >= 65 && keyStroke.getKeyCode() <= 90 && (keyStroke.getModifiers() == 0 || (keyStroke.getModifiers() & 1) > 0)) {
                    this.cancelCellEditing();
                } else {
                    for (int row = 0; row < SettingsPanelAdministrator.this.shortcutKeyTable.getRowCount(); ++row) {
                        if (!keyStroke.equals((KeyStroke)SettingsPanelAdministrator.this.shortcutKeyTable.getModel().getValueAt(row, 3))) continue;
                        this.cancelCellEditing();
                        break;
                    }
                }
            }
            return super.stopCellEditing();
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.textField.setKeyStroke((KeyStroke)value);
            return this.textField;
        }
    }
}

