/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SortOrder;
import javax.swing.UIManager;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public class SortableHeaderCellRenderer
implements TableCellRenderer {
    private Icon ascendingSortIcon = UIManager.getIcon("Table.ascendingSortIcon");
    private Icon descendingSortIcon = UIManager.getIcon("Table.descendingSortIcon");
    private Icon currentIcon;
    private int currentModelIndex = -1;
    private TableCellRenderer delegate;

    public SortableHeaderCellRenderer(TableCellRenderer delegate) {
        this.delegate = delegate;
        this.currentIcon = this.ascendingSortIcon;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component c = this.delegate.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (c instanceof JLabel) {
            JLabel label = (JLabel)c;
            if (column != -1 && this.currentModelIndex != -1 && this.currentIcon != null) {
                TableColumnModel model = table.getColumnModel();
                if (this.currentModelIndex == model.getColumn(column).getModelIndex()) {
                    label.setHorizontalTextPosition(2);
                    label.setIcon(this.currentIcon);
                } else {
                    label.setIcon(null);
                }
            }
        }
        return c;
    }

    public void setColumnIndex(int columnIndex) {
        this.currentModelIndex = columnIndex;
    }

    public void setSortingIcon(SortOrder sortOrder) {
        if (sortOrder != SortOrder.UNSORTED) {
            this.currentIcon = sortOrder == SortOrder.ASCENDING ? this.ascendingSortIcon : this.descendingSortIcon;
        }
    }
}

