/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.SortableTreeTableModel;
import javax.swing.SortOrder;
import org.jdesktop.swingx.JXTreeTable;
import org.jdesktop.swingx.treetable.TreeTableModel;

public class SortableTreeTable
extends JXTreeTable {
    private static final long serialVersionUID = 3670159528754017419L;
    private boolean started = false;
    private SortOrder order;
    private int sortColumn;
    private SortableTreeTableModel sortModel = null;
    private boolean suppress = false;

    public SortableTreeTable() {
        this.started = true;
        super.setSortable(true);
    }

    public SortableTreeTable(TreeTableModel treeModel) {
        super(treeModel);
        if (!(treeModel instanceof SortableTreeTableModel)) {
            throw new IllegalArgumentException("Model must be a SortableTreeTableModel");
        }
        this.sortModel = (SortableTreeTableModel)treeModel;
        this.addTreeExpansionListener(this.sortModel);
        this.sortModel.setTreeTable(this);
        this.started = true;
    }

    public boolean isSortable() {
        return true;
    }

    public void resetSortOrder() {
        if (this.suppress) {
            return;
        }
        this.sortModel.setSortOrder(SortOrder.UNSORTED);
    }

    public SortOrder getSortOrder(int colIndex) {
        if (!this.started || this.sortModel == null) {
            return SortOrder.UNSORTED;
        }
        this.getSortParams();
        if (colIndex != this.sortColumn) {
            return SortOrder.UNSORTED;
        }
        return this.order;
    }

    public void toggleSortOrder(int columnIndex) {
        int x = this.convertColumnIndexToModel(columnIndex);
        this.getSortParams();
        if (x == this.sortColumn) {
            this.sortModel.toggleSortOrder();
        } else {
            this.sortModel.setSortColumn(x);
        }
    }

    public void setTreeTableModel(TreeTableModel treeModel) {
        TreeTableModel m = this.getTreeTableModel();
        SortableTreeTableModel old = null;
        if (m instanceof SortableTreeTableModel) {
            old = (SortableTreeTableModel)m;
        }
        super.setTreeTableModel(treeModel);
        if (!(treeModel instanceof SortableTreeTableModel)) {
            throw new IllegalArgumentException("Model must be a SortableTreeTableModel");
        }
        this.sortModel = (SortableTreeTableModel)treeModel;
        if (old != null) {
            this.removeTreeExpansionListener(old);
        }
        this.addTreeExpansionListener(this.sortModel);
        this.sortModel.setTreeTable(this);
    }

    protected boolean isSortable(int columnIndex) {
        return true;
    }

    public void setSortOrder(int columnIndex, SortOrder sortOrder) {
        this.sortModel.setSortOptions(this.sortModel.getColumnName(columnIndex), this.order);
    }

    private void getSortParams() {
        if (this.sortModel == null) {
            throw new IllegalStateException("No TreeTable Model");
        }
        this.order = this.sortModel.getSortOrder();
        this.sortColumn = this.sortModel.getSortColumnIndex();
    }
}

