/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.model.User;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import org.apache.commons.lang3.StringUtils;

public class StatusBar
extends JPanel {
    private String timezoneText;
    private String serverTimeZone;
    private String localTimeZone;
    private long timeOffset;
    private Thread updater;
    private JProgressBar progressBar;
    private JLabel separator1Label;
    private JLabel separator2Label;
    private JLabel serverLabel;
    private JLabel statusLabel;
    private JLabel timezoneLabel;
    private JLabel workingText;

    public StatusBar(User currentUser) {
        this.initComponents();
        this.workingText.setText("");
        StringBuilder statusBarText = new StringBuilder();
        String username = currentUser != null ? currentUser.getUsername() : "";
        String userFirstName = currentUser != null ? currentUser.getFirstName() : "";
        String userLastName = currentUser != null ? currentUser.getLastName() : "";
        statusBarText.append("Connected to: ");
        if (!StringUtils.isBlank((CharSequence)PlatformUI.ENVIRONMENT_NAME)) {
            statusBarText.append(PlatformUI.ENVIRONMENT_NAME);
            if (!StringUtils.isBlank((CharSequence)PlatformUI.SERVER_NAME)) {
                statusBarText.append(" - ");
            } else {
                statusBarText.append(" | ");
            }
        }
        if (!StringUtils.isBlank((CharSequence)PlatformUI.SERVER_NAME)) {
            statusBarText.append(PlatformUI.SERVER_NAME + " | ");
        }
        statusBarText.append(PlatformUI.SERVER_URL);
        statusBarText.append(" as " + username);
        if (!StringUtils.isBlank((CharSequence)userFirstName) || !StringUtils.isBlank((CharSequence)userLastName)) {
            if (!StringUtils.isBlank((CharSequence)userFirstName)) {
                statusBarText.append(" (" + userFirstName);
                if (!StringUtils.isBlank((CharSequence)userLastName)) {
                    statusBarText.append(" " + userLastName + ")");
                } else {
                    statusBarText.append(")");
                }
            } else {
                statusBarText.append(" (" + userLastName + ")");
            }
        }
        this.serverLabel.setText(statusBarText.toString());
        this.serverLabel.setIcon(new ImageIcon(Frame.class.getResource("images/server.png")));
        this.progressBar.setEnabled(false);
        this.progressBar.setForeground(UIConstants.JX_CONTAINER_BACKGROUND_COLOR);
        this.setBorder(new BevelBorder(1));
    }

    public void shutdown() {
        if (this.updater != null && this.updater.isAlive()) {
            this.updater.interrupt();
        }
    }

    public void setWorking(boolean working) {
        this.progressBar.setIndeterminate(working);
    }

    public void setText(String text) {
        this.workingText.setText(text);
    }

    public String getText() {
        return this.workingText.getText();
    }

    public void setServerText(String serverText) {
        this.serverLabel.setText(serverText);
    }

    public String getServerText() {
        return this.serverLabel.getText();
    }

    public void setTimezoneText(String timezoneText) {
        this.timezoneText = timezoneText;
    }

    public void setServerTime(Calendar serverTime) {
        this.timeOffset = serverTime.getTimeInMillis() - Calendar.getInstance().getTimeInMillis();
        this.serverTimeZone = serverTime.getTimeZone().getID();
        this.localTimeZone = Calendar.getInstance().getTimeZone().getID();
        this.shutdown();
        this.updater = new Thread(){

            @Override
            public void run() {
                while (!Thread.currentThread().isInterrupted()) {
                    try {
                        SwingUtilities.invokeAndWait(new Runnable(){

                            @Override
                            public void run() {
                                StatusBar.this.timezoneLabel.setText(StatusBar.this.convertLocalToServerTime() + " " + StatusBar.this.timezoneText);
                            }
                        });
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (InvocationTargetException invocationTargetException) {}
                }
            }
        };
        this.updater.start();
    }

    private String convertLocalToServerTime() {
        TimeZone localTimeZone = TimeZone.getTimeZone(this.localTimeZone);
        TimeZone serverTimeZone = TimeZone.getTimeZone(this.serverTimeZone);
        Calendar calendar = Calendar.getInstance();
        calendar.add(14, (int)this.timeOffset);
        calendar.add(14, localTimeZone.getRawOffset() * -1);
        if (localTimeZone.inDaylightTime(calendar.getTime())) {
            calendar.add(14, localTimeZone.getDSTSavings() * -1);
        }
        calendar.add(14, serverTimeZone.getRawOffset());
        if (serverTimeZone.inDaylightTime(calendar.getTime())) {
            calendar.add(14, serverTimeZone.getDSTSavings());
        }
        return new SimpleDateFormat("h:mm a").format(calendar.getTime());
    }

    public void setStatusText(String statusText) {
        if (StringUtils.isEmpty((CharSequence)statusText)) {
            this.separator2Label.setText("");
            this.statusLabel.setText("");
        } else {
            this.separator2Label.setText("|");
            this.statusLabel.setText(statusText);
        }
    }

    public String getStatusText() {
        return this.statusLabel.getText();
    }

    private void initComponents() {
        this.serverLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.workingText = new JLabel();
        this.separator1Label = new JLabel();
        this.timezoneLabel = new JLabel();
        this.separator2Label = new JLabel();
        this.statusLabel = new JLabel();
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.serverLabel.setText("server");
        this.progressBar.setDoubleBuffered(true);
        this.workingText.setHorizontalAlignment(4);
        this.workingText.setText("jLabel1");
        this.separator1Label.setText("|");
        this.timezoneLabel.setText("TZ");
        this.separator2Label.setText("|");
        this.statusLabel.setText("status");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.serverLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator1Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.timezoneLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.separator2Label).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 136, Short.MAX_VALUE).addComponent(this.workingText).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.progressBar, -2, 90, -2).addGap(8, 8, 8)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverLabel).addComponent(this.workingText).addComponent(this.separator1Label).addComponent(this.timezoneLabel).addComponent(this.separator2Label).addComponent(this.statusLabel)).addGroup(layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.progressBar, -2, 9, -2)));
    }
}

