/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.AbstractDashboardTableNode;
import com.mirth.connect.client.ui.ChannelTableNode;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.tag.ChannelTagLabelCache;
import com.mirth.connect.model.ChannelTag;
import com.mirth.connect.model.DashboardStatus;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;

public class TagTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private static final int GAP = 4;
    private JLabel label;
    private JPanel tagPanel;
    private Dimension screenSize;
    private boolean renderTags = false;
    private boolean tagTextMode = false;

    public TagTreeCellRenderer(boolean renderTags, boolean tagTextMode) {
        super((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill, gap 4"));
        this.renderTags = renderTags;
        this.tagTextMode = tagTextMode;
        this.setOpaque(false);
        this.label = new JLabel();
        this.label.setOpaque(false);
        this.add(this.label);
        this.tagPanel = new JPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, gap 4"));
        this.tagPanel.setOpaque(false);
        this.add((Component)this.tagPanel, "growx, pushx");
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.screenSize == null) {
            this.screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        }
        return new Dimension(size.width + this.screenSize.width, size.height);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Point p = event.getPoint();
        p.translate((int)(-this.label.getPreferredSize().getWidth()) - 4, 0);
        int tagLocX = 0;
        for (Component tagComp : this.tagPanel.getComponents()) {
            JLabel tagLabel = (JLabel)tagComp;
            Icon tagIcon = tagLabel.getIcon();
            if (tagIcon == null) continue;
            if (p.x >= tagLocX && p.x < tagLocX + tagIcon.getIconWidth() && p.y >= 0 && p.y < tagIcon.getIconHeight()) {
                return tagLabel.getToolTipText();
            }
            tagLocX += tagIcon.getIconWidth();
        }
        return null;
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String name = "";
        String channelId = "";
        ImageIcon icon = UIConstants.ICON_CHANNEL;
        boolean channel = false;
        if (value instanceof AbstractDashboardTableNode) {
            node = (AbstractDashboardTableNode)((Object)value);
            if (((AbstractDashboardTableNode)node).isGroupNode()) {
                name = ((AbstractDashboardTableNode)node).getGroupStatus().getGroup().getName();
                icon = UIConstants.ICON_GROUP;
            } else {
                DashboardStatus status = ((AbstractDashboardTableNode)node).getDashboardStatus();
                name = status.getName();
                channelId = status.getChannelId();
                if (status.getStatusType() == DashboardStatus.StatusType.CHANNEL) {
                    icon = UIConstants.ICON_CHANNEL;
                    channel = true;
                }
            }
        } else if (value instanceof ChannelTableNode) {
            node = (ChannelTableNode)((Object)value);
            if (((ChannelTableNode)node).isGroupNode()) {
                name = ((ChannelTableNode)node).getGroupStatus().getGroup().getName();
                icon = UIConstants.ICON_GROUP;
            } else {
                name = ((ChannelTableNode)node).getChannelStatus().getChannel().getName();
                channelId = ((ChannelTableNode)node).getChannelStatus().getChannel().getId();
                channel = true;
            }
        }
        this.label.setIcon(icon);
        this.label.setText(name);
        this.tagPanel.removeAll();
        if (this.renderTags && channel) {
            ArrayList<ChannelTag> tags = new ArrayList<ChannelTag>();
            for (ChannelTag tag : PlatformUI.MIRTH_FRAME.getCachedChannelTags()) {
                if (!tag.getChannelIds().contains(channelId)) continue;
                tags.add(tag);
            }
            if (CollectionUtils.isNotEmpty(tags)) {
                tags.sort(new Comparator<ChannelTag>(){

                    @Override
                    public int compare(ChannelTag tag1, ChannelTag tag2) {
                        return tag1.getName().compareToIgnoreCase(tag2.getName());
                    }
                });
                String constraints = this.tagTextMode ? "h 16!, growx" : "";
                for (ChannelTag tag : tags) {
                    this.tagPanel.add((Component)ChannelTagLabelCache.getInstance().getLabel(tag, this.tagTextMode), constraints);
                }
            }
        }
        return this;
    }
}

