/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public abstract class TextFieldCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    private JTextField textField = new JTextField();
    private String originalValue;
    private Frame parent = PlatformUI.MIRTH_FRAME;

    protected abstract boolean valueChanged(String var1);

    public TextFieldCellEditor() {
        this.textField.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                TextFieldCellEditor.this.textField.setCaretPosition(TextFieldCellEditor.this.textField.getText().length());
            }

            @Override
            public void focusLost(FocusEvent arg0) {
            }
        });
    }

    @Override
    public boolean stopCellEditing() {
        String s = (String)this.getCellEditorValue();
        if (!this.valueChanged(s)) {
            super.cancelCellEditing();
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.getTextField().getText();
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setOriginalValue((String)value);
        this.getTextField().setText((String)value);
        return this.getTextField();
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        if (evt == null) {
            return false;
        }
        if (evt instanceof MouseEvent) {
            return ((MouseEvent)evt).getClickCount() >= 2;
        }
        return true;
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public String getOriginalValue() {
        return this.originalValue;
    }

    public void setOriginalValue(String originalValue) {
        this.originalValue = originalValue;
    }

    public Frame getParent() {
        return this.parent;
    }
}

