/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.mirth.connect.client.core.Client;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.TreeTransferable;
import com.mirth.connect.client.ui.components.MirthTree;
import com.mirth.connect.client.ui.components.MirthTreeNode;
import com.mirth.connect.client.ui.editors.BaseEditorPane;
import com.mirth.connect.donkey.model.message.SerializationType;
import com.mirth.connect.model.converters.IMessageSerializer;
import com.mirth.connect.model.datatype.DataTypeProperties;
import com.mirth.connect.model.util.MessageVocabulary;
import com.mirth.connect.model.util.MessageVocabularyFactory;
import com.mirth.connect.plugins.DataTypeClientPlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Insets;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.TransferHandler;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class TreePanel
extends JPanel {
    private static final String EMPTY = "[empty]";
    private String version = "";
    private String type = "";
    private Logger logger = LogManager.getLogger(this.getClass());
    private BaseEditorPane<?, ?> editorPane;
    private String _dropPrefix;
    private String _dropSuffix;
    private String messageName;
    private MessageVocabulary vocabulary;
    private Timer timer;
    private JPopupMenu popupMenu;
    private JMenuItem popupMenuExpand;
    private JMenuItem popupMenuCollapse;
    private JMenuItem popupMenuMapToVariable;
    private JMenuItem popupMenuMapSegmentFilter;
    private JMenuItem popupMenuMapSegment;
    private JMenuItem popupMenuFilterSegment;
    private String lastWorkingId = null;
    private JCheckBox exact;
    private JTextField filterTextBox;
    private JLabel jLabel1;
    private MirthTree tree;
    private JScrollPane treePane;

    public TreePanel(BaseEditorPane<?, ?> editorPane) {
        this(editorPane, null, null);
    }

    public TreePanel(BaseEditorPane<?, ?> editorPane, String prefix, String suffix) {
        this.editorPane = editorPane;
        this._dropPrefix = prefix;
        this._dropSuffix = suffix;
        this.setup();
    }

    public void setup() {
        this.initComponents();
        this.filterTextBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                TreePanel.this.filterActionPerformed();
            }

            @Override
            public void keyTyped(KeyEvent e) {
            }
        });
        this.exact.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePanel.this.filterActionPerformed();
            }
        });
    }

    private void recursivelyExpandChildren(MirthTreeNode tn) {
        this.tree.expandPath(new TreePath(tn.getPath()));
        Enumeration<TreeNode> children = tn.children();
        while (children.hasMoreElements()) {
            MirthTreeNode child = (MirthTreeNode)children.nextElement();
            if (child.getChildCount() > 0) {
                this.recursivelyExpandChildren(child);
            }
            this.tree.expandPath(new TreePath(child.getPath()));
        }
    }

    private void recursivelyCollapseChildren(MirthTreeNode tn) {
        Enumeration<TreeNode> children = tn.children();
        while (children.hasMoreElements()) {
            MirthTreeNode child = (MirthTreeNode)children.nextElement();
            if (child.getChildCount() > 0) {
                this.recursivelyCollapseChildren(child);
            }
            this.tree.collapsePath(new TreePath(child.getPath()));
        }
    }

    public void setPrefix(String prefix) {
        this._dropPrefix = prefix;
    }

    public void setSuffix(String suffix) {
        this._dropSuffix = suffix;
    }

    public void setupPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenuExpand = new JMenuItem("Expand");
        this.popupMenuExpand.setIcon(new ImageIcon(this.getClass().getResource("images/add.png")));
        this.popupMenuExpand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirthTreeNode tn;
                if (TreePanel.this.tree.getSelectionPath() != null) {
                    TreePath tp = TreePanel.this.tree.getSelectionPath();
                    tn = (MirthTreeNode)tp.getLastPathComponent();
                } else {
                    tn = (MirthTreeNode)TreePanel.this.tree.getModel().getRoot();
                }
                if (!tn.isLeaf()) {
                    TreePanel.this.recursivelyExpandChildren(tn);
                    TreePanel.this.tree.expandPath(new TreePath(tn.getPath()));
                }
            }
        });
        this.popupMenu.add(this.popupMenuExpand);
        this.popupMenuCollapse = new JMenuItem("Collapse");
        this.popupMenuCollapse.setIcon(new ImageIcon(this.getClass().getResource("images/delete.png")));
        this.popupMenuCollapse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MirthTreeNode tn;
                if (TreePanel.this.tree.getSelectionPath() != null) {
                    TreePath tp = TreePanel.this.tree.getSelectionPath();
                    tn = (MirthTreeNode)tp.getLastPathComponent();
                } else {
                    tn = (MirthTreeNode)TreePanel.this.tree.getModel().getRoot();
                }
                if (!tn.isLeaf()) {
                    TreePanel.this.recursivelyCollapseChildren(tn);
                    TreePanel.this.tree.collapsePath(new TreePath(tn.getPath()));
                }
            }
        });
        this.popupMenu.add(this.popupMenuCollapse);
        this.popupMenu.addSeparator();
        if (this._dropPrefix.equals("msg")) {
            this.popupMenuMapToVariable = new JMenuItem("Map to Variable");
            this.popupMenuMapToVariable.setIcon(new ImageIcon(this.getClass().getResource("images/book_previous.png")));
            this.popupMenuMapToVariable.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath path = TreePanel.this.tree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    TreeNode tp = (TreeNode)path.getLastPathComponent();
                    if (tp == null) {
                        return;
                    }
                    String variable = MirthTree.constructVariable(tp);
                    PlatformUI.MIRTH_FRAME.channelEditPanel.transformerPane.addNewElement(variable, variable, MirthTree.constructPath(tp, TreePanel.this.tree.getPrefix(), TreePanel.this.tree.getSuffix()).toString(), "Mapper", true);
                }
            });
            this.popupMenu.add(this.popupMenuMapToVariable);
            this.popupMenuMapSegment = new JMenuItem("Map to Message");
            this.popupMenuMapSegment.setIcon(new ImageIcon(this.getClass().getResource("images/book_next.png")));
            this.popupMenuMapSegment.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath path = TreePanel.this.tree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    TreeNode tp = (TreeNode)path.getLastPathComponent();
                    if (tp == null) {
                        return;
                    }
                    PlatformUI.MIRTH_FRAME.channelEditPanel.transformerPane.addNewElement(MirthTree.constructMessageBuilderStepName(null, tp), MirthTree.constructPath(tp, TreePanel.this.tree.getPrefix(), "").toString(), "", "Message Builder", true);
                }
            });
            this.popupMenu.add(this.popupMenuMapSegment);
        } else if (this._dropPrefix.equals("tmp")) {
            this.popupMenuMapSegmentFilter = new JMenuItem("Map to Message");
            this.popupMenuMapSegmentFilter.setIcon(new ImageIcon(this.getClass().getResource("images/book_next.png")));
            this.popupMenuMapSegmentFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TreePath path = TreePanel.this.tree.getSelectionPath();
                    if (path == null) {
                        return;
                    }
                    TreeNode tp = (TreeNode)path.getLastPathComponent();
                    if (tp == null) {
                        return;
                    }
                    PlatformUI.MIRTH_FRAME.channelEditPanel.transformerPane.addNewElement(MirthTree.constructMessageBuilderStepName(null, tp), MirthTree.constructPath(tp, TreePanel.this.tree.getPrefix(), TreePanel.this.tree.getSuffix()).toString(), "", "Message Builder", true);
                }
            });
            this.popupMenu.add(this.popupMenuMapSegmentFilter);
        }
        this.popupMenuFilterSegment = new JMenuItem("Filter by Value");
        this.popupMenuFilterSegment.setIcon(new ImageIcon(this.getClass().getResource("images/book_previous.png")));
        this.popupMenuFilterSegment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TreePath path = TreePanel.this.tree.getSelectionPath();
                if (path == null) {
                    return;
                }
                TreeNode tp = (TreeNode)path.getLastPathComponent();
                if (tp == null) {
                    return;
                }
                PlatformUI.MIRTH_FRAME.channelEditPanel.filterPane.addNewElement("", MirthTree.constructNodeDescription(tp), MirthTree.constructPath(tp, TreePanel.this.tree.getPrefix(), TreePanel.this.tree.getSuffix()).toString(), "Rule Builder", true);
            }
        });
        this.popupMenu.add(this.popupMenuFilterSegment);
    }

    public void setFilterView() {
        this.toggleMenuComponent(this.popupMenuMapToVariable, false);
        this.toggleMenuComponent(this.popupMenuFilterSegment, true);
        this.toggleMenuComponent(this.popupMenuMapSegment, false);
    }

    public void setTransformerView() {
        this.toggleMenuComponent(this.popupMenuFilterSegment, false);
        this.toggleMenuComponent(this.popupMenuMapSegment, true);
        this.toggleMenuComponent(this.popupMenuMapToVariable, true);
    }

    private void toggleMenuComponent(Component component, boolean show) {
        int index = this.popupMenu.getComponentIndex(component);
        if (index >= 0) {
            this.popupMenu.getComponent(index).setVisible(show);
        }
    }

    public void setBorderText(String text) {
    }

    public void filterActionPerformed() {
        class FilterTimer
        extends TimerTask {
            FilterTimer() {
            }

            @Override
            public void run() {
                TreePanel.this.filter();
            }
        }
        if (this.timer == null) {
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new FilterTimer(), 1000L);
        } else {
            this.timer.cancel();
            PlatformUI.MIRTH_FRAME.stopWorking(this.lastWorkingId);
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new FilterTimer(), 1000L);
        }
    }

    public void filter() {
        String workingId;
        this.lastWorkingId = workingId = PlatformUI.MIRTH_FRAME.startWorking("Filtering...");
        MirthTree.FilterTreeModel model = (MirthTree.FilterTreeModel)this.tree.getModel();
        if (this.filterTextBox.getText().length() > 0) {
            model.setFiltered(true);
        } else {
            model.setFiltered(false);
        }
        model.performFilter(model.getRoot(), this.filterTextBox.getText(), this.exact.isSelected(), false);
        model.updateTreeStructure();
        if (this.filterTextBox.getText().length() > 0) {
            this.tree.expandAll();
        }
        PlatformUI.MIRTH_FRAME.stopWorking(workingId);
    }

    public void setMessage(DataTypeProperties dataTypeProperties, String messageType, String source, String ignoreText) {
        Document xmlDoc = null;
        DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
        try {
            docFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        }
        catch (ParserConfigurationException e) {
            this.logger.error("Could not disable doctype declaration ", (Throwable)e);
        }
        JsonNode jsonDoc = null;
        this.messageName = "";
        this.version = "";
        this.type = "";
        String messageDescription = "";
        String dataType = null;
        if (source.length() > 0 && !source.equals(ignoreText)) {
            if (!PlatformUI.MIRTH_FRAME.displayNameToDataType.containsKey(messageType)) {
                this.logger.error("Invalid data type");
                return;
            }
            dataType = PlatformUI.MIRTH_FRAME.displayNameToDataType.get(messageType);
            DataTypeClientPlugin clientPlugin = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType);
            SerializationType serializationType = null;
            if (dataTypeProperties != null && dataTypeProperties.getSerializationProperties() != null) {
                serializationType = dataTypeProperties.getSerializationProperties().getSerializationType();
            }
            if (serializationType == null) {
                serializationType = clientPlugin.getDefaultSerializationType();
            }
            switch (serializationType) {
                case JSON: {
                    try {
                        IMessageSerializer serializer = clientPlugin.getSerializer(dataTypeProperties.getSerializerProperties());
                        Map metadata = serializer.getMetaDataFromMessage(source);
                        this.type = metadata.get("message_type") != null ? ((String)metadata.get("message_type")).trim() : "Unknown type";
                        this.messageName = this.type;
                        ObjectMapper mapper = new ObjectMapper();
                        String message = clientPlugin.isBinary() ? source : serializer.toJSON(source);
                        jsonDoc = mapper.readTree(message);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (jsonDoc != null) {
                        boolean documentIsArray = false;
                        if (jsonDoc.isArray()) {
                            documentIsArray = true;
                        }
                        MirthTreeNode top = this.processJsonElement(dataType, this.messageName, jsonDoc, null, documentIsArray);
                        this.createTree(top);
                        this.filter();
                        break;
                    }
                    this.setInvalidMessage(messageType);
                    break;
                }
                case XML: {
                    try {
                        IMessageSerializer serializer = clientPlugin.getSerializer(dataTypeProperties.getSerializerProperties());
                        Map metadata = serializer.getMetaDataFromMessage(source);
                        this.version = metadata.get("mirth_version") != null ? ((String)metadata.get("mirth_version")).trim() : "Unknown version";
                        this.type = metadata.get("message_type") != null ? ((String)metadata.get("message_type")).trim() : "Unknown type";
                        this.messageName = this.type + " (" + this.version + ")";
                        HashMap<String, Class<? extends MessageVocabulary>> vocabs = new HashMap<String, Class<? extends MessageVocabulary>>();
                        for (DataTypeClientPlugin dataTypePlugin : LoadedExtensions.getInstance().getDataTypePlugins().values()) {
                            Class<? extends MessageVocabulary> vocabulary = dataTypePlugin.getVocabulary();
                            if (vocabulary == null) continue;
                            vocabs.put(dataTypePlugin.getPluginPointName(), vocabulary);
                        }
                        this.vocabulary = MessageVocabularyFactory.getInstance((Client)PlatformUI.MIRTH_FRAME.mirthClient, vocabs).getVocabulary(dataType, this.version, this.type);
                        messageDescription = this.vocabulary.getDescription(this.type.replaceAll("-", ""));
                        DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                        String message = clientPlugin.isBinary() ? source : serializer.toXML(source);
                        xmlDoc = docBuilder.parse(new InputSource(new StringReader(message)));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (xmlDoc != null) {
                        Element element = xmlDoc.getDocumentElement();
                        MirthTreeNode top = messageDescription.length() > 0 ? new MirthTreeNode(this.messageName + " (" + messageDescription + ")") : new MirthTreeNode(this.messageName);
                        this.processAttributes(element, top);
                        NodeList children = element.getChildNodes();
                        for (int i = 0; i < children.getLength(); ++i) {
                            this.processXmlElement(dataType, children.item(i), top);
                        }
                        this.createTree(top);
                        this.filter();
                        break;
                    }
                    this.setInvalidMessage(messageType);
                    break;
                }
                case RAW: {
                    MirthTreeNode top = new MirthTreeNode("Raw Data.");
                    this.createTree(top);
                    this.filter();
                }
            }
        } else {
            this.clearMessage();
        }
    }

    private void showTreePopupMenu(MouseEvent evt) {
        if (evt.isPopupTrigger()) {
            int row = this.tree.getRowForLocation(evt.getX(), evt.getY());
            this.tree.setSelectionRow(row);
            this.popupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void createTree(MirthTreeNode top) {
        this.tree = new MirthTree(top, this._dropPrefix, this._dropSuffix);
        this.tree.setDragEnabled(true);
        this.tree.setTransferHandler(new TreeTransferHandler());
        this.tree.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                TreePath tp;
                TreeNode tn;
                if (TreePanel.this.tree.getSelectionPath() != null && (tn = (TreeNode)(tp = TreePanel.this.tree.getSelectionPath()).getLastPathComponent()).isLeaf()) {
                    PlatformUI.MIRTH_FRAME.updateAcceleratorKeyPressed(evt);
                }
            }

            @Override
            public void mouseMoved(MouseEvent evt) {
                int row = TreePanel.this.tree.getRowForLocation(evt.getPoint().x, evt.getPoint().y);
                if (!TreePanel.this.popupMenu.isShowing() && row >= 0 && row < TreePanel.this.tree.getRowCount()) {
                    TreePanel.this.tree.setSelectionRow(row);
                }
            }
        });
        this.tree.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (!TreePanel.this.popupMenu.isShowing()) {
                    TreePanel.this.tree.clearSelection();
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                TreePanel.this.showTreePopupMenu(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TreePanel.this.showTreePopupMenu(e);
            }
        });
        try {
            this.tree.setScrollsOnExpand(true);
            this.treePane.setViewportView((Component)((Object)this.tree));
            this.tree.revalidate();
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        PlatformUI.MIRTH_FRAME.setCursor(Cursor.getPredefinedCursor(0));
    }

    private MirthTreeNode processJsonElement(String dataType, String fieldName, JsonNode element, MirthTreeNode mtn, boolean parentIsArray) {
        MirthTreeNode currentNode = new MirthTreeNode(fieldName);
        currentNode.setSerializationType(SerializationType.JSON);
        if (parentIsArray) {
            currentNode.setArrayElement(true);
        }
        if (element.isArray()) {
            ArrayNode arrNode = (ArrayNode)element;
            currentNode.setJSONType(MirthTreeNode.JSONType.ARRAY);
            MirthTreeNode childNode = new MirthTreeNode("");
            childNode.setSerializationType(SerializationType.JSON);
            childNode.setArrayElement(true);
            currentNode.add(childNode);
            if (arrNode.get(0) == null) {
                childNode.setUserObject(EMPTY);
            } else {
                childNode.setUserObject(fieldName);
                for (int i = 0; i < arrNode.size(); ++i) {
                    String arrDescription = "[" + i + "]";
                    if (!parentIsArray) {
                        arrDescription = fieldName + " " + arrDescription;
                    }
                    this.processJsonElement(dataType, arrDescription, arrNode.get(i), currentNode, true);
                }
            }
        } else {
            MirthTreeNode childNode = element.isValueNode() ? new MirthTreeNode(element.toString()) : (element.isContainerNode() && element.size() > 0 ? new MirthTreeNode(fieldName) : new MirthTreeNode(EMPTY));
            if (element.isObject()) {
                currentNode.setJSONType(MirthTreeNode.JSONType.OBJECT);
            }
            childNode.setSerializationType(SerializationType.JSON);
            currentNode.add(childNode);
            Iterator children = element.fields();
            while (children.hasNext()) {
                Map.Entry child = (Map.Entry)children.next();
                this.processJsonElement(dataType, (String)child.getKey(), (JsonNode)child.getValue(), currentNode, false);
            }
        }
        if (mtn != null) {
            mtn.setSerializationType(SerializationType.JSON);
            mtn.add(currentNode);
        }
        return currentNode;
    }

    private void processXmlElement(String dataType, Object elo, MirthTreeNode mtn) {
        if (elo instanceof Element) {
            Element element = (Element)elo;
            MirthTreeNode currentNode = new MirthTreeNode(LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getNodeText(this.vocabulary, element.getNodeName()));
            String text = "";
            if (element.hasChildNodes()) {
                text = element.getFirstChild().getNodeValue();
                if (text == null || text.equals("") || text.trim().length() == 0) {
                    currentNode.add(new MirthTreeNode(element.getNodeName()));
                } else {
                    currentNode.add(new MirthTreeNode(text));
                }
            } else {
                int minLevel = LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getMinTreeLevel();
                if (minLevel > 0) {
                    Object regex = ".*";
                    for (int i = 0; i < minLevel; ++i) {
                        regex = (String)regex + "\\..*";
                    }
                    if (!element.getNodeName().matches((String)regex)) {
                        currentNode.add(new MirthTreeNode(element.getNodeName()));
                        String newNodeName = element.getNodeName() + ".1";
                        String description = this.vocabulary.getDescription(newNodeName);
                        MirthTreeNode parentNode = description != null && description.length() > 0 ? new MirthTreeNode(newNodeName + " (" + description + ")") : new MirthTreeNode(newNodeName);
                        parentNode.add(new MirthTreeNode(EMPTY));
                        currentNode.add(parentNode);
                    } else {
                        currentNode.add(new MirthTreeNode(EMPTY));
                    }
                } else {
                    currentNode.add(new MirthTreeNode(EMPTY));
                }
            }
            this.processAttributes(element, currentNode);
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                this.processXmlElement(dataType, children.item(i), currentNode);
            }
            mtn.add(currentNode);
        }
    }

    private void processAttributes(Element el, MirthTreeNode dmtn) {
        NamedNodeMap atts = el.getAttributes();
        for (int i = 0; i < atts.getLength(); ++i) {
            Attr att = (Attr)atts.item(i);
            MirthTreeNode attNode = new MirthTreeNode("@" + att.getName());
            attNode.add(new MirthTreeNode(att.getValue()));
            dmtn.add(attNode);
        }
    }

    public void clearMessage() {
        MirthTreeNode top = new MirthTreeNode("Enter a message template.");
        MirthTree tree = new MirthTree(top, this._dropPrefix, this._dropSuffix);
        this.treePane.setViewportView((Component)((Object)tree));
        this.revalidate();
    }

    public void setInvalidMessage(String messageType) {
        MirthTreeNode top = new MirthTreeNode("Template is not valid " + messageType + ".");
        MirthTree tree = new MirthTree(top, this._dropPrefix, this._dropSuffix);
        this.treePane.setViewportView((Component)((Object)tree));
        this.revalidate();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.filterTextBox = new JTextField();
        this.treePane = new JScrollPane();
        this.tree = new MirthTree();
        this.exact = new JCheckBox();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 1, 1, 1), "Message Tree", 0, 0, new Font("Tahoma", 1, 11)));
        this.jLabel1.setText("Filter:");
        this.treePane.setViewportView((Component)((Object)this.tree));
        this.exact.setBackground(new Color(255, 255, 255));
        this.exact.setText("Match Exact");
        this.exact.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.exact.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.treePane, -1, 163, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.filterTextBox, -1, 48, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exact))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.filterTextBox, -2, -1, -2).addComponent(this.exact)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.treePane, -1, 133, Short.MAX_VALUE).addContainerGap()));
    }

    public class TreeTransferHandler
    extends TransferHandler {
        @Override
        protected Transferable createTransferable(JComponent c) {
            if (c != null) {
                try {
                    TreePath path = ((MirthTree)((Object)c)).getSelectionPath();
                    if (path == null) {
                        return null;
                    }
                    TreeNode tp = (TreeNode)path.getLastPathComponent();
                    if (tp == null) {
                        return null;
                    }
                    if (!tp.isLeaf()) {
                        return null;
                    }
                    if (TreePanel.this._dropPrefix.equals("msg")) {
                        return new TreeTransferable(TreePanel.this.editorPane, tp, TreePanel.this._dropPrefix, TreePanel.this._dropSuffix, TreeTransferable.MAPPER_DATA_FLAVOR);
                    }
                    return new TreeTransferable(TreePanel.this.editorPane, tp, TreePanel.this._dropPrefix, TreePanel.this._dropSuffix, TreeTransferable.MESSAGE_BUILDER_DATA_FLAVOR);
                }
                catch (ClassCastException cce) {
                    return null;
                }
            }
            return null;
        }

        @Override
        public int getSourceActions(JComponent c) {
            return 1;
        }

        @Override
        public boolean canImport(JComponent c, DataFlavor[] df) {
            return false;
        }
    }
}

