/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.MapperDropData;
import com.mirth.connect.client.ui.MessageBuilderDropData;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RuleDropData;
import com.mirth.connect.client.ui.components.MirthTree;
import com.mirth.connect.client.ui.editors.BaseEditorPane;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import javax.swing.tree.TreeNode;

public class TreeTransferable
implements Transferable {
    public static final DataFlavor MAPPER_DATA_FLAVOR = new DataFlavor(MapperDropData.class, "MapperDropData");
    public static final DataFlavor MESSAGE_BUILDER_DATA_FLAVOR = new DataFlavor(MessageBuilderDropData.class, "MessageBuilderDropData");
    public static final DataFlavor RULE_DATA_FLAVOR = new DataFlavor(RuleDropData.class, "RuleDropData");
    private static DataFlavor[] flavors = null;
    private BaseEditorPane<?, ?> editorPane;
    private TreeNode data = null;
    private String prefix = "msg";
    private String suffix = ".toString()";

    public TreeTransferable(BaseEditorPane<?, ?> editorPane, TreeNode data, String prefix, String suffix, DataFlavor supportedDropFlavor) {
        this.editorPane = editorPane;
        this.data = data;
        this.prefix = prefix;
        this.suffix = suffix;
        this.init(supportedDropFlavor);
    }

    private void init(DataFlavor supportedDropFlavor) {
        try {
            flavors = new DataFlavor[3];
            TreeTransferable.flavors[0] = DataFlavor.stringFlavor;
            TreeTransferable.flavors[1] = supportedDropFlavor;
            TreeTransferable.flavors[2] = RULE_DATA_FLAVOR;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object getTransferData(DataFlavor df) {
        if (df == null) {
            return null;
        }
        if (this.data != null) {
            if (df == flavors[0]) {
                return this.editorPane.replaceIteratorVariables(MirthTree.constructPath(this.data.getParent(), this.prefix, PlatformUI.MIRTH_FRAME.isAcceleratorKeyPressed() ? "" : this.suffix).toString());
            }
            if (df == flavors[1]) {
                if (this.prefix.equals("msg")) {
                    return new MapperDropData(this.data, MirthTree.constructVariable(this.data.getParent()), MirthTree.constructPath(this.data.getParent(), this.prefix, this.suffix).toString());
                }
                return new MessageBuilderDropData(this.data, MirthTree.constructPath(this.data.getParent(), this.prefix, this.suffix).toString(), "");
            }
            if (df == flavors[2]) {
                return new RuleDropData(this.data, MirthTree.constructPath(this.data.getParent(), this.prefix, this.suffix).toString());
            }
        }
        return null;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor df) {
        if (df == null) {
            return false;
        }
        for (int i = 0; i < flavors.length; ++i) {
            if (!df.equals(flavors[i])) continue;
            return true;
        }
        return false;
    }
}

