/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui;

import com.mirth.connect.client.ui.VariableTransferable;
import com.mirth.connect.client.ui.panels.reference.ReferenceTable;
import com.mirth.connect.model.Connector;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jdesktop.swingx.JXList;

public class VariableListHandler
extends TransferHandler {
    private TransferMode transferMode;
    private Map<String, Integer> metaDataMap = new HashMap<String, Integer>();
    private static Map<String, String> staticJsReferences;
    private static Map<String, String> staticVelocityReferences;

    public VariableListHandler(TransferMode transferMode) {
        this(transferMode, null);
    }

    public VariableListHandler(TransferMode transferMode, List<Connector> connectors) {
        this.transferMode = transferMode;
        this.populateConnectors(connectors);
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
    }

    public void populateConnectors(List<Connector> connectors) {
        if (connectors != null) {
            for (Connector connector : connectors) {
                this.metaDataMap.put(connector.getName(), connector.getMetaDataId());
            }
        }
    }

    @Override
    protected Transferable createTransferable(JComponent c) {
        try {
            String text = "";
            if (c instanceof JXList) {
                JXList list = (JXList)c;
                if (list == null) {
                    return null;
                }
                text = (String)list.getSelectedValue();
            } else if (c instanceof ReferenceTable) {
                ReferenceTable reftable = (ReferenceTable)((Object)c);
                if (reftable == null) {
                    return null;
                }
                int currRow = reftable.getSelectedRow();
                if (currRow >= 0 && currRow < reftable.getRowCount()) {
                    text = (String)reftable.getValueAt(currRow, 0);
                }
            }
            if (text != null) {
                if (this.transferMode == TransferMode.VELOCITY && staticVelocityReferences.containsKey(text)) {
                    return new VariableTransferable(staticVelocityReferences.get(text), TransferMode.RAW, this.metaDataMap);
                }
                if (this.transferMode == TransferMode.JAVASCRIPT && staticJsReferences.containsKey(text)) {
                    return new VariableTransferable(staticJsReferences.get(text), TransferMode.RAW, this.metaDataMap);
                }
                return new VariableTransferable(text, this.transferMode, this.metaDataMap);
            }
            return null;
        }
        catch (ClassCastException cce) {
            return null;
        }
    }

    @Override
    public int getSourceActions(JComponent c) {
        return 1;
    }

    @Override
    public boolean canImport(JComponent c, DataFlavor[] df) {
        return false;
    }

    static {
        staticVelocityReferences = new HashMap<String, String>();
        staticVelocityReferences.put("Raw Data", "${message.rawData}");
        staticVelocityReferences.put("Transformed Data", "${message.transformedData}");
        staticVelocityReferences.put("Message ID", "${message.messageId}");
        staticVelocityReferences.put("Encoded Data", "${message.encodedData}");
        staticVelocityReferences.put("Message Source", "${message_source}");
        staticVelocityReferences.put("Message Type", "${message_type}");
        staticVelocityReferences.put("Message Version", "${mirth_version}");
        staticVelocityReferences.put("Message Hash", "${HASH}");
        staticVelocityReferences.put("Timestamp", "${SYSTIME}");
        staticVelocityReferences.put("Unique ID", "${UUID}");
        staticVelocityReferences.put("Date", "${DATE}");
        staticVelocityReferences.put("Original File Name", "${originalFilename}");
        staticVelocityReferences.put("Count", "${COUNT}");
        staticVelocityReferences.put("DICOM Message Raw Data", "${DICOMMESSAGE}");
        staticVelocityReferences.put("Formatted Date", "${date.get('yyyy-M-d H.m.s')}");
        staticVelocityReferences.put("XML Entity Encoder", "${XmlUtil.encode()}");
        staticVelocityReferences.put("XML Pretty Printer", "${XmlUtil.prettyPrint()}");
        staticVelocityReferences.put("Escape JSON String", "${JsonUtil.escape()}");
        staticVelocityReferences.put("JSON Pretty Printer", "${JsonUtil.prettyPrint()}");
        staticVelocityReferences.put("Server ID", "${message.serverId}");
        staticVelocityReferences.put("Channel ID", "${message.channelId}");
        staticVelocityReferences.put("Channel Name", "${message.channelName}");
        staticVelocityReferences.put("Formatted Message Date", "${date.format('yyyy-MM-dd',$message.getConnectorMessages().get(0).getReceivedDate())}");
        staticVelocityReferences.put("Formatted Current Date", "${date.get('yyyy-MM-dd')}");
        staticJsReferences = new HashMap<String, String>();
        staticJsReferences.put("Raw Data", "connectorMessage.getRawData()");
        staticJsReferences.put("Transformed Data", "connectorMessage.getTransformedData()");
        staticJsReferences.put("Message ID", "connectorMessage.getMessageId()");
        staticJsReferences.put("Encoded Data", "connectorMessage.getEncodedData()");
        staticJsReferences.put("Message Source", "$('message_source')");
        staticJsReferences.put("Message Type", "$('message_type')");
        staticJsReferences.put("Message Hash", "HashUtil.generate(connectorMessage.getEncodedData())");
        staticJsReferences.put("Message Version", "$('mirth_version')");
        staticJsReferences.put("Timestamp", "var dateString = DateUtil.getCurrentDate('yyyyMMddHHmmss');");
        staticJsReferences.put("Unique ID", "var uuid = UUIDGenerator.getUUID();");
        staticJsReferences.put("Date", "var date = DateUtil.getDate('pattern','date');");
        staticJsReferences.put("Channel ID", "channelId");
        staticJsReferences.put("Channel Name", "channelName");
        staticJsReferences.put("Server ID", "connectorMessage.getServerId()");
        staticJsReferences.put("Original File Name", "$('originalFilename')");
        staticJsReferences.put("DICOM Message Raw Data", "var rawData = DICOMUtil.getDICOMRawData(connectorMessage);");
        staticJsReferences.put("Message with Attachments", "var rawData = AttachmentUtil.reAttachMessage(connectorMessage)");
        staticJsReferences.put("Formatted Date", "var dateString = DateUtil.getCurrentDate('yyyy-M-d H.m.s');");
        staticJsReferences.put("XML Entity Encoder", "var encodedMessage = XmlUtil.encode('message');");
        staticJsReferences.put("XML Pretty Printer", "var prettyPrintedMessage = XmlUtil.prettyPrint('message');");
        staticJsReferences.put("Escape JSON String", "var escapedJSONString = JsonUtil.escape('message');");
        staticJsReferences.put("JSON Pretty Printer", "var prettyPrintedMessage = JsonUtil.prettyPrint('message');");
    }

    public static enum TransferMode {
        RAW("", ""),
        VELOCITY("${", "}"),
        JAVASCRIPT("$('", "')");

        private String prefix;
        private String suffix;

        private TransferMode(String prefix, String suffix) {
            this.prefix = prefix;
            this.suffix = suffix;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public String getSuffix() {
            return this.suffix;
        }
    }
}

