/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.alert;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.alert.AlertActionPane;
import com.mirth.connect.client.ui.alert.AlertChannelPane;
import com.mirth.connect.client.ui.alert.AlertEditPanel;
import com.mirth.connect.client.ui.alert.AlertTriggerPane;
import com.mirth.connect.client.ui.alert.DefaultAlertTriggerPane;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.model.alert.AlertActionGroup;
import com.mirth.connect.model.alert.AlertModel;
import com.mirth.connect.model.alert.AlertTrigger;
import com.mirth.connect.model.alert.ChannelTrigger;
import com.mirth.connect.model.alert.DefaultTrigger;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class DefaultAlertEditPanel
extends AlertEditPanel {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private AlertModel alertModel;
    private JLabel nameLabel;
    private MirthTextField nameTextField;
    private MirthCheckBox enabledCheckBox;
    private AlertTriggerPane alertTriggerPane;
    private AlertChannelPane alertChannelPane;
    private AlertActionPane alertActionPane;

    public DefaultAlertEditPanel() {
        this.initComponents();
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setLayout((LayoutManager)new MigLayout("insets 10", "grow", "[][grow][grow]"));
        this.nameLabel = new JLabel("Alert Name: ");
        this.nameTextField = new MirthTextField();
        this.nameTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                DefaultAlertEditPanel.this.parent.setPanelName("Edit Alert - " + DefaultAlertEditPanel.this.nameTextField.getText());
            }
        });
        this.enabledCheckBox = new MirthCheckBox("Enabled");
        this.enabledCheckBox.setBackground(UIConstants.BACKGROUND_COLOR);
        JPanel headerPanel = new JPanel();
        headerPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        headerPanel.setLayout((LayoutManager)new MigLayout("insets 0"));
        headerPanel.add((Component)this.nameLabel, "");
        headerPanel.add((Component)this.nameTextField, "width 500");
        headerPanel.add((Component)this.enabledCheckBox, "wrap");
        this.alertTriggerPane = new DefaultAlertTriggerPane();
        this.alertChannelPane = new AlertChannelPane();
        this.alertActionPane = new AlertActionPane();
        this.add((Component)headerPanel, "grow, span");
        this.add((Component)this.alertTriggerPane, "grow, sg 1, height 100");
        this.add((Component)this.alertChannelPane, "grow, sg 1, height 100, wrap");
        this.add((Component)this.alertActionPane, "grow, sgy 1, width 100, height 100, span");
    }

    private void updateTasks() {
        this.parent.setVisibleTasks(this.parent.alertEditTasks, this.parent.alertEditPopupMenu, 1, 1, true);
    }

    @Override
    public void addTriggerType(String name, AlertTriggerPane triggerPane) {
    }

    @Override
    public String getAlertId() {
        if (this.alertModel != null) {
            return this.alertModel.getId();
        }
        return null;
    }

    @Override
    public void updateVariableList() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("alertId");
        variables.add("alertName");
        variables.add("serverId");
        variables.add("serverName");
        variables.add("environmentName");
        variables.add("globalMapVariable");
        variables.add("date");
        variables.addAll(this.alertTriggerPane.getVariables());
        this.alertActionPane.setVariableList(variables);
    }

    @Override
    public void addAlert(Map<String, Map<String, String>> protocolOptions) {
        this.editAlert(new AlertModel((AlertTrigger)new DefaultTrigger(), new AlertActionGroup()), protocolOptions);
        this.parent.setSaveEnabled(true);
    }

    @Override
    public boolean editAlert(AlertModel alertModel, Map<String, Map<String, String>> protocolOptions) {
        if (alertModel.getTrigger() instanceof DefaultTrigger) {
            this.parent.setPanelName("Edit Alert - " + (alertModel.getName() == null ? "" : alertModel.getName()));
            this.nameTextField.setText(alertModel.getName());
            this.enabledCheckBox.setSelected(alertModel.isEnabled());
            this.alertActionPane.setActionGroup((AlertActionGroup)alertModel.getActionGroups().get(0), protocolOptions);
            this.alertTriggerPane.setTrigger(alertModel.getTrigger());
            this.alertChannelPane.setChannels(((ChannelTrigger)alertModel.getTrigger()).getAlertChannels(), true);
            this.updateVariableList();
            this.alertModel = alertModel;
            this.updateTasks();
            return true;
        }
        this.parent.alertError((Component)((Object)this.parent), "This alert cannot be edited. Plugin may be missing.");
        return false;
    }

    @Override
    public boolean saveAlert() {
        boolean updated = false;
        if (StringUtils.isBlank((CharSequence)this.nameTextField.getText())) {
            this.parent.alertWarning((Component)((Object)this.parent), "Alert name cannot be empty.");
            return false;
        }
        List<String> triggerValidationErrors = this.alertTriggerPane.doValidate();
        if (CollectionUtils.isNotEmpty(triggerValidationErrors)) {
            this.parent.alertWarning((Component)((Object)this.parent), StringUtils.join(triggerValidationErrors, (String)"\n"));
            return false;
        }
        this.alertModel.setName(this.nameTextField.getText());
        this.alertModel.setEnabled(this.enabledCheckBox.isSelected());
        AlertTrigger trigger = this.alertTriggerPane.getTrigger();
        ((ChannelTrigger)trigger).setAlertChannels(this.alertChannelPane.getChannels());
        this.alertModel.setTrigger(trigger);
        try {
            this.parent.mirthClient.updateAlert(this.alertModel);
            updated = true;
        }
        catch (ClientException e) {
            if (e.getMessage().contains("An alert with that name already exists.")) {
                this.parent.alertWarning((Component)((Object)this.parent), "Alert \"" + this.alertModel.getName() + "\" already exists.");
            }
            this.parent.alertThrowable((Component)((Object)this.parent), e);
        }
        return updated;
    }
}

