/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.alert;

import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.alert.AlertTriggerPane;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextArea;
import com.mirth.connect.donkey.model.event.ErrorEventType;
import com.mirth.connect.model.alert.AlertTrigger;
import com.mirth.connect.model.alert.DefaultTrigger;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class DefaultAlertTriggerPane
extends AlertTriggerPane {
    private static int SELECTION_COLUMN_NUMBER = 0;
    private static int ERROR_COLUMN_NUMBER = 1;
    private static int SELECTION_COLUMN_WIDTH = 20;
    private JPanel errorPane;
    private JScrollPane errorScrollPane;
    private MirthTable errorTable;
    private JPanel regexPane;
    private JScrollPane regexScrollPane;
    private MirthTextArea regexTextArea;

    public DefaultAlertTriggerPane() {
        this.initComponents();
        this.makeErrorTable();
    }

    private void makeErrorTable() {
        Object[][] tableData = new Object[ErrorEventType.values().length][2];
        for (int i = 0; i < ErrorEventType.values().length; ++i) {
            ErrorEventType type = ErrorEventType.values()[i];
            tableData[i][0] = false;
            tableData[i][1] = type;
        }
        this.errorTable.setModel(new RefreshTableModel(tableData, new String[]{"", "Error"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{true, false};
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex] && (rowIndex == 0 || (Boolean)DefaultAlertTriggerPane.this.errorTable.getValueAt(0, 0) == false);
            }
        });
        JCheckBox checkBox = new JCheckBox();
        checkBox.setVerticalAlignment(0);
        checkBox.setHorizontalAlignment(0);
        DefaultCellEditor editor = new DefaultCellEditor(checkBox);
        editor.addCellEditorListener(new CellEditorListener(){

            @Override
            public void editingStopped(ChangeEvent e) {
                PlatformUI.MIRTH_FRAME.setSaveEnabled(true);
            }

            @Override
            public void editingCanceled(ChangeEvent e) {
            }
        });
        this.errorTable.getColumnExt(SELECTION_COLUMN_NUMBER).setCellRenderer(new TableCellRenderer(){
            private JCheckBox checkBox = new JCheckBox();

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                this.checkBox.setVerticalAlignment(0);
                this.checkBox.setHorizontalAlignment(0);
                if (value != null) {
                    this.checkBox.setSelected((Boolean)value);
                }
                this.checkBox.setEnabled(row == 0 || (Boolean)table.getValueAt(0, 0) == false);
                return this.checkBox;
            }
        });
        this.errorTable.getColumnExt(ERROR_COLUMN_NUMBER).setCellRenderer((TableCellRenderer)new DefaultTableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                component.setEnabled(row == 0 || (Boolean)table.getValueAt(0, 0) == false);
                return component;
            }
        });
        this.errorTable.getColumnExt(SELECTION_COLUMN_NUMBER).setCellEditor((TableCellEditor)editor);
        this.errorTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.errorTable.setRowSelectionAllowed(false);
        this.errorTable.setRowHeight(20);
        this.errorTable.setSortable(false);
        this.errorTable.setOpaque(true);
        this.errorTable.setDragEnabled(false);
        this.errorTable.getTableHeader().setReorderingAllowed(false);
        this.errorTable.setShowGrid(true, true);
        this.errorTable.setAutoCreateColumnsFromModel(false);
        this.errorTable.getColumnExt(SELECTION_COLUMN_NUMBER).setMaxWidth(SELECTION_COLUMN_WIDTH);
        this.errorTable.getColumnExt(SELECTION_COLUMN_NUMBER).setMinWidth(SELECTION_COLUMN_WIDTH);
        this.errorTable.getColumnExt(SELECTION_COLUMN_NUMBER).setResizable(false);
        this.errorTable.getColumnExt(ERROR_COLUMN_NUMBER).setMinWidth(75);
        this.errorTable.getColumnExt(ERROR_COLUMN_NUMBER).setResizable(false);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.errorTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    @Override
    public List<String> getVariables() {
        ArrayList<String> variables = new ArrayList<String>();
        variables.add("systemTime");
        variables.add("error");
        variables.add("errorMessage");
        variables.add("errorType");
        variables.add("channelId");
        variables.add("channelName");
        variables.add("connectorName");
        variables.add("connectorType");
        variables.add("messageId");
        return variables;
    }

    public void updateErrorTable(Set<ErrorEventType> errorEventTypes) {
        RefreshTableModel tableModel = (RefreshTableModel)this.errorTable.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            ErrorEventType type = (ErrorEventType)tableModel.getValueAt(i, 1);
            tableModel.setValueAt(errorEventTypes.contains(type), i, 0);
        }
    }

    @Override
    public AlertTrigger getTrigger() {
        HashSet<ErrorEventType> errorEventTypes = new HashSet<ErrorEventType>();
        RefreshTableModel tableModel = (RefreshTableModel)this.errorTable.getModel();
        for (int i = 0; i < tableModel.getRowCount(); ++i) {
            boolean enabled = (Boolean)tableModel.getValueAt(i, 0);
            if (!enabled) continue;
            errorEventTypes.add((ErrorEventType)tableModel.getValueAt(i, 1));
        }
        return new DefaultTrigger(errorEventTypes, this.regexTextArea.getText());
    }

    @Override
    public void setTrigger(AlertTrigger trigger) {
        if (trigger instanceof DefaultTrigger) {
            DefaultTrigger defaultTrigger = (DefaultTrigger)trigger;
            this.updateErrorTable(defaultTrigger.getErrorEventTypes());
            this.regexTextArea.setText(defaultTrigger.getRegex());
        }
    }

    @Override
    public void reset() {
        this.updateErrorTable(new HashSet<ErrorEventType>());
        this.regexTextArea.setText("");
    }

    @Override
    public List<String> doValidate() {
        return null;
    }

    protected MirthTextArea getRegexTextArea() {
        return this.regexTextArea;
    }

    protected MirthTable getErrorTable() {
        return this.errorTable;
    }

    private void initComponents() {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.setLayout((LayoutManager)new MigLayout("insets 0, flowy", "[][grow]", "[grow]"));
        this.errorTable = new MirthTable();
        this.errorScrollPane = new JScrollPane((Component)((Object)this.errorTable));
        this.errorPane = new JPanel();
        this.errorPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.errorPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Errors (select all that apply)"));
        this.errorPane.setLayout(new BorderLayout());
        this.errorPane.add(this.errorScrollPane);
        this.regexTextArea = new MirthTextArea();
        this.regexTextArea.setToolTipText("Only errors that match against this regular expression will trigger.");
        this.regexScrollPane = new JScrollPane(this.regexTextArea);
        this.regexPane = new JPanel();
        this.regexPane.setBackground(UIConstants.BACKGROUND_COLOR);
        this.regexPane.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(), "Regex (optional)"));
        this.regexPane.setLayout(new BorderLayout());
        this.regexPane.add(this.regexScrollPane);
        this.add((Component)this.errorPane, "width 180, height 100, growy, wrap");
        this.add((Component)this.regexPane, "width 200, grow");
    }
}

