/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.attachments;

import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.plugins.AttachmentViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class AttachmentTypeDialog
extends MirthDialog {
    private boolean okPressed;
    private JLabel label;
    private JComboBox<String> comboBox;
    private JCheckBox checkBox;
    private JSeparator separator;
    private JButton okButton;
    private JButton cancelButton;

    public AttachmentTypeDialog(String contentType) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.initComponents(contentType);
        this.initLayout();
        this.setTitle("Select Attachment Viewer");
        this.setDefaultCloseOperation(2);
        this.setPreferredSize(new Dimension(400, this.checkBox.isVisible() ? 162 : 140));
        this.pack();
        this.setLocationRelativeTo((Component)((Object)PlatformUI.MIRTH_FRAME));
        this.setVisible(true);
    }

    public AttachmentViewer getAttachmentViewer() {
        if (this.okPressed) {
            return LoadedExtensions.getInstance().getAttachmentViewerPlugins().get(this.comboBox.getSelectedItem());
        }
        return null;
    }

    private void initComponents(String contentType) {
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.getContentPane().setBackground(this.getBackground());
        Map<String, AttachmentViewer> pluginMap = LoadedExtensions.getInstance().getAttachmentViewerPlugins();
        String defaultPluginName = "Text Viewer";
        if (!pluginMap.containsKey(defaultPluginName)) {
            defaultPluginName = pluginMap.keySet().iterator().next();
        }
        boolean found = false;
        for (AttachmentViewer plugin : pluginMap.values()) {
            if (!plugin.isContentTypeViewable(contentType)) continue;
            found = true;
            defaultPluginName = plugin.getPluginName();
            break;
        }
        this.label = new JLabel();
        if (found) {
            this.label.setText("<html>Select an attachment viewer to use for content type \"" + contentType + "\":</html>");
        } else {
            this.label.setText("<html>Attachment viewer for content type \"" + contentType + "\" not found. Select one from the menu below:</html>");
        }
        this.comboBox = new JComboBox<String>(new DefaultComboBoxModel<String>(pluginMap.keySet().toArray(new String[pluginMap.size()])));
        this.comboBox.setSelectedItem(defaultPluginName);
        this.checkBox = new JCheckBox("Always choose viewer automatically from MIME type");
        this.checkBox.setBackground(this.getBackground());
        this.checkBox.setToolTipText("<html>Don't show this dialog again, and instead automatically<br/>choose the attachment viewer from the MIME type. This<br/>may be changed later in the Administrator settings.</html>");
        if (!found) {
            this.checkBox.setVisible(false);
        }
        this.separator = new JSeparator(0);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentTypeDialog.this.okPressed = true;
                if (AttachmentTypeDialog.this.checkBox.isVisible() && AttachmentTypeDialog.this.checkBox.isSelected()) {
                    Preferences.userNodeForPackage(Mirth.class).putBoolean("messageBrowserShowAttachmentTypeDialog", false);
                }
                AttachmentTypeDialog.this.dispose();
            }
        });
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AttachmentTypeDialog.this.dispose();
            }
        });
    }

    private void initLayout() {
        String rowConstraints = this.checkBox.isVisible() ? "[][][][grow,bottom][]" : "[][][grow,bottom][]";
        this.setLayout((LayoutManager)new MigLayout("insets 10, novisualpadding, hidemode 3, fill", "", rowConstraints));
        this.add(this.label);
        this.add(this.comboBox, "newline, growx");
        if (this.checkBox.isVisible()) {
            this.add((Component)this.checkBox, "newline");
        }
        this.add((Component)this.separator, "newline, growx");
        this.add((Component)this.okButton, "newline, right, w 65!, split 2");
        this.add((Component)this.cancelButton, "w 65!");
    }
}

