/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.attachments;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.FunctionList;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.donkey.model.message.attachment.AttachmentHandlerProperties;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class JavaScriptAttachmentDialog
extends MirthDialog {
    private Frame parent = PlatformUI.MIRTH_FRAME;
    private AttachmentHandlerProperties attachmentHandlerProperties;
    private JButton cancelButton;
    private FunctionList functionList1;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JButton okButton;
    private MirthRTextScrollPane scriptContent;
    private JButton validateScriptButton;

    public JavaScriptAttachmentDialog(AttachmentHandlerProperties properties) {
        super((Window)((Object)PlatformUI.MIRTH_FRAME), true);
        this.initComponents();
        this.attachmentHandlerProperties = properties;
        this.scriptContent.setSaveEnabled(false);
        this.scriptContent.setCaretPosition(0);
        this.scriptContent.setText((String)this.attachmentHandlerProperties.getProperties().get("javascript.script"));
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                JavaScriptAttachmentDialog.this.cancelButtonActionPerformed(null);
            }
        });
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = this.parent.getSize();
        Point loc = this.parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        this.setVisible(true);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.cancelButton = new JButton();
        this.validateScriptButton = new JButton();
        this.scriptContent = new MirthRTextScrollPane(ContextType.CHANNEL_ATTACHMENT, true);
        this.okButton = new JButton();
        this.functionList1 = new FunctionList(ContextType.CHANNEL_ATTACHMENT);
        this.jSeparator1 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.setTitle("Script");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("Close this message sender dialog.");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptAttachmentDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.validateScriptButton.setText("Validate Script");
        this.validateScriptButton.setToolTipText("Process the message displayed in the editor above.");
        this.validateScriptButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptAttachmentDialog.this.validateScriptButtonActionPerformed(evt);
            }
        });
        this.scriptContent.setBorder(BorderFactory.createEtchedBorder());
        this.okButton.setText("OK");
        this.okButton.setToolTipText("Close this message sender dialog.");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptAttachmentDialog.this.okButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent((Component)((Object)this.scriptContent), -1, 727, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.functionList1, -2, 202, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.validateScriptButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addComponent(this.jSeparator1)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.functionList1, -1, 552, Short.MAX_VALUE).addComponent((Component)((Object)this.scriptContent), -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 3, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addComponent(this.validateScriptButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void validateScriptButtonActionPerformed(ActionEvent evt) {
        StringBuilder sb = new StringBuilder();
        Context context = JavaScriptSharedUtil.getGlobalContextForValidation();
        try {
            context.compileString("function rhinoWrapper() {" + this.scriptContent.getText() + "\n}", PlatformUI.MIRTH_FRAME.mirthClient.getGuid(), 1, null);
            sb.append("JavaScript was successfully validated.");
        }
        catch (EvaluatorException e) {
            sb.append("Error on line " + e.lineNumber() + ": " + e.getMessage() + " of the current script.");
        }
        catch (Exception e) {
            sb.append("Unknown error occurred during validation.");
        }
        Context.exit();
        this.parent.alertInformation(this, sb.toString());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        if (!((String)this.attachmentHandlerProperties.getProperties().get("javascript.script")).equals(this.scriptContent.getText())) {
            this.attachmentHandlerProperties.getProperties().put("javascript.script", this.scriptContent.getText());
            this.parent.setSaveEnabled(true);
        }
        this.dispose();
    }
}

