/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.browsers.event;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.model.ServerEvent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;

public class EventBrowserAdvancedFilter
extends MirthDialog {
    private Map<Integer, String> userMapById;
    private Map<String, Integer> userMapByName;
    private static Map<String, Object> cachedSettings;
    private JButton cancelButton;
    private MirthTextField ipAddressField;
    private JLabel ipAddressLabel;
    private JPanel jPanel1;
    private JSeparator jSeparator1;
    private JButton okButton1;
    private JComboBox outcomeComboBox;
    private JLabel outcomeLabel;
    private MirthTextField serverIdField;
    private JLabel serverIdLabel;
    private JComboBox userComboBox;
    private JLabel userLabel;
    private MirthTextField attributeSearchField;
    private JLabel attributeSearchLabel;

    public EventBrowserAdvancedFilter(Frame parent, String title, boolean modal, Map<Integer, String> userMap) {
        super((Window)((Object)parent), title, modal);
        this.initComponents();
        this.getContentPane().setBackground(new Color(255, 255, 255));
        this.pack();
        Dimension dlgSize = this.getPreferredSize();
        Dimension frmSize = parent.getSize();
        Point loc = parent.getLocation();
        if (frmSize.width == 0 && frmSize.height == 0 || loc.x == 0 && loc.y == 0) {
            this.setLocationRelativeTo(null);
        } else {
            this.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
        }
        DisplayUtil.setResizable(this, false);
        cachedSettings = new HashMap<String, Object>();
        this.userMapById = userMap;
        this.userMapByName = new LinkedHashMap<String, Integer>();
        for (Map.Entry<Integer, String> entry : this.userMapById.entrySet()) {
            this.userMapByName.put(entry.getValue(), entry.getKey());
        }
        this.userComboBox.setModel(new DefaultComboBoxModel<Object>(this.userMapById.values().toArray()));
        String[] outcomeValues = new String[ServerEvent.Outcome.values().length + 1];
        outcomeValues[0] = "ALL";
        for (int i = 1; i < outcomeValues.length; ++i) {
            outcomeValues[i] = ServerEvent.Outcome.values()[i - 1].toString();
        }
        this.outcomeComboBox.setModel(new DefaultComboBoxModel<String>(outcomeValues));
        this.reset();
    }

    public void reset() {
        this.userComboBox.setSelectedIndex(0);
        this.outcomeComboBox.setSelectedIndex(0);
        this.attributeSearchField.setText("");
        this.ipAddressField.setText("");
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.saveSelections();
        }
        super.setVisible(visible);
    }

    public void saveSelections() {
        cachedSettings.clear();
        cachedSettings.put("user", this.userComboBox.getSelectedItem());
        cachedSettings.put("outcome", this.outcomeComboBox.getSelectedItem());
        cachedSettings.put("attributeSearch", this.attributeSearchField.getText());
        cachedSettings.put("ipAddress", this.ipAddressField.getText());
    }

    public void loadSelections() {
        this.userComboBox.setSelectedItem((String)cachedSettings.get("user"));
        this.outcomeComboBox.setSelectedItem((String)cachedSettings.get("outcome"));
        this.attributeSearchField.setText((String)cachedSettings.get("attributeSearch"));
        this.ipAddressField.setText((String)cachedSettings.get("ipAddress"));
        cachedSettings.clear();
    }

    public Boolean hasAdvancedCriteria() {
        Boolean hasAdvancedCriteria = false;
        if (this.userComboBox.getSelectedIndex() != 0 || this.outcomeComboBox.getSelectedIndex() != 0 || StringUtils.isNotEmpty((CharSequence)this.ipAddressField.getText()) || StringUtils.isNotEmpty((CharSequence)this.attributeSearchField.getText())) {
            hasAdvancedCriteria = true;
        }
        return hasAdvancedCriteria;
    }

    public Integer getUser() {
        Integer user = this.userMapByName.get((String)this.userComboBox.getSelectedItem());
        return user;
    }

    public String getOutcome() {
        return (String)this.outcomeComboBox.getSelectedItem();
    }

    public String getAttributeSearch() {
        return this.attributeSearchField.getText();
    }

    public String getIpAddress() {
        return this.ipAddressField.getText();
    }

    public String getServerId() {
        return this.serverIdField.getText();
    }

    @Override
    public void onCloseAction() {
        this.formWindowClosing(null);
    }

    private void initComponents() {
        this.userLabel = new JLabel();
        this.userComboBox = new JComboBox();
        this.ipAddressField = new MirthTextField();
        this.ipAddressLabel = new JLabel();
        this.outcomeLabel = new JLabel();
        this.outcomeComboBox = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButton1 = new JButton();
        this.serverIdField = new MirthTextField();
        this.serverIdLabel = new JLabel();
        this.attributeSearchField = new MirthTextField();
        this.attributeSearchLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                EventBrowserAdvancedFilter.this.formWindowClosing(evt);
            }
        });
        this.userLabel.setText("User:");
        this.attributeSearchLabel.setText("Attributes:");
        this.ipAddressLabel.setText("IP Address:");
        this.outcomeLabel.setText("Outcome:");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(0, 2, 0, 2));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowserAdvancedFilter.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton1.setText("OK");
        this.okButton1.setMargin(new Insets(0, 2, 0, 2));
        this.okButton1.setMaximumSize(new Dimension(48, 21));
        this.okButton1.setMinimumSize(new Dimension(48, 21));
        this.okButton1.setPreferredSize(new Dimension(48, 21));
        this.okButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EventBrowserAdvancedFilter.this.okButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 336, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton1, -2, -1, -2))));
        this.serverIdLabel.setText("Server ID:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.outcomeLabel).addComponent(this.userLabel).addComponent(this.attributeSearchLabel).addComponent(this.ipAddressLabel).addComponent(this.serverIdLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.outcomeComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.userComboBox, 0, 125, Short.MAX_VALUE).addComponent(this.attributeSearchField, -1, -1, Short.MAX_VALUE).addComponent(this.ipAddressField, -1, -1, Short.MAX_VALUE)).addComponent(this.serverIdField, -2, 215, -2)).addContainerGap(56, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.userLabel).addComponent(this.userComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.outcomeLabel).addComponent(this.outcomeComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.attributeSearchField, -2, -1, -2).addComponent(this.attributeSearchLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.ipAddressField, -2, -1, -2).addComponent(this.ipAddressLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverIdField, -2, -1, -2).addComponent(this.serverIdLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -2, -1, -2).addContainerGap()));
        this.pack();
    }

    private void formWindowClosing(WindowEvent evt) {
        this.loadSelections();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.loadSelections();
        this.setVisible(false);
    }

    private void okButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

