/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.browsers.message;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.core.Operation;
import com.mirth.connect.client.core.PaginatedMessageList;
import com.mirth.connect.client.core.RequestAbortedException;
import com.mirth.connect.client.core.api.servlets.MessageServletInterface;
import com.mirth.connect.client.core.api.util.OperationUtil;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.PlatformUI;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.ViewContentDialog;
import com.mirth.connect.client.ui.attachments.AttachmentTypeDialog;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserAdvancedFilter;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserChannelModel;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserTableColumnFactory;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserTableModel;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserTableNode;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthDatePicker;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthSyntaxTextArea;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.client.ui.components.MirthTimePicker;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.util.DisplayUtil;
import com.mirth.connect.donkey.model.channel.ConnectorProperties;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.MetaDataColumnType;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;
import com.mirth.connect.donkey.model.message.MessageContent;
import com.mirth.connect.donkey.model.message.Response;
import com.mirth.connect.donkey.model.message.Status;
import com.mirth.connect.donkey.model.message.attachment.Attachment;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.model.filters.elements.ContentSearchElement;
import com.mirth.connect.model.filters.elements.MetaDataSearchElement;
import com.mirth.connect.model.filters.elements.MetaDataSearchOperator;
import com.mirth.connect.plugins.AttachmentViewer;
import com.mirth.connect.util.MirthJsonUtil;
import com.mirth.connect.util.MirthXmlUtil;
import com.mirth.connect.util.StringUtil;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.text.DateFormatter;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.table.TableColumnExt;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.syntax.jedit.SyntaxDocument;
import org.syntax.jedit.tokenmarker.JSONTokenMarker;
import org.syntax.jedit.tokenmarker.XMLTokenMarker;

public class MessageBrowser
extends JPanel {
    protected static final int ID_COLUMN = 0;
    protected static final int CONNECTOR_COLUMN = 1;
    protected static final int STATUS_COLUMN = 2;
    protected static final int ORIGINAL_RECEIVED_DATE_COLUMN = 3;
    protected static final int RECEIVED_DATE_COLUMN = 4;
    protected static final int SEND_ATTEMPTS_COLUMN = 5;
    protected static final int SEND_DATE_COLUMN = 6;
    protected static final int RESPONSE_DATE_COLUMN = 7;
    protected static final int ERRORS_COLUMN = 8;
    protected static final int SERVER_ID_COLUMN = 9;
    protected static final int ORIGINAL_SERVER_ID_COLUMN = 10;
    protected static final int ORIGINAL_ID_COLUMN = 11;
    protected static final int IMPORT_ID_COLUMN = 12;
    protected static final int IMPORT_CHANNEL_ID_COLUMN = 13;
    protected static final int CHANNEL_NAME_COLUMN = 14;
    protected static final String DATE_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    private final String SCOPE_COLUMN_NAME = "Scope";
    private final String KEY_COLUMN_NAME = "Variable";
    private final String VALUE_COLUMN_NAME = "Value";
    private final String TYPE_COLUMN_NAME = "Type";
    private final String NUMBER_COLUMN_NAME = "#";
    private final String ATTACHMENTID_COLUMN_NAME = "Attachment Id";
    private final int MAX_CACHE_SIZE = 200;
    private String lastUserSelectedMessageType = "Raw";
    private String lastUserSelectedErrorType = "Processing Error";
    protected Frame parent;
    private String channelId;
    protected List<String> channelIds = new ArrayList<String>();
    private String channelName;
    private boolean isChannelDeployed;
    private boolean isCURESPHILoggingOn;
    protected boolean isChannelMessagesPanelFirstLoadSearch;
    private Map<Integer, String> connectors;
    protected List<MetaDataColumn> metaDataColumns;
    private MessageBrowserTableModel tableModel;
    protected PaginatedMessageList messages;
    protected Map<Object, Message> messageCache;
    protected Map<Object, List<Attachment>> attachmentCache;
    protected MessageFilter messageFilter;
    protected MessageBrowserAdvancedFilter advancedSearchPopup;
    private JPopupMenu attachmentPopupMenu;
    protected TreeMap<Integer, String> columnMap;
    protected Set<String> defaultVisibleColumns;
    private SwingWorker<Void, Void> worker;
    private Logger logger = LogManager.getLogger(this.getClass());
    private ExecutorService executor;
    private List<Future<Void>> prettyPrintWorkers = new ArrayList<Future<Void>>();
    private List<Integer> selectedMetaDataIds;
    private JRadioButton EncodedMessageRadioButton;
    private MirthSyntaxTextArea EncodedMessageTextPane;
    private JPanel ErrorsCardPane;
    private JPanel ErrorsPanel;
    private JPanel ErrorsRadioPane;
    private JPanel MessagesCardPane;
    private JPanel MessagesPanel;
    private JPanel MessagesRadioPane;
    private JRadioButton PostprocessorErrorRadioButton;
    private MirthSyntaxTextArea PostprocessorErrorTextPane;
    private JRadioButton ProcessedRawMessageRadioButton;
    private MirthSyntaxTextArea ProcessedRawMessageTextPane;
    private JRadioButton ProcessedResponseRadioButton;
    private MirthSyntaxTextArea ProcessedResponseTextArea;
    private JPanel ProcessedResponseTextPane;
    private JRadioButton ProcessingErrorRadioButton;
    private MirthSyntaxTextArea ProcessingErrorTextPane;
    private JRadioButton RawMessageRadioButton;
    private MirthSyntaxTextArea RawMessageTextPane;
    private JRadioButton ResponseErrorRadioButton;
    private MirthSyntaxTextArea ResponseErrorTextPane;
    private JRadioButton ResponseRadioButton;
    private MirthSyntaxTextArea ResponseTextArea;
    private JPanel ResponseTextPane;
    private JRadioButton ResponseTransformedRadioButton;
    private MirthSyntaxTextArea ResponseTransformedTextPane;
    private JRadioButton SentMessageRadioButton;
    private MirthSyntaxTextArea SentMessageTextPane;
    private JRadioButton TransformedMessageRadioButton;
    private MirthSyntaxTextArea TransformedMessageTextPane;
    private JButton advSearchButton;
    private MirthCheckBox allDayCheckBox;
    private MirthTable attachmentTable;
    private JScrollPane attachmentsPane;
    private MirthButton countButton;
    private JTabbedPane descriptionTabbedPane;
    private ButtonGroup errorsGroup;
    private JButton filterButton;
    private JCheckBox formatMessageCheckBox;
    private JDialog jDialog1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jList1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JSplitPane jSplitPane1;
    private JTextArea lastSearchCriteria;
    private JScrollPane lastSearchCriteriaPane;
    private JScrollPane mappingsPane;
    private MirthTable mappingsTable;
    private JScrollPane messageScrollPane;
    protected MirthTreeTable messageTreeTable;
    private ButtonGroup messagesGroup;
    private MirthDatePicker mirthDatePicker1;
    private MirthDatePicker mirthDatePicker2;
    private MirthTimePicker mirthTimePicker1;
    private MirthTimePicker mirthTimePicker2;
    private JButton nextPageButton;
    private JButton pageGoButton;
    private MirthTextField pageNumberField;
    private JLabel pageNumberLabel;
    private MirthTextField pageSizeField;
    private JLabel pageSizeLabel;
    private JLabel pageTotalLabel;
    private JButton previousPageButton;
    private JLabel processedResponseLabel;
    private JLabel processedResponseStatusLabel;
    private MirthSyntaxTextArea processedResponseStatusTextArea;
    private MirthCheckBox regexTextSearchCheckBox;
    private JButton resetButton;
    private JLabel responseLabel;
    private JLabel responseStatusLabel;
    private MirthSyntaxTextArea responseStatusTextArea;
    private JLabel resultsLabel;
    private MirthCheckBox statusBoxError;
    private MirthCheckBox statusBoxFiltered;
    private MirthCheckBox statusBoxQueued;
    private MirthCheckBox statusBoxPending;
    private MirthCheckBox statusBoxReceived;
    private MirthCheckBox statusBoxSent;
    private MirthCheckBox statusBoxTransformed;
    private JTextField textSearchField;
    private JLabel textSearchLabel;

    public MessageBrowser() {
        this.parent = PlatformUI.MIRTH_FRAME;
        this.messageCache = Collections.synchronizedMap(new LinkedHashMap<Object, Message>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, Message> eldest) {
                return this.size() > 200;
            }
        });
        this.attachmentCache = Collections.synchronizedMap(new LinkedHashMap<Object, List<Attachment>>(){

            @Override
            protected boolean removeEldestEntry(Map.Entry<Object, List<Attachment>> eldest) {
                return this.size() > 200;
            }
        });
        this.initColumnData();
        this.initComponents();
        this.initComponentsManual();
        this.makeMessageTable();
        this.makeMappingsTable();
        this.executor = Executors.newFixedThreadPool(5);
    }

    public void initComponentsManual() {
        this.attachmentPopupMenu = new JPopupMenu();
        JMenuItem viewAttach = new JMenuItem("View Attachment");
        viewAttach.setIcon(new ImageIcon(Frame.class.getResource("images/attach.png")));
        viewAttach.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBrowser.this.viewAttachment();
            }
        });
        this.attachmentPopupMenu.add(viewAttach);
        JMenuItem exportAttach = new JMenuItem("Export Attachment");
        exportAttach.setIcon(new ImageIcon(Frame.class.getResource("images/report_disk.png")));
        exportAttach.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageBrowser.this.exportAttachment();
            }
        });
        this.attachmentPopupMenu.add(exportAttach);
        this.pageSizeField.setDocument(new MirthFieldConstraints(3, false, false, true));
        this.pageNumberField.setDocument(new MirthFieldConstraints(7, false, false, true));
        this.advancedSearchPopup = this.createMessageBrowserAdvancedFilter();
        this.advancedSearchPopup.setVisible(false);
        LineBorder lineBorder = new LineBorder(new Color(0, 0, 0));
        TitledBorder titledBorder = new TitledBorder("Current Search");
        titledBorder.setBorder(lineBorder);
        this.lastSearchCriteriaPane.setBorder(titledBorder);
        this.lastSearchCriteriaPane.setBackground(Color.white);
        this.lastSearchCriteria.setBackground(Color.white);
        this.mirthDatePicker1.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                MessageBrowser.this.allDayCheckBox.setEnabled(MessageBrowser.this.mirthDatePicker1.getDate() != null || MessageBrowser.this.mirthDatePicker2.getDate() != null);
                MessageBrowser.this.mirthTimePicker1.setEnabled(MessageBrowser.this.mirthDatePicker1.getDate() != null && !MessageBrowser.this.allDayCheckBox.isSelected());
            }
        });
        this.mirthDatePicker2.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent arg0) {
                MessageBrowser.this.allDayCheckBox.setEnabled(MessageBrowser.this.mirthDatePicker1.getDate() != null || MessageBrowser.this.mirthDatePicker2.getDate() != null);
                MessageBrowser.this.mirthTimePicker2.setEnabled(MessageBrowser.this.mirthDatePicker2.getDate() != null && !MessageBrowser.this.allDayCheckBox.isSelected());
            }
        });
        this.pageNumberField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10 && MessageBrowser.this.pageGoButton.isEnabled()) {
                    MessageBrowser.this.jumpToPageNumber();
                }
            }
        });
        if (!Arrays.asList("postgres", "oracle", "mysql").contains(PlatformUI.SERVER_DATABASE)) {
            this.regexTextSearchCheckBox.setEnabled(false);
        }
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                MessageBrowser.this.parent.mirthClient.getServerConnection().abort(MessageBrowser.this.getAbortOperations());
                MessageBrowser.this.parent.messageBrowser.clearCache();
                MessageBrowser.this.deselectRows();
                MessageBrowser.this.tableModel.clear();
                for (TableColumn tableColumn : MessageBrowser.this.messageTreeTable.getColumns(true)) {
                    MessageBrowser.this.messageTreeTable.removeColumn(tableColumn);
                }
            }
        });
    }

    protected MessageBrowserAdvancedFilter createMessageBrowserAdvancedFilter() {
        return new MessageBrowserAdvancedFilter(this.parent, this, "Advanced Search Filter", true, true);
    }

    public void loadChannels(List<MessageBrowserChannelModel> channelModels) {
        if (channelModels != null && !channelModels.isEmpty()) {
            this.loadChannel(channelModels.get(0));
        }
    }

    public void loadChannel(MessageBrowserChannelModel channelModel) {
        boolean isChannelDeployed;
        String channelId = channelModel.getChannelId();
        String channelName = channelModel.getChannelName();
        Map<Integer, String> connectors = channelModel.getConnectors();
        List<MetaDataColumn> metaDataColumns = channelModel.getMetaDataColumns();
        List<Integer> selectedMetaDataIds = channelModel.getSelectedMetaDataIds();
        this.isChannelDeployed = isChannelDeployed = channelModel.isChannelDeployed();
        this.selectedMetaDataIds = selectedMetaDataIds;
        this.taskPaneWhenLoadingChannels();
        this.formatMessageCheckBox.setSelected(Preferences.userNodeForPackage(Mirth.class).getBoolean("messageBrowserFormat", true));
        this.channelId = channelId;
        this.channelName = channelName;
        this.connectors = connectors;
        this.connectors.put(null, "Deleted Connectors");
        this.initMetaDataColumns(channelModel);
        this.tableModel.clear();
        this.advancedSearchPopup.loadChannel();
        this.resetSearchCriteria();
        this.advancedSearchPopup.setSelectedMetaDataIds(selectedMetaDataIds);
        this.updateAdvancedSearchButtonFont();
        this.lastUserSelectedMessageType = "Raw";
        this.updateMessageRadioGroup();
        ArrayList<String> columnList = new ArrayList<String>();
        columnList.addAll(this.columnMap.values());
        this.isCURESPHILoggingOn = false;
        for (MetaDataColumn column : this.metaDataColumns) {
            if (!column.getName().toLowerCase().equals("patient_id")) continue;
            this.isCURESPHILoggingOn = true;
            break;
        }
        Set<String> metaDataColumnNames = this.createCustomMetaDataColumns();
        Map<String, Set<String>> customHiddenColumnMap = this.messageTreeTable.getCustomHiddenColumnMap();
        Set<String> hiddenCustomColumns = customHiddenColumnMap.get(channelId);
        if (hiddenCustomColumns == null) {
            hiddenCustomColumns = new HashSet<String>();
            customHiddenColumnMap.put(channelId, hiddenCustomColumns);
        } else {
            Iterator<String> iterator = hiddenCustomColumns.iterator();
            while (iterator.hasNext()) {
                if (metaDataColumnNames.contains(iterator.next())) continue;
                iterator.remove();
            }
        }
        columnList.addAll(metaDataColumnNames);
        this.tableModel.setColumnIdentifiers(columnList);
        MessageBrowserTableColumnFactory columnFactory = (MessageBrowserTableColumnFactory)this.messageTreeTable.getColumnFactory();
        for (int modelIndex = 0; modelIndex < columnList.size(); ++modelIndex) {
            TableColumnExt column = columnFactory.createAndConfigureTableColumn(this.messageTreeTable.getModel(), modelIndex);
            this.messageTreeTable.addColumn((TableColumn)column);
        }
        this.messageTreeTable.setMetaDataColumns(metaDataColumnNames, channelId);
        this.messageTreeTable.restoreColumnPreferences();
        this.isChannelMessagesPanelFirstLoadSearch = true;
        this.runSearch();
        this.isChannelMessagesPanelFirstLoadSearch = false;
    }

    protected void initMetaDataColumns(MessageBrowserChannelModel channelModel) {
        this.metaDataColumns = channelModel.getMetaDataColumns();
    }

    protected Set<String> createCustomMetaDataColumns() {
        LinkedHashSet<String> metaDataColumnNames = new LinkedHashSet<String>();
        for (MetaDataColumn column : this.metaDataColumns) {
            metaDataColumnNames.add(column.getName());
        }
        return metaDataColumnNames;
    }

    protected void taskPaneWhenLoadingChannels() {
        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 1, 1, this.isChannelDeployed);
        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 7, 8, this.isChannelDeployed);
    }

    public Set<Operation> getAbortOperations() {
        return OperationUtil.getAbortableOperations(MessageServletInterface.class);
    }

    public void resetSearchCriteria() {
        this.mirthDatePicker1.setDate(null);
        this.mirthDatePicker2.setDate(null);
        this.textSearchField.setText("");
        this.regexTextSearchCheckBox.setSelected(false);
        this.allDayCheckBox.setSelected(false);
        this.statusBoxReceived.setSelected(false);
        this.statusBoxTransformed.setSelected(false);
        this.statusBoxFiltered.setSelected(false);
        this.statusBoxQueued.setSelected(false);
        this.statusBoxPending.setSelected(false);
        this.statusBoxSent.setSelected(false);
        this.statusBoxError.setSelected(false);
        this.pageSizeField.setText(String.valueOf(Preferences.userNodeForPackage(Mirth.class).getInt("messageBrowserPageSize", 20)));
        this.advancedSearchPopup.resetSelections();
        this.updateAdvancedSearchButtonFont();
    }

    public void updateFilterButtonFont(int font) {
        this.filterButton.setFont(this.filterButton.getFont().deriveFont(font));
        this.filterButton.requestFocus();
    }

    public void updateAdvancedSearchButtonFont() {
        if (this.advancedSearchPopup.hasAdvancedCriteria().booleanValue()) {
            this.advSearchButton.setFont(this.advSearchButton.getFont().deriveFont(1));
        } else {
            this.advSearchButton.setFont(this.advSearchButton.getFont().deriveFont(0));
        }
    }

    public String getChannelId() {
        return this.channelId;
    }

    public List<String> getChannelIds() {
        return this.channelIds;
    }

    public boolean getIsChannelMessagesPanelFirstLoadSearch() {
        return this.isChannelMessagesPanelFirstLoadSearch;
    }

    public Map<Integer, String> getConnectors() {
        return this.connectors;
    }

    public List<MetaDataColumn> getMetaDataColumns() {
        return this.metaDataColumns;
    }

    public PaginatedMessageList getMessages() {
        return this.messages;
    }

    public MessageFilter getMessageFilter() {
        return this.messageFilter;
    }

    public String getPatientId(Long messageId, Integer metaDataId, List<Integer> selectedMetaDataIds) {
        String patientId = null;
        Message message = this.getMessageFromCache(this.channelId, messageId);
        try {
            ConnectorMessage connectorMessage;
            if (message == null) {
                message = this.parent.mirthClient.getMessageContent(this.channelId, messageId, selectedMetaDataIds);
            }
            if ((connectorMessage = (ConnectorMessage)message.getConnectorMessages().get(metaDataId)).getMetaDataMap().get("PATIENT_ID") != null) {
                patientId = connectorMessage.getMetaDataMap().get("PATIENT_ID").toString();
            }
        }
        catch (ClientException e) {
            this.logger.error("Invalid patient ID.", (Throwable)e);
        }
        return patientId;
    }

    public int getPageSize() {
        return NumberUtils.toInt((String)this.pageSizeField.getText());
    }

    private Calendar getCalendar(MirthDatePicker datePicker, MirthTimePicker timePicker) throws ParseException {
        DateFormatter timeFormatter = new DateFormatter(new SimpleDateFormat("hh:mm aa"));
        Date date = datePicker.getDate();
        String time = timePicker.getDate();
        if (date != null && time != null) {
            Calendar dateCalendar = Calendar.getInstance();
            Calendar timeCalendar = Calendar.getInstance();
            Calendar dateTimeCalendar = Calendar.getInstance();
            dateCalendar.setTime(date);
            timeCalendar.setTime((Date)timeFormatter.stringToValue(time));
            dateTimeCalendar.setTime(date);
            if (timePicker.isEnabled()) {
                dateTimeCalendar.set(11, timeCalendar.get(11));
                dateTimeCalendar.set(12, timeCalendar.get(12));
                dateTimeCalendar.set(13, timeCalendar.get(13));
            }
            return dateTimeCalendar;
        }
        return null;
    }

    protected Message getMessageFromCache(String channelId, Long messageId) {
        return this.messageCache.get(messageId);
    }

    protected void putMessageInCache(String channelId, Long messageId, Message message) {
        this.messageCache.put(messageId, message);
    }

    protected List<Attachment> getAttachmentsFromCache(String channelId, Long messageId) {
        return this.attachmentCache.get(messageId);
    }

    protected void putAttachmentsInCache(String channelId, Long messageId, List<Attachment> attachments) {
        this.attachmentCache.put(messageId, attachments);
    }

    protected boolean generateMessageFilter() {
        this.messageFilter = new MessageFilter();
        try {
            this.messageFilter.setStartDate(this.getCalendar(this.mirthDatePicker1, this.mirthTimePicker1));
            Calendar endCalendar = this.getCalendar(this.mirthDatePicker2, this.mirthTimePicker2);
            if (endCalendar != null && !this.mirthTimePicker2.isEnabled()) {
                endCalendar.add(5, 1);
                endCalendar.add(14, -1);
            }
            this.messageFilter.setEndDate(endCalendar);
        }
        catch (ParseException e) {
            this.parent.alertError((Component)((Object)this.parent), "Invalid date.");
            return false;
        }
        Calendar startDate = this.messageFilter.getStartDate();
        Calendar endDate = this.messageFilter.getEndDate();
        if (startDate != null && endDate != null && startDate.getTimeInMillis() > endDate.getTimeInMillis()) {
            this.parent.alertError((Component)((Object)this.parent), "Start date cannot be after the end date.");
            return false;
        }
        String textSearch = StringUtils.trim((String)this.textSearchField.getText());
        if (textSearch.length() > 0) {
            this.messageFilter.setTextSearch(textSearch);
            ArrayList<String> textSearchMetaDataColumns = new ArrayList<String>();
            for (MetaDataColumn metaDataColumn : this.getMetaDataColumns()) {
                if (metaDataColumn.getType() != MetaDataColumnType.STRING) continue;
                textSearchMetaDataColumns.add(metaDataColumn.getName());
            }
            this.messageFilter.setTextSearchMetaDataColumns(textSearchMetaDataColumns);
        }
        if (this.regexTextSearchCheckBox.isSelected()) {
            this.messageFilter.setTextSearchRegex(Boolean.valueOf(true));
        }
        HashSet<Status> statuses = new HashSet<Status>();
        if (this.statusBoxReceived.isSelected()) {
            statuses.add(Status.RECEIVED);
        }
        if (this.statusBoxTransformed.isSelected()) {
            statuses.add(Status.TRANSFORMED);
        }
        if (this.statusBoxFiltered.isSelected()) {
            statuses.add(Status.FILTERED);
        }
        if (this.statusBoxSent.isSelected()) {
            statuses.add(Status.SENT);
        }
        if (this.statusBoxError.isSelected()) {
            statuses.add(Status.ERROR);
        }
        if (this.statusBoxQueued.isSelected()) {
            statuses.add(Status.QUEUED);
        }
        if (this.statusBoxPending.isSelected()) {
            statuses.add(Status.PENDING);
        }
        if (!statuses.isEmpty()) {
            this.messageFilter.setStatuses(statuses);
        }
        if (StringUtils.isNotEmpty((CharSequence)textSearch) && Preferences.userNodeForPackage(Mirth.class).getBoolean("textSearchWarning", true)) {
            JCheckBox dontShowTextSearchWarningCheckBox = new JCheckBox("Don't show this message again in the future");
            String textSearchWarning = "<html>Text searching may take a long time, depending on the amount of messages being searched.<br/>Are you sure you want to proceed?</html>";
            String textRegexSearchWarning = "<html>Regular expression pattern matching may take a long time and be a costly operation, depending on the amount of messages being searched.<br/>Are you sure you want to proceed?</html>";
            String searchWarning = this.regexTextSearchCheckBox.isSelected() ? textRegexSearchWarning : textSearchWarning;
            Object[] params = new Object[]{searchWarning, dontShowTextSearchWarningCheckBox};
            int result = JOptionPane.showConfirmDialog(this, params, "Select an Option", 0, 3);
            Preferences.userNodeForPackage(Mirth.class).putBoolean("textSearchWarning", !dontShowTextSearchWarningCheckBox.isSelected());
            if (result != 0) {
                return false;
            }
        }
        this.advancedSearchPopup.applySelectionsToFilter(this.messageFilter);
        this.selectedMetaDataIds = this.messageFilter.getIncludedMetaDataIds();
        if (this.messageFilter.getMaxMessageId() == null) {
            try {
                Long maxMessageId = this.parent.mirthClient.getMaxMessageId(this.channelId);
                this.messageFilter.setMaxMessageId(maxMessageId);
            }
            catch (ClientException e) {
                this.parent.alertThrowable((Component)((Object)this.parent), e);
                return false;
            }
        }
        return true;
    }

    protected void runSearch() {
        if (this.generateMessageFilter()) {
            this.updateFilterButtonFont(0);
            try {
                this.configurePaginatedMessageList();
            }
            catch (NumberFormatException e) {
                this.parent.alertError((Component)((Object)this.parent), "Invalid page size.");
                return;
            }
            catch (Exception e) {
                this.parent.alertError((Component)((Object)this.parent), "Error configuring paginated message list: " + e.getMessage());
            }
            this.countButton.setVisible(true);
            this.clearCache();
            this.loadPageNumber(1);
            this.updateSearchCriteriaPane();
            this.auditSearch();
        }
    }

    protected void configurePaginatedMessageList() throws Exception {
        this.messages = new PaginatedMessageList();
        this.messages.setClient(this.parent.mirthClient);
        this.messages.setChannelId(this.channelId);
        this.messages.setMessageFilter(this.messageFilter);
        this.messages.setPageSize(Integer.parseInt(this.pageSizeField.getText()));
    }

    protected void auditSearch() {
        this.auditSearch(this.channelId, this.channelName);
    }

    protected void auditSearch(String channelId, String channelName) {
        if (this.isCURESPHILoggingOn && !this.isChannelMessagesPanelFirstLoadSearch) {
            try {
                LinkedHashMap<String, Object> auditMessageAttributesMap = new LinkedHashMap<String, Object>();
                auditMessageAttributesMap.put("channel", "Channel[id=" + channelId + ",name=" + channelName + "]");
                auditMessageAttributesMap.put("filter", this.messageFilter.toString());
                if (this.messageFilter.getMetaDataSearch() != null) {
                    List elements = this.messageFilter.getMetaDataSearch();
                    for (MetaDataSearchElement element : elements) {
                        if (!element.getColumnName().toString().equals("PATIENT_ID") || !MetaDataSearchOperator.fromString((String)element.getOperator()).toString().equals("=")) continue;
                        auditMessageAttributesMap.put("patientId", element.getValue().toString());
                    }
                }
                this.parent.mirthClient.auditQueriedPHIMessage(auditMessageAttributesMap);
            }
            catch (ClientException e) {
                this.logger.error("Unable to audit the CURES queried PHI event.", (Throwable)e);
            }
        }
    }

    protected void updateSearchCriteriaPane() {
        StringBuilder text = new StringBuilder();
        Calendar startDate = this.messageFilter.getStartDate();
        Calendar endDate = this.messageFilter.getEndDate();
        String padding = "\n";
        text.append("Max Message Id: ");
        text.append(this.messageFilter.getMaxMessageId());
        if (this.messageFilter.getMinMessageId() != null) {
            text.append(padding + "Min Message Id: ");
            text.append(this.messageFilter.getMinMessageId());
        }
        String startDateFormatString = this.mirthTimePicker1.isEnabled() ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd";
        String endDateFormatString = this.mirthTimePicker2.isEnabled() ? "yyyy-MM-dd HH:mm" : "yyyy-MM-dd";
        SimpleDateFormat startDateFormat = new SimpleDateFormat(startDateFormatString);
        SimpleDateFormat endDateFormat = new SimpleDateFormat(endDateFormatString);
        text.append(padding + "Date Range: ");
        if (startDate == null) {
            text.append("(any)");
        } else {
            text.append(startDateFormat.format(startDate.getTime()));
            if (!this.mirthTimePicker1.isEnabled()) {
                text.append(" (all day)");
            }
        }
        text.append(" to ");
        if (endDate == null) {
            text.append("(any)");
        } else {
            text.append(endDateFormat.format(endDate.getTime()));
            if (!this.mirthTimePicker2.isEnabled()) {
                text.append(" (all day)");
            }
        }
        text.append(padding + "Statuses: ");
        if (this.messageFilter.getStatuses() == null) {
            text.append("(any)");
        } else {
            text.append(StringUtils.join((Iterable)this.messageFilter.getStatuses(), (String)", "));
        }
        if (this.messageFilter.getTextSearch() != null) {
            text.append(padding + "Text Search: " + this.messageFilter.getTextSearch());
        }
        text.append(this.getConnectorSearchCriteriaText(padding));
        if (this.messageFilter.getOriginalIdLower() != null || this.messageFilter.getOriginalIdUpper() != null) {
            text.append(padding + "Original Id: ");
            if (this.messageFilter.getOriginalIdUpper() == null) {
                text.append("Greater than " + this.messageFilter.getOriginalIdLower());
            } else if (this.messageFilter.getOriginalIdLower() == null) {
                text.append("Less than " + this.messageFilter.getOriginalIdUpper());
            } else {
                text.append("Between " + this.messageFilter.getOriginalIdLower() + " and " + this.messageFilter.getOriginalIdUpper());
            }
        }
        if (this.messageFilter.getImportIdLower() != null || this.messageFilter.getImportIdUpper() != null) {
            text.append(padding + "Import Id: ");
            if (this.messageFilter.getImportIdUpper() == null) {
                text.append("Greater than " + this.messageFilter.getImportIdLower());
            } else if (this.messageFilter.getImportIdLower() == null) {
                text.append("Less than " + this.messageFilter.getImportIdUpper());
            } else {
                text.append("Between " + this.messageFilter.getImportIdLower() + " and " + this.messageFilter.getImportIdUpper());
            }
        }
        if (this.messageFilter.getServerId() != null) {
            text.append(padding + "Server Id: " + this.messageFilter.getServerId());
        }
        Integer sendAttemptsLower = this.messageFilter.getSendAttemptsLower();
        Integer sendAttemptsUpper = this.messageFilter.getSendAttemptsUpper();
        if (sendAttemptsLower != null || sendAttemptsUpper != null) {
            text.append(padding + "# of Send Attempts: ");
            if (sendAttemptsLower != null) {
                text.append(sendAttemptsLower);
            } else {
                text.append("(any)");
            }
            text.append(" - ");
            if (sendAttemptsUpper != null) {
                text.append(sendAttemptsUpper);
            } else {
                text.append("(any)");
            }
        }
        if (this.messageFilter.getContentSearch() != null) {
            List contentSearch = this.messageFilter.getContentSearch();
            for (ContentSearchElement element : contentSearch) {
                for (String value : element.getSearches()) {
                    text.append(padding + String.valueOf(ContentType.fromCode((int)element.getContentCode())) + " contains \"" + value + "\"");
                }
            }
        }
        if (this.messageFilter.getMetaDataSearch() != null) {
            List elements = this.messageFilter.getMetaDataSearch();
            for (ContentSearchElement element : elements) {
                text.append(padding + element.getColumnName() + " " + MetaDataSearchOperator.fromString((String)element.getOperator()).toString() + " ");
                if (element.getValue() instanceof Calendar) {
                    Calendar date = (Calendar)element.getValue();
                    text.append(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date.getTime()));
                } else {
                    text.append(element.getValue());
                }
                if (!element.getIgnoreCase().booleanValue()) continue;
                text.append(" (Ignore Case)");
            }
        }
        if (this.messageFilter.getAttachment().booleanValue()) {
            text.append(padding + "Has Attachment");
        }
        if (this.messageFilter.getError().booleanValue()) {
            text.append(padding + "Has Error");
        }
        this.lastSearchCriteria.setText(text.toString());
    }

    protected String getConnectorSearchCriteriaText(String padding) {
        StringBuilder text = new StringBuilder();
        text.append(padding + "Connectors: ");
        if (this.messageFilter.getIncludedMetaDataIds() == null) {
            if (this.messageFilter.getExcludedMetaDataIds() == null) {
                text.append("(any)");
            } else {
                List excludedMetaDataIds = this.messageFilter.getExcludedMetaDataIds();
                ArrayList<String> connectorNames = new ArrayList<String>();
                for (Map.Entry<Integer, String> connectorEntry : this.connectors.entrySet()) {
                    if (excludedMetaDataIds.contains(connectorEntry.getKey())) continue;
                    connectorNames.add(connectorEntry.getValue());
                }
                text.append(StringUtils.join(connectorNames, (String)", "));
            }
        } else if (this.messageFilter.getIncludedMetaDataIds().isEmpty()) {
            text.append("(none)");
        } else {
            List includedMetaDataIds = this.messageFilter.getIncludedMetaDataIds();
            ArrayList<String> connectorNames = new ArrayList<String>();
            for (Map.Entry<Integer, String> connectorEntry : this.connectors.entrySet()) {
                if (!includedMetaDataIds.contains(connectorEntry.getKey())) continue;
                connectorNames.add(connectorEntry.getValue());
            }
            text.append(StringUtils.join(connectorNames, (String)", "));
        }
        return text.toString();
    }

    public void jumpToPageNumber() {
        if (this.messages.getPageCount() != null && this.messages.getPageCount() > 0 && StringUtils.isNotEmpty((CharSequence)this.pageNumberField.getText())) {
            this.loadPageNumber(Math.min(Math.max(Integer.parseInt(this.pageNumberField.getText()), 1), this.messages.getPageCount()));
        }
    }

    public void loadPageNumber(final int pageNumber) {
        final String workingId = this.parent.startWorking("Loading page...");
        if (this.worker != null && !this.worker.isDone()) {
            this.parent.mirthClient.getServerConnection().abort(this.getAbortOperations());
            this.worker.cancel(true);
        }
        this.filterButton.setEnabled(false);
        this.nextPageButton.setEnabled(false);
        this.previousPageButton.setEnabled(false);
        this.countButton.setEnabled(false);
        this.pageGoButton.setEnabled(false);
        this.messageTreeTable.requestFocus();
        this.worker = new SwingWorker<Void, Void>(){
            private boolean foundItems = false;
            private int retrievedPageNumber = 1;

            @Override
            public Void doInBackground() {
                try {
                    this.foundItems = MessageBrowser.this.messages.loadPageNumber(pageNumber);
                }
                catch (Throwable t) {
                    if (t.getMessage().contains("Java heap space")) {
                        MessageBrowser.this.parent.alertError((Component)((Object)MessageBrowser.this.parent), "There was an out of memory error when trying to retrieve messages.\nIncrease your heap size or decrease your page size and search again.");
                    } else if (!(t instanceof RequestAbortedException)) {
                        MessageBrowser.this.parent.alertThrowable((Component)((Object)MessageBrowser.this.parent), t);
                    }
                    this.cancel(true);
                }
                return null;
            }

            @Override
            public void done() {
                if (!this.isCancelled()) {
                    boolean enableCountButton = MessageBrowser.this.messages.getItemCount() == null;
                    MessageBrowser.this.deselectRows();
                    MessageBrowser.this.tableModel.clear();
                    if (this.foundItems) {
                        this.retrievedPageNumber = MessageBrowser.this.messages.getPageNumber();
                        MessageBrowser.this.pageNumberField.setText(String.valueOf(this.retrievedPageNumber));
                        for (Message message : MessageBrowser.this.messages) {
                            if (message.getChannelName() == null || message.getChannelName().isEmpty()) {
                                message.setChannelName(MessageBrowser.this.channelName);
                            }
                            MessageBrowser.this.tableModel.addMessage(message);
                        }
                        if (!MessageBrowser.this.messages.hasNextPage()) {
                            MessageBrowser.this.messages.setItemCount(new Long((this.retrievedPageNumber - 1) * MessageBrowser.this.messages.getPageSize() + MessageBrowser.this.messages.size()));
                            enableCountButton = false;
                        }
                    } else {
                        MessageBrowser.this.messages.setItemCount(new Long((this.retrievedPageNumber - 1) * MessageBrowser.this.messages.getPageSize()));
                        enableCountButton = false;
                        MessageBrowser.this.pageNumberField.setText("0");
                    }
                    MessageBrowser.this.messageTreeTable.expandAll();
                    MessageBrowser.this.updatePagination();
                    if (enableCountButton) {
                        MessageBrowser.this.countButton.setEnabled(true);
                    }
                }
                MessageBrowser.this.filterButton.setEnabled(true);
                MessageBrowser.this.parent.stopWorking(workingId);
            }
        };
        this.worker.execute();
    }

    public void updatePagination() {
        int endOffset;
        int startOffset;
        int pageNumber = this.messages.getPageNumber();
        Integer pageCount = this.messages.getPageCount();
        if (this.messages.size() == 0) {
            startOffset = 0;
            endOffset = 0;
        } else {
            startOffset = this.messages.getOffset(pageNumber) + 1;
            endOffset = startOffset + this.messages.size() - 1;
        }
        String resultText = "Results " + DisplayUtil.formatNumber(startOffset) + " - " + DisplayUtil.formatNumber(endOffset) + " of ";
        this.previousPageButton.setEnabled(pageNumber > 1);
        this.nextPageButton.setEnabled(this.messages.hasNextPage());
        if (pageCount != null) {
            this.resultsLabel.setText(resultText + DisplayUtil.formatNumber(this.messages.getItemCount()));
            this.pageTotalLabel.setText("of " + DisplayUtil.formatNumber(this.messages.getPageCount()));
            this.pageTotalLabel.setEnabled(true);
            this.pageGoButton.setEnabled(true);
            this.pageNumberLabel.setEnabled(true);
            this.pageNumberField.setEnabled(true);
        } else {
            this.resultsLabel.setText(resultText + "?");
            this.pageTotalLabel.setText("of ?");
            this.pageGoButton.setEnabled(false);
            this.pageTotalLabel.setEnabled(false);
            this.pageNumberLabel.setEnabled(false);
            this.pageNumberField.setEnabled(false);
        }
    }

    protected void resetResultsText() {
        this.resultsLabel.setText("Results");
    }

    public void refresh(Integer page, boolean clearCache) {
        if (clearCache) {
            this.clearCache();
        }
        if (page == null) {
            this.loadPageNumber(this.messages.getPageNumber());
        } else {
            this.loadPageNumber(page);
        }
    }

    public void clearCache() {
        this.messageCache.clear();
        this.attachmentCache.clear();
    }

    public void updateDescriptionTabs(boolean hasErrors, boolean attachment) {
        String title = this.descriptionTabbedPane.getTitleAt(this.descriptionTabbedPane.getSelectedIndex());
        this.descriptionTabbedPane.removeAll();
        this.descriptionTabbedPane.addTab("Messages", this.MessagesPanel);
        this.descriptionTabbedPane.addTab("Mappings", this.mappingsPane);
        if (hasErrors) {
            this.descriptionTabbedPane.addTab("Errors", this.ErrorsPanel);
        }
        if (attachment) {
            this.descriptionTabbedPane.addTab("Attachments", this.attachmentsPane);
        }
        int tabIndex = Math.max(this.descriptionTabbedPane.indexOfTab(title), 0);
        this.descriptionTabbedPane.setSelectedIndex(tabIndex);
    }

    public void updateMessageRadioGroup() {
        JRadioButton button = this.getRadioButtonForMessagePane(this.lastUserSelectedMessageType);
        if (!button.isShowing()) {
            button = this.RawMessageRadioButton;
        }
        button.setSelected(true);
        this.showMessagePane(button.getText());
    }

    private JRadioButton getRadioButtonForMessagePane(String messagePaneName) {
        if (messagePaneName.equals("Raw")) {
            return this.RawMessageRadioButton;
        }
        if (messagePaneName.equals("Processed Raw")) {
            return this.ProcessedRawMessageRadioButton;
        }
        if (messagePaneName.equals("Transformed")) {
            return this.TransformedMessageRadioButton;
        }
        if (messagePaneName.equals("Encoded")) {
            return this.EncodedMessageRadioButton;
        }
        if (messagePaneName.equals("Sent")) {
            return this.SentMessageRadioButton;
        }
        if (messagePaneName.equals("Response")) {
            return this.ResponseRadioButton;
        }
        if (messagePaneName.equals("Response Transformed")) {
            return this.ResponseTransformedRadioButton;
        }
        if (messagePaneName.equals("Processed Response")) {
            return this.ProcessedResponseRadioButton;
        }
        return null;
    }

    private JRadioButton getRadioButtonForErrorPane(String errorPaneName) {
        if (errorPaneName.equals("Processing Error")) {
            return this.ProcessingErrorRadioButton;
        }
        if (errorPaneName.equals("Postprocessor Error")) {
            return this.PostprocessorErrorRadioButton;
        }
        if (errorPaneName.equals("Response Error")) {
            return this.ResponseErrorRadioButton;
        }
        return null;
    }

    private void setCorrectDocument(final MirthSyntaxTextArea textPane, final String message, String dataType) {
        SyntaxDocument newDoc = new SyntaxDocument();
        boolean isXml = false;
        boolean isJson = false;
        if (StringUtils.isNotEmpty((CharSequence)message)) {
            String trimmedMessage = message.trim();
            isXml = trimmedMessage.length() > 0 && trimmedMessage.charAt(0) == '<';
            boolean bl = isJson = trimmedMessage.length() > 0 && (trimmedMessage.charAt(0) == '{' || trimmedMessage.charAt(0) == '[');
            if (isXml) {
                newDoc.setTokenMarker(new XMLTokenMarker());
            } else if (isJson) {
                newDoc.setTokenMarker(new JSONTokenMarker());
            } else if (dataType != null) {
                newDoc.setTokenMarker(LoadedExtensions.getInstance().getDataTypePlugins().get(dataType).getTokenMarker());
            }
            textPane.setDocument(newDoc);
            textPane.setText(message);
        } else {
            textPane.setDocument(newDoc);
            textPane.setText("");
        }
        textPane.setCaretPosition(0);
        if (this.formatMessageCheckBox.isSelected() && (isXml || isJson)) {
            final boolean formatXml = isXml;
            final boolean formatJson = isJson;
            final String workingId = this.parent.startWorking("Pretty printing...");
            SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){
                String prettifiedMessage = null;

                @Override
                public Void doInBackground() {
                    if (StringUtils.isNotEmpty((CharSequence)message)) {
                        if (formatXml) {
                            this.prettifiedMessage = MirthXmlUtil.prettyPrint((String)message);
                        } else if (formatJson) {
                            try {
                                this.prettifiedMessage = MirthJsonUtil.prettyPrint((String)message);
                            }
                            catch (Exception e) {
                                MessageBrowser.this.logger.error("Error pretty printing json.", (Throwable)e);
                            }
                        }
                    }
                    return null;
                }

                @Override
                public void done() {
                    if (!this.isCancelled() && this.prettifiedMessage != null && StringUtils.isNotEmpty((CharSequence)this.prettifiedMessage)) {
                        textPane.setText(this.prettifiedMessage);
                        textPane.setCaretPosition(0);
                    }
                    MessageBrowser.this.parent.stopWorking(workingId);
                }
            };
            this.prettyPrintWorkers.add((Future<Void>)worker);
            this.executor.submit(worker);
        }
    }

    protected void initColumnData() {
        this.columnMap = new TreeMap();
        this.columnMap.put(0, "Id");
        this.columnMap.put(1, "Connector");
        this.columnMap.put(2, "Status");
        this.columnMap.put(3, "Orig. Received Date");
        this.columnMap.put(4, "Received Date");
        this.columnMap.put(5, "Send Attempts");
        this.columnMap.put(6, "Send Date");
        this.columnMap.put(7, "Response Date");
        this.columnMap.put(8, "Errors");
        this.columnMap.put(9, "Server Id");
        this.columnMap.put(10, "Original Server Id");
        this.columnMap.put(11, "Original Id");
        this.columnMap.put(12, "Import Id");
        this.columnMap.put(13, "Import Channel Id");
        this.columnMap.put(14, "Channel Name");
        this.defaultVisibleColumns = new LinkedHashSet<String>();
        this.defaultVisibleColumns.add(this.columnMap.get(0));
        this.defaultVisibleColumns.add(this.columnMap.get(1));
        this.defaultVisibleColumns.add(this.columnMap.get(2));
        this.defaultVisibleColumns.add(this.columnMap.get(4));
        this.defaultVisibleColumns.add(this.columnMap.get(7));
        this.defaultVisibleColumns.add(this.columnMap.get(8));
    }

    private void makeMessageTable() {
        this.messageTreeTable.setDragEnabled(true);
        this.messageTreeTable.setSortable(false);
        this.messageTreeTable.setSelectionMode(0);
        this.messageTreeTable.setColumnFactory(new MessageBrowserTableColumnFactory());
        this.messageTreeTable.setLeafIcon(null);
        this.messageTreeTable.setOpenIcon(null);
        this.messageTreeTable.setClosedIcon(null);
        this.messageTreeTable.setAutoCreateColumnsFromModel(false);
        this.messageTreeTable.setMirthColumnControlEnabled(true);
        this.messageTreeTable.setShowGrid(true, true);
        this.messageTreeTable.setHorizontalScrollEnabled(true);
        this.messageTreeTable.setPreferredScrollableViewportSize(this.messageTreeTable.getPreferredSize());
        this.messageTreeTable.setMirthTransferHandlerEnabled(true);
        this.tableModel = new MessageBrowserTableModel(this.columnMap.size());
        this.tableModel.setColumnIdentifiers(Arrays.asList(""));
        this.messageTreeTable.setTreeTableModel((TreeTableModel)this.tableModel);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.messageTreeTable.setHighlighters(new Highlighter[]{highlighter});
        }
        this.messageTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MessageBrowser.this.MessageListSelected(evt);
            }
        });
        this.messageTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                MessageBrowser.this.checkMessageSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                MessageBrowser.this.checkMessageSelectionAndPopupMenu(evt);
            }

            @Override
            public void mouseClicked(MouseEvent evt) {
                MessageBrowserTableNode messageNode;
                int row;
                if (evt.getClickCount() >= 2 && (row = MessageBrowser.this.getSelectedMessageIndex()) >= 0 && (messageNode = (MessageBrowserTableNode)((Object)MessageBrowser.this.messageTreeTable.getPathForRow(row).getLastPathComponent())).isNodeActive().booleanValue()) {
                    String channelId = messageNode.getChannelId();
                    Long messageId = messageNode.getMessageId();
                    Integer metaDataId = messageNode.getMetaDataId();
                    Message currentMessage = MessageBrowser.this.getMessageFromCache(channelId, messageId);
                    ConnectorMessage connectorMessage = (ConnectorMessage)currentMessage.getConnectorMessages().get(metaDataId);
                    ArrayList<Integer> selectedMetaDataIds = new ArrayList<Integer>();
                    HashMap<String, Object> sourceMap = new HashMap<String, Object>();
                    if (connectorMessage.getSourceMap() != null) {
                        sourceMap.putAll(connectorMessage.getSourceMap());
                        sourceMap.remove("destinationSet");
                    }
                    if (metaDataId == 0) {
                        selectedMetaDataIds = null;
                    } else {
                        selectedMetaDataIds.add(metaDataId);
                    }
                    if (connectorMessage.getRaw() != null) {
                        MessageBrowser.this.parent.editMessageDialog.setPropertiesAndShow(connectorMessage.getRaw().getContent(), connectorMessage.getRaw().getDataType(), channelId, MessageBrowser.this.parent.dashboardPanel.getDestinationConnectorNames(channelId), selectedMetaDataIds, sourceMap);
                    }
                }
            }
        });
        this.messageTreeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                block7: {
                    block8: {
                        int row = MessageBrowser.this.getSelectedMessageIndex();
                        if (row < 0) break block7;
                        if (e.getKeyCode() != 127) break block8;
                        MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)MessageBrowser.this.messageTreeTable.getPathForRow(row).getLastPathComponent());
                        if (!messageNode.isNodeActive().booleanValue()) break block7;
                        MessageBrowser.this.parent.doRemoveMessage();
                        break block7;
                    }
                    if (!MessageBrowser.this.descriptionTabbedPane.getTitleAt(MessageBrowser.this.descriptionTabbedPane.getSelectedIndex()).equals("Messages")) break block7;
                    if (e.getKeyCode() == 37) {
                        ArrayList<AbstractButton> buttons = Collections.list(MessageBrowser.this.messagesGroup.getElements());
                        boolean passedSelected = false;
                        for (int i = buttons.size() - 1; i >= 0; --i) {
                            AbstractButton button = (AbstractButton)buttons.get(i);
                            if (passedSelected && button.isShowing()) {
                                MessageBrowser.this.lastUserSelectedMessageType = ((AbstractButton)buttons.get(i)).getText();
                                MessageBrowser.this.updateMessageRadioGroup();
                                break;
                            }
                            if (!button.isSelected()) continue;
                            passedSelected = true;
                        }
                    } else if (e.getKeyCode() == 39) {
                        ArrayList<AbstractButton> buttons = Collections.list(MessageBrowser.this.messagesGroup.getElements());
                        boolean passedSelected = false;
                        for (int i = 0; i < buttons.size(); ++i) {
                            AbstractButton button = (AbstractButton)buttons.get(i);
                            if (passedSelected && button.isShowing()) {
                                MessageBrowser.this.lastUserSelectedMessageType = ((AbstractButton)buttons.get(i)).getText();
                                MessageBrowser.this.updateMessageRadioGroup();
                                break;
                            }
                            if (!button.isSelected()) continue;
                            passedSelected = true;
                        }
                    }
                }
            }
        });
    }

    private void makeMappingsTable() {
        this.updateMappingsTable(null, true);
        this.mappingsTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (MessageBrowser.this.mappingsTable.rowAtPoint(new Point(evt.getX(), evt.getY())) == -1) {
                    return;
                }
                if (evt.getClickCount() >= 2) {
                    new ViewContentDialog((String)MessageBrowser.this.mappingsTable.getModel().getValueAt(MessageBrowser.this.mappingsTable.convertRowIndexToModel(MessageBrowser.this.mappingsTable.getSelectedRow()), 2));
                }
            }
        });
        this.mappingsTable.setSelectionMode(0);
        this.mappingsTable.getColumnExt("Scope").setMinWidth(75);
        this.mappingsTable.getColumnExt("Scope").setMaxWidth(200);
        DefaultTableCellRenderer noHTMLRenderer = new DefaultTableCellRenderer();
        noHTMLRenderer.putClientProperty("html.disable", Boolean.TRUE);
        this.mappingsTable.getColumnExt("Value").setCellRenderer((TableCellRenderer)noHTMLRenderer);
        this.mappingsPane.setViewportView((Component)((Object)this.mappingsTable));
    }

    public void updateMappingsTable(String[][] tableData, boolean cleared) {
        if (tableData == null || tableData.length == 0) {
            tableData = new String[1][3];
            tableData[0][1] = cleared ? "Please select a message to view mappings." : "There are no mappings present.";
            tableData[0][0] = "";
            tableData[0][2] = "";
        }
        if (this.mappingsTable != null) {
            RefreshTableModel model = (RefreshTableModel)this.mappingsTable.getModel();
            model.refreshDataVector(tableData);
        } else {
            this.mappingsTable = new MirthTable();
            this.mappingsTable.setModel(new RefreshTableModel(tableData, new String[]{"Scope", "Variable", "Value"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false, false};
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
        }
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
            this.mappingsTable.setHighlighters(new Highlighter[]{highlighter});
        }
    }

    public void updateAttachmentsTable(String channelId, Long messageId) {
        Object[][] tableData = this.updateAttachmentList(channelId, messageId);
        if (this.attachmentTable != null) {
            RefreshTableModel model = (RefreshTableModel)this.attachmentTable.getModel();
            if (tableData != null) {
                model.refreshDataVector(tableData);
            }
        } else {
            this.attachmentTable = new MirthTable();
            this.attachmentTable.setModel(new RefreshTableModel(tableData, new String[]{"#", "Type", "Attachment Id"}){
                boolean[] canEdit;
                {
                    this.canEdit = new boolean[]{false, false, false};
                }

                @Override
                public boolean isCellEditable(int rowIndex, int columnIndex) {
                    return this.canEdit[columnIndex];
                }
            });
            this.attachmentTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent evt) {
                    if (MessageBrowser.this.attachmentTable != null && MessageBrowser.this.attachmentTable.getSelectedRow() != -1) {
                        MessageBrowser.this.parent.setVisibleTasks(MessageBrowser.this.parent.messageTasks, MessageBrowser.this.parent.messagePopupMenu, 9, 10, true);
                    } else {
                        MessageBrowser.this.parent.setVisibleTasks(MessageBrowser.this.parent.messageTasks, MessageBrowser.this.parent.messagePopupMenu, 9, 10, false);
                    }
                }
            });
            this.attachmentTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MessageBrowser.this.checkAttachmentSelectionAndPopupMenu(evt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    MessageBrowser.this.checkAttachmentSelectionAndPopupMenu(evt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (MessageBrowser.this.attachmentTable.rowAtPoint(new Point(evt.getX(), evt.getY())) == -1) {
                        return;
                    }
                    if (evt.getClickCount() >= 2) {
                        MessageBrowser.this.viewAttachment();
                    }
                }
            });
            if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
                Highlighter highlighter = HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR);
                this.attachmentTable.setHighlighters(new Highlighter[]{highlighter});
            }
            this.attachmentTable.setSelectionMode(0);
            this.attachmentTable.getColumnExt("#").setMinWidth(20);
            this.attachmentTable.getColumnExt("#").setMaxWidth(50);
            this.attachmentTable.getColumnExt("Type").setMinWidth(75);
            this.attachmentTable.getColumnExt("Type").setMaxWidth(200);
            this.attachmentsPane.setViewportView((Component)((Object)this.attachmentTable));
        }
    }

    public Object[][] updateAttachmentList(String channelId, Long messageId) {
        if (messageId == null) {
            return null;
        }
        try {
            List<Attachment> attachments = this.getAttachmentsFromCache(channelId, messageId);
            ArrayList<Object[]> attachData = new ArrayList<Object[]>();
            int count = 1;
            ArrayList<String> types = new ArrayList<String>();
            for (Attachment attachment : attachments) {
                String type = attachment.getType();
                if (types.contains(type)) continue;
                types.add(type);
            }
            for (String type : types) {
                Object[] rowData;
                if (this.getAttachmentViewer(type) != null && this.getAttachmentViewer(type).handleMultiple()) {
                    Object number = Integer.toString(count);
                    Object attachment_Ids = "";
                    for (Attachment attachment : attachments) {
                        if (!type.equals(attachment.getType())) continue;
                        if (((String)attachment_Ids).equals("")) {
                            attachment_Ids = attachment.getId();
                            continue;
                        }
                        ++count;
                        attachment_Ids = (String)attachment_Ids + ", " + attachment.getId();
                    }
                    if (!((String)number).equals(Integer.toString(count))) {
                        number = (String)number + " - " + Integer.toString(count);
                    }
                    rowData = new Object[]{number, type, attachment_Ids};
                    attachData.add(rowData);
                    continue;
                }
                for (Attachment attachment : attachments) {
                    if (!attachment.getType().equals(type)) continue;
                    rowData = new Object[]{Integer.toString(count), attachment.getType(), attachment.getId()};
                    attachData.add(rowData);
                    ++count;
                }
            }
            Object[][] temp = new Object[attachData.size()][3];
            int rowCount = 0;
            for (Object[] objects : attachData) {
                temp[rowCount] = objects;
                ++rowCount;
            }
            return temp;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public AttachmentViewer getAttachmentViewer(String type) {
        if (LoadedExtensions.getInstance().getAttachmentViewerPlugins().size() > 0) {
            for (AttachmentViewer plugin : LoadedExtensions.getInstance().getAttachmentViewerPlugins().values()) {
                if (!plugin.isContentTypeViewable(type)) continue;
                return plugin;
            }
        }
        return null;
    }

    private void checkMessageSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.messageTreeTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.messageTreeTable.setRowSelectionInterval(row, row);
            }
            this.parent.messagePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    private void checkAttachmentSelectionAndPopupMenu(MouseEvent evt) {
        int row = this.attachmentTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
        if (row == -1) {
            this.deselectAttachmentRows();
        }
        if (evt.isPopupTrigger()) {
            if (row != -1) {
                this.attachmentTable.setRowSelectionInterval(row, row);
            }
            this.attachmentPopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }
    }

    public void deselectRows() {
        if (this.messageTreeTable != null) {
            this.messageTreeTable.clearSelection();
        }
        this.clearDescription(null);
    }

    public void deselectAttachmentRows() {
        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 9, 10, false);
        if (this.attachmentTable != null) {
            this.attachmentTable.clearSelection();
        }
    }

    private void clearDescription(String text) {
        this.taskPaneWhenClearingDescription();
        this.RawMessageTextPane.setDocument(new SyntaxDocument());
        this.RawMessageTextPane.setText(text != null ? text : "Select a message to view the raw message.");
        this.ProcessedRawMessageTextPane.setDocument(new SyntaxDocument());
        this.ProcessedRawMessageTextPane.setText(text != null ? text : "Select a message to view the processed raw message.");
        this.TransformedMessageTextPane.setDocument(new SyntaxDocument());
        this.TransformedMessageTextPane.setText(text != null ? text : "Select a message to view the transformed message.");
        this.EncodedMessageTextPane.setDocument(new SyntaxDocument());
        this.EncodedMessageTextPane.setText(text != null ? text : "Select a message to view the encoded message.");
        this.SentMessageTextPane.setDocument(new SyntaxDocument());
        this.SentMessageTextPane.setText(text != null ? text : "Select a message to view the sent message.");
        this.ResponseTextArea.setDocument(new SyntaxDocument());
        this.ResponseTextArea.setText(text != null ? text : "Select a message to view the response message.");
        this.responseStatusTextArea.setText("");
        this.responseStatusTextArea.setCaretPosition(0);
        this.ResponseTransformedTextPane.setDocument(new SyntaxDocument());
        this.ResponseTransformedTextPane.setText(text != null ? text : "Select a message to view the response transformed message.");
        this.ProcessedResponseTextArea.setDocument(new SyntaxDocument());
        this.ProcessedResponseTextArea.setText(text != null ? text : "Select a message to view the processed response message.");
        this.processedResponseStatusTextArea.setText("");
        this.processedResponseStatusTextArea.setCaretPosition(0);
        this.ProcessingErrorTextPane.setDocument(new SyntaxDocument());
        this.ProcessingErrorTextPane.setText(text != null ? text : "Select a message to view any errors.");
        this.ResponseErrorTextPane.setDocument(new SyntaxDocument());
        this.ResponseErrorTextPane.setText(text != null ? text : "Select a message to view any errors.");
        this.updateMappingsTable(new String[0][0], true);
        this.updateAttachmentsTable(null, null);
        this.descriptionTabbedPane.remove(this.attachmentsPane);
        this.formatMessageCheckBox.setEnabled(false);
    }

    protected void taskPaneWhenClearingDescription() {
        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 6, -1, false);
        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 7, 7, this.isChannelDeployed);
    }

    public Message getSelectedMessage() {
        String channelId = this.getSelectedMessageChannelId();
        Long messageId = this.getSelectedMessageId();
        if (messageId != null) {
            return this.getMessageFromCache(channelId, messageId);
        }
        return null;
    }

    public ConnectorMessage getSelectedConnectorMessage() {
        Message message = this.getSelectedMessage();
        Integer metaDataId = this.getSelectedMetaDataId();
        if (message != null && metaDataId != null) {
            return (ConnectorMessage)message.getConnectorMessages().get(metaDataId);
        }
        return null;
    }

    public String getSelectedMessageChannelId() {
        int row = this.getSelectedMessageIndex();
        if (row >= 0) {
            MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)this.messageTreeTable.getPathForRow(row).getLastPathComponent());
            return messageNode.getChannelId();
        }
        return null;
    }

    public Long getSelectedMessageId() {
        int row = this.getSelectedMessageIndex();
        if (row >= 0) {
            MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)this.messageTreeTable.getPathForRow(row).getLastPathComponent());
            return messageNode.getMessageId();
        }
        return null;
    }

    public Integer getSelectedMetaDataId() {
        int row = this.getSelectedMessageIndex();
        if (row >= 0) {
            MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)this.messageTreeTable.getPathForRow(row).getLastPathComponent());
            return messageNode.getMetaDataId();
        }
        return null;
    }

    public String getSelectedAttachmentId() {
        return (String)this.attachmentTable.getModel().getValueAt(this.attachmentTable.convertRowIndexToModel(this.attachmentTable.getSelectedRow()), 2);
    }

    public String getSelectedMimeType() {
        return (String)this.attachmentTable.getModel().getValueAt(this.attachmentTable.convertRowIndexToModel(this.attachmentTable.getSelectedRow()), 1);
    }

    public boolean canReprocessMessage(Long messageId) {
        ConnectorMessage sourceMessage;
        Message message = this.getMessageFromCache(this.channelId, messageId);
        return message == null || (sourceMessage = (ConnectorMessage)message.getConnectorMessages().get(0)) == null || sourceMessage.getRaw() != null;
    }

    public void viewAttachment() {
        try {
            final String attachmentId = this.getSelectedAttachmentId();
            final Long messageId = this.getSelectedMessageId();
            final String selectedChannelId = this.getSelectedMessageChannelId();
            String contentType = (String)this.attachmentTable.getModel().getValueAt(this.attachmentTable.convertRowIndexToModel(this.attachmentTable.getSelectedRow()), 1);
            if (LoadedExtensions.getInstance().getAttachmentViewerPlugins().size() > 0) {
                AttachmentViewer attachmentViewer;
                if (Preferences.userNodeForPackage(Mirth.class).getBoolean("messageBrowserShowAttachmentTypeDialog", true)) {
                    dialog = new AttachmentTypeDialog(contentType);
                    attachmentViewer = dialog.getAttachmentViewer();
                } else {
                    attachmentViewer = this.getAttachmentViewer(contentType);
                    if (attachmentViewer == null) {
                        dialog = new AttachmentTypeDialog(contentType);
                        attachmentViewer = dialog.getAttachmentViewer();
                    }
                }
                if (attachmentViewer != null) {
                    final String workingId = this.parent.startWorking("Loading " + attachmentViewer.getPluginName() + "...");
                    final AttachmentViewer finalAttachmentViewer = attachmentViewer;
                    SwingWorker<Void, Void> worker = new SwingWorker<Void, Void>(){

                        @Override
                        public Void doInBackground() {
                            finalAttachmentViewer.viewAttachments(selectedChannelId, messageId, attachmentId);
                            return null;
                        }

                        @Override
                        public void done() {
                            MessageBrowser.this.parent.stopWorking(workingId);
                        }
                    };
                    worker.execute();
                }
            } else {
                this.parent.alertWarning(this, "No Attachment Viewer plugins installed.");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void exportAttachment() {
        this.parent.doExportAttachment();
    }

    private int getSelectedMessageIndex() {
        int row = -1;
        if (this.messageTreeTable.getSelectedRow() > -1) {
            row = this.messageTreeTable.convertRowIndexToModel(this.messageTreeTable.getSelectedRow());
        }
        return row;
    }

    private void MessageListSelected(ListSelectionEvent evt) {
        int row;
        if (!evt.getValueIsAdjusting() && (row = this.getSelectedMessageIndex()) >= 0) {
            for (Future<Void> worker : this.prettyPrintWorkers) {
                worker.cancel(true);
            }
            this.prettyPrintWorkers.clear();
            this.taskPaneWhenSelectingMessages();
            this.setCursor(Cursor.getPredefinedCursor(3));
            MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)this.messageTreeTable.getPathForRow(row).getLastPathComponent());
            if (messageNode.isNodeActive().booleanValue()) {
                ConnectorMessage connectorMessage;
                String channelId = messageNode.getChannelId();
                Long messageId = messageNode.getMessageId();
                Integer metaDataId = messageNode.getMetaDataId();
                Message message = this.getMessageFromCache(channelId, messageId);
                List attachments = this.getAttachmentsFromCache(channelId, messageId);
                if (message == null) {
                    try {
                        message = this.getMessageContent(channelId, messageId);
                        if (message == null || message.getConnectorMessages().size() == 0) {
                            this.clearDescription("Could not retrieve message content. The message may have been deleted.");
                            this.setCursor(Cursor.getPredefinedCursor(0));
                            return;
                        }
                        attachments = this.parent.mirthClient.getAttachmentsByMessageId(channelId, messageId, false);
                    }
                    catch (Throwable t) {
                        if (t.getMessage().contains("Java heap space")) {
                            this.parent.alertError((Component)((Object)this.parent), "There was an out of memory error when trying to retrieve message content.\nIncrease your heap size and try again.");
                        } else if (!(t instanceof RequestAbortedException)) {
                            this.parent.alertThrowable((Component)((Object)this.parent), t);
                        }
                        this.setCursor(Cursor.getPredefinedCursor(0));
                        return;
                    }
                    this.putMessageInCache(channelId, messageId, message);
                    this.putAttachmentsInCache(channelId, messageId, attachments);
                }
                if ((connectorMessage = (ConnectorMessage)message.getConnectorMessages().get(metaDataId)) != null) {
                    this.updateDescriptionMessages(connectorMessage);
                    this.updateDescriptionMappings(connectorMessage);
                    this.updateAttachmentsTable(channelId, messageId);
                    this.updateDescriptionErrors(connectorMessage);
                    this.updateDescriptionTabs(connectorMessage.getProcessingError() != null || connectorMessage.getPostProcessorError() != null || connectorMessage.getResponseError() != null, attachments.size() > 0);
                    this.updateMessageRadioGroup();
                    if (this.attachmentTable == null || this.attachmentTable.getSelectedRow() == -1 || this.descriptionTabbedPane.indexOfTab("Attachments") == -1) {
                        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 9, 10, false);
                    }
                    if (this.isCURESPHILoggingOn) {
                        try {
                            LinkedHashMap<String, Object> auditMessageAttributesMap = new LinkedHashMap<String, Object>();
                            auditMessageAttributesMap.put("patientId", connectorMessage.getMetaDataMap() != null && connectorMessage.getMetaDataMap().get("PATIENT_ID") != null ? connectorMessage.getMetaDataMap().get("PATIENT_ID").toString() : "");
                            auditMessageAttributesMap.put("channel", "Channel[id=" + channelId + ",name=" + this.channelName + "]");
                            auditMessageAttributesMap.put("messageId", String.valueOf(connectorMessage.getMessageId()));
                            this.parent.mirthClient.auditAccessedPHIMessage(auditMessageAttributesMap);
                        }
                        catch (ClientException e) {
                            this.logger.error("Unable to audit the CURES accessed PHI event.", (Throwable)e);
                        }
                    }
                }
            } else {
                this.clearDescription(null);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected Message getMessageContent(String channelId, Long messageId) throws ClientException {
        return this.parent.mirthClient.getMessageContent(channelId, messageId, this.selectedMetaDataIds);
    }

    protected void taskPaneWhenSelectingMessages() {
        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 6, 6, true);
        this.parent.setVisibleTasks(this.parent.messageTasks, this.parent.messagePopupMenu, 7, -1, this.isChannelDeployed);
    }

    private void updateDescriptionMessages(ConnectorMessage connectorMessage) {
        Response responseObject;
        ObjectXMLSerializer serializer;
        MessageContent rawMessage = connectorMessage.getRaw();
        MessageContent processedRawMessage = connectorMessage.getProcessedRaw();
        MessageContent transformedMessage = connectorMessage.getTransformed();
        MessageContent encodedMessage = connectorMessage.getEncoded();
        MessageContent sentMessage = connectorMessage.getSent();
        MessageContent responseMessage = connectorMessage.getResponse();
        MessageContent responseTransformedMessage = connectorMessage.getResponseTransformed();
        MessageContent processedResponseMessage = connectorMessage.getProcessedResponse();
        this.MessagesRadioPane.removeAll();
        String content = null;
        String dataType = null;
        content = rawMessage == null ? null : rawMessage.getContent();
        String string = dataType = rawMessage == null ? null : rawMessage.getDataType();
        if (content != null) {
            this.MessagesRadioPane.add(this.RawMessageRadioButton);
        }
        this.setCorrectDocument(this.RawMessageTextPane, content, dataType);
        content = processedRawMessage == null ? null : processedRawMessage.getContent();
        String string2 = dataType = processedRawMessage == null ? null : processedRawMessage.getDataType();
        if (content != null) {
            this.MessagesRadioPane.add(this.ProcessedRawMessageRadioButton);
        }
        this.setCorrectDocument(this.ProcessedRawMessageTextPane, content, dataType);
        content = transformedMessage == null ? null : transformedMessage.getContent();
        String string3 = dataType = transformedMessage == null ? null : transformedMessage.getDataType();
        if (content != null) {
            this.MessagesRadioPane.add(this.TransformedMessageRadioButton);
        }
        this.setCorrectDocument(this.TransformedMessageTextPane, content, dataType);
        content = encodedMessage == null ? null : encodedMessage.getContent();
        String string4 = dataType = encodedMessage == null ? null : encodedMessage.getDataType();
        if (content != null) {
            this.MessagesRadioPane.add(this.EncodedMessageRadioButton);
        }
        this.setCorrectDocument(this.EncodedMessageTextPane, content, dataType);
        content = null;
        if (sentMessage != null) {
            ConnectorProperties sentObject;
            content = connectorMessage.getMetaDataId() > 0 ? ((sentObject = (ConnectorProperties)(serializer = ObjectXMLSerializer.getInstance()).deserialize(sentMessage.getContent(), ConnectorProperties.class)) == null ? null : sentObject.toFormattedString()) : sentMessage.getContent();
        }
        String string5 = dataType = sentMessage == null ? null : sentMessage.getDataType();
        if (content != null) {
            this.MessagesRadioPane.add(this.SentMessageRadioButton);
        }
        this.setCorrectDocument(this.SentMessageTextPane, content, dataType);
        content = null;
        if (responseMessage != null) {
            serializer = ObjectXMLSerializer.getInstance();
            responseObject = (Response)serializer.deserialize(responseMessage.getContent(), Response.class);
            if (responseObject != null) {
                String responseStatusMessage = StringUtils.isEmpty((CharSequence)responseObject.getStatusMessage()) ? "" : ": " + responseObject.getStatusMessage();
                this.responseStatusTextArea.setText(responseObject.getStatus().toString() + responseStatusMessage);
                this.responseStatusTextArea.setCaretPosition(0);
                content = responseObject.getMessage();
            }
            String string6 = responseMessage == null ? null : (dataType = connectorMessage.getMetaDataId() == 0 ? rawMessage.getDataType() : responseMessage.getDataType());
        }
        if (content != null) {
            this.MessagesRadioPane.add(this.ResponseRadioButton);
        }
        this.setCorrectDocument(this.ResponseTextArea, content, dataType);
        content = responseTransformedMessage == null ? null : responseTransformedMessage.getContent();
        String string7 = dataType = responseTransformedMessage == null ? null : responseTransformedMessage.getDataType();
        if (content != null) {
            this.MessagesRadioPane.add(this.ResponseTransformedRadioButton);
        }
        this.setCorrectDocument(this.ResponseTransformedTextPane, content, dataType);
        content = null;
        if (processedResponseMessage != null) {
            if (connectorMessage.getMetaDataId() > 0) {
                serializer = ObjectXMLSerializer.getInstance();
                responseObject = (Response)serializer.deserialize(processedResponseMessage.getContent(), Response.class);
                if (responseObject != null) {
                    String processedResponseStatusMessage = StringUtils.isEmpty((CharSequence)responseObject.getStatusMessage()) ? "" : ": " + responseObject.getStatusMessage();
                    this.processedResponseStatusTextArea.setText(responseObject.getStatus().toString() + processedResponseStatusMessage);
                    this.processedResponseStatusTextArea.setCaretPosition(0);
                    content = responseObject.getMessage();
                }
            } else {
                this.processedResponseStatusTextArea.setText("");
                this.processedResponseStatusTextArea.setCaretPosition(0);
                content = processedResponseMessage.getContent();
            }
        }
        String string8 = dataType = processedResponseMessage == null ? null : processedResponseMessage.getDataType();
        if (content != null) {
            this.MessagesRadioPane.add(this.ProcessedResponseRadioButton);
        }
        this.setCorrectDocument(this.ProcessedResponseTextArea, content, dataType);
    }

    private void updateDescriptionMappings(ConnectorMessage connectorMessage) {
        Map sourceMap = connectorMessage.getSourceMap();
        Map connectorMap = connectorMessage.getConnectorMap();
        Map channelMap = connectorMessage.getChannelMap();
        Map responseMap = connectorMessage.getResponseMap();
        int rowCount = 0;
        if (sourceMap != null) {
            rowCount += sourceMap.size();
        }
        if (connectorMap != null) {
            rowCount += connectorMap.size();
        }
        if (channelMap != null) {
            rowCount += channelMap.size();
        }
        if (responseMap != null) {
            rowCount += responseMap.size();
        }
        String[][] tableData = new String[rowCount][3];
        int row = 0;
        if (sourceMap != null) {
            for (Map.Entry variableMapEntry : sourceMap.entrySet()) {
                tableData[row][0] = "Source";
                tableData[row][1] = StringUtil.valueOf(variableMapEntry.getKey());
                tableData[row][2] = StringUtil.valueOf(variableMapEntry.getValue());
                ++row;
            }
        }
        if (connectorMap != null) {
            for (Map.Entry variableMapEntry : connectorMap.entrySet()) {
                tableData[row][0] = "Connector";
                tableData[row][1] = StringUtil.valueOf(variableMapEntry.getKey());
                tableData[row][2] = StringUtil.valueOf(variableMapEntry.getValue());
                ++row;
            }
        }
        if (channelMap != null) {
            for (Map.Entry variableMapEntry : channelMap.entrySet()) {
                tableData[row][0] = "Channel";
                tableData[row][1] = StringUtil.valueOf(variableMapEntry.getKey());
                tableData[row][2] = StringUtil.valueOf(variableMapEntry.getValue());
                ++row;
            }
        }
        if (responseMap != null) {
            for (Map.Entry variableMapEntry : responseMap.entrySet()) {
                tableData[row][0] = "Response";
                tableData[row][1] = StringUtil.valueOf(variableMapEntry.getKey());
                tableData[row][2] = StringUtil.valueOf(variableMapEntry.getValue());
                ++row;
            }
        }
        this.updateMappingsTable(tableData, false);
    }

    private void updateDescriptionErrors(ConnectorMessage connectorMessage) {
        String processingError = connectorMessage.getProcessingError();
        String postProcessorError = connectorMessage.getPostProcessorError();
        String responseError = connectorMessage.getResponseError();
        this.ErrorsRadioPane.removeAll();
        boolean paneSelected = false;
        String firstVisiblePane = null;
        if (processingError != null) {
            this.ErrorsRadioPane.add(this.ProcessingErrorRadioButton);
            paneSelected = this.lastUserSelectedErrorType.equals(this.ProcessingErrorRadioButton.getText());
            if (firstVisiblePane == null) {
                firstVisiblePane = this.ProcessingErrorRadioButton.getText();
            }
            this.setCorrectDocument(this.ProcessingErrorTextPane, processingError, null);
        }
        if (postProcessorError != null) {
            this.ErrorsRadioPane.add(this.PostprocessorErrorRadioButton);
            paneSelected = this.lastUserSelectedErrorType.equals(this.PostprocessorErrorRadioButton.getText());
            if (firstVisiblePane == null) {
                firstVisiblePane = this.PostprocessorErrorRadioButton.getText();
            }
            this.setCorrectDocument(this.PostprocessorErrorTextPane, postProcessorError, null);
        }
        if (responseError != null) {
            this.ErrorsRadioPane.add(this.ResponseErrorRadioButton);
            paneSelected = this.lastUserSelectedErrorType.equals(this.ResponseErrorRadioButton.getText());
            if (firstVisiblePane == null) {
                firstVisiblePane = this.ResponseErrorRadioButton.getText();
            }
            this.setCorrectDocument(this.ResponseErrorTextPane, responseError, null);
        }
        String paneToSelect = !paneSelected ? (firstVisiblePane != null ? firstVisiblePane : this.ProcessingErrorRadioButton.getText()) : this.lastUserSelectedErrorType;
        JRadioButton button = this.getRadioButtonForErrorPane(paneToSelect);
        button.setSelected(true);
        this.showErrorPane(button.getText());
    }

    private void messagesRadioButtonActionPerformed(ActionEvent evt) {
        JRadioButton messagesRadioButton = (JRadioButton)evt.getSource();
        this.showMessagePane(messagesRadioButton.getText());
        this.lastUserSelectedMessageType = messagesRadioButton.getText();
    }

    private void showMessagePane(String messagePaneName) {
        CardLayout cardLayout = (CardLayout)this.MessagesCardPane.getLayout();
        this.updateXmlCheckBoxEnabled(messagePaneName);
        cardLayout.show(this.MessagesCardPane, messagePaneName);
    }

    private void errorsRadioButtonActionPerformed(ActionEvent evt) {
        JRadioButton errorsRadioButton = (JRadioButton)evt.getSource();
        this.showErrorPane(errorsRadioButton.getText());
        this.lastUserSelectedErrorType = errorsRadioButton.getText();
    }

    private void showErrorPane(String errorPaneName) {
        CardLayout cardLayout = (CardLayout)this.ErrorsCardPane.getLayout();
        cardLayout.show(this.ErrorsCardPane, errorPaneName);
    }

    private void updateXmlCheckBoxEnabled(String messagePaneName) {
        int row = this.getSelectedMessageIndex();
        if (row >= 0) {
            MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)this.messageTreeTable.getPathForRow(row).getLastPathComponent());
            if (messageNode.isNodeActive().booleanValue()) {
                String channelId = messageNode.getChannelId();
                Long messageId = messageNode.getMessageId();
                Integer metaDataId = messageNode.getMetaDataId();
                Message message = this.getMessageFromCache(channelId, messageId);
                ConnectorMessage connectorMessage = (ConnectorMessage)message.getConnectorMessages().get(metaDataId);
                MessageContent content = null;
                if (messagePaneName.equals("Raw")) {
                    content = connectorMessage.getRaw();
                } else if (messagePaneName.equals("Processed Raw")) {
                    content = connectorMessage.getProcessedRaw();
                } else if (messagePaneName.equals("Transformed")) {
                    content = connectorMessage.getTransformed();
                } else if (messagePaneName.equals("Encoded")) {
                    content = connectorMessage.getEncoded();
                } else if (messagePaneName.equals("Sent")) {
                    content = connectorMessage.getSent();
                } else if (messagePaneName.equals("Response")) {
                    content = connectorMessage.getResponse();
                } else if (messagePaneName.equals("Response Transformed")) {
                    content = connectorMessage.getResponseTransformed();
                } else if (messagePaneName.equals("Processed Response")) {
                    content = connectorMessage.getProcessedResponse();
                }
                if (content != null && StringUtils.isNotEmpty((CharSequence)content.getContent())) {
                    char firstChar;
                    String trimmedContent = "";
                    if (messagePaneName.equals("Response") || messagePaneName.equals("Processed Response")) {
                        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
                        Response responseObject = (Response)serializer.deserialize(content.getContent(), Response.class);
                        if (responseObject != null) {
                            trimmedContent = responseObject.getMessage().trim();
                        }
                    } else {
                        trimmedContent = content.getContent().trim();
                    }
                    if (trimmedContent.length() > 0 && ((firstChar = trimmedContent.charAt(0)) == '<' || firstChar == '{' || firstChar == '[')) {
                        this.formatMessageCheckBox.setEnabled(true);
                    }
                }
            } else {
                this.formatMessageCheckBox.setEnabled(false);
            }
        }
    }

    private void formatCheckBoxActionPerformed(ActionEvent evt) {
        int row = this.getSelectedMessageIndex();
        if (row >= 0) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)this.messageTreeTable.getPathForRow(row).getLastPathComponent());
            String channelId = messageNode.getChannelId();
            Long messageId = messageNode.getMessageId();
            Integer metaDataId = messageNode.getMetaDataId();
            Message message = this.getMessageFromCache(channelId, messageId);
            ConnectorMessage connectorMessage = (ConnectorMessage)message.getConnectorMessages().get(metaDataId);
            this.updateDescriptionMessages(connectorMessage);
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    protected void nextPageButtonActionPerformed(ActionEvent evt) {
        this.loadPageNumber(this.messages.getPageNumber() + 1);
    }

    protected void previousPageButtonActionPerformed(ActionEvent evt) {
        this.loadPageNumber(this.messages.getPageNumber() - 1);
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.messagesGroup = new ButtonGroup();
        this.errorsGroup = new ButtonGroup();
        this.jDialog1 = new JDialog();
        this.jSplitPane1 = new JSplitPane();
        this.descriptionTabbedPane = new JTabbedPane();
        this.MessagesPanel = new JPanel();
        this.MessagesRadioPane = new JPanel();
        this.RawMessageRadioButton = new JRadioButton();
        this.ProcessedRawMessageRadioButton = new JRadioButton();
        this.TransformedMessageRadioButton = new JRadioButton();
        this.EncodedMessageRadioButton = new JRadioButton();
        this.SentMessageRadioButton = new JRadioButton();
        this.ResponseRadioButton = new JRadioButton();
        this.ResponseTransformedRadioButton = new JRadioButton();
        this.ProcessedResponseRadioButton = new JRadioButton();
        this.MessagesCardPane = new JPanel();
        this.RawMessageTextPane = new MirthSyntaxTextArea();
        this.ProcessedRawMessageTextPane = new MirthSyntaxTextArea();
        this.TransformedMessageTextPane = new MirthSyntaxTextArea();
        this.EncodedMessageTextPane = new MirthSyntaxTextArea();
        this.SentMessageTextPane = new MirthSyntaxTextArea();
        this.ResponseTextPane = new JPanel();
        this.responseStatusLabel = new JLabel();
        this.responseLabel = new JLabel();
        this.ResponseTextArea = new MirthSyntaxTextArea();
        this.responseStatusTextArea = new MirthSyntaxTextArea();
        this.ResponseTransformedTextPane = new MirthSyntaxTextArea();
        this.ProcessedResponseTextPane = new JPanel();
        this.ProcessedResponseTextArea = new MirthSyntaxTextArea();
        this.processedResponseStatusLabel = new JLabel();
        this.processedResponseLabel = new JLabel();
        this.processedResponseStatusTextArea = new MirthSyntaxTextArea();
        this.formatMessageCheckBox = new JCheckBox();
        this.mappingsPane = new JScrollPane();
        this.mappingsTable = null;
        this.ErrorsPanel = new JPanel();
        this.ErrorsRadioPane = new JPanel();
        this.ProcessingErrorRadioButton = new JRadioButton();
        this.PostprocessorErrorRadioButton = new JRadioButton();
        this.ResponseErrorRadioButton = new JRadioButton();
        this.ErrorsCardPane = new JPanel();
        this.ProcessingErrorTextPane = new MirthSyntaxTextArea();
        this.PostprocessorErrorTextPane = new MirthSyntaxTextArea();
        this.ResponseErrorTextPane = new MirthSyntaxTextArea();
        this.attachmentsPane = new JScrollPane();
        this.attachmentTable = null;
        this.messageScrollPane = new JScrollPane();
        this.messageTreeTable = this.createMessageTreeTable();
        this.jPanel1 = new JPanel();
        this.pageNumberLabel = new JLabel();
        this.mirthDatePicker1 = new MirthDatePicker();
        this.resultsLabel = new JLabel();
        this.lastSearchCriteriaPane = new JScrollPane();
        this.lastSearchCriteria = new JTextArea();
        this.previousPageButton = new JButton();
        this.statusBoxQueued = new MirthCheckBox();
        this.statusBoxPending = new MirthCheckBox();
        this.pageTotalLabel = new JLabel();
        this.textSearchField = new JTextField();
        this.pageNumberField = new MirthTextField();
        this.jLabel2 = new JLabel();
        this.textSearchLabel = new JLabel();
        this.filterButton = new JButton();
        this.statusBoxFiltered = new MirthCheckBox();
        this.pageSizeLabel = new JLabel();
        this.statusBoxSent = new MirthCheckBox();
        this.resetButton = new JButton();
        this.countButton = new MirthButton();
        this.advSearchButton = new JButton();
        this.pageSizeField = new MirthTextField();
        this.statusBoxError = new MirthCheckBox();
        this.mirthTimePicker2 = new MirthTimePicker();
        this.statusBoxReceived = new MirthCheckBox();
        this.pageGoButton = new JButton();
        this.statusBoxTransformed = new MirthCheckBox();
        this.mirthTimePicker1 = new MirthTimePicker();
        this.jLabel3 = new JLabel();
        this.allDayCheckBox = new MirthCheckBox();
        this.mirthDatePicker2 = new MirthDatePicker();
        this.nextPageButton = new JButton();
        this.regexTextSearchCheckBox = new MirthCheckBox();
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        GroupLayout jDialog1Layout = new GroupLayout(this.jDialog1.getContentPane());
        this.jDialog1.getContentPane().setLayout(jDialog1Layout);
        jDialog1Layout.setHorizontalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 400, Short.MAX_VALUE));
        jDialog1Layout.setVerticalGroup(jDialog1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 300, Short.MAX_VALUE));
        this.setBackground(new Color(255, 255, 255));
        this.setFocusable(false);
        this.setRequestFocusEnabled(false);
        this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jSplitPane1.setDividerLocation(265);
        this.jSplitPane1.setOrientation(0);
        this.descriptionTabbedPane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.descriptionTabbedPane.setFocusable(false);
        this.MessagesPanel.setBackground(new Color(255, 255, 255));
        this.MessagesPanel.setFocusable(false);
        this.MessagesRadioPane.setBackground(new Color(255, 255, 255));
        this.MessagesRadioPane.setLayout(new FlowLayout(0, 5, 0));
        this.RawMessageRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.RawMessageRadioButton);
        this.RawMessageRadioButton.setText("Raw");
        this.RawMessageRadioButton.setFocusable(false);
        this.RawMessageRadioButton.setRequestFocusEnabled(false);
        this.RawMessageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.RawMessageRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.RawMessageRadioButton);
        this.ProcessedRawMessageRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.ProcessedRawMessageRadioButton);
        this.ProcessedRawMessageRadioButton.setText("Processed Raw");
        this.ProcessedRawMessageRadioButton.setFocusable(false);
        this.ProcessedRawMessageRadioButton.setRequestFocusEnabled(false);
        this.ProcessedRawMessageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.ProcessedRawMessageRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.ProcessedRawMessageRadioButton);
        this.TransformedMessageRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.TransformedMessageRadioButton);
        this.TransformedMessageRadioButton.setText("Transformed");
        this.TransformedMessageRadioButton.setFocusable(false);
        this.TransformedMessageRadioButton.setRequestFocusEnabled(false);
        this.TransformedMessageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.TransformedMessageRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.TransformedMessageRadioButton);
        this.EncodedMessageRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.EncodedMessageRadioButton);
        this.EncodedMessageRadioButton.setText("Encoded");
        this.EncodedMessageRadioButton.setFocusable(false);
        this.EncodedMessageRadioButton.setRequestFocusEnabled(false);
        this.EncodedMessageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.EncodedMessageRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.EncodedMessageRadioButton);
        this.SentMessageRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.SentMessageRadioButton);
        this.SentMessageRadioButton.setText("Sent");
        this.SentMessageRadioButton.setFocusable(false);
        this.SentMessageRadioButton.setRequestFocusEnabled(false);
        this.SentMessageRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.SentMessageRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.SentMessageRadioButton);
        this.ResponseRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.ResponseRadioButton);
        this.ResponseRadioButton.setText("Response");
        this.ResponseRadioButton.setFocusable(false);
        this.ResponseRadioButton.setRequestFocusEnabled(false);
        this.ResponseRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.ResponseRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.ResponseRadioButton);
        this.ResponseTransformedRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.ResponseTransformedRadioButton);
        this.ResponseTransformedRadioButton.setText("Response Transformed");
        this.ResponseTransformedRadioButton.setFocusable(false);
        this.ResponseTransformedRadioButton.setRequestFocusEnabled(false);
        this.ResponseTransformedRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.ResponseTransformedRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.ResponseTransformedRadioButton);
        this.ProcessedResponseRadioButton.setBackground(new Color(255, 255, 255));
        this.messagesGroup.add(this.ProcessedResponseRadioButton);
        this.ProcessedResponseRadioButton.setText("Processed Response");
        this.ProcessedResponseRadioButton.setFocusable(false);
        this.ProcessedResponseRadioButton.setRequestFocusEnabled(false);
        this.ProcessedResponseRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.ProcessedResponseRadioButtonActionPerformed(evt);
            }
        });
        this.MessagesRadioPane.add(this.ProcessedResponseRadioButton);
        this.MessagesCardPane.setBackground(new Color(255, 255, 255));
        this.MessagesCardPane.setLayout(new CardLayout());
        this.RawMessageTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.RawMessageTextPane.setEditable(false);
        this.MessagesCardPane.add((Component)this.RawMessageTextPane, "Raw");
        this.ProcessedRawMessageTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.ProcessedRawMessageTextPane.setEditable(false);
        this.MessagesCardPane.add((Component)this.ProcessedRawMessageTextPane, "Processed Raw");
        this.TransformedMessageTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.TransformedMessageTextPane.setEditable(false);
        this.MessagesCardPane.add((Component)this.TransformedMessageTextPane, "Transformed");
        this.EncodedMessageTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.EncodedMessageTextPane.setEditable(false);
        this.MessagesCardPane.add((Component)this.EncodedMessageTextPane, "Encoded");
        this.SentMessageTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.SentMessageTextPane.setEditable(false);
        this.MessagesCardPane.add((Component)this.SentMessageTextPane, "Sent");
        this.ResponseTextPane.setBackground(new Color(255, 255, 255));
        this.responseStatusLabel.setText("Status:");
        this.responseLabel.setText("Response:");
        this.ResponseTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.ResponseTextArea.setEditable(false);
        this.responseStatusTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.responseStatusTextArea.setEditable(false);
        GroupLayout ResponseTextPaneLayout = new GroupLayout(this.ResponseTextPane);
        this.ResponseTextPane.setLayout(ResponseTextPaneLayout);
        ResponseTextPaneLayout.setHorizontalGroup(ResponseTextPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ResponseTextArea, -1, -1, Short.MAX_VALUE).addGroup(ResponseTextPaneLayout.createSequentialGroup().addGroup(ResponseTextPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.responseStatusLabel).addComponent(this.responseLabel)).addGap(0, 720, Short.MAX_VALUE)).addComponent(this.responseStatusTextArea, -1, -1, Short.MAX_VALUE));
        ResponseTextPaneLayout.setVerticalGroup(ResponseTextPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ResponseTextPaneLayout.createSequentialGroup().addComponent(this.responseStatusLabel).addGap(3, 3, 3).addComponent(this.responseStatusTextArea, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.responseLabel).addGap(3, 3, 3).addComponent(this.ResponseTextArea, -1, -1, Short.MAX_VALUE)));
        this.MessagesCardPane.add((Component)this.ResponseTextPane, "Response");
        this.ResponseTransformedTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.ResponseTransformedTextPane.setEditable(false);
        this.MessagesCardPane.add((Component)this.ResponseTransformedTextPane, "Response Transformed");
        this.ProcessedResponseTextPane.setBackground(new Color(255, 255, 255));
        this.ProcessedResponseTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.ProcessedResponseTextArea.setEditable(false);
        this.processedResponseStatusLabel.setText("Status:");
        this.processedResponseLabel.setText("Response:");
        this.processedResponseStatusTextArea.setBorder(BorderFactory.createEtchedBorder());
        this.processedResponseStatusTextArea.setEditable(false);
        GroupLayout ProcessedResponseTextPaneLayout = new GroupLayout(this.ProcessedResponseTextPane);
        this.ProcessedResponseTextPane.setLayout(ProcessedResponseTextPaneLayout);
        ProcessedResponseTextPaneLayout.setHorizontalGroup(ProcessedResponseTextPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.ProcessedResponseTextArea, -1, -1, Short.MAX_VALUE).addGroup(ProcessedResponseTextPaneLayout.createSequentialGroup().addGroup(ProcessedResponseTextPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.processedResponseStatusLabel).addComponent(this.processedResponseLabel)).addGap(0, 720, Short.MAX_VALUE)).addComponent(this.processedResponseStatusTextArea, -1, -1, Short.MAX_VALUE));
        ProcessedResponseTextPaneLayout.setVerticalGroup(ProcessedResponseTextPaneLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ProcessedResponseTextPaneLayout.createSequentialGroup().addComponent(this.processedResponseStatusLabel).addGap(3, 3, 3).addComponent(this.processedResponseStatusTextArea, -2, 57, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.processedResponseLabel).addGap(3, 3, 3).addComponent(this.ProcessedResponseTextArea, -1, -1, Short.MAX_VALUE)));
        this.MessagesCardPane.add((Component)this.ProcessedResponseTextPane, "Processed Response");
        this.formatMessageCheckBox.setBackground(new Color(255, 255, 255));
        this.formatMessageCheckBox.setText("Format XML Messages");
        this.formatMessageCheckBox.setToolTipText("Pretty print messages that are XML.");
        this.formatMessageCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.formatMessageCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout MessagesPanelLayout = new GroupLayout(this.MessagesPanel);
        this.MessagesPanel.setLayout(MessagesPanelLayout);
        MessagesPanelLayout.setHorizontalGroup(MessagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MessagesPanelLayout.createSequentialGroup().addContainerGap().addGroup(MessagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.MessagesCardPane, -1, -1, Short.MAX_VALUE).addGroup(MessagesPanelLayout.createSequentialGroup().addComponent(this.formatMessageCheckBox).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.MessagesRadioPane, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        MessagesPanelLayout.setVerticalGroup(MessagesPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(MessagesPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.MessagesRadioPane, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.MessagesCardPane, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.formatMessageCheckBox).addContainerGap()));
        this.descriptionTabbedPane.addTab("Messages", this.MessagesPanel);
        this.mappingsPane.setViewportView((Component)((Object)this.mappingsTable));
        this.descriptionTabbedPane.addTab("Mappings", this.mappingsPane);
        this.ErrorsPanel.setBackground(new Color(255, 255, 255));
        this.ErrorsPanel.setFocusable(false);
        this.ErrorsRadioPane.setBackground(new Color(255, 255, 255));
        this.ErrorsRadioPane.setMinimumSize(new Dimension(601, 19));
        this.ErrorsRadioPane.setPreferredSize(new Dimension(601, 19));
        this.ErrorsRadioPane.setLayout(new FlowLayout(0, 5, 0));
        this.ProcessingErrorRadioButton.setBackground(new Color(255, 255, 255));
        this.errorsGroup.add(this.ProcessingErrorRadioButton);
        this.ProcessingErrorRadioButton.setText("Processing Error");
        this.ProcessingErrorRadioButton.setFocusable(false);
        this.ProcessingErrorRadioButton.setRequestFocusEnabled(false);
        this.ProcessingErrorRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.ProcessingErrorRadioButtonActionPerformed(evt);
            }
        });
        this.ErrorsRadioPane.add(this.ProcessingErrorRadioButton);
        this.PostprocessorErrorRadioButton.setBackground(new Color(255, 255, 255));
        this.errorsGroup.add(this.PostprocessorErrorRadioButton);
        this.PostprocessorErrorRadioButton.setText("Postprocessor Error");
        this.PostprocessorErrorRadioButton.setFocusable(false);
        this.PostprocessorErrorRadioButton.setRequestFocusEnabled(false);
        this.PostprocessorErrorRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.PostprocessorErrorRadioButtonActionPerformed(evt);
            }
        });
        this.ErrorsRadioPane.add(this.PostprocessorErrorRadioButton);
        this.ResponseErrorRadioButton.setBackground(new Color(255, 255, 255));
        this.errorsGroup.add(this.ResponseErrorRadioButton);
        this.ResponseErrorRadioButton.setText("Response Error");
        this.ResponseErrorRadioButton.setFocusable(false);
        this.ResponseErrorRadioButton.setRequestFocusEnabled(false);
        this.ResponseErrorRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.ResponseErrorRadioButtonActionPerformed(evt);
            }
        });
        this.ErrorsRadioPane.add(this.ResponseErrorRadioButton);
        this.ErrorsCardPane.setBackground(new Color(255, 255, 255));
        this.ErrorsCardPane.setLayout(new CardLayout());
        this.ProcessingErrorTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.ProcessingErrorTextPane.setEditable(false);
        this.ErrorsCardPane.add((Component)this.ProcessingErrorTextPane, "Processing Error");
        this.PostprocessorErrorTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.PostprocessorErrorTextPane.setEditable(false);
        this.ErrorsCardPane.add((Component)this.PostprocessorErrorTextPane, "Postprocessor Error");
        this.ResponseErrorTextPane.setBorder(BorderFactory.createEtchedBorder());
        this.ResponseErrorTextPane.setEditable(false);
        this.ErrorsCardPane.add((Component)this.ResponseErrorTextPane, "Response Error");
        GroupLayout ErrorsPanelLayout = new GroupLayout(this.ErrorsPanel);
        this.ErrorsPanel.setLayout(ErrorsPanelLayout);
        ErrorsPanelLayout.setHorizontalGroup(ErrorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, ErrorsPanelLayout.createSequentialGroup().addContainerGap().addGroup(ErrorsPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.ErrorsCardPane, -1, -1, Short.MAX_VALUE).addComponent(this.ErrorsRadioPane, -1, 773, Short.MAX_VALUE)).addContainerGap()));
        ErrorsPanelLayout.setVerticalGroup(ErrorsPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(ErrorsPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.ErrorsRadioPane, -2, 17, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.ErrorsCardPane, -1, 155, Short.MAX_VALUE).addContainerGap()));
        this.descriptionTabbedPane.addTab("Errors", this.ErrorsPanel);
        this.attachmentsPane.setViewportView((Component)((Object)this.attachmentTable));
        this.descriptionTabbedPane.addTab("Attachments", this.attachmentsPane);
        this.jSplitPane1.setRightComponent(this.descriptionTabbedPane);
        this.messageScrollPane.setViewportView((Component)((Object)this.messageTreeTable));
        this.jSplitPane1.setLeftComponent(this.messageScrollPane);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.pageNumberLabel.setHorizontalAlignment(4);
        this.pageNumberLabel.setText("Page");
        this.resultsLabel.setForeground(new Color(204, 0, 0));
        this.resultsLabel.setHorizontalAlignment(4);
        this.resultsLabel.setText("Results");
        this.lastSearchCriteriaPane.setBorder(null);
        this.lastSearchCriteriaPane.setHorizontalScrollBarPolicy(31);
        this.lastSearchCriteria.setEditable(false);
        this.lastSearchCriteria.setColumns(20);
        this.lastSearchCriteria.setForeground(new Color(96, 96, 96));
        this.lastSearchCriteria.setLineWrap(true);
        this.lastSearchCriteria.setRows(5);
        this.lastSearchCriteria.setAlignmentX(0.0f);
        this.lastSearchCriteria.setDisabledTextColor(new Color(255, 255, 255));
        this.lastSearchCriteriaPane.setViewportView(this.lastSearchCriteria);
        this.previousPageButton.setText("< Prev");
        this.previousPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.previousPageButtonActionPerformed(evt);
            }
        });
        this.statusBoxQueued.setBackground(new Color(255, 255, 255));
        this.statusBoxQueued.setText("QUEUED");
        this.statusBoxQueued.setFont(new Font("Lucida Grande", 0, 11));
        this.statusBoxQueued.setToolTipText("The message either has not been attempted to be dispatched yet, or it has failed to dispatch and is waiting in the queue to be attempted again.");
        this.pageTotalLabel.setHorizontalAlignment(4);
        this.pageTotalLabel.setText("of ?");
        this.pageTotalLabel.setAlignmentY(0.0f);
        this.pageTotalLabel.setHorizontalTextPosition(4);
        this.textSearchField.setToolTipText("<html>\nSearch all message content for the given string. This process could take a long<br/>\ntime depending on the amount of message content currently stored. Any message<br/>\ncontent that was encrypted by this channel will not be searchable.\n</html>");
        this.textSearchField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.textSearchFieldActionPerformed(evt);
            }
        });
        this.pageNumberField.setHorizontalAlignment(4);
        this.pageNumberField.setToolTipText("Enter a page number and press Enter to jump to that page.");
        this.pageNumberField.setPreferredSize(new Dimension(40, 22));
        this.jLabel2.setHorizontalAlignment(4);
        this.jLabel2.setText("End Time:");
        this.jLabel2.setMaximumSize(new Dimension(78, 15));
        this.textSearchLabel.setHorizontalAlignment(4);
        this.textSearchLabel.setText("Text Search:");
        this.filterButton.setText("Search");
        this.filterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.filterButtonActionPerformed(evt);
            }
        });
        this.statusBoxFiltered.setBackground(new Color(255, 255, 255));
        this.statusBoxFiltered.setText("FILTERED");
        this.statusBoxFiltered.setFont(new Font("Lucida Grande", 0, 11));
        this.statusBoxFiltered.setMaximumSize(new Dimension(83, 23));
        this.statusBoxFiltered.setMinimumSize(new Dimension(83, 23));
        this.statusBoxFiltered.setToolTipText("The message has been rejected by the destination filter, and will not be dispatched by this destination. Other destinations may still dispatch this message.");
        this.pageSizeLabel.setHorizontalAlignment(4);
        this.pageSizeLabel.setText("Page Size:");
        this.pageSizeLabel.setMaximumSize(new Dimension(78, 15));
        this.statusBoxSent.setBackground(new Color(255, 255, 255));
        this.statusBoxSent.setText("SENT");
        this.statusBoxSent.setFont(new Font("Lucida Grande", 0, 11));
        this.statusBoxSent.setToolTipText("The message has been successfully dispatched / written out by the destination connector.");
        this.resetButton.setText("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.resetButtonActionPerformed(evt);
            }
        });
        this.countButton.setText("Count");
        this.countButton.setToolTipText("Count the number of overall messages for the current search criteria.");
        this.countButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.countButtonActionPerformed(evt);
            }
        });
        this.advSearchButton.setText("Advanced...");
        this.advSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.advSearchButtonActionPerformed(evt);
            }
        });
        this.pageSizeField.setToolTipText("<html>\nAfter changing the page size, a new search must be performed for the changes to<br/>\ntake effect.  The default page size can also be configured on the Settings panel.\n</html>");
        this.statusBoxError.setBackground(new Color(255, 255, 255));
        this.statusBoxError.setText("ERROR");
        this.statusBoxError.setFont(new Font("Lucida Grande", 0, 11));
        this.statusBoxError.setToolTipText("An error occurred while processing the message through the destination connector.");
        this.statusBoxReceived.setBackground(new Color(255, 255, 255));
        this.statusBoxReceived.setText("RECEIVED");
        this.statusBoxReceived.setFont(new Font("Lucida Grande", 0, 11));
        this.statusBoxReceived.setPreferredSize(new Dimension(90, 22));
        this.statusBoxReceived.setToolTipText("The inbound data for the destination connector has been committed to the database, but the destination has not yet finished processing the message.");
        this.statusBoxPending.setBackground(new Color(255, 255, 255));
        this.statusBoxPending.setText("PENDING");
        this.statusBoxPending.setFont(new Font("Lucida Grande", 0, 11));
        this.statusBoxPending.setToolTipText("The destination was able to dispatch / write the message outbound, but has not yet finished processing the message through the response transformer.");
        this.pageGoButton.setText("Go");
        this.pageGoButton.setNextFocusableComponent((Component)((Object)this.messageTreeTable));
        this.pageGoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.pageGoButtonActionPerformed(evt);
            }
        });
        this.statusBoxTransformed.setBackground(new Color(255, 255, 255));
        this.statusBoxTransformed.setText("TRANSFORMED");
        this.statusBoxTransformed.setFont(new Font("Lucida Grande", 0, 11));
        this.statusBoxTransformed.setMaximumSize(new Dimension(83, 23));
        this.statusBoxTransformed.setMinimumSize(new Dimension(83, 23));
        this.statusBoxTransformed.setToolTipText("The message has passed the source filter/transformer, and the source encoded data has been dispatched to any destinations.");
        this.jLabel3.setHorizontalAlignment(4);
        this.jLabel3.setText("Start Time:");
        this.jLabel3.setMaximumSize(new Dimension(78, 15));
        this.allDayCheckBox.setBackground(new Color(255, 255, 255));
        this.allDayCheckBox.setText("All Day");
        this.allDayCheckBox.setFont(new Font("Lucida Grande", 0, 11));
        this.allDayCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.allDayCheckBoxActionPerformed(evt);
            }
        });
        this.nextPageButton.setText("Next >");
        this.nextPageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowser.this.nextPageButtonActionPerformed(evt);
            }
        });
        this.regexTextSearchCheckBox.setBackground(new Color(255, 255, 255));
        this.regexTextSearchCheckBox.setText("Regex");
        this.regexTextSearchCheckBox.setToolTipText("<html> Search all message content for a match to the regular expression pattern.<br/> Regex matching could be a very costly operation and should be used with<br/> caution, specially with large amount of messages. Any message content<br/> that was encrypted by this channel will not be searchable. Only supported<br/> on PostgreSQL, Oracle and MySQL databases.</html> ");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.pageSizeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.textSearchLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.pageSizeField, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.advSearchButton, -2, 89, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.resetButton, -2, 56, -2)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)((Object)this.mirthDatePicker1), -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mirthTimePicker1, -2, 80, -2)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent((Component)((Object)this.mirthDatePicker2), -2, 1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.mirthTimePicker2, -2, 80, -2)).addComponent(this.textSearchField, GroupLayout.Alignment.TRAILING, -2, 218, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.allDayCheckBox, -2, -1, -2).addComponent(this.filterButton, -2, 63, -2).addComponent(this.regexTextSearchCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusBoxQueued, -2, -1, -2).addComponent(this.statusBoxSent, -2, -1, -2).addComponent(this.statusBoxError, -2, -1, -2).addComponent(this.statusBoxPending, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.statusBoxReceived, -1, -1, Short.MAX_VALUE).addComponent(this.statusBoxFiltered, -1, -1, Short.MAX_VALUE).addComponent(this.statusBoxTransformed, -2, -1, -2))).addGap(117, 117, 117).addComponent(this.lastSearchCriteriaPane, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.previousPageButton, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nextPageButton, -2, 55, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.resultsLabel).addGap(5, 5, 5).addComponent(this.countButton, -2, 55, -2)).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.pageNumberLabel).addGap(4, 4, 4).addComponent(this.pageNumberField, -2, 50, -2).addGap(6, 6, 6).addComponent(this.pageTotalLabel).addGap(5, 5, 5).addComponent(this.pageGoButton, -2, 29, -2))).addContainerGap()));
        jPanel1Layout.linkSize(0, this.mirthTimePicker1, this.mirthTimePicker2);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mirthTimePicker1, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)((Object)this.mirthDatePicker1), -2, -1, -2).addComponent(this.jLabel3, -2, -1, -2))).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.mirthTimePicker2, GroupLayout.Alignment.TRAILING, -2, -1, -2).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent((Component)((Object)this.mirthDatePicker2), -2, -1, -2).addComponent(this.jLabel2, -2, -1, -2))).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.textSearchField, -2, -1, -2).addComponent(this.textSearchLabel).addComponent(this.regexTextSearchCheckBox, -2, -1, -2))).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.countButton, -2, -1, -2).addComponent(this.resultsLabel)).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.pageGoButton).addComponent(this.pageTotalLabel).addComponent(this.pageNumberField, -2, -1, -2).addComponent(this.pageNumberLabel)))).addGap(7, 7, 7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.nextPageButton).addComponent(this.previousPageButton).addComponent(this.filterButton).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.resetButton).addComponent(this.advSearchButton).addGroup(jPanel1Layout.createSequentialGroup().addGap(4, 4, 4).addComponent(this.pageSizeLabel, -2, -1, -2)).addGroup(jPanel1Layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.pageSizeField, -2, -1, -2))))).addGroup(jPanel1Layout.createSequentialGroup().addGap(4, 4, 4).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lastSearchCriteriaPane, -2, 107, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.statusBoxReceived, -2, 16, -2).addComponent(this.allDayCheckBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBoxTransformed, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBoxFiltered, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBoxQueued, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBoxSent, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBoxError, -2, 16, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.statusBoxPending, -2, 16, -2))))).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSplitPane1).addComponent(this.jPanel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(0, 0, 0).addComponent(this.jPanel1, -2, -1, -2).addGap(0, 0, 0).addComponent(this.jSplitPane1, -1, 502, Short.MAX_VALUE)));
    }

    protected MirthTreeTable createMessageTreeTable() {
        return new MirthTreeTable(this.mirthTreeTablePrefix(), this.defaultVisibleColumns);
    }

    public String mirthTreeTablePrefix() {
        return "messageBrowser";
    }

    private void advSearchButtonActionPerformed(ActionEvent evt) {
        this.advancedSearchPopup.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        this.advancedSearchPopup.setLocationRelativeTo((Component)((Object)this.parent));
        this.advancedSearchPopup.setVisible(true);
        this.updateAdvancedSearchButtonFont();
    }

    private void filterButtonActionPerformed(ActionEvent evt) {
        this.runSearch();
    }

    private void countButtonActionPerformed(ActionEvent evt) {
        final String workingId = this.parent.startWorking("Counting search result size...");
        this.filterButton.setEnabled(false);
        this.nextPageButton.setEnabled(false);
        this.previousPageButton.setEnabled(false);
        this.countButton.setEnabled(false);
        this.pageGoButton.setEnabled(false);
        final MessageBrowser messageBrowser = this;
        if (this.worker != null && !this.worker.isDone()) {
            this.worker.cancel(true);
        }
        this.worker = new SwingWorker<Void, Void>(){
            private Exception e;

            @Override
            public Void doInBackground() {
                try {
                    MessageBrowser.this.messages.setItemCount(MessageBrowser.this.getMessageCount());
                }
                catch (ClientException e) {
                    if (!(e instanceof RequestAbortedException)) {
                        MessageBrowser.this.parent.alertThrowable((Component)((Object)MessageBrowser.this.parent), e);
                    }
                    this.cancel(true);
                }
                return null;
            }

            @Override
            public void done() {
                if (!this.isCancelled()) {
                    if (this.e != null) {
                        MessageBrowser.this.countButton.setEnabled(true);
                        MessageBrowser.this.parent.alertThrowable(messageBrowser, this.e);
                    } else {
                        MessageBrowser.this.updatePagination();
                        MessageBrowser.this.countButton.setEnabled(false);
                    }
                    MessageBrowser.this.filterButton.setEnabled(true);
                }
                MessageBrowser.this.parent.stopWorking(workingId);
            }
        };
        this.worker.execute();
    }

    protected Long getMessageCount() throws ClientException {
        return this.parent.mirthClient.getMessageCount(this.channelId, this.messageFilter);
    }

    private void formatMessageCheckBoxActionPerformed(ActionEvent evt) {
        this.formatCheckBoxActionPerformed(evt);
    }

    private void RawMessageRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void ProcessedRawMessageRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void TransformedMessageRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void EncodedMessageRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void SentMessageRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void ResponseRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void ProcessedResponseRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void resetButtonActionPerformed(ActionEvent evt) {
        this.resetSearchCriteria();
    }

    private void allDayCheckBoxActionPerformed(ActionEvent evt) {
        this.mirthTimePicker1.setEnabled(this.mirthDatePicker1.getDate() != null && !this.allDayCheckBox.isSelected());
        this.mirthTimePicker2.setEnabled(this.mirthDatePicker2.getDate() != null && !this.allDayCheckBox.isSelected());
    }

    private void pageGoButtonActionPerformed(ActionEvent evt) {
        this.jumpToPageNumber();
    }

    private void ProcessingErrorRadioButtonActionPerformed(ActionEvent evt) {
        this.errorsRadioButtonActionPerformed(evt);
    }

    private void ResponseErrorRadioButtonActionPerformed(ActionEvent evt) {
        this.errorsRadioButtonActionPerformed(evt);
    }

    private void ResponseTransformedRadioButtonActionPerformed(ActionEvent evt) {
        this.messagesRadioButtonActionPerformed(evt);
    }

    private void PostprocessorErrorRadioButtonActionPerformed(ActionEvent evt) {
        this.errorsRadioButtonActionPerformed(evt);
    }

    private void textSearchFieldActionPerformed(ActionEvent evt) {
        this.runSearch();
    }
}

