/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.browsers.message;

import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.MirthDialog;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.browsers.message.MessageBrowser;
import com.mirth.connect.client.ui.components.ItemSelectionTable;
import com.mirth.connect.client.ui.components.ItemSelectionTableModel;
import com.mirth.connect.client.ui.components.MirthBlankableSpinner;
import com.mirth.connect.client.ui.components.MirthButton;
import com.mirth.connect.client.ui.components.MirthCheckBox;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellEditor;
import com.mirth.connect.client.ui.components.MirthComboBoxTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthFieldConstraints;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTextField;
import com.mirth.connect.donkey.model.channel.MetaDataColumn;
import com.mirth.connect.donkey.model.channel.MetaDataColumnException;
import com.mirth.connect.donkey.model.channel.MetaDataColumnType;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.model.filters.MessageFilter;
import com.mirth.connect.model.filters.elements.ContentSearchElement;
import com.mirth.connect.model.filters.elements.MetaDataSearchElement;
import com.mirth.connect.model.filters.elements.MetaDataSearchOperator;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.prefs.Preferences;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;

public class MessageBrowserAdvancedFilter
extends MirthDialog {
    private Frame parent;
    private static final int CONTENT_TYPE_COLUMN_WIDTH = 120;
    private static final int METADATA_NAME_COLUMN_WIDTH = 140;
    private static final int METADATA_OPERATOR_COLUMN_WIDTH = 140;
    private static final int METADATA_CASE_COLUMN_WIDTH = 75;
    private static Map<String, Object> cachedSettings;
    private static Map<String, MetaDataColumn> cachedMetaDataColumns;
    private MessageBrowser messageBrowser;
    private MirthButton addContentSearchButton;
    private MirthButton addMetaDataSearchButton;
    private MirthCheckBox attachmentCheckBox;
    private JButton cancelButton;
    private JLabel connectorDeselectAll;
    private JLabel connectorSelectAll;
    private MirthTable connectorTable;
    private JPanel containerPanel;
    private MirthTable contentSearchTable;
    private MirthButton deleteContentSearchButton;
    private MirthButton deleteMetaDataSearchButton;
    private MirthCheckBox errorCheckBox;
    private JLabel importIdLabel;
    private MirthTextField importIdLowerField;
    private MirthTextField importIdUpperField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JSeparator jSeparator1;
    private JLabel messageIdLabel;
    private MirthTextField messageIdLowerField;
    private MirthTextField messageIdUpperField;
    private MirthTable metaDataSearchTable;
    private MirthTable mirthTable1;
    private MirthTable mirthTable2;
    private MirthTable mirthTable3;
    private JButton okButton1;
    private JLabel originalIdLabel;
    private MirthTextField originalIdLowerField;
    private MirthTextField originalIdUpperField;
    private JSpinner sendAttemptsLower;
    private MirthBlankableSpinner sendAttemptsUpper;
    private MirthTextField serverIdField;
    private JLabel serverIdLabel;

    public MessageBrowserAdvancedFilter(Frame parent, MessageBrowser messageBrowser, String title, boolean modal, boolean allowSearch) {
        super((Window)((Object)parent), title, modal);
        this.parent = parent;
        this.messageBrowser = messageBrowser;
        this.initComponents();
        this.initComponentsManual();
        this.initContentSearchTable();
        this.connectorTable = new ItemSelectionTable();
        cachedSettings = new HashMap<String, Object>();
        cachedMetaDataColumns = new HashMap<String, MetaDataColumn>();
        this.jScrollPane6.setViewportView((Component)((Object)this.connectorTable));
    }

    private void initComponentsManual() {
        this.messageIdLowerField.setDocument(new MirthFieldConstraints(19, false, false, true));
        this.messageIdUpperField.setDocument(new MirthFieldConstraints(19, false, false, true));
        this.originalIdLowerField.setDocument(new MirthFieldConstraints(19, false, false, true));
        this.originalIdUpperField.setDocument(new MirthFieldConstraints(19, false, false, true));
        this.importIdLowerField.setDocument(new MirthFieldConstraints(19, false, false, true));
        this.importIdUpperField.setDocument(new MirthFieldConstraints(19, false, false, true));
        this.sendAttemptsLower.setModel(new SpinnerNumberModel((Number)0, Integer.valueOf(0), null, (Number)1));
    }

    private void initContentSearchTable() {
        this.contentSearchTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Content Type", "Contains"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return true;
            }
        });
        this.contentSearchTable.setSelectionMode(0);
        this.contentSearchTable.setDragEnabled(false);
        this.contentSearchTable.setSortable(false);
        this.contentSearchTable.getTableHeader().setReorderingAllowed(false);
        this.contentSearchTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MessageBrowserAdvancedFilter.this.deleteContentSearchButton.setEnabled(MessageBrowserAdvancedFilter.this.getSelectedRow(MessageBrowserAdvancedFilter.this.contentSearchTable) != -1);
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.contentSearchTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        TableColumn column = this.contentSearchTable.getColumnModel().getColumn(0);
        column.setCellRenderer(new MirthComboBoxTableCellRenderer(ContentType.getDisplayValues()));
        column.setCellEditor(new MirthComboBoxTableCellEditor((JTable)((Object)this.contentSearchTable), ContentType.getDisplayValues(), 1, false, null));
        column.setMinWidth(120);
        column.setMaxWidth(120);
        this.deleteContentSearchButton.setEnabled(false);
    }

    private void initMetaDataSearchTable() {
        this.metaDataSearchTable.setModel(new DefaultTableModel(new Object[0][], new String[]{"Metadata", "Operator", "Value", "Ignore Case"}){

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return columnIndex != 3 || cachedMetaDataColumns.get(this.getValueAt(rowIndex, 0)).getType() == MetaDataColumnType.STRING;
            }

            @Override
            public void setValueAt(Object value, int row, int column) {
                int metaDataColumnIndex = this.findColumn("Metadata");
                int operatorColumnIndex = this.findColumn("Operator");
                int valueColumnIndex = this.findColumn("Value");
                int ignoreCaseColumnIndex = this.findColumn("Ignore Case");
                if (column == valueColumnIndex) {
                    MetaDataColumn metaDataColumn = cachedMetaDataColumns.get(this.getValueAt(row, metaDataColumnIndex));
                    if (StringUtils.isNotEmpty((CharSequence)((String)value))) {
                        try {
                            metaDataColumn.getType().castValue(value);
                        }
                        catch (MetaDataColumnException e) {
                            MessageBrowserAdvancedFilter.this.parent.alertError((Component)((Object)MessageBrowserAdvancedFilter.this.parent), "Invalid value for column type " + metaDataColumn.getType().toString());
                            return;
                        }
                    }
                } else if (column == metaDataColumnIndex) {
                    if (!value.equals(this.getValueAt(row, metaDataColumnIndex))) {
                        MetaDataSearchOperator operator = MetaDataSearchOperator.EQUAL;
                        super.setValueAt(operator, row, operatorColumnIndex);
                        MetaDataColumn metaDataColumn = cachedMetaDataColumns.get(value);
                        if (metaDataColumn.getType() != MetaDataColumnType.STRING) {
                            super.setValueAt(Boolean.FALSE, row, ignoreCaseColumnIndex);
                        }
                    }
                    super.setValueAt("", row, valueColumnIndex);
                }
                super.setValueAt(value, row, column);
            }
        });
        this.metaDataSearchTable.setSelectionMode(0);
        this.metaDataSearchTable.setDragEnabled(false);
        this.metaDataSearchTable.setSortable(false);
        this.metaDataSearchTable.getTableHeader().setReorderingAllowed(false);
        this.addMetaDataSearchButton.setEnabled(!this.messageBrowser.getMetaDataColumns().isEmpty());
        this.metaDataSearchTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                MessageBrowserAdvancedFilter.this.deleteMetaDataSearchButton.setEnabled(MessageBrowserAdvancedFilter.this.getSelectedRow(MessageBrowserAdvancedFilter.this.metaDataSearchTable) != -1);
            }
        });
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.metaDataSearchTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        List<MetaDataColumn> metaDataColumns = this.messageBrowser.getMetaDataColumns();
        cachedMetaDataColumns.clear();
        Object[] metaDataNames = new String[metaDataColumns.size()];
        for (int i = 0; i < metaDataColumns.size(); ++i) {
            String columnName = metaDataColumns.get(i).getName();
            metaDataNames[i] = columnName;
            cachedMetaDataColumns.put(columnName, metaDataColumns.get(i));
        }
        MirthComboBoxTableCellEditor metaDataEditor = new MirthComboBoxTableCellEditor((JTable)((Object)this.metaDataSearchTable), metaDataNames, 1, false, null);
        metaDataEditor.getComboBox().setAutoResizeDropdown(true);
        TableColumn metaDataColumn = this.metaDataSearchTable.getColumnModel().getColumn(0);
        metaDataColumn.setCellRenderer(new MirthComboBoxTableCellRenderer(metaDataNames));
        metaDataColumn.setCellEditor(metaDataEditor);
        metaDataColumn.setMinWidth(140);
        metaDataColumn.setMaxWidth(280);
        metaDataColumn.setPreferredWidth(140);
        MirthComboBoxTableCellEditor operatorEditor = new MirthComboBoxTableCellEditor((JTable)((Object)this.metaDataSearchTable), MetaDataSearchOperator.values(), 1, false, null){

            @Override
            public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
                MetaDataColumn metaDataColumn = cachedMetaDataColumns.get(table.getValueAt(row, 0));
                this.comboBox.setModel(new DefaultComboBoxModel<MetaDataSearchOperator>(MetaDataSearchOperator.valuesForColumnType((MetaDataColumnType)metaDataColumn.getType())));
                return super.getTableCellEditorComponent(table, value, isSelected, row, column);
            }
        };
        TableColumn operatorColumn = this.metaDataSearchTable.getColumnModel().getColumn(1);
        operatorColumn.setCellRenderer(new MirthComboBoxTableCellRenderer(MetaDataSearchOperator.values()));
        operatorColumn.setCellEditor(operatorEditor);
        operatorColumn.setMinWidth(140);
        operatorColumn.setMaxWidth(140);
        TableColumn caseColumn = this.metaDataSearchTable.getColumnModel().getColumn(3);
        caseColumn.setMinWidth(75);
        caseColumn.setMaxWidth(75);
        this.deleteMetaDataSearchButton.setEnabled(false);
    }

    public void loadChannel() {
        this.connectorTable.setModel(this.createConnectorTableModel());
        this.initMetaDataSearchTable();
    }

    protected TableModel createConnectorTableModel() {
        return new ItemSelectionTableModel<Integer, String>(this.messageBrowser.getConnectors(), null, "Current Connector Name", "Included", "Id");
    }

    protected TableModel getConnectorTableModel() {
        return this.connectorTable.getModel();
    }

    public void setSelectedMetaDataIds(List<Integer> selectedMetaDataIds) {
        if (selectedMetaDataIds.get(0) != null) {
            ItemSelectionTableModel connectorModel = (ItemSelectionTableModel)this.connectorTable.getModel();
            connectorModel.unselectAllKeys();
            for (Integer metaDataId : selectedMetaDataIds) {
                connectorModel.selectKey(metaDataId);
            }
        }
    }

    public void applySelectionsToFilter(MessageFilter messageFilter) {
        String id;
        List<Integer> selectedMetaDataIds = this.getMetaDataIds(true);
        if (selectedMetaDataIds != null) {
            if (selectedMetaDataIds.contains(null)) {
                messageFilter.setExcludedMetaDataIds(this.getMetaDataIds(false));
            } else {
                messageFilter.setIncludedMetaDataIds(selectedMetaDataIds);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)(id = this.messageIdLowerField.getText()))) {
            messageFilter.setMinMessageId(Long.valueOf(Long.parseLong(id)));
        }
        if (!StringUtils.isEmpty((CharSequence)(id = this.messageIdUpperField.getText()))) {
            messageFilter.setMaxMessageId(Long.valueOf(Long.parseLong(id)));
        }
        if (!StringUtils.isEmpty((CharSequence)(id = this.originalIdLowerField.getText()))) {
            messageFilter.setOriginalIdLower(Long.valueOf(Long.parseLong(id)));
        }
        if (!StringUtils.isEmpty((CharSequence)(id = this.originalIdUpperField.getText()))) {
            messageFilter.setOriginalIdUpper(Long.valueOf(Long.parseLong(id)));
        }
        if (!StringUtils.isEmpty((CharSequence)(id = this.importIdLowerField.getText()))) {
            messageFilter.setImportIdLower(Long.valueOf(Long.parseLong(id)));
        }
        if (!StringUtils.isEmpty((CharSequence)(id = this.importIdUpperField.getText()))) {
            messageFilter.setImportIdUpper(Long.valueOf(Long.parseLong(id)));
        }
        messageFilter.setServerId(this.getServerId());
        Integer sendAttemptsLower = (Integer)this.sendAttemptsLower.getValue();
        Integer sendAttemptsUpper = this.sendAttemptsUpper.getIntegerValue();
        if (sendAttemptsLower <= 0) {
            sendAttemptsLower = null;
        }
        if (sendAttemptsLower != null && sendAttemptsUpper != null && sendAttemptsLower > sendAttemptsUpper) {
            sendAttemptsLower = null;
            sendAttemptsUpper = null;
        }
        messageFilter.setAttachment(Boolean.valueOf(this.attachmentCheckBox.isSelected()));
        messageFilter.setError(Boolean.valueOf(this.errorCheckBox.isSelected()));
        messageFilter.setSendAttemptsLower(sendAttemptsLower);
        messageFilter.setSendAttemptsUpper(sendAttemptsUpper);
        List<ContentSearchElement> contentSearch = this.getContentSearch();
        messageFilter.setContentSearch(contentSearch.isEmpty() ? null : contentSearch);
        try {
            messageFilter.setMetaDataSearch(this.getMetaDataSearch());
        }
        catch (MetaDataColumnException e) {
            this.parent.alertError(this.parent.messageBrowser, "Invalid value for column: " + e.getMetaDataColumn().getName());
        }
    }

    private List<Integer> getMetaDataIds(boolean selected) {
        List<Integer> selectedMetaDataIds = ((ItemSelectionTableModel)this.connectorTable.getModel()).getKeys(selected);
        if (selectedMetaDataIds.size() == this.connectorTable.getRowCount()) {
            return null;
        }
        return selectedMetaDataIds;
    }

    private String getServerId() {
        String serverId = this.serverIdField.getText();
        return serverId.length() == 0 ? null : serverId;
    }

    private List<ContentSearchElement> getContentSearch() {
        ArrayList<ContentSearchElement> contentSearch = new ArrayList<ContentSearchElement>();
        HashMap<ContentType, ArrayList<String>> contentSearchMap = new HashMap<ContentType, ArrayList<String>>();
        DefaultTableModel model = (DefaultTableModel)this.contentSearchTable.getModel();
        int rowCount = model.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            ContentType contentType = (ContentType)model.getValueAt(i, 0);
            String searchText = (String)model.getValueAt(i, 1);
            if (searchText.length() <= 0) continue;
            ArrayList<String> searchList = (ArrayList<String>)contentSearchMap.get(contentType);
            if (searchList == null) {
                searchList = new ArrayList<String>();
                contentSearchMap.put(contentType, searchList);
            }
            searchList.add(searchText);
        }
        for (ContentType contentType : ContentType.getDisplayValues()) {
            if (!contentSearchMap.containsKey(contentType)) continue;
            contentSearch.add(new ContentSearchElement(contentType.getContentTypeCode(), (List)contentSearchMap.get(contentType)));
        }
        return contentSearch;
    }

    private List<MetaDataSearchElement> getMetaDataSearch() throws MetaDataColumnException {
        ArrayList<MetaDataSearchElement> metaDataSearch = new ArrayList<MetaDataSearchElement>();
        DefaultTableModel model = (DefaultTableModel)this.metaDataSearchTable.getModel();
        int rowCount = model.getRowCount();
        if (rowCount == 0) {
            return null;
        }
        for (int i = 0; i < rowCount; ++i) {
            String metaDataName = (String)model.getValueAt(i, 0);
            String operator = ((MetaDataSearchOperator)model.getValueAt(i, 1)).toFullString();
            String searchText = (String)model.getValueAt(i, 2);
            Boolean ignoreCase = (Boolean)model.getValueAt(i, 3);
            if (!StringUtils.isNotEmpty((CharSequence)searchText)) continue;
            MetaDataColumn column = cachedMetaDataColumns.get(metaDataName);
            metaDataSearch.add(new MetaDataSearchElement(metaDataName, operator, column.getType().castValue((Object)searchText), ignoreCase));
        }
        return metaDataSearch;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            this.saveSelections();
        }
        super.setVisible(visible);
    }

    public void saveSelections() {
        DefaultTableModel contentSearchModel = (DefaultTableModel)this.contentSearchTable.getModel();
        DefaultTableModel metaDataSearchModel = (DefaultTableModel)this.metaDataSearchTable.getModel();
        ItemSelectionTableModel connectorModel = (ItemSelectionTableModel)this.connectorTable.getModel();
        cachedSettings.clear();
        cachedSettings.put("messageIdLowerField", this.messageIdLowerField.getText());
        cachedSettings.put("messageIdUpperField", this.messageIdUpperField.getText());
        cachedSettings.put("originalIdLowerField", this.originalIdLowerField.getText());
        cachedSettings.put("originalIdUpperField", this.originalIdUpperField.getText());
        cachedSettings.put("importIdLowerField", this.importIdLowerField.getText());
        cachedSettings.put("importIdUpperField", this.importIdUpperField.getText());
        cachedSettings.put("serverIdField", this.serverIdField.getText());
        cachedSettings.put("sendAttemptsLower", this.sendAttemptsLower.getValue());
        cachedSettings.put("sendAttemptsUpper", this.sendAttemptsUpper.getValue());
        cachedSettings.put("attachment", this.attachmentCheckBox.isSelected());
        cachedSettings.put("error", this.errorCheckBox.isSelected());
        Object[][] contentSearchData = new Object[contentSearchModel.getRowCount()][contentSearchModel.getColumnCount()];
        for (int row = 0; row < contentSearchModel.getRowCount(); ++row) {
            for (int column = 0; column < contentSearchModel.getColumnCount(); ++column) {
                contentSearchData[row][column] = contentSearchModel.getValueAt(row, column);
            }
        }
        cachedSettings.put("contentSearchTable", contentSearchData);
        Object[][] metaDataSearchData = new Object[metaDataSearchModel.getRowCount()][metaDataSearchModel.getColumnCount()];
        for (int row = 0; row < metaDataSearchModel.getRowCount(); ++row) {
            for (int column = 0; column < metaDataSearchModel.getColumnCount(); ++column) {
                metaDataSearchData[row][column] = metaDataSearchModel.getValueAt(row, column);
            }
        }
        cachedSettings.put("metaDataSearchTable", metaDataSearchData);
        Boolean[] connectorData = new Boolean[connectorModel.getRowCount()];
        for (int row = 0; row < connectorModel.getRowCount(); ++row) {
            connectorData[row] = (Boolean)connectorModel.getValueAt(row, 2);
        }
        cachedSettings.put("connectorTable", connectorData);
    }

    public void loadSelections() {
        DefaultTableModel contentSearchModel = (DefaultTableModel)this.contentSearchTable.getModel();
        DefaultTableModel metaDataSearchModel = (DefaultTableModel)this.metaDataSearchTable.getModel();
        ItemSelectionTableModel connectorModel = (ItemSelectionTableModel)this.connectorTable.getModel();
        this.messageIdLowerField.setText((String)cachedSettings.get("messageIdLowerField"));
        this.messageIdUpperField.setText((String)cachedSettings.get("messageIdUpperField"));
        this.originalIdLowerField.setText((String)cachedSettings.get("originalIdLowerField"));
        this.originalIdUpperField.setText((String)cachedSettings.get("originalIdUpperField"));
        this.importIdLowerField.setText((String)cachedSettings.get("importIdLowerField"));
        this.importIdUpperField.setText((String)cachedSettings.get("importIdUpperField"));
        this.serverIdField.setText((String)cachedSettings.get("serverIdField"));
        this.sendAttemptsLower.setValue(cachedSettings.get("sendAttemptsLower"));
        this.sendAttemptsUpper.setValue(cachedSettings.get("sendAttemptsUpper"));
        this.attachmentCheckBox.setSelected((Boolean)cachedSettings.get("attachment"));
        this.errorCheckBox.setSelected((Boolean)cachedSettings.get("error"));
        contentSearchModel.setNumRows(0);
        Object[][] contentSearchData = (Object[][])cachedSettings.get("contentSearchTable");
        for (int row = 0; row < contentSearchData.length; ++row) {
            contentSearchModel.addRow(contentSearchData[row]);
        }
        metaDataSearchModel.setNumRows(0);
        Object[][] metaDataSearchData = (Object[][])cachedSettings.get("metaDataSearchTable");
        for (int row = 0; row < metaDataSearchData.length; ++row) {
            metaDataSearchModel.addRow(metaDataSearchData[row]);
        }
        Boolean[] connectorData = (Boolean[])cachedSettings.get("connectorTable");
        for (int row = 0; row < connectorModel.getRowCount(); ++row) {
            connectorModel.setValueAt(connectorData[row], row, 2);
        }
        cachedSettings.clear();
    }

    public void resetSelections() {
        this.messageIdLowerField.setText("");
        this.messageIdUpperField.setText("");
        this.originalIdLowerField.setText("");
        this.originalIdUpperField.setText("");
        this.importIdLowerField.setText("");
        this.importIdUpperField.setText("");
        this.serverIdField.setText("");
        this.sendAttemptsLower.setValue(0);
        this.sendAttemptsUpper.setValue("");
        this.attachmentCheckBox.setSelected(false);
        this.errorCheckBox.setSelected(false);
        ((DefaultTableModel)this.contentSearchTable.getModel()).setNumRows(0);
        ((DefaultTableModel)this.metaDataSearchTable.getModel()).setNumRows(0);
        ((ItemSelectionTableModel)this.connectorTable.getModel()).selectAllKeys();
    }

    public Boolean hasAdvancedCriteria() {
        Boolean hasAdvancedCriteria = false;
        ItemSelectionTableModel model = (ItemSelectionTableModel)this.connectorTable.getModel();
        if (StringUtils.isNotEmpty((CharSequence)this.messageIdLowerField.getText()) || StringUtils.isNotEmpty((CharSequence)this.messageIdUpperField.getText()) || StringUtils.isNotEmpty((CharSequence)this.originalIdLowerField.getText()) || StringUtils.isNotEmpty((CharSequence)this.originalIdUpperField.getText()) || StringUtils.isNotEmpty((CharSequence)this.importIdLowerField.getText()) || StringUtils.isNotEmpty((CharSequence)this.importIdUpperField.getText()) || StringUtils.isNotEmpty((CharSequence)this.serverIdField.getText()) || !this.sendAttemptsLower.getValue().equals(0) || StringUtils.isNotEmpty((CharSequence)this.sendAttemptsUpper.getValue().toString()) || this.attachmentCheckBox.isSelected() || this.errorCheckBox.isSelected() || ((DefaultTableModel)this.contentSearchTable.getModel()).getRowCount() != 0 || ((DefaultTableModel)this.metaDataSearchTable.getModel()).getRowCount() != 0 || model.getKeys(true).size() != model.getRowCount()) {
            hasAdvancedCriteria = true;
        }
        return hasAdvancedCriteria;
    }

    private void stopEditing() {
        TableCellEditor cellEditor = this.contentSearchTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        if ((cellEditor = this.metaDataSearchTable.getCellEditor()) != null) {
            cellEditor.stopCellEditing();
        }
    }

    @Override
    public void onCloseAction() {
        this.formWindowClosing(null);
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.mirthTable1 = new MirthTable();
        this.jScrollPane3 = new JScrollPane();
        this.mirthTable2 = new MirthTable();
        this.jScrollPane5 = new JScrollPane();
        this.mirthTable3 = new MirthTable();
        this.containerPanel = new JPanel();
        this.messageIdLabel = new JLabel();
        this.messageIdLowerField = new MirthTextField();
        this.serverIdField = new MirthTextField();
        this.serverIdLabel = new JLabel();
        this.jLabel5 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jSeparator1 = new JSeparator();
        this.cancelButton = new JButton();
        this.okButton1 = new JButton();
        this.jScrollPane4 = new JScrollPane();
        this.contentSearchTable = new MirthTable();
        this.addContentSearchButton = new MirthButton();
        this.deleteContentSearchButton = new MirthButton();
        this.sendAttemptsUpper = new MirthBlankableSpinner(0, null);
        this.jScrollPane6 = new JScrollPane();
        this.connectorTable = new MirthTable();
        this.connectorSelectAll = new JLabel();
        this.connectorDeselectAll = new JLabel();
        this.jLabel7 = new JLabel();
        this.sendAttemptsLower = new JSpinner();
        this.addMetaDataSearchButton = new MirthButton();
        this.jScrollPane7 = new JScrollPane();
        this.metaDataSearchTable = new MirthTable();
        this.deleteMetaDataSearchButton = new MirthButton();
        this.jLabel1 = new JLabel();
        this.attachmentCheckBox = new MirthCheckBox();
        this.importIdLabel = new JLabel();
        this.importIdLowerField = new MirthTextField();
        this.jLabel4 = new JLabel();
        this.messageIdUpperField = new MirthTextField();
        this.jLabel6 = new JLabel();
        this.importIdUpperField = new MirthTextField();
        this.jLabel8 = new JLabel();
        this.jLabel2 = new JLabel();
        this.errorCheckBox = new MirthCheckBox();
        this.originalIdLabel = new JLabel();
        this.jLabel9 = new JLabel();
        this.originalIdUpperField = new MirthTextField();
        this.originalIdLowerField = new MirthTextField();
        this.mirthTable1.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane2.setViewportView((Component)((Object)this.mirthTable1));
        this.mirthTable2.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane3.setViewportView((Component)((Object)this.mirthTable2));
        this.mirthTable3.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.jScrollPane5.setViewportView((Component)((Object)this.mirthTable3));
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                MessageBrowserAdvancedFilter.this.formWindowClosing(evt);
            }
        });
        this.containerPanel.setBackground(new Color(255, 255, 255));
        this.messageIdLabel.setHorizontalAlignment(4);
        this.messageIdLabel.setText("Message Id:");
        this.serverIdField.setToolTipText("<html>The GUID of the message in the BridgeLink database.<br>This can be retrieved from the Meta Data tab in the Message Browser.</html>");
        this.serverIdLabel.setHorizontalAlignment(4);
        this.serverIdLabel.setText("Server Id:");
        this.jLabel5.setHorizontalAlignment(4);
        this.jLabel5.setText("Send Attempts:");
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.cancelButton.setText("Cancel");
        this.cancelButton.setMargin(new Insets(0, 2, 0, 2));
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowserAdvancedFilter.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton1.setText("OK");
        this.okButton1.setMargin(new Insets(0, 2, 0, 2));
        this.okButton1.setMaximumSize(new Dimension(48, 21));
        this.okButton1.setMinimumSize(new Dimension(48, 21));
        this.okButton1.setPreferredSize(new Dimension(48, 21));
        this.okButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowserAdvancedFilter.this.okButton1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1).addGroup(jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)));
        jPanel1Layout.linkSize(0, this.cancelButton, this.okButton1);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 6, Short.MAX_VALUE).addComponent(this.jSeparator1, -2, -1, -2).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cancelButton, -1, -1, Short.MAX_VALUE).addComponent(this.okButton1, -2, -1, -2))));
        jPanel1Layout.linkSize(1, this.cancelButton, this.okButton1);
        this.contentSearchTable.setToolTipText("<html> \nSearch specific message content. This process could take a long time<br/>\ndepending on the amount of message content currently stored. Any message<br/>\ncontent that was encrypted by this channel will not be searchable. </html>");
        this.jScrollPane4.setViewportView((Component)((Object)this.contentSearchTable));
        this.addContentSearchButton.setText("New");
        this.addContentSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowserAdvancedFilter.this.addContentSearchButtonActionPerformed(evt);
            }
        });
        this.deleteContentSearchButton.setText("Delete");
        this.deleteContentSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowserAdvancedFilter.this.deleteContentSearchButtonActionPerformed(evt);
            }
        });
        this.connectorTable.setToolTipText("<html>\nInclude messages from the selected connectors. Connectors that were<br/>\nremoved from this channel are not available to select. Messages for removed<br/>\nconnectors will only be included if all connectors are selected. If a connector's<br/>\nname has changed, messages before the name change will still be included.\n</html>");
        this.jScrollPane6.setViewportView((Component)((Object)this.connectorTable));
        this.connectorSelectAll.setForeground(Color.blue);
        this.connectorSelectAll.setText("<html><u>Select All</u></html>");
        this.connectorSelectAll.setToolTipText("Select all connectors below.");
        this.connectorSelectAll.setCursor(new Cursor(12));
        this.connectorSelectAll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MessageBrowserAdvancedFilter.this.connectorSelectAllMouseReleased(evt);
            }
        });
        this.connectorDeselectAll.setForeground(Color.blue);
        this.connectorDeselectAll.setText("<html><u>Deselect All</u></html>");
        this.connectorDeselectAll.setToolTipText("Deselect all connectors below.");
        this.connectorDeselectAll.setCursor(new Cursor(12));
        this.connectorDeselectAll.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                MessageBrowserAdvancedFilter.this.connectorDeselectAllMouseReleased(evt);
            }
        });
        this.jLabel7.setFont(new Font("Lucida Grande", 0, 12));
        this.jLabel7.setText("|");
        this.addMetaDataSearchButton.setText("New");
        this.addMetaDataSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowserAdvancedFilter.this.addMetaDataSearchButtonActionPerformed(evt);
            }
        });
        this.metaDataSearchTable.setToolTipText("<html>Search on custom metadata stored for this channel.<br/>Note that if Ignore Case is unchecked, case<br/>sensitivity depends on the database collation.</html>");
        this.jScrollPane7.setViewportView((Component)((Object)this.metaDataSearchTable));
        this.deleteMetaDataSearchButton.setText("Delete");
        this.deleteMetaDataSearchButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MessageBrowserAdvancedFilter.this.deleteMetaDataSearchButtonActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Has Attachment:");
        this.attachmentCheckBox.setBackground(new Color(255, 255, 255));
        this.attachmentCheckBox.setToolTipText("If checked, only messages with attachments will be included.");
        this.importIdLabel.setHorizontalAlignment(4);
        this.importIdLabel.setText("Import Id:");
        this.jLabel4.setText("-");
        this.jLabel6.setText("-");
        this.jLabel8.setText("-");
        this.jLabel2.setText("Has Error:");
        this.errorCheckBox.setBackground(new Color(255, 255, 255));
        this.errorCheckBox.setToolTipText("If checked, only messages with errors will be included.");
        this.originalIdLabel.setHorizontalAlignment(4);
        this.originalIdLabel.setText("Original Id:");
        this.jLabel9.setText("-");
        GroupLayout containerPanelLayout = new GroupLayout(this.containerPanel);
        this.containerPanel.setLayout(containerPanelLayout);
        containerPanelLayout.setHorizontalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addContainerGap().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel5, GroupLayout.Alignment.TRAILING).addComponent(this.serverIdLabel, GroupLayout.Alignment.TRAILING, -2, 52, -2).addComponent(this.importIdLabel, GroupLayout.Alignment.TRAILING).addComponent(this.originalIdLabel, GroupLayout.Alignment.TRAILING).addComponent(this.messageIdLabel, GroupLayout.Alignment.TRAILING)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.attachmentCheckBox, -2, -1, -2).addComponent(this.errorCheckBox, -2, -1, -2).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.serverIdField, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(containerPanelLayout.createSequentialGroup().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.messageIdLowerField, -2, 118, -2).addComponent(this.originalIdLowerField, -2, 118, -2).addComponent(this.importIdLowerField, -2, 118, -2).addComponent(this.sendAttemptsLower, -2, 118, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.originalIdUpperField, -2, 118, -2)).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.messageIdUpperField, -2, 118, -2)).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.importIdUpperField, -2, 118, -2)).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendAttemptsUpper, -2, 118, -2)))))).addGap(0, 167, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, containerPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.connectorSelectAll, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.connectorDeselectAll, -2, -1, -2)).addGroup(containerPanelLayout.createSequentialGroup().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane7).addComponent(this.jScrollPane4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addContentSearchButton, -1, -1, Short.MAX_VALUE).addComponent(this.deleteContentSearchButton, -2, -1, -2)).addGroup(GroupLayout.Alignment.TRAILING, containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.addMetaDataSearchButton, -1, -1, Short.MAX_VALUE).addComponent(this.deleteMetaDataSearchButton, -2, 52, -2)))).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane6, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        containerPanelLayout.setVerticalGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addGap(4, 4, 4).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.connectorSelectAll, -2, -1, -2).addComponent(this.connectorDeselectAll, -2, -1, -2).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -2, 140, -2).addGap(5, 5, 5).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.messageIdLabel).addComponent(this.messageIdLowerField, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.messageIdUpperField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel9).addComponent(this.originalIdUpperField, -2, -1, -2)).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.originalIdLowerField, -2, -1, -2).addComponent(this.originalIdLabel))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel6).addComponent(this.importIdUpperField, -2, -1, -2)).addGroup(containerPanelLayout.createSequentialGroup().addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.importIdLowerField, -2, -1, -2).addComponent(this.importIdLabel)).addGap(5, 5, 5).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.serverIdField, -2, -1, -2).addComponent(this.serverIdLabel)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.sendAttemptsLower, -2, -1, -2).addComponent(this.sendAttemptsUpper, -2, -1, -2).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.attachmentCheckBox, GroupLayout.Alignment.LEADING, -2, -1, -2).addComponent(this.jLabel1)).addGap(5, 5, 5).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jLabel2).addComponent(this.errorCheckBox, GroupLayout.Alignment.LEADING, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.jScrollPane4, -2, 0, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.addContentSearchButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteContentSearchButton, -2, -1, -2).addGap(85, 85, 85))).addGroup(containerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(containerPanelLayout.createSequentialGroup().addComponent(this.addMetaDataSearchButton, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteMetaDataSearchButton, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jScrollPane7, -1, 129, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addGap(11, 11, 11)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.containerPanel, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.containerPanel, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void shiftValues(JList source, JList destination) {
        Object[] values = source.getSelectedValues();
        DefaultListModel sourceModel = (DefaultListModel)source.getModel();
        DefaultListModel destinationModel = (DefaultListModel)destination.getModel();
        for (Object value : values) {
            sourceModel.removeElement(value);
            destinationModel.addElement(value);
        }
    }

    private void addContentSearchButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.contentSearchTable.getModel();
        int row = model.getRowCount();
        model.addRow(new Object[]{ContentType.RAW, ""});
        this.contentSearchTable.setRowSelectionInterval(row, row);
    }

    private int getSelectedRow(MirthTable table) {
        if (table.isEditing()) {
            return table.getEditingRow();
        }
        return table.getSelectedRow();
    }

    private void deleteContentSearchButtonActionPerformed(ActionEvent evt) {
        int rowCount;
        int selectedRow = this.getSelectedRow(this.contentSearchTable);
        if (selectedRow != -1 && !this.contentSearchTable.isEditing()) {
            ((DefaultTableModel)this.contentSearchTable.getModel()).removeRow(selectedRow);
        }
        if ((rowCount = this.contentSearchTable.getRowCount()) > 0) {
            if (selectedRow >= rowCount) {
                --selectedRow;
            }
            this.contentSearchTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    private void connectorSelectAllMouseReleased(MouseEvent evt) {
        ((ItemSelectionTableModel)this.connectorTable.getModel()).selectAllKeys();
    }

    private void connectorDeselectAllMouseReleased(MouseEvent evt) {
        ((ItemSelectionTableModel)this.connectorTable.getModel()).unselectAllKeys();
    }

    private void addMetaDataSearchButtonActionPerformed(ActionEvent evt) {
        DefaultTableModel model = (DefaultTableModel)this.metaDataSearchTable.getModel();
        int row = model.getRowCount();
        List<MetaDataColumn> metaDataColumns = this.messageBrowser.getMetaDataColumns();
        if (metaDataColumns.size() > 0) {
            MetaDataColumn metaDataColumn = metaDataColumns.get(0);
            MetaDataSearchOperator operator = MetaDataSearchOperator.EQUAL;
            model.addRow(new Object[]{metaDataColumn.getName(), operator, "", false});
            this.metaDataSearchTable.setRowSelectionInterval(row, row);
        }
    }

    private void deleteMetaDataSearchButtonActionPerformed(ActionEvent evt) {
        int rowCount;
        int selectedRow = this.getSelectedRow(this.metaDataSearchTable);
        if (selectedRow != -1 && !this.metaDataSearchTable.isEditing()) {
            ((DefaultTableModel)this.metaDataSearchTable.getModel()).removeRow(selectedRow);
        }
        if ((rowCount = this.metaDataSearchTable.getRowCount()) > 0) {
            if (selectedRow >= rowCount) {
                --selectedRow;
            }
            this.metaDataSearchTable.setRowSelectionInterval(selectedRow, selectedRow);
        }
    }

    private void formWindowClosing(WindowEvent evt) {
        this.stopEditing();
        this.loadSelections();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.stopEditing();
        this.loadSelections();
        this.setVisible(false);
    }

    private void okButton1ActionPerformed(ActionEvent evt) {
        this.stopEditing();
        this.setVisible(false);
    }
}

