/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.browsers.message;

import com.mirth.connect.client.ui.DateCellRenderer;
import com.mirth.connect.client.ui.NumberCellRenderer;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserTableNode;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.donkey.model.channel.MetaDataColumnType;
import java.awt.Component;
import java.text.SimpleDateFormat;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.table.ColumnFactory;
import org.jdesktop.swingx.table.TableColumnExt;

public class MessageBrowserTableColumnFactory
extends ColumnFactory {
    public TableColumnExt createAndConfigureTableColumn(TableModel model, int index) {
        DefaultTableCellRenderer renderer;
        TableColumnExt column = super.createAndConfigureTableColumn(model, index);
        switch (index) {
            case 0: {
                renderer = new MessageBrowserNumberCellRenderer();
                column.setMaxWidth(500);
                column.setMinWidth(90);
                column.setPreferredWidth(90);
                column.setToolTipText("<html><body>The message id.</body></html>");
                break;
            }
            case 1: {
                renderer = new MessageBrowserTextCellRenderer();
                column.setMinWidth(90);
                column.setToolTipText("<html><body>The historic name of the connector at the time the message was processed.</body></html>");
                break;
            }
            case 2: {
                renderer = new MessageBrowserTextCellRenderer();
                column.setMaxWidth(85);
                column.setMinWidth(85);
                column.setToolTipText("<html><body>The message status after being processed by the connector.</body></html>");
                break;
            }
            case 3: {
                DateCellRenderer dateCellRenderer = new DateCellRenderer();
                dateCellRenderer.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                renderer = dateCellRenderer;
                column.setMaxWidth(140);
                column.setMinWidth(140);
                column.setToolTipText("<html><body>The date and time the original message was received. This value is<br>not updated when the message is reprocessed.</body></html>");
                break;
            }
            case 4: {
                DateCellRenderer dateCellRenderer = new DateCellRenderer();
                dateCellRenderer.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                renderer = dateCellRenderer;
                column.setMaxWidth(140);
                column.setMinWidth(140);
                column.setToolTipText("<html><body>The date and time the message began processing through the connector.</body></html>");
                break;
            }
            case 5: {
                renderer = new MessageBrowserNumberCellRenderer();
                column.setMaxWidth(500);
                column.setMinWidth(90);
                column.setPreferredWidth(90);
                column.setToolTipText("<html><body>Source Connector: The number of times the connector<br>attempted to send the response back to the point of origin.<br>Destination Connector: The number of times the connector<br>attempted to send the message to its recipient.</body></html>");
                break;
            }
            case 6: {
                DateCellRenderer dateCellRenderer = new DateCellRenderer();
                dateCellRenderer.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                renderer = dateCellRenderer;
                column.setMaxWidth(140);
                column.setMinWidth(140);
                column.setToolTipText("<html><body>Source Connector: N/A<br>Destination Connector: The date and time immediately before the most recent send attempt.</body></html>");
                break;
            }
            case 7: {
                DateCellRenderer dateCellRenderer = new DateCellRenderer();
                dateCellRenderer.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                renderer = dateCellRenderer;
                column.setMaxWidth(140);
                column.setMinWidth(140);
                column.setToolTipText("<html><body>Source Connector: The date and time immediately before the connector<br>attempted to send the response back to the point of origin.<br>Destination Connector: The date and time immediately after the server<br>receives a response from the connector, which may be empty.</body></html>");
                break;
            }
            case 8: {
                renderer = new MessageBrowserTextCellRenderer();
                column.setMaxWidth(85);
                column.setMinWidth(85);
                column.setToolTipText("<html><body>Indicates whether an error exists for this message. It is possible for<br>a message to have errors even if the message status is not ERROR.</body></html>");
                break;
            }
            case 9: {
                column.setMaxWidth(210);
                column.setMinWidth(210);
                renderer = new MessageBrowserTextCellRenderer();
                column.setToolTipText("<html><body>The id of the server that processed the message through the connector.</body></html>");
                break;
            }
            case 10: {
                column.setMaxWidth(210);
                column.setMinWidth(210);
                renderer = new MessageBrowserTextCellRenderer();
                column.setToolTipText("<html><body>The id of the server that received the message.</body></html>");
                break;
            }
            case 11: {
                renderer = new MessageBrowserTextCellRenderer(4);
                column.setMaxWidth(500);
                column.setMinWidth(90);
                column.setPreferredWidth(90);
                column.setToolTipText("<html><body>The original message id of a reprocessed message. This value<br>only exists for reprocessed messages.</body></html>");
                break;
            }
            case 12: {
                renderer = new MessageBrowserTextCellRenderer(4);
                column.setMaxWidth(500);
                column.setMinWidth(90);
                column.setToolTipText("<html><body>The original message id of an imported message. This value<br>only exists for imported messages.</body></html>");
                break;
            }
            case 13: {
                column.setMaxWidth(210);
                column.setMinWidth(210);
                renderer = new MessageBrowserTextCellRenderer();
                column.setToolTipText("<html><body>The original channel id of an imported message. This value<br>only exists for messages imported from a different channel.</body></html>");
                break;
            }
            case 14: {
                renderer = new MessageBrowserTextCellRenderer();
                column.setMaxWidth(250);
                column.setMinWidth(90);
                column.setPreferredWidth(190);
                column.setToolTipText("<html><body>The channel name of the channel that the message was passed through.</body></html>");
                break;
            }
            default: {
                renderer = new MessageBrowserTextCellRenderer();
            }
        }
        column.setCellRenderer((TableCellRenderer)new MessageBrowserItalicCellRenderer(renderer));
        return column;
    }

    public void configureCustomColumn(TableColumnExt column, MetaDataColumnType columnType) {
        DefaultTableCellRenderer renderer;
        switch (columnType) {
            case NUMBER: {
                renderer = new MessageBrowserNumberCellRenderer();
                column.setMaxWidth(500);
                column.setMinWidth(90);
                column.setPreferredWidth(90);
                break;
            }
            case BOOLEAN: {
                renderer = new MessageBrowserTextCellRenderer();
                column.setMaxWidth(500);
                column.setMinWidth(90);
                column.setPreferredWidth(90);
                break;
            }
            case TIMESTAMP: {
                DateCellRenderer timestampRenderer = new DateCellRenderer();
                timestampRenderer.setDateFormat(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS"));
                renderer = timestampRenderer;
                column.setMaxWidth(140);
                column.setMinWidth(140);
                break;
            }
            default: {
                renderer = new MessageBrowserTextCellRenderer();
            }
        }
        column.setCellRenderer((TableCellRenderer)new MessageBrowserItalicCellRenderer(renderer));
    }

    private class MessageBrowserNumberCellRenderer
    extends NumberCellRenderer {
        private int alignment;

        public MessageBrowserNumberCellRenderer() {
            this(4);
        }

        public MessageBrowserNumberCellRenderer(int alignment) {
            this.alignment = alignment;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                label.setHorizontalAlignment(0);
                label.setText("--");
            } else {
                label.setHorizontalAlignment(this.alignment);
            }
            return label;
        }
    }

    private class MessageBrowserTextCellRenderer
    extends DefaultTableCellRenderer {
        private int alignment;

        public MessageBrowserTextCellRenderer() {
            this(2);
        }

        public MessageBrowserTextCellRenderer(int alignment) {
            this.alignment = alignment;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (value == null) {
                label.setHorizontalAlignment(0);
                label.setText("--");
            } else {
                label.setHorizontalAlignment(this.alignment);
            }
            return label;
        }
    }

    private class MessageBrowserItalicCellRenderer
    implements TableCellRenderer {
        private TableCellRenderer delegateRenderer;

        public MessageBrowserItalicCellRenderer(TableCellRenderer renderer) {
            this.delegateRenderer = renderer;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = this.delegateRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (component instanceof JLabel) {
                JLabel label = (JLabel)component;
                MessageBrowserTableNode messageNode = (MessageBrowserTableNode)((Object)((MirthTreeTable)((Object)table)).getPathForRow(row).getLastPathComponent());
                if (!messageNode.isProcessed().booleanValue()) {
                    label.setText("<html><i><font color='gray'>" + label.getText() + "</font></i></html>");
                }
            }
            return component;
        }
    }
}

