/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.browsers.message;

import com.mirth.connect.client.ui.AbstractSortableTreeTableNode;
import com.mirth.connect.client.ui.browsers.message.MessageBrowserTableModel;
import com.mirth.connect.donkey.model.message.ConnectorMessage;
import com.mirth.connect.donkey.model.message.ContentType;
import com.mirth.connect.donkey.model.message.Message;

public class MessageBrowserTableNode
extends AbstractSortableTreeTableNode {
    private Object[] row;
    private String channelId;
    private Long messageId;
    private Integer metaDataId;
    private Boolean active;
    private Boolean processed;

    public MessageBrowserTableNode(int staticColumnCount, Message message) {
        this.row = new Object[staticColumnCount];
        this.active = false;
        this.processed = message.isProcessed();
        this.row[0] = message.getMessageId();
        this.row[1] = null;
        this.row[2] = null;
        this.row[3] = null;
        this.row[4] = null;
        this.row[5] = null;
        this.row[6] = null;
        this.row[7] = null;
        this.row[8] = null;
        this.row[9] = null;
        this.row[11] = message.getOriginalId();
        this.row[12] = message.getImportId();
        this.row[13] = message.getImportChannelId();
        this.row[10] = null;
        this.row[14] = message.getChannelName();
    }

    public MessageBrowserTableNode(int staticColumnCount, Message message, int metaDataId, MessageBrowserTableModel model) {
        this.row = new Object[model.getColumnCount()];
        this.channelId = message.getChannelId();
        this.messageId = message.getMessageId();
        this.metaDataId = metaDataId;
        ConnectorMessage connectorMessage = (ConnectorMessage)message.getConnectorMessages().get(this.metaDataId);
        this.active = true;
        this.processed = message.isProcessed();
        this.row[0] = connectorMessage.getMetaDataId() == 0 ? message.getMessageId() : null;
        this.row[1] = connectorMessage.getConnectorName();
        this.row[2] = connectorMessage.getStatus();
        this.row[3] = message.getReceivedDate();
        this.row[4] = connectorMessage.getReceivedDate();
        this.row[5] = connectorMessage.getSendAttempts();
        this.row[6] = connectorMessage.getSendDate();
        this.row[7] = connectorMessage.getResponseDate();
        this.row[8] = this.getErrorString(connectorMessage);
        this.row[9] = connectorMessage.getServerId();
        this.row[11] = connectorMessage.getMetaDataId() == 0 ? message.getOriginalId() : null;
        this.row[12] = connectorMessage.getMetaDataId() == 0 ? message.getImportId() : null;
        this.row[13] = connectorMessage.getMetaDataId() == 0 ? message.getImportChannelId() : null;
        this.row[10] = message.getServerId();
        this.row[14] = connectorMessage.getMetaDataId() == 0 ? message.getChannelName() : " ";
        for (int i = staticColumnCount; i < model.getColumnCount(); ++i) {
            this.row[i] = connectorMessage.getMetaDataMap().get(model.getColumnName(i).toUpperCase());
        }
    }

    private String getErrorString(ConnectorMessage connectorMessage) {
        String error = null;
        if (connectorMessage.containsError(ContentType.PROCESSING_ERROR)) {
            error = "Processing";
        }
        if (connectorMessage.containsError(ContentType.RESPONSE_ERROR)) {
            if (error != null) {
                return "Multiple";
            }
            error = "Response";
        }
        if (connectorMessage.containsError(ContentType.POSTPROCESSOR_ERROR)) {
            if (error != null) {
                return "Multiple";
            }
            error = "Postprocessor";
        }
        return error;
    }

    public Object getValueAt(int column) {
        return this.row[column];
    }

    public int getColumnCount() {
        return this.row.length;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public Long getMessageId() {
        return this.messageId;
    }

    public Integer getMetaDataId() {
        return this.metaDataId;
    }

    public Boolean isNodeActive() {
        return this.active;
    }

    public Boolean isProcessed() {
        return this.processed;
    }
}

