/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.codetemplate;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.codetemplate.CodeTemplatePanel;
import com.mirth.connect.client.ui.codetemplate.CodeTemplatePropertiesPanel;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.model.codetemplates.BasicCodeTemplateProperties;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.util.CodeTemplateUtil;
import com.mirth.connect.util.JavaScriptSharedUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;

public class BasicCodeTemplatePropertiesPanel
extends CodeTemplatePropertiesPanel {
    private CodeTemplateProperties.CodeTemplateType type;
    private JLabel templateCodeLabel;
    private JPanel containerPanel;
    private MirthRTextScrollPane templateCodeTextArea;
    private JButton templateAutoGenerateDocumentationButton;

    public BasicCodeTemplatePropertiesPanel(CodeTemplatePanel parent, DocumentListener codeChangeListener) {
        super(parent, codeChangeListener);
        this.initComponents();
        this.initLayout();
    }

    @Override
    public List<Pair<Pair<Component, String>, Pair<Component, String>>> getRows() {
        ArrayList<Pair<Pair<Component, String>, Pair<Component, String>>> rows = new ArrayList<Pair<Pair<Component, String>, Pair<Component, String>>>();
        rows.add((Pair<Pair<Component, String>, Pair<Component, String>>)new ImmutablePair((Object)new ImmutablePair((Object)this.templateCodeLabel, (Object)"newline, top, right"), (Object)new ImmutablePair((Object)this.containerPanel, (Object)"grow, push, sx, w :400, h 127:127")));
        return rows;
    }

    @Override
    public CodeTemplateProperties getProperties() {
        return new BasicCodeTemplateProperties(this.type, this.templateCodeTextArea.getText());
    }

    @Override
    public CodeTemplateProperties getDefaults() {
        return new BasicCodeTemplateProperties(CodeTemplateProperties.CodeTemplateType.FUNCTION, "/**\n\tModify the description here. Modify the function name and parameters as needed. One function per\n\ttemplate is recommended; create a new code template for each new function.\n\n\t@param {String} arg1 - arg1 description\n\t@return {String} return description\n*/\nfunction new_function1(arg1) {\n\t// TODO: Enter code here\n}");
    }

    @Override
    public void setProperties(CodeTemplateProperties properties) {
        this.type = CodeTemplateProperties.CodeTemplateType.fromString((String)properties.getPluginPointName());
        this.templateCodeTextArea.setText(properties.getCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String checkProperties(CodeTemplateProperties properties, boolean highlight) {
        try {
            JavaScriptSharedUtil.getGlobalContextForValidation().compileString("function rhinoWrapper() {" + properties.getCode() + "\n}", UUID.randomUUID().toString(), 1, null);
        }
        catch (EvaluatorException e) {
            String string = "Error on line " + e.lineNumber() + ": " + e.getMessage() + ".";
            return string;
        }
        catch (Exception e) {
            String string = "Unknown error occurred during validation.";
            return string;
        }
        finally {
            Context.exit();
        }
        return null;
    }

    @Override
    public void resetInvalidProperties() {
    }

    @Override
    public void setVisible(boolean visible) {
        this.templateCodeLabel.setVisible(visible);
        this.containerPanel.setVisible(visible);
    }

    private void initComponents() {
        this.containerPanel = new JPanel();
        this.containerPanel.setBackground(UIConstants.BACKGROUND_COLOR);
        this.templateCodeLabel = new JLabel("Code:");
        this.templateCodeTextArea = new MirthRTextScrollPane(ContextType.GLOBAL_DEPLOY);
        this.templateCodeTextArea.getDocument().addDocumentListener(this.codeChangeListener);
        this.templateCodeTextArea.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.codeChanged(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.codeChanged(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.codeChanged(evt);
            }

            private void codeChanged(DocumentEvent evt) {
                try {
                    if (evt.getDocument().getLength() >= 3 && StringUtils.equals((CharSequence)evt.getDocument().getText(0, 3), (CharSequence)"/**")) {
                        BasicCodeTemplatePropertiesPanel.this.templateAutoGenerateDocumentationButton.setText("Update JSDoc");
                    } else {
                        BasicCodeTemplatePropertiesPanel.this.templateAutoGenerateDocumentationButton.setText("Generate JSDoc");
                    }
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.templateAutoGenerateDocumentationButton = new JButton("Update JSDoc");
        this.templateAutoGenerateDocumentationButton.setToolTipText("<html>Generates/updates a JSDoc at the beginning of your<br/>code, with parameter/return annotations as needed.</html>");
        this.templateAutoGenerateDocumentationButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                String currentText = BasicCodeTemplatePropertiesPanel.this.templateCodeTextArea.getText();
                String newText = CodeTemplateUtil.updateCode((String)BasicCodeTemplatePropertiesPanel.this.templateCodeTextArea.getText());
                BasicCodeTemplatePropertiesPanel.this.templateCodeTextArea.setText(newText, false);
                if (!currentText.equals(newText)) {
                    BasicCodeTemplatePropertiesPanel.this.parent.setSaveEnabled(true);
                }
            }
        });
    }

    private void initLayout() {
        this.containerPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.containerPanel.add((Component)((Object)this.templateCodeTextArea), "grow, push");
        this.containerPanel.add((Component)this.templateAutoGenerateDocumentationButton, "newline, right");
    }
}

