/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.codetemplate;

import com.mirth.connect.client.core.ClientException;
import com.mirth.connect.client.ui.AbstractFramePanel;
import com.mirth.connect.client.ui.AbstractSortableTreeTableNode;
import com.mirth.connect.client.ui.Frame;
import com.mirth.connect.client.ui.LoadedExtensions;
import com.mirth.connect.client.ui.Mirth;
import com.mirth.connect.client.ui.OffsetRowSorter;
import com.mirth.connect.client.ui.QueuingSwingWorker;
import com.mirth.connect.client.ui.QueuingSwingWorkerTask;
import com.mirth.connect.client.ui.RefreshTableModel;
import com.mirth.connect.client.ui.SortableTreeTableModel;
import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.codetemplate.BasicCodeTemplatePropertiesPanel;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateImportDialog;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateLibraryTreeTableNode;
import com.mirth.connect.client.ui.codetemplate.CodeTemplatePropertiesPanel;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateRootTreeTableNode;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateTableColumnFactory;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateTreeTableCellEditor;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateTreeTableModel;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateTreeTableNode;
import com.mirth.connect.client.ui.codetemplate.ContextTreeTableCellEditor;
import com.mirth.connect.client.ui.codetemplate.ContextTreeTableCellRenderer;
import com.mirth.connect.client.ui.components.ChannelInfo;
import com.mirth.connect.client.ui.components.ChannelsTableCellEditor;
import com.mirth.connect.client.ui.components.ChannelsTableCellRenderer;
import com.mirth.connect.client.ui.components.MirthTable;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.components.rsta.MirthRTextScrollPane;
import com.mirth.connect.client.ui.reference.ReferenceListFactory;
import com.mirth.connect.model.codetemplates.BasicCodeTemplateProperties;
import com.mirth.connect.model.codetemplates.CodeTemplate;
import com.mirth.connect.model.codetemplates.CodeTemplateContextSet;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrary;
import com.mirth.connect.model.codetemplates.CodeTemplateLibrarySaveResult;
import com.mirth.connect.model.codetemplates.CodeTemplateProperties;
import com.mirth.connect.model.codetemplates.CodeTemplateSummary;
import com.mirth.connect.model.codetemplates.ContextType;
import com.mirth.connect.model.converters.ObjectXMLSerializer;
import com.mirth.connect.plugins.CodeTemplateTypePlugin;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.text.BadLocationException;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.decorator.Highlighter;
import org.jdesktop.swingx.decorator.HighlighterFactory;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.DefaultMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableModel;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class CodeTemplatePanel
extends AbstractFramePanel {
    public static final String OPTION_ONLY_SINGLE_CODE_TEMPLATES = "onlySingleCodeTemplates";
    public static final String OPTION_ONLY_SINGLE_LIBRARIES = "onlySingleLibraries";
    public static final int TEMPLATE_NAME_COLUMN = 0;
    public static final int TEMPLATE_ID_COLUMN = 1;
    public static final int TEMPLATE_TYPE_COLUMN = 2;
    public static final int TEMPLATE_DESCRIPTION_COLUMN = 3;
    public static final int TEMPLATE_REVISION_COLUMN = 4;
    public static final int TEMPLATE_LAST_MODIFIED_COLUMN = 5;
    public static final String NEW_CHANNELS = "[New Channels]";
    static final int TEMPLATE_NUM_COLUMNS = 6;
    private static final int LIBRARY_CHANNELS_NAME_COLUMN = 0;
    private static final int LIBRARY_CHANNELS_ID_COLUMN = 1;
    private static final int TASK_CODE_TEMPLATE_REFRESH = 0;
    private static final int TASK_CODE_TEMPLATE_SAVE = 1;
    private static final int TASK_CODE_TEMPLATE_NEW = 2;
    private static final int TASK_CODE_TEMPLATE_LIBRARY_NEW = 3;
    private static final int TASK_CODE_TEMPLATE_IMPORT = 4;
    private static final int TASK_CODE_TEMPLATE_LIBRARY_IMPORT = 5;
    private static final int TASK_CODE_TEMPLATE_EXPORT = 6;
    private static final int TASK_CODE_TEMPLATE_LIBRARY_EXPORT = 7;
    private static final int TASK_CODE_TEMPLATE_LIBRARY_EXPORT_ALL = 8;
    private static final int TASK_CODE_TEMPLATE_DELETE = 9;
    private static final int TASK_CODE_TEMPLATE_LIBRARY_DELETE = 10;
    private static final int TASK_CODE_TEMPLATE_VALIDATE = 11;
    private Frame parent;
    private Logger logger = LogManager.getLogger(this.getClass());
    private boolean firstLoad = true;
    private Map<String, CodeTemplateLibrary> codeTemplateLibraries = new LinkedHashMap<String, CodeTemplateLibrary>();
    private Map<String, CodeTemplate> codeTemplates = new LinkedHashMap<String, CodeTemplate>();
    private AtomicBoolean libraryComboBoxAdjusting = new AtomicBoolean(false);
    private AtomicBoolean saveAdjusting = new AtomicBoolean(false);
    private AtomicBoolean updateCurrentNode = new AtomicBoolean(true);
    private CodeTemplateTreeTableModel fullModel;
    private int currentSelectedRow = -1;
    private CodeTemplatePropertiesPanel currentPropertiesPanel;
    private CodeChangeWorker codeChangeWorker;
    private List<Pair<Component, Component>> singleLibraryTaskComponents = new ArrayList<Pair<Component, Component>>();
    private List<Pair<Component, Component>> singleCodeTemplateTaskComponents = new ArrayList<Pair<Component, Component>>();
    private JXTaskPane codeTemplateTasks;
    private JPopupMenu codeTemplatePopupMenu;
    private JSplitPane splitPane;
    private JPanel topPanel;
    private MirthTreeTable templateTreeTable;
    private JScrollPane templateTreeTableScrollPane;
    private JLabel templateFilterNotificationLabel;
    private JLabel templateFilterLabel;
    private JTextField templateFilterField;
    private JPanel blankPanel;
    private JPanel libraryPanel;
    private JPanel libraryLeftPanel;
    private JLabel librarySummaryLabel;
    private JLabel librarySummaryValue;
    private JLabel libraryDescriptionLabel;
    private MirthRTextScrollPane libraryDescriptionScrollPane;
    private JPanel libraryRightPanel;
    private JPanel libraryChannelsSelectPanel;
    private JLabel libraryChannelsLabel;
    private JLabel libraryChannelsSelectAllLabel;
    private JLabel libraryChannelsDeselectAllLabel;
    private JLabel libraryChannelsFilterLabel;
    private JTextField libraryChannelsFilterField;
    private MirthTable libraryChannelsTable;
    private JScrollPane libraryChannelsScrollPane;
    private JPanel templatePanel;
    private JScrollPane templateScrollPane;
    private JPanel templateLeftPanel;
    private JLabel templateLibraryLabel;
    private JComboBox<String> templateLibraryComboBox;
    private JLabel templateTypeLabel;
    private JComboBox<String> templateTypeComboBox;
    private BasicCodeTemplatePropertiesPanel basicPropertiesPanel;
    private Map<String, CodeTemplatePropertiesPanel> pluginPropertiesPanelMap;
    private JPanel templateRightPanel;
    private JPanel templateContextSelectPanel;
    private JLabel templateContextLabel;
    private JLabel templateContextSelectAllLabel;
    private JLabel templateContextDeselectAllLabel;
    private MirthTreeTable templateContextTreeTable;
    private JScrollPane templateContextTreeTableScrollPane;

    public CodeTemplatePanel(Frame parent) {
        this.parent = parent;
        this.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.setBackground(UIConstants.BACKGROUND_COLOR);
        this.initComponents();
        this.initToolTips();
        this.initLayout();
        this.codeTemplateTasks = new JXTaskPane();
        this.codeTemplateTasks.setTitle("Code Template Tasks");
        this.codeTemplateTasks.setName("codeTemplate");
        this.codeTemplateTasks.setFocusable(false);
        this.codeTemplatePopupMenu = new JPopupMenu();
        this.templateTreeTableScrollPane.setComponentPopupMenu(this.codeTemplatePopupMenu);
        parent.addTask("doRefreshCodeTemplates", "Refresh", "Refresh the list of code templates.", "", new ImageIcon(Frame.class.getResource("images/arrow_refresh.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doSaveCodeTemplates", "Save Changes", "Save all changes made to all libraries and code templates.", "", new ImageIcon(Frame.class.getResource("images/disk.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doNewCodeTemplate", "New Code Template", "Create a new code template.", "N", new ImageIcon(Frame.class.getResource("images/add.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doNewLibrary", "New Library", "Create a new code template library.", "", new ImageIcon(Frame.class.getResource("images/add.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doImportCodeTemplates", "Import Code Templates", "Import list of code templates from an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doImportLibraries", "Import Libraries", "Import list of code template libraries from an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_go.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doExportCodeTemplate", "Export Code Template", "Export the selected code template to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doExportLibrary", "Export Library", "Export the selected code template library to an XML file.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doExportAllLibraries", "Export All Libraries", "Export all libraries to XML files.", "", new ImageIcon(Frame.class.getResource("images/report_disk.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doDeleteCodeTemplate", "Delete Code Template", "Delete the currently selected code template.", "L", new ImageIcon(Frame.class.getResource("images/delete.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doDeleteLibrary", "Delete Library", "Delete the currently selected code template library.", "", new ImageIcon(Frame.class.getResource("images/delete.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.addTask("doValidateCodeTemplate", "Validate Script", "Validate the currently viewed script.", "", new ImageIcon(Frame.class.getResource("images/accept.png")), this.codeTemplateTasks, this.codeTemplatePopupMenu, this);
        parent.setNonFocusable(this.codeTemplateTasks);
        parent.taskPaneContainer.add((Component)this.codeTemplateTasks, parent.taskPaneContainer.getComponentCount() - 1);
        this.setTaskVisible(0);
        this.setTaskVisible(2);
        this.setTaskVisible(4);
        this.setTaskVisible(3);
        this.setTaskVisible(5);
        this.setTaskVisible(8);
        this.setTaskInvisible(1);
        this.setTaskInvisible(6);
        this.setTaskInvisible(7);
        this.setTaskInvisible(9);
        this.setTaskInvisible(10);
        this.setTaskInvisible(11);
    }

    private void setTaskVisible(int task) {
        this.setTaskVisibility(task, true);
    }

    private void setTaskInvisible(int task) {
        this.setTaskVisibility(task, false);
    }

    private void setTaskVisibility(int task, boolean visible) {
        this.parent.setVisibleTasks(this.codeTemplateTasks, this.codeTemplatePopupMenu, task, task, visible);
    }

    MirthTreeTable getTreeTable() {
        return this.templateTreeTable;
    }

    CodeTemplateTreeTableModel getFullModel() {
        return this.fullModel;
    }

    @Override
    public void switchPanel() {
        Object[][] data = new Object[this.parent.channelPanel.getCachedChannelIdsAndNames().size() + 1][2];
        data[0][0] = new ChannelInfo(NEW_CHANNELS, false);
        data[0][1] = NEW_CHANNELS;
        int row = 1;
        for (Map.Entry<String, String> entry : this.parent.channelPanel.getCachedChannelIdsAndNames().entrySet()) {
            data[row][0] = new ChannelInfo(entry.getValue(), false);
            data[row][1] = entry.getKey();
            ++row;
        }
        ((RefreshTableModel)this.libraryChannelsTable.getModel()).refreshDataVector(data);
        this.doRefreshCodeTemplates();
        this.parent.setBold(this.parent.viewPane, -1);
        this.parent.setPanelName("Code Templates");
        this.parent.setCurrentContentPage(this);
        this.parent.setFocus(this.codeTemplateTasks);
        this.setSaveEnabled(false);
    }

    @Override
    public boolean isSaveEnabled() {
        return this.codeTemplateTasks.getContentPane().getComponent(1).isVisible();
    }

    @Override
    public void setSaveEnabled(boolean enabled) {
        if (!enabled || !this.saveAdjusting.get()) {
            this.setTaskVisibility(1, enabled);
        }
    }

    @Override
    public boolean changesHaveBeenMade() {
        return this.isSaveEnabled();
    }

    @Override
    public void doContextSensitiveSave() {
        if (this.isSaveEnabled()) {
            this.doSaveCodeTemplates();
        }
    }

    @Override
    public boolean confirmLeave() {
        return this.promptSave(false);
    }

    public boolean promptSave(boolean force) {
        this.stopTableEditing();
        int option = force ? JOptionPane.showConfirmDialog((Component)((Object)this.parent), "You must save the code template changes before continuing. Would you like to save now?") : JOptionPane.showConfirmDialog((Component)((Object)this.parent), "Would you like to save the code templates?");
        if (option == 0) {
            CodeTemplateLibrarySaveResult updateSummary = this.doSaveCodeTemplates(false);
            if (updateSummary == null || updateSummary.isOverrideNeeded() || !updateSummary.isLibrariesSuccess()) {
                return false;
            }
            for (CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult result : updateSummary.getCodeTemplateResults().values()) {
                if (result.isSuccess()) continue;
                return false;
            }
        } else if (option == 2 || option == -1 || option == 1 && force) {
            return false;
        }
        return true;
    }

    @Override
    protected Component addAction(Action action, Set<String> options) {
        Component taskComponent = this.codeTemplateTasks.add(action);
        JMenuItem popupComponent = this.codeTemplatePopupMenu.add(action);
        if (options.contains(OPTION_ONLY_SINGLE_LIBRARIES)) {
            this.singleLibraryTaskComponents.add((Pair<Component, Component>)new ImmutablePair((Object)taskComponent, (Object)popupComponent));
        } else if (options.contains(OPTION_ONLY_SINGLE_CODE_TEMPLATES)) {
            this.singleCodeTemplateTaskComponents.add((Pair<Component, Component>)new ImmutablePair((Object)taskComponent, (Object)popupComponent));
        }
        return taskComponent;
    }

    public Map<String, CodeTemplateLibrary> getCachedCodeTemplateLibraries() {
        return this.codeTemplateLibraries;
    }

    public Map<String, CodeTemplate> getCachedCodeTemplates() {
        return this.codeTemplates;
    }

    public String getCurrentSelectedId() {
        TreePath selectedPath;
        int selectedRow = this.templateTreeTable.getSelectedRow();
        if (selectedRow >= 0 && (selectedPath = this.templateTreeTable.getPathForRow(selectedRow)) != null) {
            return (String)((TreeTableNode)selectedPath.getLastPathComponent()).getValueAt(1);
        }
        return null;
    }

    public void doRefreshCodeTemplates() {
        this.doRefreshCodeTemplates(true);
    }

    public void doRefreshCodeTemplates(boolean showMessageOnForbidden) {
        this.doRefreshCodeTemplates(null, showMessageOnForbidden);
    }

    public void doRefreshCodeTemplates(ActionListener actionListener) {
        this.doRefreshCodeTemplates(actionListener, true);
    }

    public void doRefreshCodeTemplates(final ActionListener actionListener, final boolean showMessageOnForbidden) {
        if (this.isSaveEnabled() && !this.confirmLeave()) {
            return;
        }
        final Map<String, Integer> codeTemplateRevisions = this.getCodeTemplateRevisions();
        int selectedRow = this.templateTreeTable.getSelectedRow();
        final TreeTableNode selectedNode = selectedRow >= 0 ? (TreeTableNode)this.templateTreeTable.getPathForRow(selectedRow).getLastPathComponent() : null;
        final Set<String> expandedLibraryIds = this.getExpandedLibraryIds();
        QueuingSwingWorkerTask<Void, Void> task = new QueuingSwingWorkerTask<Void, Void>("doRefreshCodeTemplates", "Loading code templates..."){
            private List<CodeTemplateSummary> codeTemplateSummaries;
            private List<CodeTemplateLibrary> codeTemplateLibraries;

            @Override
            public Void doInBackground() throws ClientException {
                this.codeTemplateSummaries = CodeTemplatePanel.this.parent.mirthClient.getCodeTemplateSummary(codeTemplateRevisions);
                this.codeTemplateLibraries = CodeTemplatePanel.this.parent.mirthClient.getCodeTemplateLibraries(null, false);
                return null;
            }

            @Override
            public void done() {
                try {
                    this.get();
                    for (CodeTemplateSummary codeTemplateSummary : this.codeTemplateSummaries) {
                        String codeTemplateId = codeTemplateSummary.getCodeTemplateId();
                        if (codeTemplateSummary.isDeleted()) {
                            CodeTemplatePanel.this.codeTemplates.remove(codeTemplateId);
                            continue;
                        }
                        CodeTemplatePanel.this.codeTemplates.put(codeTemplateId, codeTemplateSummary.getCodeTemplate());
                    }
                    HashSet<String> assignedCodeTemplateIds = new HashSet<String>();
                    ArrayList<String> libraryNames = new ArrayList<String>();
                    CodeTemplatePanel.this.codeTemplateLibraries.clear();
                    for (CodeTemplateLibrary library : this.codeTemplateLibraries) {
                        CodeTemplatePanel.this.codeTemplateLibraries.put(library.getId(), library);
                        for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                            assignedCodeTemplateIds.add(codeTemplate.getId());
                        }
                        libraryNames.add(library.getName());
                    }
                    ReferenceListFactory.getInstance().updateUserCodeTemplates();
                    CodeTemplatePanel.this.saveAdjusting.set(true);
                    CodeTemplatePanel.this.updateCurrentNode.set(false);
                    CodeTemplatePanel.this.updateTasks();
                    final TreePath selectedPath = CodeTemplatePanel.this.updateCodeTemplateTable(selectedNode);
                    CodeTemplatePanel.this.updateLibrariesComboBox();
                    CodeTemplatePanel.this.setSaveEnabled(false);
                    if (selectedNode != null && !CodeTemplatePanel.this.codeTemplates.containsKey((String)selectedNode.getValueAt(1))) {
                        CodeTemplatePanel.this.switchSplitPaneComponent(CodeTemplatePanel.this.blankPanel);
                    }
                    if (CodeTemplatePanel.this.firstLoad) {
                        CodeTemplatePanel.this.templateTreeTable.expandAll();
                        CodeTemplatePanel.this.firstLoad = false;
                    } else {
                        CodeTemplatePanel.this.expandLibraryNodes(expandedLibraryIds);
                    }
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (selectedPath != null) {
                                CodeTemplatePanel.this.selectTemplatePath(selectedPath);
                            }
                            CodeTemplatePanel.this.saveAdjusting.set(false);
                            CodeTemplatePanel.this.updateCurrentNode.set(true);
                        }
                    });
                }
                catch (Exception e) {
                    Throwable cause = e;
                    if (cause instanceof ExecutionException) {
                        cause = e.getCause();
                    }
                    CodeTemplatePanel.this.parent.alertThrowable((Component)((Object)CodeTemplatePanel.this.parent), e.getCause(), showMessageOnForbidden);
                }
                if (actionListener != null) {
                    actionListener.actionPerformed(null);
                }
            }
        };
        new QueuingSwingWorker<Void, Void>(task, false).executeDelegate();
    }

    private Set<String> getExpandedLibraryIds() {
        HashSet<String> expandedLibraryIds = new HashSet<String>();
        Enumeration libraryNodes = ((TreeTableNode)this.templateTreeTable.getTreeTableModel().getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            TreeTableNode libraryNode = (TreeTableNode)libraryNodes.nextElement();
            if (!this.templateTreeTable.isExpanded(new TreePath(((CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel()).getPathToRoot(libraryNode)))) continue;
            expandedLibraryIds.add((String)libraryNode.getValueAt(1));
        }
        return expandedLibraryIds;
    }

    private void expandLibraryNodes(Set<String> expandedLibraryIds) {
        if (expandedLibraryIds != null) {
            Enumeration libraryNodes = ((TreeTableNode)this.templateTreeTable.getTreeTableModel().getRoot()).children();
            while (libraryNodes.hasMoreElements()) {
                TreeTableNode libraryNode = (TreeTableNode)libraryNodes.nextElement();
                if (!expandedLibraryIds.contains((String)libraryNode.getValueAt(1))) continue;
                this.templateTreeTable.expandPath(new TreePath(((CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel()).getPathToRoot(libraryNode)));
            }
        }
    }

    private Map<String, Integer> getCodeTemplateRevisions() {
        HashMap<String, Integer> codeTemplateRevisions = new HashMap<String, Integer>();
        for (CodeTemplate codeTemplate : this.codeTemplates.values()) {
            codeTemplateRevisions.put(codeTemplate.getId(), codeTemplate.getRevision());
        }
        return codeTemplateRevisions;
    }

    private TreePath updateCodeTemplateTable(TreeTableNode selectedNode) {
        CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
        CodeTemplateRootTreeTableNode root = new CodeTemplateRootTreeTableNode();
        for (CodeTemplateLibrary library : this.codeTemplateLibraries.values()) {
            this.addLibraryNode(root, library);
        }
        this.fullModel.setRoot((TreeTableNode)root);
        this.fullModel.sort();
        if (StringUtils.isNotBlank((CharSequence)this.templateFilterField.getText())) {
            root = this.getFilteredRootNode(root);
        }
        model.setRoot((TreeTableNode)root);
        model.sort();
        this.updateFilterNotification();
        return this.selectPathFromNodeId(selectedNode, root);
    }

    private TreePath selectPathFromNodeId(TreeTableNode selectedNode, CodeTemplateRootTreeTableNode root) {
        TreePath selectedPath = null;
        if (selectedNode != null) {
            CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
            Enumeration libraries = root.children();
            while (libraries.hasMoreElements()) {
                CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)((Object)libraries.nextElement());
                if (selectedNode instanceof CodeTemplateLibraryTreeTableNode && ((CodeTemplateLibraryTreeTableNode)selectedNode).getLibraryId().equals(libraryNode.getLibraryId())) {
                    selectedPath = new TreePath(model.getPathToRoot((TreeTableNode)libraryNode));
                    break;
                }
                Enumeration codeTemplates = libraryNode.children();
                while (codeTemplates.hasMoreElements()) {
                    CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplates.nextElement());
                    if (!(selectedNode instanceof CodeTemplateTreeTableNode) || !((CodeTemplateTreeTableNode)selectedNode).getCodeTemplateId().equals(codeTemplateNode.getCodeTemplateId())) continue;
                    selectedPath = new TreePath(model.getPathToRoot((TreeTableNode)codeTemplateNode));
                    break;
                }
                if (selectedPath == null) continue;
                break;
            }
            if (selectedPath != null) {
                this.selectTemplatePath(selectedPath);
            }
        }
        return selectedPath;
    }

    private CodeTemplateLibraryTreeTableNode addLibraryNode(AbstractMutableTreeTableNode root, CodeTemplateLibrary library) {
        CodeTemplateLibraryTreeTableNode libraryNode = new CodeTemplateLibraryTreeTableNode(library);
        for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
            CodeTemplate cachedCodeTemplate = this.codeTemplates.get(codeTemplate.getId());
            if (cachedCodeTemplate == null) continue;
            libraryNode.add((MutableTreeTableNode)new CodeTemplateTreeTableNode(cachedCodeTemplate));
        }
        root.add((MutableTreeTableNode)libraryNode);
        return libraryNode;
    }

    private CodeTemplateRootTreeTableNode getFilteredRootNode(CodeTemplateRootTreeTableNode root) {
        CodeTemplateRootTreeTableNode newRoot = new CodeTemplateRootTreeTableNode();
        String filter = StringUtils.trim((String)this.templateFilterField.getText());
        Enumeration libraryNodes = root.children();
        while (libraryNodes.hasMoreElements()) {
            CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)((Object)libraryNodes.nextElement());
            CodeTemplateLibraryTreeTableNode newLibraryNode = new CodeTemplateLibraryTreeTableNode(libraryNode.getLibrary());
            Enumeration codeTemplateNodes = libraryNode.children();
            while (codeTemplateNodes.hasMoreElements()) {
                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                if (!StringUtils.containsIgnoreCase((CharSequence)((String)codeTemplateNode.getValueAt(0)), (CharSequence)filter)) continue;
                CodeTemplateTreeTableNode newCodeTemplateNode = new CodeTemplateTreeTableNode(codeTemplateNode.getCodeTemplate());
                newLibraryNode.add((MutableTreeTableNode)newCodeTemplateNode);
            }
            if (newLibraryNode.getChildCount() <= 0 && !StringUtils.containsIgnoreCase((CharSequence)((String)libraryNode.getValueAt(0)), (CharSequence)filter)) continue;
            newRoot.add((MutableTreeTableNode)newLibraryNode);
        }
        return newRoot;
    }

    public void doSaveCodeTemplates() {
        this.doSaveCodeTemplates(true);
    }

    private CodeTemplateLibrarySaveResult doSaveCodeTemplates(boolean asynchronous) {
        this.stopTableEditing();
        this.updateCurrentNode();
        if (!this.validateAll()) {
            return null;
        }
        LinkedHashMap<String, CodeTemplateLibrary> codeTemplateLibraries = new LinkedHashMap<String, CodeTemplateLibrary>();
        LinkedHashMap<String, CodeTemplateLibrary> removedCodeTemplateLibraries = new LinkedHashMap<String, CodeTemplateLibrary>();
        LinkedHashMap<String, CodeTemplate> updatedCodeTemplates = new LinkedHashMap<String, CodeTemplate>();
        LinkedHashMap<String, CodeTemplate> removedCodeTemplates = new LinkedHashMap<String, CodeTemplate>(this.codeTemplates);
        Enumeration libraryNodes = ((AbstractSortableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)((Object)libraryNodes.nextElement());
            CodeTemplateLibrary library = libraryNode.getLibrary();
            ArrayList<CodeTemplate> libraryTemplates = new ArrayList<CodeTemplate>();
            Enumeration codeTemplateNodes = libraryNode.children();
            while (codeTemplateNodes.hasMoreElements()) {
                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                CodeTemplate codeTemplate = codeTemplateNode.getCodeTemplate();
                if (!this.codeTemplates.containsKey(codeTemplate.getId()) || !codeTemplate.equals((Object)this.codeTemplates.get(codeTemplate.getId()))) {
                    updatedCodeTemplates.put(codeTemplate.getId(), codeTemplate);
                }
                removedCodeTemplates.remove(codeTemplate.getId());
                libraryTemplates.add(new CodeTemplate(codeTemplate.getId()));
            }
            library.setCodeTemplates(libraryTemplates);
            codeTemplateLibraries.put(library.getId(), library);
        }
        for (CodeTemplateLibrary library : this.codeTemplateLibraries.values()) {
            if (codeTemplateLibraries.containsKey(library.getId())) continue;
            removedCodeTemplateLibraries.put(library.getId(), library);
        }
        int selectedRow = this.templateTreeTable.getSelectedRow();
        TreeTableNode selectedNode = selectedRow >= 0 ? (TreeTableNode)this.templateTreeTable.getPathForRow(selectedRow).getLastPathComponent() : null;
        Set<String> expandedLibraryIds = this.getExpandedLibraryIds();
        if (asynchronous) {
            new UpdateSwingWorker(codeTemplateLibraries, removedCodeTemplateLibraries, updatedCodeTemplates, removedCodeTemplates, false, selectedNode, expandedLibraryIds).execute();
            return null;
        }
        return this.attemptUpdate(codeTemplateLibraries, removedCodeTemplateLibraries, updatedCodeTemplates, removedCodeTemplates, false, selectedNode, expandedLibraryIds);
    }

    public CodeTemplateLibrarySaveResult attemptUpdate(Map<String, CodeTemplateLibrary> libraries, Map<String, CodeTemplateLibrary> removedLibraries, Map<String, CodeTemplate> updatedCodeTemplates, Map<String, CodeTemplate> removedCodeTemplates, boolean override, TreeTableNode selectedNode, Set<String> expandedLibraryIds) {
        CodeTemplateLibrarySaveResult updateSummary = null;
        boolean tryAgain = false;
        try {
            updateSummary = this.updateLibrariesAndTemplates(libraries, removedLibraries, updatedCodeTemplates, removedCodeTemplates, override);
            if (updateSummary.isOverrideNeeded()) {
                if (!override) {
                    if (this.parent.alertOption((Component)((Object)this.parent), "One or more code templates or libraries have been modified since you last refreshed.\nDo you want to overwrite the changes?")) {
                        tryAgain = true;
                    }
                } else {
                    this.parent.alertError((Component)((Object)this.parent), "Unable to save code templates or libraries.");
                }
            } else {
                this.handleUpdateSummary(libraries, updatedCodeTemplates, removedCodeTemplates, override, selectedNode, expandedLibraryIds, updateSummary);
            }
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof ExecutionException) {
                cause = e.getCause();
            }
            this.parent.alertThrowable((Component)((Object)this.parent), cause, "Unable to save code templates or libraries: " + cause.getMessage());
        }
        if (tryAgain && !override) {
            return this.attemptUpdate(libraries, removedLibraries, updatedCodeTemplates, removedCodeTemplates, true, selectedNode, expandedLibraryIds);
        }
        return updateSummary;
    }

    private CodeTemplateLibrarySaveResult updateLibrariesAndTemplates(Map<String, CodeTemplateLibrary> libraries, Map<String, CodeTemplateLibrary> removedLibraries, Map<String, CodeTemplate> updatedCodeTemplates, Map<String, CodeTemplate> removedCodeTemplates, boolean override) throws Exception {
        return this.parent.mirthClient.updateLibrariesAndTemplates(new ArrayList<CodeTemplateLibrary>(libraries.values()), new HashSet<String>(removedLibraries.keySet()), new ArrayList<CodeTemplate>(updatedCodeTemplates.values()), new HashSet<String>(removedCodeTemplates.keySet()), override);
    }

    private void handleUpdateSummary(Map<String, CodeTemplateLibrary> libraries, Map<String, CodeTemplate> updatedCodeTemplates, Map<String, CodeTemplate> removedCodeTemplates, boolean override, TreeTableNode selectedNode, Set<String> expandedLibraryIds, CodeTemplateLibrarySaveResult updateSummary) {
        try {
            if (!updateSummary.isOverrideNeeded()) {
                if (updateSummary.isLibrariesSuccess()) {
                    HashSet<String> assignedCodeTemplateIds = new HashSet<String>();
                    ArrayList<String> libraryNames = new ArrayList<String>();
                    this.codeTemplateLibraries.clear();
                    for (CodeTemplateLibrary library : libraries.values()) {
                        CodeTemplateLibrarySaveResult.LibraryUpdateResult result = (CodeTemplateLibrarySaveResult.LibraryUpdateResult)updateSummary.getLibraryResults().get(library.getId());
                        library.setRevision(Integer.valueOf(result.getNewRevision()));
                        library.setLastModified(result.getNewLastModified());
                        this.codeTemplateLibraries.put(library.getId(), library);
                        for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                            assignedCodeTemplateIds.add(codeTemplate.getId());
                        }
                        libraryNames.add(library.getName());
                    }
                    int numFailed = 0;
                    Throwable firstCause = null;
                    HashSet<String> successfulIds = new HashSet<String>();
                    for (Map.Entry entry : updateSummary.getCodeTemplateResults().entrySet()) {
                        String codeTemplateId = (String)entry.getKey();
                        CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult result = (CodeTemplateLibrarySaveResult.CodeTemplateUpdateResult)entry.getValue();
                        if (result.isSuccess()) {
                            CodeTemplate updatedCodeTemplate = updatedCodeTemplates.get(codeTemplateId);
                            if (updatedCodeTemplate != null) {
                                updatedCodeTemplate.setRevision(Integer.valueOf(result.getNewRevision()));
                                updatedCodeTemplate.setLastModified(result.getNewLastModified());
                                this.codeTemplates.put(codeTemplateId, updatedCodeTemplate);
                            } else {
                                this.codeTemplates.remove(codeTemplateId);
                            }
                            successfulIds.add(codeTemplateId);
                            continue;
                        }
                        ++numFailed;
                        if (firstCause != null || result.getCause() == null) continue;
                        firstCause = result.getCause();
                    }
                    CodeTemplateRootTreeTableNode root = new CodeTemplateRootTreeTableNode();
                    for (CodeTemplateLibrary library : this.codeTemplateLibraries.values()) {
                        CodeTemplateLibraryTreeTableNode libraryNode = new CodeTemplateLibraryTreeTableNode(library);
                        for (CodeTemplate codeTemplate : library.getCodeTemplates()) {
                            String codeTemplateId = codeTemplate.getId();
                            if (successfulIds.contains(codeTemplateId)) {
                                if (!updatedCodeTemplates.containsKey(codeTemplateId)) continue;
                                CodeTemplateTreeTableNode newCodeTemplateNode = new CodeTemplateTreeTableNode(this.codeTemplates.get(codeTemplate.getId()));
                                libraryNode.add((MutableTreeTableNode)newCodeTemplateNode);
                                continue;
                            }
                            CodeTemplateTreeTableNode codeTemplateNode = this.getCodeTemplateNodeById(codeTemplateId);
                            if (codeTemplateNode == null) continue;
                            CodeTemplateTreeTableNode newCodeTemplateNode = new CodeTemplateTreeTableNode(codeTemplateNode.getCodeTemplate());
                            libraryNode.add((MutableTreeTableNode)newCodeTemplateNode);
                        }
                        root.add((MutableTreeTableNode)libraryNode);
                    }
                    CodeTemplateTreeTableModel codeTemplateTreeTableModel = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
                    this.updateCurrentNode.set(false);
                    this.fullModel.setRoot((TreeTableNode)root);
                    this.fullModel.sort();
                    if (StringUtils.isNotBlank((CharSequence)this.templateFilterField.getText())) {
                        root = this.getFilteredRootNode(root);
                    }
                    codeTemplateTreeTableModel.setRoot((TreeTableNode)root);
                    codeTemplateTreeTableModel.sort();
                    this.updateFilterNotification();
                    this.saveAdjusting.set(true);
                    ReferenceListFactory.getInstance().updateUserCodeTemplates();
                    this.updateTasks();
                    this.updateLibrariesComboBox();
                    this.expandLibraryNodes(expandedLibraryIds);
                    TreePath selectedPath = null;
                    if (selectedNode != null) {
                        Enumeration libraryNodes = root.children();
                        while (libraryNodes.hasMoreElements()) {
                            CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)((Object)libraryNodes.nextElement());
                            if (selectedNode instanceof CodeTemplateLibraryTreeTableNode && ((CodeTemplateLibraryTreeTableNode)selectedNode).getLibraryId().equals(libraryNode.getLibraryId())) {
                                selectedPath = new TreePath(codeTemplateTreeTableModel.getPathToRoot((TreeTableNode)libraryNode));
                                break;
                            }
                            Enumeration codeTemplates = libraryNode.children();
                            while (codeTemplates.hasMoreElements()) {
                                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplates.nextElement());
                                if (!(selectedNode instanceof CodeTemplateTreeTableNode) || !((CodeTemplateTreeTableNode)selectedNode).getCodeTemplateId().equals(codeTemplateNode.getCodeTemplateId())) continue;
                                selectedPath = new TreePath(codeTemplateTreeTableModel.getPathToRoot((TreeTableNode)codeTemplateNode));
                                break;
                            }
                            if (selectedPath == null) continue;
                            break;
                        }
                        if (selectedPath != null) {
                            this.selectTemplatePath(selectedPath);
                        }
                    }
                    if (numFailed > 0) {
                        if (firstCause != null) {
                            this.parent.alertThrowable((Component)((Object)this.parent), firstCause, numFailed + " code templates failed to be updated or removed. First cause: " + firstCause.getMessage());
                        } else {
                            this.parent.alertError((Component)((Object)this.parent), numFailed + " code templates failed to be updated or removed.");
                        }
                    } else {
                        this.setSaveEnabled(false);
                        if (this.currentPropertiesPanel != null) {
                            this.currentPropertiesPanel.resetInvalidProperties();
                        }
                    }
                    final TreePath finalPath = selectedPath;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            if (finalPath != null) {
                                CodeTemplatePanel.this.selectTemplatePath(finalPath);
                            }
                            CodeTemplatePanel.this.saveAdjusting.set(false);
                            CodeTemplatePanel.this.updateCurrentNode.set(true);
                        }
                    });
                } else if (updateSummary.getLibrariesCause() != null) {
                    this.parent.alertThrowable((Component)((Object)this.parent), updateSummary.getLibrariesCause(), "Unable to save code template libraries: " + updateSummary.getLibrariesCause().getMessage());
                } else {
                    this.parent.alertError((Component)((Object)this.parent), "Unable to save code template libraries.");
                }
            }
        }
        catch (Exception e) {
            Throwable cause = e;
            if (cause instanceof ExecutionException) {
                cause = e.getCause();
            }
            this.parent.alertThrowable((Component)((Object)this.parent), cause, "Unable to save code templates or libraries: " + cause.getMessage());
        }
    }

    public UpdateSwingWorker getSwingWorker(Map<String, CodeTemplateLibrary> libraries, Map<String, CodeTemplateLibrary> removedLibraries, Map<String, CodeTemplate> updatedCodeTemplates, Map<String, CodeTemplate> removedCodeTemplates, boolean override) {
        return new UpdateSwingWorker(libraries, removedLibraries, updatedCodeTemplates, removedCodeTemplates, override, null, null);
    }

    private CodeTemplateTreeTableNode getCodeTemplateNodeById(String codeTemplateId) {
        Enumeration libraryNodes = ((AbstractSortableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            Enumeration codeTemplateNodes = ((MutableTreeTableNode)libraryNodes.nextElement()).children();
            while (codeTemplateNodes.hasMoreElements()) {
                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                if (!codeTemplateNode.getCodeTemplateId().equals(codeTemplateId)) continue;
                return codeTemplateNode;
            }
        }
        return null;
    }

    private AbstractSortableTreeTableNode findFullNode(AbstractSortableTreeTableNode node) {
        String id = (String)node.getValueAt(1);
        Enumeration libraryNodes = ((AbstractSortableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)((Object)libraryNodes.nextElement());
            if (id.equals(libraryNode.getValueAt(1))) {
                return libraryNode;
            }
            Enumeration codeTemplateNodes = libraryNode.children();
            while (codeTemplateNodes.hasMoreElements()) {
                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                if (!id.equals(codeTemplateNode.getValueAt(1))) continue;
                return codeTemplateNode;
            }
        }
        return null;
    }

    public void doNewCodeTemplate() {
        String name;
        AbstractSortableTreeTableNode parentNode;
        this.stopTableEditing();
        this.updateCurrentNode();
        this.updateCurrentNode.set(false);
        this.setSaveEnabled(true);
        int selectedRow = this.templateTreeTable.getSelectedRow();
        if (selectedRow >= 0) {
            parentNode = (AbstractSortableTreeTableNode)((Object)this.templateTreeTable.getPathForRow(selectedRow).getLastPathComponent());
            if (parentNode instanceof CodeTemplateTreeTableNode) {
                parentNode = (AbstractSortableTreeTableNode)parentNode.getParent();
            }
        } else {
            return;
        }
        int index = 1;
        while (!this.checkCodeTemplateName(name = "Template " + index++)) {
        }
        CodeTemplate codeTemplate = CodeTemplate.getDefaultCodeTemplate((String)name);
        CodeTemplateTreeTableNode codeTemplateNode = new CodeTemplateTreeTableNode(codeTemplate);
        CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
        model.insertNodeInto((MutableTreeTableNode)codeTemplateNode, (MutableTreeTableNode)parentNode);
        if (model.getRoot() != this.fullModel.getRoot()) {
            this.fullModel.insertNodeInto((MutableTreeTableNode)new CodeTemplateTreeTableNode(codeTemplate), (MutableTreeTableNode)this.findFullNode(parentNode));
        }
        TreePath selectedPath = new TreePath(model.getPathToRoot((TreeTableNode)codeTemplateNode));
        this.selectTemplatePath(selectedPath);
        this.updateFilterNotification();
        this.updateCurrentNode.set(true);
    }

    public void doNewLibrary() {
        String name;
        this.stopTableEditing();
        this.updateCurrentNode();
        this.updateCurrentNode.set(false);
        this.setSaveEnabled(true);
        int index = 1;
        while (!this.checkLibraryName(name = "Library " + index++)) {
        }
        CodeTemplateLibrary library = new CodeTemplateLibrary();
        library.setName(name);
        CodeTemplateLibraryTreeTableNode libraryNode = new CodeTemplateLibraryTreeTableNode(library);
        CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
        model.insertNodeInto((MutableTreeTableNode)libraryNode, (MutableTreeTableNode)((AbstractSortableTreeTableNode)model.getRoot()));
        if (model.getRoot() != this.fullModel.getRoot()) {
            this.fullModel.insertNodeInto((MutableTreeTableNode)new CodeTemplateLibraryTreeTableNode(library), (MutableTreeTableNode)((AbstractSortableTreeTableNode)this.fullModel.getRoot()));
        }
        final TreePath selectedPath = new TreePath(model.getPathToRoot((TreeTableNode)libraryNode));
        this.selectTemplatePath(selectedPath);
        this.updateLibrariesComboBox();
        this.updateFilterNotification();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeTemplatePanel.this.selectTemplatePath(selectedPath);
                CodeTemplatePanel.this.updateCurrentNode.set(true);
            }
        });
    }

    private boolean checkLibraryName(String name) {
        Enumeration libraries = ((AbstractSortableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraries.hasMoreElements()) {
            if (!((CodeTemplateLibraryTreeTableNode)((Object)libraries.nextElement())).getLibrary().getName().equals(name)) continue;
            return false;
        }
        return true;
    }

    private boolean checkCodeTemplateName(String name) {
        Enumeration libraries = ((AbstractSortableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraries.hasMoreElements()) {
            Enumeration codeTemplates = ((MutableTreeTableNode)libraries.nextElement()).children();
            while (codeTemplates.hasMoreElements()) {
                if (!((CodeTemplateTreeTableNode)((Object)codeTemplates.nextElement())).getCodeTemplate().getName().equals(name)) continue;
                return false;
            }
        }
        return true;
    }

    public void doImportCodeTemplates() {
        List importCodeTemplates;
        this.stopTableEditing();
        this.updateCurrentNode();
        if (this.changesHaveBeenMade() && !this.promptSave(true)) {
            return;
        }
        if (this.codeTemplateLibraries.size() == 0) {
            this.parent.alertError((Component)((Object)this.parent), "Cannot import code templates without an existing library.");
            return;
        }
        String content = this.parent.browseForFileString("XML");
        if (content == null) {
            return;
        }
        try {
            importCodeTemplates = ObjectXMLSerializer.getInstance().deserializeList(content, CodeTemplate.class);
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)this, (Throwable)e, "Invalid code template file: " + e.getMessage());
            return;
        }
        this.parent.removeInvalidItems(importCodeTemplates, CodeTemplate.class);
        if (CollectionUtils.isEmpty((Collection)importCodeTemplates)) {
            this.parent.alertError((Component)((Object)this.parent), "No code templates found in the file.");
            return;
        }
        CodeTemplateLibrary unassignedLibrary = new CodeTemplateLibrary();
        unassignedLibrary.setCodeTemplates(importCodeTemplates);
        this.showImportDialog(Collections.singletonList(unassignedLibrary), true);
    }

    public void doImportLibraries() {
        List importLibraries;
        this.stopTableEditing();
        this.updateCurrentNode();
        if (this.changesHaveBeenMade() && !this.promptSave(true)) {
            return;
        }
        String content = this.parent.browseForFileString("XML");
        if (content == null) {
            return;
        }
        try {
            importLibraries = ObjectXMLSerializer.getInstance().deserializeList(content, CodeTemplateLibrary.class);
        }
        catch (Exception e) {
            this.parent.alertThrowable((Component)this, (Throwable)e, "Invalid code template library file: " + e.getMessage());
            return;
        }
        this.parent.removeInvalidItems(importLibraries, CodeTemplateLibrary.class);
        if (CollectionUtils.isEmpty((Collection)importLibraries)) {
            this.parent.alertError((Component)((Object)this.parent), "No code template libraries found in the file.");
            return;
        }
        this.showImportDialog(importLibraries, false);
    }

    private void showImportDialog(List<CodeTemplateLibrary> importLibraries, boolean unassignedCodeTemplates) {
        CodeTemplateImportDialog dialog = new CodeTemplateImportDialog((java.awt.Frame)((Object)this.parent), importLibraries, unassignedCodeTemplates);
        if (dialog.wasSaved()) {
            int selectedRow = this.templateTreeTable.getSelectedRow();
            TreeTableNode selectedNode = selectedRow >= 0 ? (TreeTableNode)this.templateTreeTable.getPathForRow(selectedRow).getLastPathComponent() : null;
            new UpdateSwingWorker(dialog.getUpdatedLibraries(), new HashMap<String, CodeTemplateLibrary>(), dialog.getUpdatedCodeTemplates(), new HashMap<String, CodeTemplate>(), true, selectedNode, this.getExpandedLibraryIds()).execute();
            this.doRefreshCodeTemplates();
        }
    }

    public void doExportCodeTemplate() {
        this.stopTableEditing();
        this.updateCurrentNode();
        if (this.changesHaveBeenMade() && !this.promptSave(true)) {
            return;
        }
        TreePath selectedPath = this.templateTreeTable.getTreeSelectionModel().getSelectionPath();
        if (selectedPath != null) {
            CodeTemplate codeTemplate = ((CodeTemplateTreeTableNode)((Object)selectedPath.getLastPathComponent())).getCodeTemplate();
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            try {
                String codeTemplateXML = serializer.serialize((Object)codeTemplate);
                this.parent.exportFile(codeTemplateXML, codeTemplate.getName() + ".xml", "XML", "Code template export");
            }
            catch (Throwable t) {
                this.parent.alertThrowable((Component)((Object)this.parent), t, "Unable to export: " + t.getMessage());
            }
        }
    }

    public void doExportLibrary() {
        this.stopTableEditing();
        this.updateCurrentNode();
        if (this.changesHaveBeenMade() && !this.promptSave(true)) {
            return;
        }
        TreePath selectedPath = this.templateTreeTable.getTreeSelectionModel().getSelectionPath();
        if (selectedPath != null) {
            CodeTemplateLibrary library = this.getLibraryWithTemplates((CodeTemplateLibraryTreeTableNode)((Object)selectedPath.getLastPathComponent()));
            ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
            try {
                String libraryXml = serializer.serialize((Object)library);
                this.parent.exportFile(libraryXml, library.getName() + ".xml", "XML", "Code template library export");
            }
            catch (Throwable t) {
                this.parent.alertThrowable((Component)((Object)this.parent), t, "Unable to export: " + t.getMessage());
            }
        }
    }

    public void doExportAllLibraries() {
        this.stopTableEditing();
        this.updateCurrentNode();
        if (this.changesHaveBeenMade() && !this.promptSave(true)) {
            return;
        }
        ArrayList<CodeTemplateLibrary> libraries = new ArrayList<CodeTemplateLibrary>();
        Enumeration libraryNodes = ((AbstractSortableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            libraries.add(this.getLibraryWithTemplates((CodeTemplateLibraryTreeTableNode)((Object)libraryNodes.nextElement())));
        }
        ObjectXMLSerializer serializer = ObjectXMLSerializer.getInstance();
        try {
            String librariesXml = serializer.serialize(libraries);
            this.parent.exportFile(librariesXml, null, "XML", "Code template libraries export");
        }
        catch (Throwable t) {
            this.parent.alertThrowable((Component)((Object)this.parent), t, "Unable to export: " + t.getMessage());
        }
    }

    private CodeTemplateLibrary getLibraryWithTemplates(CodeTemplateLibraryTreeTableNode libraryNode) {
        CodeTemplateLibrary library = new CodeTemplateLibrary(libraryNode.getLibrary());
        ArrayList<CodeTemplate> codeTemplates = new ArrayList<CodeTemplate>();
        Enumeration codeTemplateNodes = this.findFullNode(libraryNode).children();
        while (codeTemplateNodes.hasMoreElements()) {
            codeTemplates.add(new CodeTemplate(((CodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement())).getCodeTemplate()));
        }
        library.setCodeTemplates(codeTemplates);
        return library;
    }

    public void doDeleteCodeTemplate() {
        this.deleteSelectedNode(true);
    }

    public void doDeleteLibrary() {
        this.deleteSelectedNode(false);
        this.updateLibrariesComboBox();
    }

    private void deleteSelectedNode(boolean codeTemplate) {
        this.stopTableEditing();
        this.setSaveEnabled(true);
        TreePath selectedPath = this.templateTreeTable.getTreeSelectionModel().getSelectionPath();
        if (selectedPath != null) {
            CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
            MutableTreeTableNode selectedNode = (MutableTreeTableNode)selectedPath.getLastPathComponent();
            MutableTreeTableNode parent = (MutableTreeTableNode)selectedNode.getParent();
            int selectedNodeIndex = parent.getIndex((TreeNode)selectedNode);
            MutableTreeTableNode newSelectedNode = null;
            if (!codeTemplate && selectedNode.getChildCount() > 0) {
                if (!this.parent.alertOkCancel((Component)((Object)this.parent), "The selected library contains " + selectedNode.getChildCount() + " code templates. If you delete the library, the code templates will be deleted as well. Are you sure you wish to continue?")) {
                    return;
                }
                for (MutableTreeTableNode codeTemplateNode : Collections.list(selectedNode.children())) {
                    model.removeNodeFromParent(codeTemplateNode);
                    if (model.getRoot() == this.fullModel.getRoot()) continue;
                    AbstractSortableTreeTableNode fullCodeTemplateNode = this.findFullNode((AbstractSortableTreeTableNode)codeTemplateNode);
                    this.fullModel.removeNodeFromParent((MutableTreeTableNode)fullCodeTemplateNode);
                }
            }
            this.updateCurrentNode.set(false);
            selectedNode = (MutableTreeTableNode)selectedPath.getLastPathComponent();
            model.removeNodeFromParent(selectedNode);
            if (model.getRoot() != this.fullModel.getRoot()) {
                this.fullModel.removeNodeFromParent((MutableTreeTableNode)this.findFullNode((AbstractSortableTreeTableNode)selectedNode));
            }
            if (selectedNodeIndex < parent.getChildCount()) {
                newSelectedNode = (MutableTreeTableNode)parent.getChildAt(selectedNodeIndex);
            } else if (parent.getChildCount() > 0) {
                newSelectedNode = (MutableTreeTableNode)parent.getChildAt(parent.getChildCount() - 1);
            } else if (codeTemplate) {
                newSelectedNode = parent;
            }
            if (newSelectedNode != null) {
                final TreePath newSelectedPath = new TreePath(((CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel()).getPathToRoot((TreeTableNode)newSelectedNode));
                this.selectTemplatePath(newSelectedPath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeTemplatePanel.this.selectTemplatePath(newSelectedPath);
                        CodeTemplatePanel.this.updateCurrentNode.set(true);
                    }
                });
            } else {
                this.switchSplitPaneComponent(this.blankPanel);
                this.updateCurrentNode.set(true);
            }
            this.updateFilterNotification();
        }
    }

    public void doValidateCodeTemplate() {
        this.doValidateCodeTemplate(true);
    }

    private boolean doValidateCodeTemplate(boolean showSuccessMessage) {
        this.stopTableEditing();
        String validationMessage = this.currentPropertiesPanel.checkProperties(this.currentPropertiesPanel.getProperties(), true);
        if (validationMessage == null) {
            if (showSuccessMessage) {
                this.parent.alertInformation(this, "Validation successful.");
            }
            return true;
        }
        this.parent.alertInformation(this, validationMessage);
        return false;
    }

    private boolean validateAll() {
        this.stopTableEditing();
        this.updateCurrentNode();
        Enumeration libraryNodes = ((AbstractSortableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)((Object)libraryNodes.nextElement());
            CodeTemplateLibrary library = libraryNode.getLibrary();
            Enumeration codeTemplateNodes = libraryNode.children();
            while (codeTemplateNodes.hasMoreElements()) {
                Object validationMessage;
                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplateNodes.nextElement());
                CodeTemplate codeTemplate = codeTemplateNode.getCodeTemplate();
                CodeTemplateProperties properties = codeTemplate.getProperties();
                CodeTemplatePropertiesPanel selectedPropertiesPanel = this.pluginPropertiesPanelMap.get(properties.getPluginPointName());
                if (selectedPropertiesPanel == null) {
                    selectedPropertiesPanel = this.basicPropertiesPanel;
                }
                if ((validationMessage = selectedPropertiesPanel.checkProperties(properties, selectedPropertiesPanel == this.currentPropertiesPanel)) == null) continue;
                validationMessage = "Error validating code template \"" + codeTemplate.getName() + "\" in library \"" + library.getName() + "\":\n\n" + (String)validationMessage;
                this.parent.alertError(this, (String)validationMessage);
                return false;
            }
        }
        return true;
    }

    private void initComponents() {
        this.splitPane = new JSplitPane();
        this.splitPane.setBackground(this.getBackground());
        this.splitPane.setOrientation(0);
        this.splitPane.setBorder(BorderFactory.createEmptyBorder());
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerLocation(Preferences.userNodeForPackage(Mirth.class).getInt("height", 650) / 3);
        this.splitPane.setResizeWeight(0.5);
        this.topPanel = new JPanel();
        this.topPanel.setBackground(UIConstants.COMBO_BOX_BACKGROUND);
        final CodeTemplateTreeTableCellEditor templateCellEditor = new CodeTemplateTreeTableCellEditor(this);
        this.templateTreeTable = new MirthTreeTable("CodeTemplate", new HashSet<String>(Arrays.asList("Name", "Description", "Revision", "Last Modified"))){
            private TreeTableNode selectedNode;

            public boolean isCellEditable(int row, int column) {
                return column == 0;
            }

            public TableCellEditor getCellEditor(int row, int column) {
                if (this.isHierarchical(column)) {
                    return templateCellEditor;
                }
                return super.getCellEditor(row, column);
            }

            @Override
            protected void beforeSort() {
                CodeTemplatePanel.this.updateCurrentNode();
                CodeTemplatePanel.this.updateCurrentNode.set(false);
                int selectedRow = CodeTemplatePanel.this.templateTreeTable.getSelectedRow();
                this.selectedNode = selectedRow >= 0 ? (TreeTableNode)CodeTemplatePanel.this.templateTreeTable.getPathForRow(selectedRow).getLastPathComponent() : null;
            }

            @Override
            protected void afterSort() {
                final TreePath selectedPath = CodeTemplatePanel.this.selectPathFromNodeId(this.selectedNode, (CodeTemplateRootTreeTableNode)((Object)CodeTemplatePanel.this.templateTreeTable.getTreeTableModel().getRoot()));
                if (selectedPath != null) {
                    CodeTemplatePanel.this.selectTemplatePath(selectedPath);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (selectedPath != null) {
                            CodeTemplatePanel.this.selectTemplatePath(selectedPath);
                        }
                        CodeTemplatePanel.this.updateCurrentNode.set(true);
                    }
                });
            }
        };
        CodeTemplateTreeTableModel model = new CodeTemplateTreeTableModel();
        model.setColumnIdentifiers(Arrays.asList("Name", "Id", "Type", "Description", "Revision", "Last Modified"));
        CodeTemplateRootTreeTableNode rootNode = new CodeTemplateRootTreeTableNode();
        model.setRoot((TreeTableNode)rootNode);
        this.fullModel = new CodeTemplateTreeTableModel();
        this.fullModel.setColumnIdentifiers(Arrays.asList("Name", "Id", "Type", "Description", "Revision", "Last Modified"));
        CodeTemplateRootTreeTableNode fullRootNode = new CodeTemplateRootTreeTableNode();
        this.fullModel.setRoot((TreeTableNode)fullRootNode);
        this.templateTreeTable.setColumnFactory(new CodeTemplateTableColumnFactory());
        this.templateTreeTable.setTreeTableModel((TreeTableModel)model);
        this.templateTreeTable.setOpenIcon(null);
        this.templateTreeTable.setClosedIcon(null);
        this.templateTreeTable.setLeafIcon(null);
        this.templateTreeTable.setRootVisible(false);
        this.templateTreeTable.setDoubleBuffered(true);
        this.templateTreeTable.setDragEnabled(false);
        this.templateTreeTable.setRowSelectionAllowed(true);
        this.templateTreeTable.setSelectionMode(0);
        this.templateTreeTable.setRowHeight(20);
        this.templateTreeTable.setFocusable(true);
        this.templateTreeTable.setOpaque(true);
        this.templateTreeTable.getTableHeader().setReorderingAllowed(true);
        this.templateTreeTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.templateTreeTable.setEditable(true);
        this.templateTreeTable.setSortable(true);
        this.templateTreeTable.setAutoCreateColumnsFromModel(false);
        this.templateTreeTable.setShowGrid(true, true);
        this.templateTreeTable.restoreColumnPreferences();
        this.templateTreeTable.setMirthColumnControlEnabled(true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.templateTreeTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.templateTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                int row = CodeTemplatePanel.this.templateTreeTable.rowAtPoint(new Point(evt.getX(), evt.getY()));
                if (row < 0) {
                    CodeTemplatePanel.this.templateTreeTable.clearSelection();
                }
                if (evt.isPopupTrigger()) {
                    if (row != -1 && !CodeTemplatePanel.this.templateTreeTable.isRowSelected(row)) {
                        CodeTemplatePanel.this.templateTreeTable.setRowSelectionInterval(row, row);
                    }
                    CodeTemplatePanel.this.codeTemplatePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        });
        this.templateTreeTable.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                TreePath selectedPath;
                if (e.getKeyCode() == 127 && (selectedPath = CodeTemplatePanel.this.templateTreeTable.getTreeSelectionModel().getSelectionPath()) != null) {
                    MutableTreeTableNode selectedNode = (MutableTreeTableNode)selectedPath.getLastPathComponent();
                    if (selectedNode instanceof CodeTemplateLibraryTreeTableNode && CodeTemplatePanel.this.codeTemplateTasks.getContentPane().getComponent(10).isVisible()) {
                        CodeTemplatePanel.this.doDeleteLibrary();
                    } else if (selectedNode instanceof CodeTemplateTreeTableNode && CodeTemplatePanel.this.codeTemplateTasks.getContentPane().getComponent(9).isVisible()) {
                        CodeTemplatePanel.this.doDeleteCodeTemplate();
                    }
                }
            }
        });
        this.templateTreeTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting() && !CodeTemplatePanel.this.templateTreeTable.getSelectionModel().getValueIsAdjusting()) {
                    int selectedRow = CodeTemplatePanel.this.templateTreeTable.getSelectedRow();
                    boolean saveEnabled = CodeTemplatePanel.this.isSaveEnabled();
                    boolean adjusting = CodeTemplatePanel.this.saveAdjusting.getAndSet(true);
                    CodeTemplatePanel.this.printTreeTable();
                    CodeTemplatePanel.this.updateCurrentNode();
                    CodeTemplatePanel.this.currentSelectedRow = selectedRow;
                    if (selectedRow < 0) {
                        if (!adjusting) {
                            CodeTemplatePanel.this.switchSplitPaneComponent(CodeTemplatePanel.this.blankPanel);
                        }
                    } else {
                        TreePath path = CodeTemplatePanel.this.templateTreeTable.getPathForRow(selectedRow);
                        if (path != null) {
                            TreeTableNode node = (TreeTableNode)path.getLastPathComponent();
                            if (node instanceof CodeTemplateLibraryTreeTableNode) {
                                CodeTemplatePanel.this.setLibraryProperties((CodeTemplateLibraryTreeTableNode)node);
                                CodeTemplatePanel.this.switchSplitPaneComponent(CodeTemplatePanel.this.libraryPanel);
                            } else if (node instanceof CodeTemplateTreeTableNode) {
                                CodeTemplatePanel.this.setCodeTemplateProperties((CodeTemplateTreeTableNode)node);
                                CodeTemplatePanel.this.switchSplitPaneComponent(CodeTemplatePanel.this.templateScrollPane);
                            }
                        }
                    }
                    CodeTemplatePanel.this.updateTasks();
                    CodeTemplatePanel.this.setSaveEnabled(saveEnabled);
                    if (!adjusting) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                CodeTemplatePanel.this.saveAdjusting.set(false);
                            }
                        });
                    }
                }
            }
        });
        this.templateTreeTable.addTreeWillExpandListener(new TreeWillExpandListener(){

            @Override
            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                this.treeExpansionChanged();
            }

            @Override
            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
                this.treeExpansionChanged();
            }

            private void treeExpansionChanged() {
                CodeTemplatePanel.this.updateCurrentNode();
                CodeTemplatePanel.this.updateCurrentNode.set(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeTemplatePanel.this.updateCurrentNode.set(true);
                    }
                });
            }
        });
        this.templateTreeTableScrollPane = new JScrollPane((Component)((Object)this.templateTreeTable));
        this.templateTreeTableScrollPane.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(0x6E6E6E)));
        this.templateFilterNotificationLabel = new JLabel();
        this.templateFilterLabel = new JLabel("Filter:");
        this.templateFilterField = new JTextField();
        this.templateFilterField.setToolTipText("Filters (by name) the code templates and libraries that show up in the table above.");
        this.templateFilterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.filterChanged(evt);
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.filterChanged(evt);
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.filterChanged(evt);
            }

            private void filterChanged(DocumentEvent evt) {
                try {
                    CodeTemplatePanel.this.updateTemplateFilter(evt.getDocument().getText(0, evt.getLength()));
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        });
        this.templateFilterField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent evt) {
                CodeTemplatePanel.this.updateTemplateFilter(CodeTemplatePanel.this.templateFilterField.getText());
            }
        });
        this.blankPanel = new JPanel();
        this.libraryPanel = new JPanel();
        this.libraryPanel.setBackground(this.splitPane.getBackground());
        this.libraryLeftPanel = new JPanel();
        this.libraryLeftPanel.setBackground(this.libraryPanel.getBackground());
        this.librarySummaryLabel = new JLabel("Summary:");
        this.librarySummaryValue = new JLabel();
        this.libraryDescriptionLabel = new JLabel("Description:");
        this.libraryDescriptionScrollPane = new MirthRTextScrollPane(null, false, "text/plain", false);
        DocumentListener codeChangeListener = new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                this.codeChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                this.codeChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                this.codeChanged();
            }

            private void codeChanged() {
                TreePath selectedPath;
                int selectedRow;
                if (CodeTemplatePanel.this.codeChangeWorker != null) {
                    CodeTemplatePanel.this.codeChangeWorker.cancel(true);
                }
                if ((selectedRow = CodeTemplatePanel.this.templateTreeTable.getSelectedRow()) >= 0 && (selectedPath = CodeTemplatePanel.this.templateTreeTable.getPathForRow(selectedRow)) != null) {
                    CodeTemplatePanel.this.codeChangeWorker = new CodeChangeWorker((String)((TreeTableNode)selectedPath.getLastPathComponent()).getValueAt(1));
                    CodeTemplatePanel.this.codeChangeWorker.execute();
                }
            }
        };
        this.libraryDescriptionScrollPane.getDocument().addDocumentListener(codeChangeListener);
        this.libraryRightPanel = new JPanel();
        this.libraryRightPanel.setBackground(this.libraryPanel.getBackground());
        this.libraryChannelsSelectPanel = new JPanel();
        this.libraryChannelsSelectPanel.setBackground(this.libraryRightPanel.getBackground());
        this.libraryChannelsLabel = new JLabel("<html><b>Channels</b></html>");
        this.libraryChannelsLabel.setForeground(new Color(64, 64, 64));
        this.libraryChannelsSelectAllLabel = new JLabel("<html><u>Select All</u></html>");
        this.libraryChannelsSelectAllLabel.setForeground(Color.BLUE);
        this.libraryChannelsSelectAllLabel.setCursor(new Cursor(12));
        this.libraryChannelsSelectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getComponent().isEnabled()) {
                    for (int row = 0; row < CodeTemplatePanel.this.libraryChannelsTable.getRowCount(); ++row) {
                        ChannelInfo channelInfo = (ChannelInfo)CodeTemplatePanel.this.libraryChannelsTable.getValueAt(row, 0);
                        channelInfo.setEnabled(true);
                        CodeTemplatePanel.this.libraryChannelsTable.setValueAt(channelInfo, row, 0);
                    }
                    CodeTemplatePanel.this.setSaveEnabled(true);
                }
            }
        });
        this.libraryChannelsDeselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
        this.libraryChannelsDeselectAllLabel.setForeground(Color.BLUE);
        this.libraryChannelsDeselectAllLabel.setCursor(new Cursor(12));
        this.libraryChannelsDeselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.getComponent().isEnabled()) {
                    for (int row = 0; row < CodeTemplatePanel.this.libraryChannelsTable.getRowCount(); ++row) {
                        ChannelInfo channelInfo = (ChannelInfo)CodeTemplatePanel.this.libraryChannelsTable.getValueAt(row, 0);
                        channelInfo.setEnabled(false);
                        CodeTemplatePanel.this.libraryChannelsTable.setValueAt(channelInfo, row, 0);
                    }
                    CodeTemplatePanel.this.setSaveEnabled(true);
                }
            }
        });
        this.libraryChannelsFilterLabel = new JLabel("Filter:");
        this.libraryChannelsFilterField = new JTextField();
        this.libraryChannelsFilterField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent evt) {
                CodeTemplatePanel.this.libraryChannelsTable.getRowSorter().allRowsChanged();
            }

            @Override
            public void insertUpdate(DocumentEvent evt) {
                CodeTemplatePanel.this.libraryChannelsTable.getRowSorter().allRowsChanged();
            }

            @Override
            public void changedUpdate(DocumentEvent evt) {
                CodeTemplatePanel.this.libraryChannelsTable.getRowSorter().allRowsChanged();
            }
        });
        this.libraryChannelsTable = new MirthTable();
        this.libraryChannelsTable.setModel(new RefreshTableModel(new Object[]{"Name", "Id"}, 0));
        this.libraryChannelsTable.setDragEnabled(false);
        this.libraryChannelsTable.setRowSelectionAllowed(false);
        this.libraryChannelsTable.setRowHeight(20);
        this.libraryChannelsTable.setFocusable(false);
        this.libraryChannelsTable.setOpaque(true);
        this.libraryChannelsTable.getTableHeader().setReorderingAllowed(false);
        this.libraryChannelsTable.setEditable(true);
        OffsetRowSorter libraryChannelsRowSorter = new OffsetRowSorter(this.libraryChannelsTable.getModel(), 1);
        libraryChannelsRowSorter.setRowFilter(new RowFilter<TableModel, Integer>(){

            @Override
            public boolean include(RowFilter.Entry<? extends TableModel, ? extends Integer> entry) {
                String name = entry.getStringValue(0);
                return name.equals(CodeTemplatePanel.NEW_CHANNELS) || StringUtils.containsIgnoreCase((CharSequence)name, (CharSequence)StringUtils.trim((String)CodeTemplatePanel.this.libraryChannelsFilterField.getText()));
            }
        });
        this.libraryChannelsTable.setRowSorter(libraryChannelsRowSorter);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.libraryChannelsTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.libraryChannelsTable.getColumnExt(0).setCellRenderer((TableCellRenderer)new ChannelsTableCellRenderer());
        this.libraryChannelsTable.getColumnExt(0).setCellEditor((TableCellEditor)new ChannelsTableCellEditor());
        this.libraryChannelsTable.getColumnExt(1).setVisible(false);
        this.libraryChannelsScrollPane = new JScrollPane((Component)((Object)this.libraryChannelsTable));
        this.templatePanel = new JPanel();
        this.templatePanel.setBackground(this.splitPane.getBackground());
        this.templateScrollPane = new JScrollPane(this.templatePanel);
        this.templateScrollPane.setBorder(null);
        this.templateScrollPane.setPreferredSize(new Dimension(this.templatePanel.getWidth(), this.templatePanel.getHeight()));
        this.templateLeftPanel = new JPanel();
        this.templateLeftPanel.setBackground(this.templatePanel.getBackground());
        this.templateLibraryLabel = new JLabel("Library:");
        this.templateLibraryComboBox = new JComboBox();
        this.templateLibraryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeTemplatePanel.this.libraryComboBoxActionPerformed();
            }
        });
        this.templateTypeLabel = new JLabel("Type:");
        ArrayList<String> types = new ArrayList<String>();
        for (CodeTemplateProperties.CodeTemplateType type : CodeTemplateProperties.CodeTemplateType.values()) {
            types.add(type.toString());
        }
        this.basicPropertiesPanel = new BasicCodeTemplatePropertiesPanel(this, codeChangeListener);
        this.currentPropertiesPanel = this.basicPropertiesPanel;
        this.pluginPropertiesPanelMap = new LinkedHashMap<String, CodeTemplatePropertiesPanel>();
        for (CodeTemplateTypePlugin plugin : LoadedExtensions.getInstance().getCodeTemplateTypePlugins().values()) {
            types.add(plugin.getPluginPointName());
            this.pluginPropertiesPanelMap.put(plugin.getPluginPointName(), plugin.getPanel(this, codeChangeListener));
        }
        this.templateTypeComboBox = new JComboBox<String>(types.toArray(new String[types.size()]));
        this.templateTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeTemplatePanel.this.templateTypeComboBoxActionPerformed();
                CodeTemplatePanel.this.setSaveEnabled(true);
            }
        });
        this.templateRightPanel = new JPanel();
        this.templateRightPanel.setBackground(this.templatePanel.getBackground());
        this.templateContextSelectPanel = new JPanel();
        this.templateContextSelectPanel.setBackground(this.templateRightPanel.getBackground());
        this.templateContextLabel = new JLabel("<html><b>Context</b></html>");
        this.templateContextLabel.setForeground(new Color(64, 64, 64));
        this.templateContextSelectAllLabel = new JLabel("<html><u>Select All</u></html>");
        this.templateContextSelectAllLabel.setForeground(Color.BLUE);
        this.templateContextSelectAllLabel.setCursor(new Cursor(12));
        this.templateContextSelectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                TreeTableNode root = (TreeTableNode)CodeTemplatePanel.this.templateContextTreeTable.getTreeTableModel().getRoot();
                Enumeration groups = root.children();
                while (groups.hasMoreElements()) {
                    TreeTableNode group = (TreeTableNode)groups.nextElement();
                    ((MutablePair)group.getUserObject()).setLeft((Object)0);
                    Enumeration children = group.children();
                    while (children.hasMoreElements()) {
                        ((MutablePair)((TreeTableNode)children.nextElement()).getUserObject()).setLeft((Object)0);
                    }
                }
                CodeTemplatePanel.this.templateContextTreeTable.updateUI();
                CodeTemplatePanel.this.setSaveEnabled(true);
            }
        });
        this.templateContextDeselectAllLabel = new JLabel("<html><u>Deselect All</u></html>");
        this.templateContextDeselectAllLabel.setForeground(Color.BLUE);
        this.templateContextDeselectAllLabel.setCursor(new Cursor(12));
        this.templateContextDeselectAllLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                TreeTableNode root = (TreeTableNode)CodeTemplatePanel.this.templateContextTreeTable.getTreeTableModel().getRoot();
                Enumeration groups = root.children();
                while (groups.hasMoreElements()) {
                    TreeTableNode group = (TreeTableNode)groups.nextElement();
                    ((MutablePair)group.getUserObject()).setLeft((Object)1);
                    Enumeration children = group.children();
                    while (children.hasMoreElements()) {
                        ((MutablePair)((TreeTableNode)children.nextElement()).getUserObject()).setLeft((Object)1);
                    }
                }
                CodeTemplatePanel.this.templateContextTreeTable.updateUI();
                CodeTemplatePanel.this.setSaveEnabled(true);
            }
        });
        final ContextTreeTableCellEditor contextCellEditor = new ContextTreeTableCellEditor(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CodeTemplatePanel.this.setSaveEnabled(true);
            }
        });
        this.templateContextTreeTable = new MirthTreeTable(){

            public TableCellEditor getCellEditor(int row, int column) {
                if (this.isHierarchical(column)) {
                    return contextCellEditor;
                }
                return super.getCellEditor(row, column);
            }
        };
        DefaultMutableTreeTableNode rootContextNode = new DefaultMutableTreeTableNode();
        DefaultMutableTreeTableNode globalScriptsNode = new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)"Global Scripts"));
        globalScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.GLOBAL_DEPLOY)));
        globalScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.GLOBAL_UNDEPLOY)));
        globalScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.GLOBAL_PREPROCESSOR)));
        globalScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.GLOBAL_POSTPROCESSOR)));
        rootContextNode.add((MutableTreeTableNode)globalScriptsNode);
        DefaultMutableTreeTableNode channelScriptsNode = new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)"Channel Scripts"));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.CHANNEL_DEPLOY)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.CHANNEL_UNDEPLOY)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.CHANNEL_PREPROCESSOR)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.CHANNEL_POSTPROCESSOR)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.CHANNEL_ATTACHMENT)));
        channelScriptsNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.CHANNEL_BATCH)));
        rootContextNode.add((MutableTreeTableNode)channelScriptsNode);
        DefaultMutableTreeTableNode sourceConnectorNode = new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)"Source Connector"));
        sourceConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.SOURCE_RECEIVER)));
        sourceConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.SOURCE_FILTER_TRANSFORMER)));
        rootContextNode.add((MutableTreeTableNode)sourceConnectorNode);
        DefaultMutableTreeTableNode destinationConnectorNode = new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)"Destination Connector"));
        destinationConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.DESTINATION_FILTER_TRANSFORMER)));
        destinationConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.DESTINATION_DISPATCHER)));
        destinationConnectorNode.add((MutableTreeTableNode)new DefaultMutableTreeTableNode((Object)new MutablePair((Object)0, (Object)ContextType.DESTINATION_RESPONSE_TRANSFORMER)));
        rootContextNode.add((MutableTreeTableNode)destinationConnectorNode);
        SortableTreeTableModel contextModel = new SortableTreeTableModel((TreeTableNode)rootContextNode);
        contextModel.setColumnIdentifiers(Arrays.asList("Context"));
        this.templateContextTreeTable.setTreeTableModel((TreeTableModel)contextModel);
        this.templateContextTreeTable.setRootVisible(false);
        this.templateContextTreeTable.setDragEnabled(false);
        this.templateContextTreeTable.setRowSelectionAllowed(false);
        this.templateContextTreeTable.setRowHeight(20);
        this.templateContextTreeTable.setFocusable(false);
        this.templateContextTreeTable.setOpaque(true);
        this.templateContextTreeTable.getTableHeader().setReorderingAllowed(false);
        this.templateContextTreeTable.setEditable(true);
        this.templateContextTreeTable.setSortable(false);
        this.templateContextTreeTable.setShowGrid(true, true);
        if (Preferences.userNodeForPackage(Mirth.class).getBoolean("highlightRows", true)) {
            this.templateContextTreeTable.setHighlighters(new Highlighter[]{HighlighterFactory.createAlternateStriping((Color)UIConstants.HIGHLIGHTER_COLOR, (Color)UIConstants.BACKGROUND_COLOR)});
        }
        this.templateContextTreeTable.setTreeCellRenderer(new ContextTreeTableCellRenderer());
        this.templateContextTreeTable.setOpenIcon(null);
        this.templateContextTreeTable.setClosedIcon(null);
        this.templateContextTreeTable.setLeafIcon(null);
        this.templateContextTreeTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                this.checkSelection(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                this.checkSelection(evt);
            }

            private void checkSelection(MouseEvent evt) {
                if (CodeTemplatePanel.this.templateContextTreeTable.rowAtPoint(new Point(evt.getX(), evt.getY())) < 0) {
                    CodeTemplatePanel.this.templateContextTreeTable.clearSelection();
                }
            }
        });
        this.templateContextTreeTable.getTreeTableModel().addTreeModelListener(new TreeModelListener(){

            @Override
            public void treeNodesChanged(TreeModelEvent evt) {
                if (ArrayUtils.isNotEmpty((Object[])evt.getChildren())) {
                    TreeTableNode node = (TreeTableNode)evt.getChildren()[0];
                    if (evt.getTreePath().getPathCount() == 2) {
                        boolean allChildren = true;
                        boolean noChildren = true;
                        Enumeration children = node.getParent().children();
                        while (children.hasMoreElements()) {
                            TreeTableNode child = (TreeTableNode)children.nextElement();
                            if ((Integer)((Pair)child.getUserObject()).getLeft() == 1) {
                                allChildren = false;
                                continue;
                            }
                            noChildren = false;
                        }
                        int value = allChildren ? 0 : (noChildren ? 1 : 2);
                        ((MutablePair)node.getParent().getUserObject()).setLeft((Object)value);
                    } else if (evt.getTreePath().getPathCount() == 1) {
                        int value = (Integer)((Pair)node.getUserObject()).getLeft();
                        Enumeration children = node.children();
                        while (children.hasMoreElements()) {
                            ((MutablePair)((TreeTableNode)children.nextElement()).getUserObject()).setLeft((Object)value);
                        }
                    }
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent evt) {
            }

            @Override
            public void treeNodesRemoved(TreeModelEvent evt) {
            }

            @Override
            public void treeStructureChanged(TreeModelEvent evt) {
            }
        });
        this.templateContextTreeTableScrollPane = new JScrollPane((Component)((Object)this.templateContextTreeTable));
    }

    private void initToolTips() {
        this.libraryChannelsFilterField.setToolTipText("Filters the channels that show up in the table below.");
        String toolTipText = "<html>Select the channels to include this library in. If [New Channels]<br/>is selected, any new channels that are created or imported will<br/>automatically have the code templates within this library included.</html>";
        this.libraryChannelsTable.getTableHeader().setToolTipText(toolTipText);
        this.libraryChannelsTable.setToolTipText(toolTipText);
        this.templateLibraryComboBox.setToolTipText("<html>The parent library that this code template belongs to.</html>");
        this.templateTypeComboBox.setToolTipText("<html>The type of code template to create.<br/><b>&nbsp;&nbsp;&nbsp;&nbsp;- " + String.valueOf(CodeTemplateProperties.CodeTemplateType.FUNCTION) + ":</b> The template will be compiled in with scripts, and the drag-and-drop will include the function signature.<br/><b>&nbsp;&nbsp;&nbsp;&nbsp;- " + String.valueOf(CodeTemplateProperties.CodeTemplateType.DRAG_AND_DROP_CODE) + ":</b> The template will not be compiled in with scripts, and the drag-and-drop will<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;include the entire code block verbatim (except for the initial documentation block).<br/><b>&nbsp;&nbsp;&nbsp;&nbsp;- " + String.valueOf(CodeTemplateProperties.CodeTemplateType.COMPILED_CODE) + ":</b> The template will be compiled in with scripts, but drag-and-drop will not be available at all.</html>");
        toolTipText = "Select which scripts should have access to this code template.";
        this.templateContextTreeTable.setToolTipText(toolTipText);
        this.templateContextTreeTable.getColumnExt(0).setToolTipText(toolTipText);
    }

    private void initLayout() {
        this.topPanel.setLayout((LayoutManager)new MigLayout("insets 0 0 5 0, novisualpadding, hidemode 3, fill"));
        this.topPanel.add((Component)this.templateTreeTableScrollPane, "grow, sx, push");
        this.topPanel.add((Component)this.templateFilterNotificationLabel, "newline, gapbefore 13");
        this.topPanel.add((Component)this.templateFilterLabel, "right, split");
        this.topPanel.add((Component)this.templateFilterField, "right, w :300, gapafter 5");
        this.splitPane.setTopComponent(this.topPanel);
        this.splitPane.setBottomComponent(this.blankPanel);
        this.libraryPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.libraryLeftPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill", "[]13[]", "[]8[]"));
        this.libraryLeftPanel.add((Component)this.librarySummaryLabel, "right");
        this.libraryLeftPanel.add((Component)this.librarySummaryValue, "grow");
        this.libraryLeftPanel.add((Component)this.libraryDescriptionLabel, "newline, top, right");
        this.libraryLeftPanel.add((Component)((Object)this.libraryDescriptionScrollPane), "grow, push, w :400, h 100:100");
        this.libraryPanel.add((Component)this.libraryLeftPanel, "grow, push");
        this.libraryRightPanel.setLayout((LayoutManager)new MigLayout("insets 12 0 12 12, novisualpadding, hidemode 3, fill", "", "[][][grow]"));
        this.libraryRightPanel.add((Component)this.libraryChannelsLabel, "left");
        this.libraryChannelsSelectPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.libraryChannelsSelectPanel.add(this.libraryChannelsSelectAllLabel);
        this.libraryChannelsSelectPanel.add(new JLabel("|"));
        this.libraryChannelsSelectPanel.add(this.libraryChannelsDeselectAllLabel);
        this.libraryRightPanel.add((Component)this.libraryChannelsSelectPanel, "right");
        this.libraryRightPanel.add((Component)this.libraryChannelsFilterLabel, "newline, split 2, sx");
        this.libraryRightPanel.add((Component)this.libraryChannelsFilterField, "grow");
        this.libraryRightPanel.add((Component)this.libraryChannelsScrollPane, "newline, grow, h 100:100, sx");
        this.libraryPanel.add((Component)this.libraryRightPanel, "grow, w 220!");
        this.templatePanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.templateLeftPanel.setLayout((LayoutManager)new MigLayout("insets 12, novisualpadding, hidemode 3, fill, gap 6", "[]13[grow]"));
        this.templateLeftPanel.add((Component)this.templateLibraryLabel, "right");
        this.templateLeftPanel.add(this.templateLibraryComboBox, "w 200:");
        this.templateLeftPanel.add((Component)this.templateTypeLabel, "newline, right");
        this.templateLeftPanel.add(this.templateTypeComboBox);
        for (Pair<Pair<Component, String>, Pair<Component, String>> row : this.basicPropertiesPanel.getRows()) {
            this.templateLeftPanel.add((Component)((Pair)row.getLeft()).getLeft(), ((Pair)row.getLeft()).getRight());
            this.templateLeftPanel.add((Component)((Pair)row.getRight()).getLeft(), ((Pair)row.getRight()).getRight());
        }
        for (CodeTemplatePropertiesPanel pluginPanel : this.pluginPropertiesPanelMap.values()) {
            for (Pair<Pair<Component, String>, Pair<Component, String>> row : pluginPanel.getRows()) {
                this.templateLeftPanel.add((Component)((Pair)row.getLeft()).getLeft(), ((Pair)row.getLeft()).getRight());
                if (row.getRight() == null) continue;
                this.templateLeftPanel.add((Component)((Pair)row.getRight()).getLeft(), ((Pair)row.getRight()).getRight());
            }
        }
        this.templatePanel.add((Component)this.templateLeftPanel, "grow, push");
        this.templateRightPanel.setLayout((LayoutManager)new MigLayout("insets 12 0 12 12, novisualpadding, hidemode 3, fill"));
        this.templateRightPanel.add((Component)this.templateContextLabel, "left");
        this.templateContextSelectPanel.setLayout((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.templateContextSelectPanel.add(this.templateContextSelectAllLabel);
        this.templateContextSelectPanel.add(new JLabel("|"));
        this.templateContextSelectPanel.add(this.templateContextDeselectAllLabel);
        this.templateRightPanel.add((Component)this.templateContextSelectPanel, "right");
        this.templateRightPanel.add((Component)this.templateContextTreeTableScrollPane, "newline, grow, sx, push");
        this.templatePanel.add((Component)this.templateRightPanel, "grow, w 220!, h 100:100");
        this.add((Component)this.splitPane, "grow");
    }

    private void switchSplitPaneComponent(Component c) {
        int dividerLocation = this.splitPane.getDividerLocation();
        this.splitPane.setRightComponent(c);
        this.splitPane.setDividerLocation(dividerLocation);
    }

    private void setLibraryProperties(CodeTemplateLibraryTreeTableNode libraryNode) {
        CodeTemplateLibrary library = libraryNode.getLibrary();
        ArrayList<CodeTemplate> codeTemplates = new ArrayList<CodeTemplate>();
        Enumeration en = libraryNode.children();
        while (en.hasMoreElements()) {
            codeTemplates.add(((CodeTemplateTreeTableNode)((Object)en.nextElement())).getCodeTemplate());
        }
        HashMap<CodeTemplateProperties.CodeTemplateType, Integer> typeMap = new HashMap<CodeTemplateProperties.CodeTemplateType, Integer>();
        for (CodeTemplateProperties.CodeTemplateType type : CodeTemplateProperties.CodeTemplateType.values()) {
            typeMap.put(type, 0);
        }
        for (CodeTemplate codeTemplate : codeTemplates) {
            typeMap.put(codeTemplate.getType(), (Integer)typeMap.get(codeTemplate.getType()) + 1);
        }
        StringBuilder summary = new StringBuilder();
        for (CodeTemplateProperties.CodeTemplateType type : CodeTemplateProperties.CodeTemplateType.values()) {
            summary.append(typeMap.get(type)).append(' ').append(type);
            if ((Integer)typeMap.get(type) != 1) {
                summary.append('s');
            }
            if (type.ordinal() >= CodeTemplateProperties.CodeTemplateType.values().length - 1) continue;
            summary.append(", ");
        }
        this.librarySummaryValue.setText(summary.toString());
        this.libraryDescriptionScrollPane.setText(library.getDescription());
        this.setLibraryChannels(library.isIncludeNewChannels(), library.getEnabledChannelIds(), library.getDisabledChannelIds());
    }

    private void setLibraryChannels(boolean includeNewChannels, Set<String> enabledChannelIds, Set<String> disabledChannelIds) {
        for (int row = 0; row < this.libraryChannelsTable.getModel().getRowCount(); ++row) {
            ChannelInfo channelInfo = (ChannelInfo)this.libraryChannelsTable.getModel().getValueAt(row, 0);
            String channelId = (String)this.libraryChannelsTable.getModel().getValueAt(row, 1);
            if (channelId.equals(NEW_CHANNELS)) {
                channelInfo.setEnabled(includeNewChannels);
            } else {
                channelInfo.setEnabled(enabledChannelIds.contains(channelId) || !disabledChannelIds.contains(channelId) && includeNewChannels);
            }
            this.libraryChannelsTable.getModel().setValueAt(channelInfo, row, 0);
        }
    }

    private void updateCurrentNode() {
        TreePath selectedPath;
        if (this.currentSelectedRow >= 0 && this.updateCurrentNode.get() && (selectedPath = this.templateTreeTable.getPathForRow(this.currentSelectedRow)) != null) {
            TreeTableNode selectedNode = (TreeTableNode)selectedPath.getLastPathComponent();
            if (selectedNode instanceof CodeTemplateLibraryTreeTableNode) {
                CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)selectedNode;
                this.updateLibraryNode(libraryNode);
                if (this.templateTreeTable.getTreeTableModel().getRoot() != this.fullModel.getRoot()) {
                    this.updateLibraryNode((CodeTemplateLibraryTreeTableNode)this.findFullNode(libraryNode));
                }
            } else {
                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)selectedNode;
                this.updateCodeTemplateNode(codeTemplateNode);
                if (this.templateTreeTable.getTreeTableModel().getRoot() != this.fullModel.getRoot()) {
                    CodeTemplateTreeTableNode fullCodeTemplateNode = (CodeTemplateTreeTableNode)this.findFullNode(codeTemplateNode);
                    fullCodeTemplateNode.setValueAt(codeTemplateNode.getValueAt(0), 0);
                    this.updateCodeTemplateNode(fullCodeTemplateNode);
                }
            }
        }
    }

    private void updateLibraryNode(CodeTemplateLibraryTreeTableNode libraryNode) {
        if (libraryNode != null) {
            libraryNode.setValueAt(this.libraryDescriptionScrollPane.getText(), 3);
            HashSet<String> enabledChannelIds = new HashSet<String>();
            HashSet<String> disabledChannelIds = new HashSet<String>();
            for (int row = 0; row < this.libraryChannelsTable.getModel().getRowCount(); ++row) {
                ChannelInfo channelInfo = (ChannelInfo)this.libraryChannelsTable.getModel().getValueAt(row, 0);
                String channelId = (String)this.libraryChannelsTable.getModel().getValueAt(row, 1);
                if (channelId.equals(NEW_CHANNELS)) {
                    libraryNode.getLibrary().setIncludeNewChannels(channelInfo.isEnabled());
                    continue;
                }
                if (channelInfo.isEnabled()) {
                    enabledChannelIds.add(channelId);
                    continue;
                }
                disabledChannelIds.add(channelId);
            }
            libraryNode.getLibrary().setEnabledChannelIds(enabledChannelIds);
            libraryNode.getLibrary().setDisabledChannelIds(disabledChannelIds);
        }
    }

    private void updateCodeTemplateNode(CodeTemplateTreeTableNode codeTemplateNode) {
        if (codeTemplateNode != null) {
            CodeTemplateProperties properties = this.currentPropertiesPanel.getProperties();
            if (properties instanceof BasicCodeTemplateProperties) {
                properties.setType(CodeTemplateProperties.CodeTemplateType.fromString((String)((String)this.templateTypeComboBox.getSelectedItem())));
            }
            codeTemplateNode.getCodeTemplate().setProperties(properties);
            CodeTemplateContextSet contextSet = new CodeTemplateContextSet(new ContextType[0]);
            Enumeration groups = ((MutableTreeTableNode)this.templateContextTreeTable.getTreeTableModel().getRoot()).children();
            while (groups.hasMoreElements()) {
                MutableTreeTableNode group = (MutableTreeTableNode)groups.nextElement();
                Enumeration children = group.children();
                while (children.hasMoreElements()) {
                    Pair pair = (Pair)((MutableTreeTableNode)children.nextElement()).getUserObject();
                    if ((Integer)pair.getLeft() != 0) continue;
                    try {
                        contextSet.add((ContextType)pair.getRight());
                    }
                    catch (ClassCastException e) {
                        e.printStackTrace();
                    }
                }
            }
            codeTemplateNode.getCodeTemplate().setContextSet(contextSet);
        }
    }

    private void setCodeTemplateProperties(CodeTemplateTreeTableNode codeTemplateNode) {
        CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)codeTemplateNode.getParent();
        CodeTemplate codeTemplate = codeTemplateNode.getCodeTemplate();
        this.libraryComboBoxAdjusting.set(true);
        this.templateLibraryComboBox.setSelectedItem(libraryNode.getLibrary().getName());
        this.templateTypeComboBox.setSelectedItem(codeTemplate.getProperties().getPluginPointName());
        this.templateTypeComboBoxActionPerformed();
        this.currentPropertiesPanel.resetInvalidProperties();
        this.currentPropertiesPanel.setProperties(codeTemplate.getProperties());
        this.updateContextTable(codeTemplate.getContextSet());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CodeTemplatePanel.this.libraryComboBoxAdjusting.set(false);
            }
        });
    }

    private void updateContextTable(CodeTemplateContextSet context) {
        DefaultMutableTreeTableNode root = (DefaultMutableTreeTableNode)this.templateContextTreeTable.getTreeTableModel().getRoot();
        Enumeration groups = root.children();
        while (groups.hasMoreElements()) {
            MutableTreeTableNode group = (MutableTreeTableNode)groups.nextElement();
            MutablePair groupPair = (MutablePair)group.getUserObject();
            boolean allChildren = true;
            boolean noChildren = true;
            Enumeration children = group.children();
            while (children.hasMoreElements()) {
                MutableTreeTableNode child = (MutableTreeTableNode)children.nextElement();
                MutablePair childPair = (MutablePair)child.getUserObject();
                if (context.contains(childPair.getRight())) {
                    childPair.setLeft((Object)0);
                    noChildren = false;
                    continue;
                }
                childPair.setLeft((Object)1);
                allChildren = false;
            }
            if (allChildren) {
                groupPair.setLeft((Object)0);
                continue;
            }
            if (noChildren) {
                groupPair.setLeft((Object)1);
                continue;
            }
            groupPair.setLeft((Object)2);
        }
        this.templateContextTreeTable.expandAll();
    }

    private void updateTasks() {
        int selectedRow = this.templateTreeTable.getSelectedRow();
        for (Pair<Component, Component> task : this.singleLibraryTaskComponents) {
            ((Component)task.getLeft()).setVisible(false);
            ((Component)task.getRight()).setVisible(false);
        }
        for (Pair<Component, Component> task : this.singleCodeTemplateTaskComponents) {
            ((Component)task.getLeft()).setVisible(false);
            ((Component)task.getRight()).setVisible(false);
        }
        if (selectedRow >= 0) {
            TreeTableNode selectedNode = (TreeTableNode)this.templateTreeTable.getPathForRow(selectedRow).getLastPathComponent();
            this.setTaskVisible(2);
            if (selectedNode instanceof CodeTemplateLibraryTreeTableNode) {
                this.setTaskVisible(7);
                this.setTaskVisible(10);
                this.setTaskInvisible(6);
                this.setTaskInvisible(9);
                this.setTaskInvisible(11);
                for (Pair<Component, Component> task : this.singleLibraryTaskComponents) {
                    ((Component)task.getLeft()).setVisible(true);
                    ((Component)task.getRight()).setVisible(true);
                }
            } else if (selectedNode instanceof CodeTemplateTreeTableNode) {
                this.setTaskVisible(6);
                this.setTaskVisible(9);
                this.setTaskVisible(11);
                this.setTaskInvisible(7);
                this.setTaskInvisible(10);
                for (Pair<Component, Component> task : this.singleCodeTemplateTaskComponents) {
                    ((Component)task.getLeft()).setVisible(true);
                    ((Component)task.getRight()).setVisible(true);
                }
            }
        } else {
            this.setTaskInvisible(2);
            this.setTaskInvisible(6);
            this.setTaskInvisible(9);
            this.setTaskInvisible(11);
            this.setTaskInvisible(7);
            this.setTaskInvisible(10);
        }
        if (this.fullModel.getRoot().getChildCount() > 0) {
            this.setTaskVisible(4);
        } else {
            this.setTaskInvisible(4);
        }
        this.setTaskVisibility(8, ((MutableTreeTableNode)this.fullModel.getRoot()).getChildCount() > 1);
    }

    void updateLibrariesComboBox() {
        MutableTreeTableNode root = (MutableTreeTableNode)this.fullModel.getRoot();
        ArrayList<String> libraryNames = new ArrayList<String>();
        Enumeration libraries = root.children();
        while (libraries.hasMoreElements()) {
            libraryNames.add(((CodeTemplateLibraryTreeTableNode)((Object)libraries.nextElement())).getLibrary().getName());
        }
        String selectedName = (String)this.templateLibraryComboBox.getSelectedItem();
        this.templateLibraryComboBox.setModel(new DefaultComboBoxModel<String>(libraryNames.toArray(new String[libraryNames.size()])));
        if (libraryNames.contains(selectedName)) {
            this.templateLibraryComboBox.setSelectedItem(selectedName);
        }
    }

    private void libraryComboBoxActionPerformed() {
        if (!this.libraryComboBoxAdjusting.get()) {
            TreeTableNode selectedNode;
            this.setSaveEnabled(true);
            TreePath selectedPath = this.templateTreeTable.getTreeSelectionModel().getSelectionPath();
            if (selectedPath != null && (selectedNode = (TreeTableNode)selectedPath.getLastPathComponent()) instanceof CodeTemplateTreeTableNode) {
                CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)selectedNode;
                CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
                CodeTemplateLibraryTreeTableNode currentParent = (CodeTemplateLibraryTreeTableNode)codeTemplateNode.getParent();
                String libraryName = (String)this.templateLibraryComboBox.getSelectedItem();
                CodeTemplateLibraryTreeTableNode libraryNode = null;
                Enumeration libraries = ((MutableTreeTableNode)model.getRoot()).children();
                while (libraries.hasMoreElements()) {
                    CodeTemplateLibraryTreeTableNode library = (CodeTemplateLibraryTreeTableNode)((Object)libraries.nextElement());
                    if (!library.getLibrary().getName().equals(libraryName)) continue;
                    libraryNode = library;
                    break;
                }
                CodeTemplateLibraryTreeTableNode fullLibraryNode = null;
                Enumeration libraries2 = ((MutableTreeTableNode)this.fullModel.getRoot()).children();
                while (libraries2.hasMoreElements()) {
                    CodeTemplateLibraryTreeTableNode library = (CodeTemplateLibraryTreeTableNode)((Object)libraries2.nextElement());
                    if (!library.getLibrary().getName().equals(libraryName)) continue;
                    fullLibraryNode = library;
                    break;
                }
                if (!currentParent.getLibraryId().equals(fullLibraryNode.getLibraryId())) {
                    this.updateCurrentNode();
                    this.updateCurrentNode.set(false);
                    model.removeNodeFromParent((MutableTreeTableNode)codeTemplateNode);
                    if (libraryNode != null) {
                        model.insertNodeInto((MutableTreeTableNode)codeTemplateNode, (MutableTreeTableNode)libraryNode);
                        this.selectTemplatePath(new TreePath(model.getPathToRoot((TreeTableNode)codeTemplateNode)));
                    } else {
                        this.selectTemplatePath(new TreePath(model.getPathToRoot(model.getRoot())));
                    }
                    if (model.getRoot() != this.fullModel.getRoot()) {
                        AbstractSortableTreeTableNode fullCodeTemplateNode = this.findFullNode(codeTemplateNode);
                        this.fullModel.removeNodeFromParent((MutableTreeTableNode)fullCodeTemplateNode);
                        this.fullModel.insertNodeInto((MutableTreeTableNode)fullCodeTemplateNode, (MutableTreeTableNode)fullLibraryNode);
                    }
                    this.updateCurrentNode.set(true);
                }
            }
        }
    }

    private void selectTemplatePath(TreePath path) {
        this.templateTreeTable.scrollPathToVisible(path);
        int selectedRow = this.templateTreeTable.getRowForPath(path);
        this.templateTreeTable.getTreeSelectionModel().setSelectionPath(path);
        this.templateTreeTable.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        this.templateTreeTable.scrollRowToVisible(selectedRow);
    }

    private void stopTableEditing() {
        if (this.templateTreeTable.isEditing()) {
            this.templateTreeTable.getCellEditor().stopCellEditing();
        }
    }

    private void updateTemplateFilter(String filter) {
        this.stopTableEditing();
        this.updateCurrentNode();
        this.updateCurrentNode.set(false);
        CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)this.templateTreeTable.getTreeTableModel();
        CodeTemplateRootTreeTableNode root = (CodeTemplateRootTreeTableNode)this.fullModel.getRoot();
        if (StringUtils.isNotBlank((CharSequence)filter)) {
            root = this.getFilteredRootNode(root);
        }
        model.setRoot((TreeTableNode)root);
        model.sort();
        this.updateFilterNotification();
        this.templateTreeTable.expandAll();
        this.templateTreeTable.clearSelection();
        this.switchSplitPaneComponent(this.blankPanel);
        this.updateCurrentNode.set(true);
    }

    private void updateFilterNotification() {
        int totalLibraries = 0;
        int totalCodeTemplates = 0;
        Enumeration libraryNodes = ((MutableTreeTableNode)this.fullModel.getRoot()).children();
        while (libraryNodes.hasMoreElements()) {
            ++totalLibraries;
            totalCodeTemplates += ((MutableTreeTableNode)libraryNodes.nextElement()).getChildCount();
        }
        int tableLibraries = 0;
        int tableCodeTemplates = 0;
        Enumeration libraryNodes2 = ((MutableTreeTableNode)this.templateTreeTable.getTreeTableModel().getRoot()).children();
        while (libraryNodes2.hasMoreElements()) {
            ++tableLibraries;
            tableCodeTemplates += ((MutableTreeTableNode)libraryNodes2.nextElement()).getChildCount();
        }
        StringBuilder builder = new StringBuilder();
        if (totalLibraries == tableLibraries) {
            builder.append(String.valueOf(tableLibraries)).append(" Librar");
            if (tableLibraries == 1) {
                builder.append('y');
            } else {
                builder.append("ies");
            }
            builder.append(", ");
        } else {
            builder.append(String.valueOf(tableLibraries)).append(" of ").append(String.valueOf(totalLibraries)).append(" Librar");
            if (totalLibraries == 1) {
                builder.append('y');
            } else {
                builder.append("ies");
            }
            builder.append(" (").append(String.valueOf(totalLibraries - tableLibraries)).append(" filtered), ");
        }
        if (totalCodeTemplates == tableCodeTemplates) {
            builder.append(String.valueOf(tableCodeTemplates)).append(" Code Template");
            if (tableCodeTemplates != 1) {
                builder.append('s');
            }
        } else {
            builder.append(String.valueOf(tableCodeTemplates)).append(" of ").append(String.valueOf(totalCodeTemplates)).append(" Code Template");
            if (totalCodeTemplates != 1) {
                builder.append('s');
            }
            builder.append(" (").append(String.valueOf(totalCodeTemplates - tableCodeTemplates)).append(" filtered)");
        }
        this.templateFilterNotificationLabel.setText(builder.toString());
    }

    private void printTreeTable() {
        if (this.logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder();
            Enumeration children = ((MutableTreeTableNode)this.templateTreeTable.getTreeTableModel().getRoot()).children();
            while (children.hasMoreElements()) {
                this.printTreeTable((MutableTreeTableNode)children.nextElement(), builder, 0);
            }
            this.logger.debug(builder.toString());
            if (this.templateTreeTable.getTreeTableModel().getRoot() != this.fullModel.getRoot()) {
                builder = new StringBuilder();
                children = ((MutableTreeTableNode)this.fullModel.getRoot()).children();
                while (children.hasMoreElements()) {
                    this.printTreeTable((MutableTreeTableNode)children.nextElement(), builder, 0);
                }
                this.logger.debug(builder.toString());
            }
        }
    }

    private void printTreeTable(MutableTreeTableNode node, StringBuilder builder, int depth) {
        builder.append(StringUtils.repeat((char)'\t', (int)depth));
        if (node instanceof CodeTemplateLibraryTreeTableNode) {
            CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)node;
            builder.append(libraryNode.getLibrary().getName()).append("\t\t\t\t").append(libraryNode.getLibrary().getDescription().replaceAll("\r\n|\r|\n", " "));
        } else if (node instanceof CodeTemplateTreeTableNode) {
            CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)node;
            builder.append(codeTemplateNode.getCodeTemplate().getName()).append("\t\t\t\t").append(StringUtils.defaultString((String)codeTemplateNode.getCodeTemplate().getDescription()).replaceAll("\r\n|\r|\n", " "));
        }
        builder.append('\n');
        Enumeration children = node.children();
        while (children.hasMoreElements()) {
            this.printTreeTable((MutableTreeTableNode)children.nextElement(), builder, depth + 1);
        }
    }

    private void templateTypeComboBoxActionPerformed() {
        String type = (String)this.templateTypeComboBox.getSelectedItem();
        CodeTemplatePropertiesPanel selectedPropertiesPanel = null;
        CodeTemplateProperties.CodeTemplateType codeTemplateType = CodeTemplateProperties.CodeTemplateType.fromString((String)type);
        if (codeTemplateType != null) {
            selectedPropertiesPanel = this.basicPropertiesPanel;
        }
        for (Map.Entry<String, CodeTemplatePropertiesPanel> entry : this.pluginPropertiesPanelMap.entrySet()) {
            if (entry.getKey().equals(type)) {
                this.basicPropertiesPanel.setVisible(false);
                selectedPropertiesPanel = entry.getValue();
                continue;
            }
            entry.getValue().setVisible(false);
        }
        if (selectedPropertiesPanel != null) {
            ((CodeTemplatePropertiesPanel)selectedPropertiesPanel).setVisible(true);
            if (this.currentPropertiesPanel != selectedPropertiesPanel) {
                this.currentPropertiesPanel = selectedPropertiesPanel;
                this.currentPropertiesPanel.resetInvalidProperties();
                this.currentPropertiesPanel.setProperties(this.currentPropertiesPanel.getDefaults());
            }
        }
    }

    public class UpdateSwingWorker
    extends SwingWorker<CodeTemplateLibrarySaveResult, Void> {
        private Map<String, CodeTemplateLibrary> libraries;
        private Map<String, CodeTemplateLibrary> removedLibraries;
        private Map<String, CodeTemplate> updatedCodeTemplates;
        private Map<String, CodeTemplate> removedCodeTemplates;
        private boolean override;
        private TreeTableNode selectedNode;
        private Set<String> expandedLibraryIds;
        private String workingId;
        private ActionListener actionListener;

        public UpdateSwingWorker(Map<String, CodeTemplateLibrary> libraries, Map<String, CodeTemplateLibrary> removedLibraries, Map<String, CodeTemplate> updatedCodeTemplates, Map<String, CodeTemplate> removedCodeTemplates, boolean override, TreeTableNode selectedNode, Set<String> expandedLibraryIds) {
            this.libraries = libraries;
            this.removedLibraries = removedLibraries;
            this.updatedCodeTemplates = updatedCodeTemplates;
            this.removedCodeTemplates = removedCodeTemplates;
            this.override = override;
            this.selectedNode = selectedNode;
            this.expandedLibraryIds = expandedLibraryIds;
            this.workingId = CodeTemplatePanel.this.parent.startWorking("Saving code templates and libraries...");
        }

        public void setActionListener(ActionListener actionListener) {
            this.actionListener = actionListener;
        }

        @Override
        protected CodeTemplateLibrarySaveResult doInBackground() throws Exception {
            return CodeTemplatePanel.this.updateLibrariesAndTemplates(this.libraries, this.removedLibraries, this.updatedCodeTemplates, this.removedCodeTemplates, this.override);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void done() {
            boolean tryAgain = false;
            try {
                CodeTemplateLibrarySaveResult updateSummary = (CodeTemplateLibrarySaveResult)this.get();
                if (updateSummary.isOverrideNeeded()) {
                    if (!this.override) {
                        if (CodeTemplatePanel.this.parent.alertOption((Component)((Object)CodeTemplatePanel.this.parent), "One or more code templates or libraries have been modified since you last refreshed.\nDo you want to overwrite the changes?")) {
                            tryAgain = true;
                        }
                    } else {
                        CodeTemplatePanel.this.parent.alertError((Component)((Object)CodeTemplatePanel.this.parent), "Unable to save code templates or libraries.");
                    }
                } else {
                    CodeTemplatePanel.this.handleUpdateSummary(this.libraries, this.updatedCodeTemplates, this.removedCodeTemplates, this.override, this.selectedNode, this.expandedLibraryIds, updateSummary);
                    if (updateSummary.isLibrariesSuccess() && this.actionListener != null) {
                        this.actionListener.actionPerformed(null);
                    }
                }
            }
            catch (Exception e) {
                Throwable cause = e;
                if (cause instanceof ExecutionException) {
                    cause = e.getCause();
                }
                CodeTemplatePanel.this.parent.alertThrowable((Component)((Object)CodeTemplatePanel.this.parent), cause, "Unable to save code templates or libraries: " + cause.getMessage());
            }
            finally {
                CodeTemplatePanel.this.parent.stopWorking(this.workingId);
                if (tryAgain && !this.override) {
                    new UpdateSwingWorker(this.libraries, this.removedLibraries, this.updatedCodeTemplates, this.removedCodeTemplates, true, this.selectedNode, this.expandedLibraryIds).execute();
                }
            }
        }
    }

    private class CodeChangeWorker
    extends SwingWorker<Void, Void> {
        private String selectedId;

        public CodeChangeWorker(String selectedId) {
            this.selectedId = selectedId;
        }

        @Override
        protected Void doInBackground() throws Exception {
            Thread.sleep(100L);
            return null;
        }

        @Override
        protected void done() {
            try {
                TreeTableNode selectedNode;
                TreePath selectedPath;
                this.get();
                int selectedRow = CodeTemplatePanel.this.templateTreeTable.getSelectedRow();
                if (selectedRow >= 0 && (selectedPath = CodeTemplatePanel.this.templateTreeTable.getPathForRow(selectedRow)) != null && this.selectedId.equals((selectedNode = (TreeTableNode)selectedPath.getLastPathComponent()).getValueAt(1))) {
                    CodeTemplateTreeTableModel model = (CodeTemplateTreeTableModel)CodeTemplatePanel.this.templateTreeTable.getTreeTableModel();
                    if (selectedNode instanceof CodeTemplateLibraryTreeTableNode) {
                        CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)selectedNode;
                        model.setValueAt(CodeTemplatePanel.this.libraryDescriptionScrollPane.getText(), (Object)libraryNode, 3);
                        CodeTemplatePanel.this.fullModel.setValueAt(CodeTemplatePanel.this.libraryDescriptionScrollPane.getText(), (Object)CodeTemplatePanel.this.findFullNode(libraryNode), 3);
                    } else if (selectedNode instanceof CodeTemplateTreeTableNode) {
                        CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)selectedNode;
                        CodeTemplateProperties properties = CodeTemplatePanel.this.currentPropertiesPanel.getProperties();
                        codeTemplateNode.getCodeTemplate().setProperties(properties);
                        model.setValueAt(codeTemplateNode.getCodeTemplate().getDescription(), (Object)codeTemplateNode, 3);
                        CodeTemplateTreeTableNode fullCodeTemplateNode = (CodeTemplateTreeTableNode)CodeTemplatePanel.this.findFullNode(codeTemplateNode);
                        fullCodeTemplateNode.getCodeTemplate().setProperties(properties);
                        CodeTemplatePanel.this.fullModel.setValueAt(fullCodeTemplateNode.getCodeTemplate().getDescription(), (Object)fullCodeTemplateNode, 3);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

