/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.codetemplate;

import com.mirth.connect.client.ui.codetemplate.CodeTemplateLibraryTreeTableNode;
import com.mirth.connect.client.ui.codetemplate.CodeTemplatePanel;
import com.mirth.connect.client.ui.codetemplate.CodeTemplateTreeTableNode;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;

public class CodeTemplateTreeTableCellEditor
extends DefaultCellEditor {
    private CodeTemplatePanel parent;
    private OffsetPanel panel;
    private JTextField field;

    public CodeTemplateTreeTableCellEditor(CodeTemplatePanel parent) {
        super(new JTextField());
        this.parent = parent;
        this.panel = new OffsetPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
        this.field = (JTextField)this.editorComponent;
        this.panel.add((Component)this.field, "grow, push");
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        MirthTreeTable treeTable = (MirthTreeTable)((Object)table);
        JTree tree = (JTree)((Object)treeTable.getCellRenderer(0, treeTable.getHierarchicalColumn()));
        this.panel.setOffset(tree.getRowBounds((int)row).x);
        this.field.setText((String)value);
        return this.panel;
    }

    @Override
    public boolean isCellEditable(EventObject evt) {
        return evt != null && evt instanceof MouseEvent && ((MouseEvent)evt).getClickCount() >= 2;
    }

    @Override
    public boolean stopCellEditing() {
        TreePath selectedPath;
        int selectedRow;
        boolean valid;
        String value = (String)this.getCellEditorValue();
        boolean bl = valid = StringUtils.isNotBlank((CharSequence)value) && value.length() <= 255;
        if (valid && (selectedRow = this.parent.getTreeTable().getSelectedRow()) >= 0 && (selectedPath = this.parent.getTreeTable().getPathForRow(selectedRow)) != null) {
            TreeTableNode selectedNode = (TreeTableNode)selectedPath.getLastPathComponent();
            if (selectedNode instanceof CodeTemplateLibraryTreeTableNode) {
                Enumeration libraries = ((MutableTreeTableNode)this.parent.getFullModel().getRoot()).children();
                while (libraries.hasMoreElements()) {
                    if (!((CodeTemplateLibraryTreeTableNode)((Object)libraries.nextElement())).getLibrary().getName().equals(value)) continue;
                    valid = false;
                    break;
                }
            } else {
                CodeTemplateLibraryTreeTableNode libraryNode = (CodeTemplateLibraryTreeTableNode)selectedNode.getParent();
                Enumeration codeTemplates = libraryNode.children();
                while (codeTemplates.hasMoreElements()) {
                    CodeTemplateTreeTableNode codeTemplateNode = (CodeTemplateTreeTableNode)((Object)codeTemplates.nextElement());
                    if (!codeTemplateNode.getCodeTemplate().getName().equals(value)) continue;
                    valid = false;
                    break;
                }
            }
        }
        if (valid) {
            this.parent.setSaveEnabled(true);
            TreePath selectedPath2 = this.parent.getTreeTable().getTreeSelectionModel().getSelectionPath();
            if (selectedPath2 != null && selectedPath2.getLastPathComponent() instanceof CodeTemplateLibraryTreeTableNode) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CodeTemplateTreeTableCellEditor.this.parent.updateLibrariesComboBox();
                    }
                });
            }
        } else {
            super.cancelCellEditing();
        }
        return super.stopCellEditing();
    }

    private class OffsetPanel
    extends JPanel {
        private int offset;

        public OffsetPanel(LayoutManager layout) {
            super(layout);
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x + this.offset, y, width - this.offset, height);
        }
    }
}

