/*
 * Decompiled with CFR 0.152.
 */
package com.mirth.connect.client.ui.codetemplate;

import com.mirth.connect.client.ui.UIConstants;
import com.mirth.connect.client.ui.components.MirthTreeTable;
import com.mirth.connect.client.ui.components.MirthTriStateCheckBox;
import com.mirth.connect.model.codetemplates.ContextType;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.DefaultCellEditor;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTree;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ContextTreeTableCellEditor
extends DefaultCellEditor {
    private CheckBoxPanel panel = new CheckBoxPanel((LayoutManager)new MigLayout("insets 0, novisualpadding, hidemode 3, fill"));
    private MirthTriStateCheckBox checkBox = (MirthTriStateCheckBox)this.editorComponent;
    private ContextType contextType;

    public ContextTreeTableCellEditor(ActionListener saveEnableActionListener) {
        super(new MirthTriStateCheckBox());
        this.checkBox.addActionListener(saveEnableActionListener);
        this.panel.add(this.checkBox);
    }

    @Override
    public Object getCellEditorValue() {
        if (this.contextType != null) {
            return new MutablePair((Object)this.checkBox.getState(), (Object)this.contextType);
        }
        return new MutablePair((Object)this.checkBox.getState(), (Object)this.checkBox.getText());
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        Pair pair = (Pair)value;
        if (pair != null) {
            this.checkBox.setState((Integer)pair.getLeft());
            if (pair.getRight() instanceof String) {
                this.contextType = null;
                this.checkBox.setText((String)pair.getRight());
            } else {
                this.contextType = (ContextType)pair.getRight();
                this.checkBox.setText(this.contextType.getDisplayName());
            }
        }
        MirthTreeTable treeTable = (MirthTreeTable)((Object)table);
        JTree tree = (JTree)((Object)treeTable.getCellRenderer(0, treeTable.getHierarchicalColumn()));
        this.panel.setOffset(tree.getRowBounds((int)row).x);
        this.panel.setBackground(row % 2 == 0 ? UIConstants.HIGHLIGHTER_COLOR : UIConstants.BACKGROUND_COLOR);
        this.checkBox.setBackground(this.panel.getBackground());
        return this.panel;
    }

    private class CheckBoxPanel
    extends JPanel {
        private int offset;

        public CheckBoxPanel(LayoutManager layout) {
            super(layout);
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        @Override
        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x + this.offset, y, width - this.offset, height);
        }
    }
}

